/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.enums.BudgetTypeEnum;
import com.ejianc.business.budget.mapper.BudgetProjectDetailMapper;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.service.IBudgetSetDetailService;
import com.ejianc.business.budget.service.IBudgetSetService;
import com.ejianc.business.budget.utils.ExcelImportUtil;
import com.ejianc.business.budget.vo.BudgetMatchVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.business.budget.vo.BudgetSetDetailVO;
import com.ejianc.business.budget.vo.ThreeCompareVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailComparatoeVo;
import com.ejianc.business.cost.bean.xml.ConstructionProject;
import com.ejianc.business.cost.bean.xml.DivisionalWorkInfo;
import com.ejianc.business.cost.bean.xml.ExtraItem;
import com.ejianc.business.cost.bean.xml.ListProjectInfo;
import com.ejianc.business.cost.bean.xml.SectionalWorks;
import com.ejianc.business.cost.bean.xml.StatutoryFeesItem;
import com.ejianc.business.cost.bean.xml.SummaryItemInfo;
import com.ejianc.business.cost.bean.xml.TaxItem;
import com.ejianc.business.cost.bean.xml.UnitWorks;
import com.ejianc.business.cost.controller.YdbxController;
import com.ejianc.business.cost.utils.DetailListUtil;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.business.utils.HuaKangExcelReader;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="budgetProjectDetailService")
public class BudgetProjectDetailServiceImpl
extends BaseServiceImpl<BudgetProjectDetailMapper, BudgetProjectDetailEntity>
implements IBudgetProjectDetailService {
    @Autowired
    private IBudgetProjectService budgetProjectService;
    @Autowired
    private IBudgetSetService budgetSetService;
    @Autowired
    private IBudgetSetDetailService budgetSetDetailService;
    @Autowired
    private IBudgetProjectProService costService;
    @Autowired
    private DetailListUtil detailListUtil;

    @Override
    public void deleteByBudgetId(Long id) {
        QueryWrapper deleteWrapper = new QueryWrapper();
        deleteWrapper.eq((Object)"budget_id", (Object)id);
        ((BudgetProjectDetailMapper)this.baseMapper).delete((Wrapper)deleteWrapper);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<BudgetProjectDetailVO> detailVoList = new ArrayList<BudgetProjectDetailVO>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                BudgetProjectDetailVO vo = new BudgetProjectDetailVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                vo.setDetailIndex(detailIndex);
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }
                } else {
                    vo.setTid(id);
                    vo.setTpid("");
                }
                if (indexMap.containsKey(detailIndex)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(detailIndex) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(detailIndex, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setCode(null);
                    warnType = warnType + "\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setCode((String)datas.get(1));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setName(null);
                    warnType = warnType + "\u9879\u76ee\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setName((String)datas.get(2));
                }
                vo.setProjectFeature((String)datas.get(3));
                vo.setUnit((String)datas.get(4));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    vo.setNum(null);
                    warnType = warnType + "\u5de5\u7a0b\u91cf\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setNum(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        vo.setNum(null);
                        warnType = warnType + "\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(7)))) {
                    vo.setLaborCost(null);
                } else {
                    try {
                        vo.setLaborCost(new BigDecimal((String)datas.get(7)));
                    }
                    catch (Exception e) {
                        vo.setLaborCost(null);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(8)))) {
                    vo.setMaterialCost(null);
                } else {
                    try {
                        vo.setMaterialCost(new BigDecimal((String)datas.get(8)));
                    }
                    catch (Exception e) {
                        vo.setMaterialCost(null);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(9)))) {
                    vo.setMechanicalCost(null);
                } else {
                    try {
                        vo.setMechanicalCost(new BigDecimal((String)datas.get(9)));
                    }
                    catch (Exception e) {
                        vo.setMechanicalCost(null);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(10)))) {
                    vo.setOtherCost(null);
                } else {
                    try {
                        vo.setOtherCost(new BigDecimal((String)datas.get(10)));
                    }
                    catch (Exception e) {
                        vo.setOtherCost(null);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(11)))) {
                    vo.setMny(null);
                    warnType = warnType + "\u5408\u4ef7\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setMny(new BigDecimal((String)datas.get(11)));
                    }
                    catch (Exception e) {
                        vo.setMny(null);
                        warnType = warnType + "\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (null == vo.getNum() || null == vo.getMny()) {
                    vo.setPrice(null);
                } else if (vo.getNum().compareTo(BigDecimal.ZERO) == 0) {
                    vo.setPrice(null);
                } else {
                    vo.setPrice(vo.getMny().divide(vo.getNum(), 20, 6));
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setParentWarn(Boolean.valueOf(parentWarn));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                vo.setChangeType(Integer.valueOf(3));
                detailVoList.add(vo);
            }
            for (BudgetProjectDetailVO tVo : detailVoList) {
                tVo.setTpid((String)tidMap.get(tVo.getTpid()));
            }
            List deailTreeData = ExcelImportUtil.treeData((List)BeanMapper.mapList(detailVoList, Map.class));
            List mapList = ExcelImportUtil.importFlag((List)deailTreeData);
            ArrayList falseList = new ArrayList();
            List allList = ExcelImportUtil.separate((List)mapList, falseList);
            List errorList = ExcelImportUtil.treeToList((List)((List)allList.get(1)));
            resp.put("successList", allList.get(0));
            resp.put("errorList", (Object)errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public CommonResponse<JSONObject> excelImportYdbx(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        ConstructionProject project = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if (!"ydbx".equalsIgnoreCase(extName)) {
                return CommonResponse.error((String)"\u8bf7\u4e0a\u4f20.ydbx\u6587\u4ef6");
            }
            try {
                project = YdbxController.processYdbxAsZip(mf);
                if (project != null) continue;
                return CommonResponse.error((String)"\u6587\u4ef6\u5904\u7406\u5931\u8d25");
            }
            catch (Exception e) {
                return CommonResponse.error((String)("\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage()));
            }
        }
        JSONObject resp = new JSONObject();
        if (project == null) {
            return CommonResponse.error((String)"\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01");
        }
        if (project.getProjectfee() == null) {
            return CommonResponse.error((String)"\u6587\u4ef6\u4e0d\u5b58\u5728projectFee");
        }
        List<SectionalWorks> sectionalWorks = project.getProjectfee().getSectionalWorks();
        if (ListUtil.isEmpty(sectionalWorks)) {
            return CommonResponse.error((String)"\u6587\u4ef6\u4e0d\u5b58\u5728SectionalWorks");
        }
        ArrayList<BudgetProjectDetailVO> detailVoList = new ArrayList<BudgetProjectDetailVO>();
        HashMap<String, String> tidMap = new HashMap<String, String>();
        for (int i = 0; i < sectionalWorks.size(); ++i) {
            SectionalWorks works = sectionalWorks.get(i);
            BudgetProjectDetailVO vo = new BudgetProjectDetailVO();
            String warnType = "";
            String detailIndex = i + 1 + "";
            System.out.println(detailIndex);
            vo.setDetailIndex(detailIndex);
            String id = UUID.randomUUID().toString().replaceAll("-", "");
            String[] split = detailIndex.split("[-/.]");
            vo.setTid(id);
            tidMap.put(detailIndex, id);
            if (split.length > 1) {
                vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
            }
            vo.setName(works.getName());
            vo.setImportFlag(Boolean.valueOf(true));
            vo.setParentWarn(Boolean.valueOf(false));
            vo.setWarnType(warnType);
            vo.setRowState("add");
            vo.setShadowId(vo.getTid());
            vo.setChangeType(Integer.valueOf(3));
            detailVoList.add(vo);
            List<UnitWorks> unitWorks = works.getUnitWorks();
            if (!ListUtil.isNotEmpty(unitWorks)) continue;
            String parentIndex = vo.getDetailIndex();
            for (int i1 = 0; i1 < unitWorks.size(); ++i1) {
                BudgetProjectDetailVO vo1 = new BudgetProjectDetailVO();
                UnitWorks unitWorks1 = unitWorks.get(i1);
                detailIndex = parentIndex + "." + (i1 + 1);
                vo1.setDetailIndex(detailIndex);
                System.out.println(detailIndex);
                id = UUID.randomUUID().toString().replaceAll("-", "");
                split = detailIndex.split("[-/.]");
                vo1.setTid(id);
                tidMap.put(detailIndex, id);
                if (split.length > 1) {
                    vo1.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                }
                vo1.setName(unitWorks1.getName());
                vo1.setImportFlag(Boolean.valueOf(true));
                vo1.setParentWarn(Boolean.valueOf(false));
                vo1.setRowState("add");
                vo1.setShadowId(vo1.getTid());
                vo1.setChangeType(Integer.valueOf(3));
                detailVoList.add(vo1);
                List<SummaryItemInfo> summaryItemInfos = unitWorks1.getSummaryItemInfos();
                if (!ListUtil.isNotEmpty(summaryItemInfos)) continue;
                String parentIndex2 = vo1.getDetailIndex();
                for (int i2 = 0; i2 < summaryItemInfos.size(); ++i2) {
                    BudgetProjectDetailVO vo4;
                    ListProjectInfo listProjectInfo;
                    int i4;
                    SummaryItemInfo itemInfo = summaryItemInfos.get(i2);
                    if (itemInfo.getOrdCode().contains(".")) continue;
                    BudgetProjectDetailVO vo2 = new BudgetProjectDetailVO();
                    warnType = "";
                    detailIndex = parentIndex2 + "." + ("6".equals(itemInfo.getOrdCode()) ? "5" : itemInfo.getOrdCode());
                    System.out.println(detailIndex);
                    vo2.setDetailIndex(detailIndex);
                    id = UUID.randomUUID().toString().replaceAll("-", "");
                    split = detailIndex.split("[-/.]");
                    vo2.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        vo2.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }
                    vo2.setCode(itemInfo.getOrdCode());
                    vo2.setName(itemInfo.getName());
                    vo2.setImportFlag(Boolean.valueOf(true));
                    vo2.setParentWarn(Boolean.valueOf(false));
                    vo2.setRowState("add");
                    vo2.setShadowId(vo2.getTid());
                    vo2.setChangeType(Integer.valueOf(3));
                    if ("1".equals(itemInfo.getOrdCode())) {
                        List<DivisionalWorkInfo> billTables = itemInfo.getBillTables();
                        if (ListUtil.isNotEmpty(billTables)) {
                            String parentIndex3 = vo2.getDetailIndex();
                            for (int i3 = 0; i3 < billTables.size(); ++i3) {
                                DivisionalWorkInfo billTable = billTables.get(i3);
                                BudgetProjectDetailVO vo3 = new BudgetProjectDetailVO();
                                detailIndex = parentIndex3 + "." + (i3 + 1);
                                System.out.println(detailIndex);
                                vo3.setDetailIndex(detailIndex);
                                id = UUID.randomUUID().toString().replaceAll("-", "");
                                split = detailIndex.split("[-/.]");
                                vo3.setTid(id);
                                tidMap.put(detailIndex, id);
                                if (split.length > 1) {
                                    vo3.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                }
                                vo3.setName(billTable.getName());
                                vo3.setImportFlag(Boolean.valueOf(true));
                                vo3.setParentWarn(Boolean.valueOf(false));
                                vo3.setRowState("add");
                                vo3.setShadowId(vo3.getTid());
                                vo3.setChangeType(Integer.valueOf(3));
                                detailVoList.add(vo3);
                                List<ListProjectInfo> listProjects = billTable.getListProjects();
                                if (ListUtil.isNotEmpty(listProjects)) {
                                    String parentIndex4 = vo3.getDetailIndex();
                                    for (i4 = 0; i4 < listProjects.size(); ++i4) {
                                        ListProjectInfo listProjectInfo2 = listProjects.get(i4);
                                        BudgetProjectDetailVO vo42 = new BudgetProjectDetailVO();
                                        detailIndex = parentIndex4 + "." + (i4 + 1);
                                        System.out.println(detailIndex);
                                        vo42.setDetailIndex(detailIndex);
                                        id = UUID.randomUUID().toString().replaceAll("-", "");
                                        split = detailIndex.split("[-/.]");
                                        vo42.setTid(id);
                                        tidMap.put(detailIndex, id);
                                        if (split.length > 1) {
                                            vo42.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                        }
                                        vo42.setCode(listProjectInfo2.getCode());
                                        vo42.setName(listProjectInfo2.getName());
                                        vo42.setUnit(listProjectInfo2.getUnit());
                                        vo42.setNum(new BigDecimal(listProjectInfo2.getQuantity()));
                                        vo42.setPrice(new BigDecimal(listProjectInfo2.getPrice()));
                                        vo42.setMny(new BigDecimal(listProjectInfo2.getTotal()));
                                        vo42.setProjectFeature(listProjectInfo2.getAttr());
                                        vo42.setLeafFlag(Boolean.valueOf(true));
                                        vo42.setImportFlag(Boolean.valueOf(true));
                                        vo42.setRowState("add");
                                        vo42.setShadowId(vo42.getTid());
                                        vo42.setChangeType(Integer.valueOf(3));
                                        detailVoList.add(vo42);
                                    }
                                    continue;
                                }
                                vo3.setMny(new BigDecimal(0));
                                vo3.setNum(new BigDecimal(0));
                                vo3.setPrice(new BigDecimal(0));
                                vo3.setCode("0");
                            }
                        } else {
                            List<ListProjectInfo> billTableList = itemInfo.getBillTableList();
                            if (ListUtil.isNotEmpty(billTableList)) {
                                String parentIndex4 = vo2.getDetailIndex();
                                for (int i42 = 0; i42 < billTableList.size(); ++i42) {
                                    listProjectInfo = billTableList.get(i42);
                                    vo4 = new BudgetProjectDetailVO();
                                    detailIndex = parentIndex4 + "." + (i42 + 1);
                                    System.out.println(detailIndex);
                                    vo4.setDetailIndex(detailIndex);
                                    id = UUID.randomUUID().toString().replaceAll("-", "");
                                    split = detailIndex.split("[-/.]");
                                    vo4.setTid(id);
                                    tidMap.put(detailIndex, id);
                                    if (split.length > 1) {
                                        vo4.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                    }
                                    vo4.setProjectFeature(listProjectInfo.getAttr());
                                    vo4.setCode(listProjectInfo.getCode());
                                    vo4.setName(listProjectInfo.getName());
                                    vo4.setUnit(listProjectInfo.getUnit());
                                    vo4.setNum(new BigDecimal(listProjectInfo.getQuantity()));
                                    vo4.setPrice(new BigDecimal(listProjectInfo.getPrice()));
                                    vo4.setMny(new BigDecimal(listProjectInfo.getTotal()));
                                    vo4.setLeafFlag(Boolean.valueOf(true));
                                    vo4.setImportFlag(Boolean.valueOf(true));
                                    vo4.setRowState("add");
                                    vo4.setShadowId(vo4.getTid());
                                    vo4.setChangeType(Integer.valueOf(3));
                                    detailVoList.add(vo4);
                                }
                            }
                        }
                    } else if ("2".equals(itemInfo.getOrdCode())) {
                        int i3;
                        List<ListProjectInfo> totals = itemInfo.getPreliminariesByTotal();
                        List<ListProjectInfo> prices = itemInfo.getPreliminariesByPrice();
                        if (ListUtil.isNotEmpty(totals)) {
                            BudgetProjectDetailVO vo3 = new BudgetProjectDetailVO();
                            detailIndex = vo2.getDetailIndex() + ".1";
                            System.out.println(detailIndex);
                            vo3.setDetailIndex(detailIndex);
                            vo3.setName("\u603b\u4ef7\u63aa\u65bd\u9879\u76ee");
                            id = UUID.randomUUID().toString().replaceAll("-", "");
                            split = detailIndex.split("[-/.]");
                            vo3.setTid(id);
                            tidMap.put(detailIndex, id);
                            if (split.length > 1) {
                                vo3.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                            }
                            vo3.setShadowId(vo3.getTid());
                            vo3.setImportFlag(Boolean.valueOf(true));
                            vo3.setParentWarn(Boolean.valueOf(false));
                            vo3.setRowState("add");
                            vo3.setChangeType(Integer.valueOf(3));
                            detailVoList.add(vo3);
                            for (i3 = 0; i3 < totals.size(); ++i3) {
                                listProjectInfo = totals.get(i3);
                                vo4 = new BudgetProjectDetailVO();
                                detailIndex = vo3.getDetailIndex() + "." + (i3 + 1);
                                System.out.println(detailIndex);
                                vo4.setDetailIndex(detailIndex);
                                id = UUID.randomUUID().toString().replaceAll("-", "");
                                split = detailIndex.split("[-/.]");
                                vo4.setTid(id);
                                tidMap.put(detailIndex, id);
                                if (split.length > 1) {
                                    vo4.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                }
                                vo4.setCode(listProjectInfo.getCode());
                                vo4.setName(listProjectInfo.getName());
                                if (ListUtil.isEmpty(listProjectInfo.getInnerListProjectInfos())) {
                                    vo4.setUnit(listProjectInfo.getUnit());
                                    vo4.setNum(new BigDecimal(listProjectInfo.getQuantity()));
                                    if (StringUtils.isNotEmpty((CharSequence)listProjectInfo.getPrice())) {
                                        vo4.setPrice(new BigDecimal(listProjectInfo.getPrice()));
                                    }
                                    vo4.setMny(new BigDecimal(listProjectInfo.getTotal()));
                                    vo4.setLeafFlag(Boolean.valueOf(true));
                                } else {
                                    List<ListProjectInfo> innerListProjectInfos = listProjectInfo.getInnerListProjectInfos();
                                    for (i4 = 0; i4 < innerListProjectInfos.size(); ++i4) {
                                        detailIndex = vo4.getDetailIndex() + "." + (i4 + 1);
                                        System.out.println(detailIndex);
                                        ListProjectInfo info = innerListProjectInfos.get(i4);
                                        BudgetProjectDetailVO vo5 = new BudgetProjectDetailVO();
                                        vo5.setDetailIndex(detailIndex);
                                        id = UUID.randomUUID().toString().replaceAll("-", "");
                                        split = detailIndex.split("[-/.]");
                                        vo5.setTid(id);
                                        tidMap.put(detailIndex, id);
                                        if (split.length > 1) {
                                            vo5.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                        }
                                        vo5.setCode(info.getCode());
                                        vo5.setName(info.getName());
                                        vo5.setUnit(info.getUnit());
                                        vo5.setNum(new BigDecimal(info.getQuantity()));
                                        if (StringUtils.isNotEmpty((CharSequence)info.getPrice())) {
                                            vo5.setPrice(new BigDecimal(info.getPrice()));
                                        }
                                        vo5.setMny(new BigDecimal(info.getTotal()));
                                        vo5.setLeafFlag(Boolean.valueOf(true));
                                        vo5.setImportFlag(Boolean.valueOf(true));
                                        vo5.setRowState("add");
                                        vo5.setShadowId(vo5.getTid());
                                        vo5.setChangeType(Integer.valueOf(3));
                                        detailVoList.add(vo5);
                                    }
                                }
                                vo4.setImportFlag(Boolean.valueOf(true));
                                vo4.setRowState("add");
                                vo4.setShadowId(vo4.getTid());
                                vo4.setChangeType(Integer.valueOf(3));
                                detailVoList.add(vo4);
                            }
                        }
                        if (ListUtil.isNotEmpty(prices)) {
                            BudgetProjectDetailVO vo3 = new BudgetProjectDetailVO();
                            detailIndex = vo2.getDetailIndex() + ".2";
                            vo3.setDetailIndex(detailIndex);
                            System.out.println(detailIndex);
                            vo3.setName("\u5355\u4ef7\u63aa\u65bd\u9879\u76ee");
                            id = UUID.randomUUID().toString().replaceAll("-", "");
                            split = vo3.getDetailIndex().split("[-/.]");
                            vo3.setTid(id);
                            tidMap.put(vo3.getDetailIndex(), id);
                            if (split.length > 1) {
                                vo3.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                            }
                            vo3.setImportFlag(Boolean.valueOf(true));
                            vo3.setParentWarn(Boolean.valueOf(false));
                            vo3.setRowState("add");
                            vo3.setShadowId(vo3.getTid());
                            vo3.setChangeType(Integer.valueOf(3));
                            detailVoList.add(vo3);
                            for (i3 = 0; i3 < prices.size(); ++i3) {
                                listProjectInfo = prices.get(i3);
                                vo4 = new BudgetProjectDetailVO();
                                detailIndex = vo3.getDetailIndex() + "." + (i3 + 1);
                                System.out.println(detailIndex);
                                vo4.setDetailIndex(detailIndex);
                                id = UUID.randomUUID().toString().replaceAll("-", "");
                                split = detailIndex.split("[-/.]");
                                vo4.setTid(id);
                                tidMap.put(detailIndex, id);
                                if (split.length > 1) {
                                    vo4.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                }
                                vo4.setCode(listProjectInfo.getCode());
                                vo4.setName(listProjectInfo.getName());
                                vo4.setUnit(listProjectInfo.getUnit());
                                vo4.setNum(new BigDecimal(listProjectInfo.getQuantity()));
                                vo4.setPrice(new BigDecimal(listProjectInfo.getPrice()));
                                vo4.setMny(new BigDecimal(listProjectInfo.getTotal()));
                                vo4.setLeafFlag(Boolean.valueOf(true));
                                vo4.setImportFlag(Boolean.valueOf(true));
                                vo4.setRowState("add");
                                vo4.setShadowId(vo4.getTid());
                                vo4.setChangeType(Integer.valueOf(3));
                                detailVoList.add(vo4);
                            }
                        }
                    } else if ("3".equals(itemInfo.getOrdCode())) {
                        List<ExtraItem> extraTables = itemInfo.getExtraTables();
                        if (ListUtil.isNotEmpty(extraTables)) {
                            for (int i3 = 0; i3 < extraTables.size(); ++i3) {
                                ExtraItem extraItem = extraTables.get(i3);
                                if (extraItem.getCode().contains(".")) continue;
                                BudgetProjectDetailVO vo3 = new BudgetProjectDetailVO();
                                detailIndex = vo2.getDetailIndex() + "." + extraItem.getCode();
                                System.out.println(detailIndex);
                                vo3.setDetailIndex(detailIndex);
                                id = UUID.randomUUID().toString().replaceAll("-", "");
                                split = detailIndex.split("[-/.]");
                                vo3.setTid(id);
                                tidMap.put(detailIndex, id);
                                if (split.length > 1) {
                                    vo3.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                                }
                                vo3.setCode(extraItem.getCode());
                                vo3.setName(extraItem.getName());
                                vo3.setUnit(extraItem.getUnit());
                                vo3.setNum(new BigDecimal(extraItem.getQuantity()));
                                vo3.setPrice(new BigDecimal(extraItem.getPrice()));
                                vo3.setMny(new BigDecimal(extraItem.getTotal()));
                                vo3.setLeafFlag(Boolean.valueOf(true));
                                vo3.setImportFlag(Boolean.valueOf(true));
                                vo3.setParentWarn(Boolean.valueOf(false));
                                vo3.setRowState("add");
                                vo3.setShadowId(vo2.getTid());
                                vo3.setChangeType(Integer.valueOf(3));
                                detailVoList.add(vo3);
                            }
                        }
                    } else if ("4".equals(itemInfo.getOrdCode())) {
                        StatutoryFeesItem statutoryFeesItem = itemInfo.getStatutoryFeesItem();
                        if (statutoryFeesItem != null) {
                            BudgetProjectDetailVO vo43 = new BudgetProjectDetailVO();
                            detailIndex = vo2.getDetailIndex() + ".1";
                            vo43.setDetailIndex(detailIndex);
                            System.out.println(detailIndex);
                            vo43.setName(statutoryFeesItem.getName());
                            vo43.setMny(new BigDecimal(statutoryFeesItem.getTotal()));
                            vo43.setLeafFlag(Boolean.valueOf(true));
                            vo43.setImportFlag(Boolean.valueOf(true));
                            vo43.setParentWarn(Boolean.valueOf(false));
                            vo43.setCode(detailIndex);
                            vo43.setPrice(new BigDecimal(statutoryFeesItem.getTotal()));
                            vo43.setNum(new BigDecimal(1));
                            id = UUID.randomUUID().toString().replaceAll("-", "");
                            split = vo43.getDetailIndex().split("[-/.]");
                            vo43.setTid(id);
                            tidMap.put(vo43.getDetailIndex(), id);
                            if (split.length > 1) {
                                vo43.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                            }
                            vo43.setRowState("add");
                            vo43.setShadowId(vo43.getTid());
                            vo43.setChangeType(Integer.valueOf(3));
                            detailVoList.add(vo43);
                        }
                    } else {
                        if (!"6".equals(itemInfo.getOrdCode())) continue;
                        TaxItem taxItem = itemInfo.getTaxItem();
                        if (taxItem != null) {
                            BudgetProjectDetailVO vo44 = new BudgetProjectDetailVO();
                            detailIndex = vo2.getDetailIndex() + ".1";
                            vo44.setDetailIndex(detailIndex);
                            System.out.println(detailIndex);
                            vo44.setName(taxItem.getName());
                            vo44.setMny(new BigDecimal(taxItem.getTotal()));
                            vo44.setCode(detailIndex);
                            vo44.setPrice(new BigDecimal(taxItem.getTotal()));
                            vo44.setNum(new BigDecimal(1));
                            vo44.setLeafFlag(Boolean.valueOf(true));
                            vo44.setProjectFeature(taxItem.getRate() + "%");
                            id = UUID.randomUUID().toString().replaceAll("-", "");
                            split = vo44.getDetailIndex().split("[-/.]");
                            vo44.setTid(id);
                            tidMap.put(vo44.getDetailIndex(), id);
                            if (split.length > 1) {
                                vo44.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                            }
                            vo44.setRowState("add");
                            vo44.setShadowId(vo44.getTid());
                            vo44.setChangeType(Integer.valueOf(3));
                            vo44.setLeafFlag(Boolean.valueOf(true));
                            vo44.setImportFlag(Boolean.valueOf(true));
                            vo44.setParentWarn(Boolean.valueOf(false));
                            detailVoList.add(vo44);
                        }
                    }
                    detailVoList.add(vo2);
                }
            }
        }
        for (BudgetProjectDetailVO tVo : detailVoList) {
            tVo.setTpid((String)tidMap.get(tVo.getTpid()));
        }
        List deailTreeData = ExcelImportUtil.treeData((List)BeanMapper.mapList(detailVoList, Map.class));
        List mapList = ExcelImportUtil.importFlag((List)deailTreeData);
        ArrayList falseList = new ArrayList();
        List allList = ExcelImportUtil.separate((List)mapList, falseList);
        List errorList = ExcelImportUtil.treeToList((List)((List)allList.get(1)));
        resp.put("successList", allList.get(0));
        resp.put("errorList", (Object)errorList);
        resp.put("successNum", (Object)(sectionalWorks.size() - errorList.size()));
        resp.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)resp);
    }

    @Override
    public List<BudgetProjectDetailVO> detailRef(Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BudgetProjectEntity::getProjectId, (Object)projectId);
        queryWrapper.and(wrapper -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BudgetProjectEntity::getBillState, (Object)1)).or()).eq(BudgetProjectEntity::getBillState, (Object)3));
        BudgetProjectEntity entity = (BudgetProjectEntity)((Object)this.budgetProjectService.getOne((Wrapper)queryWrapper));
        List detailList = new ArrayList();
        if (entity != null && entity.getId() != null) {
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            wrapper2.eq(BudgetProjectDetailEntity::getBudgetId, (Object)entity.getId());
            wrapper2.ne(BudgetProjectDetailEntity::getChangeType, (Object)5);
            wrapper2.orderBy(true, true, (Object[])new SFunction[]{BudgetProjectDetailEntity::getDetailIndex});
            List entityList = super.list((Wrapper)wrapper2);
            if (CollectionUtils.isNotEmpty((Collection)entityList)) {
                for (BudgetProjectDetailEntity i : entityList) {
                    i.setTid(i.getId().toString());
                    i.setTpid(i.getParentId() != null && i.getParentId() > 0L ? i.getParentId().toString() : "");
                }
            }
            detailList = BeanMapper.mapList((Iterable)entityList, BudgetProjectDetailVO.class);
            Collections.sort(detailList, new BudgetDetailComparatoeVo());
        }
        return TreeNodeBUtil.buildTree(detailList);
    }

    @Override
    public CommonResponse<JSONObject> excelImportHk(HttpServletRequest request, HttpServletResponse response) {
        Integer projNameLine = Integer.valueOf(request.getParameter("projNameLine"));
        Integer beginLine = Integer.valueOf(request.getParameter("beginLine"));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = HuaKangExcelReader.readExcel((MultipartFile)mf, (Integer)projNameLine, (Integer)beginLine);
        if (result != null && result.size() > 0) {
            int engineeringNameIndex = 0;
            int nameIndex = 0;
            int itemIndex = 0;
            String engineeringtpid = "";
            String tpid = "";
            LinkedList<BudgetProjectDetailVO> detailVoList = new LinkedList<BudgetProjectDetailVO>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                BudgetProjectDetailVO vo = new BudgetProjectDetailVO();
                boolean flag = false;
                boolean parentWarn = false;
                vo.setSheetName((String)datas.get(0));
                String detailIndex = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) && ((String)datas.get(1)).contains(".") ? null : (String)datas.get(1);
                String code = (String)datas.get(2);
                String name = (String)datas.get(3);
                if (StringUtils.isNotBlank((CharSequence)name) && ("\u5206\u90e8\u5c0f\u8ba1".equals(name) || "\u672c\u9875\u5c0f\u8ba1".equals(name) || "\u5408\u8ba1".equals(name))) continue;
                if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)detailIndex)) {
                    String key;
                    if (StringUtils.isNotBlank((CharSequence)detailIndex)) {
                        if (detailIndex.contains("\u5de5\u7a0b\u540d\u79f0")) {
                            String engineeringName = detailIndex.replaceAll("\u5de5\u7a0b\u540d\u79f0\uff1a", "").trim();
                            vo.setDetailIndex(String.valueOf(++engineeringNameIndex));
                            vo.setName(engineeringName);
                            engineeringtpid = vo.getDetailIndex();
                            vo.setTid(vo.getDetailIndex());
                            nameIndex = 0;
                            vo.setImportFlag(Boolean.valueOf(true));
                            vo.setParentWarn(Boolean.valueOf(false));
                            vo.setRowState("add");
                            vo.setShadowId(vo.getTid());
                            key = vo.getCode() + vo.getName() + vo.getUnit();
                            vo.setKey(key);
                            detailVoList.add(vo);
                            continue;
                        }
                        if (!StringUtils.isBlank((CharSequence)name)) continue;
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)name) || "\u5206\u90e8\u5c0f\u8ba1".equals(name) || "\u672c\u9875\u5c0f\u8ba1".equals(name) || "\u5408\u8ba1".equals(name)) continue;
                    BudgetProjectDetailVO lastVO = (BudgetProjectDetailVO)detailVoList.get(detailVoList.size() - 1);
                    if (lastVO.getDetailIndex().contains(".")) {
                        if (!StringUtils.isBlank((CharSequence)lastVO.getCode())) {
                            String lastDetailIndex = lastVO.getDetailIndex().substring(0, lastVO.getDetailIndex().lastIndexOf("."));
                            String parentDetailIndex = lastDetailIndex.substring(0, lastDetailIndex.lastIndexOf("."));
                            Integer index = Integer.valueOf(lastDetailIndex.substring(lastDetailIndex.lastIndexOf(".") + 1));
                            vo.setDetailIndex(parentDetailIndex + "." + (index + 1));
                            vo.setTpid(parentDetailIndex);
                            vo.setTid(vo.getDetailIndex());
                        } else {
                            vo.setDetailIndex(lastVO.getDetailIndex() + ".1");
                            vo.setTpid(tpid);
                            vo.setTid(vo.getDetailIndex());
                        }
                    } else {
                        vo.setDetailIndex(engineeringNameIndex + "." + ++nameIndex);
                        vo.setCode("\u5355\u4ef7\u63aa\u65bd\u8d39".equals(name) ? code : null);
                        vo.setTpid(engineeringtpid);
                        vo.setTid(vo.getDetailIndex());
                    }
                    vo.setName(name);
                    vo.setParentId(Long.valueOf(111L));
                    tpid = vo.getDetailIndex();
                    itemIndex = 0;
                    vo.setImportFlag(Boolean.valueOf(true));
                    vo.setParentWarn(Boolean.valueOf(false));
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
                    key = vo.getCode() + vo.getName() + vo.getUnit();
                    vo.setKey(key);
                    detailVoList.add(vo);
                    continue;
                }
                String warnType = "";
                String parentId = StringUtils.isBlank((CharSequence)tpid) ? engineeringtpid : tpid;
                vo.setDetailIndex(parentId + "." + ++itemIndex);
                vo.setTid(vo.getDetailIndex());
                vo.setTpid(parentId);
                vo.setParentId(Long.valueOf(111L));
                if (StringUtils.isBlank((CharSequence)code)) {
                    vo.setCode(null);
                    warnType = warnType + "\u9879\u76ee\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setCode(code);
                }
                if (StringUtils.isBlank((CharSequence)name)) {
                    vo.setName(null);
                    warnType = warnType + "\u9879\u76ee\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setName(name.replace(" ", ""));
                }
                vo.setProjectFeature((String)datas.get(4));
                vo.setUnit((String)datas.get(5));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    vo.setNum(null);
                    warnType = warnType + "\u5de5\u7a0b\u91cf\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setNum(new BigDecimal((String)datas.get(6)));
                    }
                    catch (Exception e) {
                        vo.setNum(null);
                        warnType = warnType + "\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    vo.setPrice(null);
                    warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setPrice(new BigDecimal((String)datas.get(7)));
                    }
                    catch (Exception e) {
                        vo.setPrice(null);
                        warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    vo.setMny(null);
                    warnType = warnType + "\u5408\u4ef7\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setMny(new BigDecimal((String)datas.get(8)));
                    }
                    catch (Exception e) {
                        vo.setMny(null);
                        warnType = warnType + "\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (null == vo.getNum() || null == vo.getMny()) {
                    vo.setPrice(null);
                } else if (vo.getNum().compareTo(BigDecimal.ZERO) == 0) {
                    vo.setPrice(null);
                } else {
                    vo.setPrice(vo.getMny().divide(vo.getNum(), 20, 6));
                    vo.setPrice(ComputeUtil.scale((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getMny(), (BigDecimal)vo.getNum()), (int)4));
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setParentWarn(Boolean.valueOf(parentWarn));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                vo.setChangeType(Integer.valueOf(3));
                detailVoList.add(vo);
            }
            List deailTreeData = ExcelImportUtil.treeData((List)BeanMapper.mapList(detailVoList, Map.class));
            List mapList = ExcelImportUtil.importFlag((List)deailTreeData);
            ArrayList falseList = new ArrayList();
            List allList = ExcelImportUtil.separate((List)mapList, falseList);
            List errorList = ExcelImportUtil.treeToList((List)((List)allList.get(1)));
            resp.put("successList", allList.get(0));
            resp.put("errorList", (Object)errorList);
            resp.put("successNum", (Object)(detailVoList.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public List<BudgetMatchVO> queryMatchList(Page<BudgetMatchVO> page, QueryWrapper wrapper, Long budgetId, Long setDetailId) {
        return ((BudgetProjectDetailMapper)this.baseMapper).queryMatchList(page, wrapper, budgetId, setDetailId);
    }

    @Override
    public List<Map<String, Object>> queryThreeCompare(Long projectId) {
        LinkedList<ThreeCompareVO> result = new LinkedList<ThreeCompareVO>();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(BudgetProjectEntity::getProjectId, (Object)projectId);
        queryWrapper.in(BudgetProjectEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = this.budgetProjectService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            List<BudgetProjectEntity> qtList;
            List<BudgetProjectEntity> zbList;
            List<BudgetProjectEntity> sgtList;
            Map<String, ThreeCompareVO> baseCodeMap = new LinkedHashMap<String, ThreeCompareVO>();
            Map<Integer, List<BudgetProjectEntity>> map = entities.stream().collect(Collectors.groupingBy(BudgetProjectEntity::getBudgetType));
            List<BudgetProjectEntity> jsList = map.get(BudgetTypeEnum.\u7ed3\u7b97\u9884\u7b97.getCode());
            if (CollectionUtils.isNotEmpty(jsList)) {
                baseCodeMap = this.dealReportData(jsList, baseCodeMap, BudgetTypeEnum.\u7ed3\u7b97\u9884\u7b97.getCode());
            }
            if (CollectionUtils.isNotEmpty(sgtList = map.get(BudgetTypeEnum.\u65bd\u5de5\u56fe\u9884\u7b97.getCode()))) {
                baseCodeMap = this.dealReportData(sgtList, baseCodeMap, BudgetTypeEnum.\u65bd\u5de5\u56fe\u9884\u7b97.getCode());
            }
            if (CollectionUtils.isNotEmpty(zbList = map.get(BudgetTypeEnum.\u4e2d\u6807\u9884\u7b97.getCode()))) {
                baseCodeMap = this.dealReportData(zbList, baseCodeMap, BudgetTypeEnum.\u4e2d\u6807\u9884\u7b97.getCode());
            }
            if (!baseCodeMap.isEmpty()) {
                ThreeCompareVO compareVO = new ThreeCompareVO();
                compareVO.setId(Long.valueOf(IdWorker.getId()));
                compareVO.setName("\u5408\u540c\u5185");
                result.add(compareVO);
                for (ThreeCompareVO threeVO : baseCodeMap.values()) {
                    if (null == threeVO.getParentId()) {
                        threeVO.setParentId(compareVO.getId());
                    }
                    result.add(threeVO);
                }
            }
            baseCodeMap = new LinkedHashMap();
            List<BudgetProjectEntity> qzList = map.get(BudgetTypeEnum.\u7b7e\u8bc1.getCode());
            if (CollectionUtils.isNotEmpty(qzList)) {
                baseCodeMap = this.dealReportData(qzList, baseCodeMap, BudgetTypeEnum.\u7ed3\u7b97\u9884\u7b97.getCode());
            }
            if (CollectionUtils.isNotEmpty(qtList = map.get(BudgetTypeEnum.\u5176\u4ed6.getCode()))) {
                baseCodeMap = this.dealReportData(qtList, baseCodeMap, BudgetTypeEnum.\u7ed3\u7b97\u9884\u7b97.getCode());
            }
            if (!baseCodeMap.isEmpty()) {
                ThreeCompareVO compareVO = new ThreeCompareVO();
                compareVO.setId(Long.valueOf(IdWorker.getId()));
                compareVO.setName("\u5408\u540c\u5916");
                result.add(compareVO);
                for (ThreeCompareVO threeVO : baseCodeMap.values()) {
                    if (null == threeVO.getParentId()) {
                        threeVO.setParentId(compareVO.getId());
                    }
                    result.add(threeVO);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(result)) {
            this.generateSequences(result);
            List resultMapList = BeanMapper.mapList(result, Map.class);
            List treeData = TreeNodeBUtil.createTreeData((List)resultMapList);
            this.gatherMny(null, treeData);
            return treeData.stream().sorted(BudgetProjectDetailServiceImpl::compareDetailIndex).collect(Collectors.toList());
        }
        return null;
    }

    private Map<String, ThreeCompareVO> dealReportData(List<BudgetProjectEntity> settles, Map<String, ThreeCompareVO> baseCodeMap, Integer bugetType) {
        for (int i = 0; i < settles.size(); ++i) {
            List<BudgetProjectDetailEntity> detailEntities = ((BudgetProjectEntity)((Object)this.budgetProjectService.selectById(settles.get(i).getId()))).getCheckList();
            if (!CollectionUtils.isNotEmpty(detailEntities)) continue;
            detailEntities = detailEntities.stream().sorted(BudgetProjectDetailServiceImpl::compareDetailIndex).collect(Collectors.toList());
            if (baseCodeMap.isEmpty()) {
                for (BudgetProjectDetailEntity budgetProjectDetailEntity : detailEntities) {
                    ThreeCompareVO compareVO = (ThreeCompareVO)BeanMapper.map((Object)((Object)budgetProjectDetailEntity), ThreeCompareVO.class);
                    if (bugetType.equals(BudgetTypeEnum.\u7ed3\u7b97\u9884\u7b97.getCode())) {
                        compareVO.setJsNum(budgetProjectDetailEntity.getNum());
                        compareVO.setJsPrice(budgetProjectDetailEntity.getPrice());
                        compareVO.setJsMny(budgetProjectDetailEntity.getMny());
                    } else if (bugetType.equals(BudgetTypeEnum.\u65bd\u5de5\u56fe\u9884\u7b97.getCode())) {
                        compareVO.setSgtNum(budgetProjectDetailEntity.getNum());
                        compareVO.setSgtPrice(budgetProjectDetailEntity.getPrice());
                        compareVO.setSgtMny(budgetProjectDetailEntity.getMny());
                    } else if (bugetType.equals(BudgetTypeEnum.\u4e2d\u6807\u9884\u7b97.getCode())) {
                        compareVO.setZbNum(budgetProjectDetailEntity.getNum());
                        compareVO.setZbPrice(budgetProjectDetailEntity.getPrice());
                        compareVO.setZbMny(budgetProjectDetailEntity.getMny());
                    }
                    baseCodeMap.put(this.createKey(compareVO), compareVO);
                }
                continue;
            }
            LinkedList<ThreeCompareVO> tmp = new LinkedList<ThreeCompareVO>();
            for (BudgetProjectDetailEntity detailEntity3 : detailEntities) {
                ThreeCompareVO compareVO = (ThreeCompareVO)BeanMapper.map((Object)((Object)detailEntity3), ThreeCompareVO.class);
                if (bugetType.equals(BudgetTypeEnum.\u7ed3\u7b97\u9884\u7b97.getCode())) {
                    compareVO.setJsNum(detailEntity3.getNum());
                    compareVO.setJsPrice(detailEntity3.getPrice());
                    compareVO.setJsMny(detailEntity3.getMny());
                } else if (bugetType.equals(BudgetTypeEnum.\u65bd\u5de5\u56fe\u9884\u7b97.getCode())) {
                    compareVO.setSgtNum(detailEntity3.getNum());
                    compareVO.setSgtPrice(detailEntity3.getPrice());
                    compareVO.setSgtMny(detailEntity3.getMny());
                } else if (bugetType.equals(BudgetTypeEnum.\u4e2d\u6807\u9884\u7b97.getCode())) {
                    compareVO.setZbNum(detailEntity3.getNum());
                    compareVO.setZbPrice(detailEntity3.getPrice());
                    compareVO.setZbMny(detailEntity3.getMny());
                }
                tmp.add(compareVO);
            }
            LinkedHashMap<Long, ThreeCompareVO> linkedHashMap = new LinkedHashMap<Long, ThreeCompareVO>();
            LinkedHashMap<String, ThreeCompareVO> cpreCodeMap = new LinkedHashMap<String, ThreeCompareVO>();
            for (ThreeCompareVO compareVO : tmp) {
                linkedHashMap.put(compareVO.getId(), compareVO);
                cpreCodeMap.put(this.createKey(compareVO), compareVO);
            }
            for (ThreeCompareVO compareVO : tmp) {
                String key = this.createKey(compareVO);
                if (!compareVO.getLeafFlag().booleanValue()) continue;
                String innerCode = compareVO.getInnerCode();
                for (String code : innerCode.split("\\|")) {
                    if (!key.equals(code) && !baseCodeMap.containsKey(code)) {
                        ThreeCompareVO threeCompareVO = (ThreeCompareVO)cpreCodeMap.get(code);
                        if (null != threeCompareVO.getParentId()) {
                            threeCompareVO.setParentId(baseCodeMap.get(this.createKey((ThreeCompareVO)linkedHashMap.get(threeCompareVO.getParentId()))).getId());
                        }
                        baseCodeMap.put(code, threeCompareVO);
                        continue;
                    }
                    if (!key.equals(code)) continue;
                    if (!baseCodeMap.containsKey(code)) {
                        compareVO.setParentId(baseCodeMap.get(this.createKey((ThreeCompareVO)linkedHashMap.get(compareVO.getParentId()))).getId());
                        baseCodeMap.put(key, compareVO);
                        continue;
                    }
                    ThreeCompareVO baseVO = baseCodeMap.get(key);
                    if (bugetType.equals(BudgetTypeEnum.\u7ed3\u7b97\u9884\u7b97.getCode())) {
                        baseVO.setJsNum(ComputeUtil.safeAdd((BigDecimal)baseVO.getJsNum(), (BigDecimal)compareVO.getJsNum()));
                        baseVO.setJsMny(ComputeUtil.safeAdd((BigDecimal)baseVO.getJsMny(), (BigDecimal)compareVO.getJsMny()));
                        baseVO.setJsPrice(ComputeUtil.safeDiv((BigDecimal)baseVO.getJsMny(), (BigDecimal)baseVO.getJsNum()));
                        continue;
                    }
                    if (bugetType.equals(BudgetTypeEnum.\u65bd\u5de5\u56fe\u9884\u7b97.getCode())) {
                        baseVO.setSgtNum(ComputeUtil.safeAdd((BigDecimal)baseVO.getSgtNum(), (BigDecimal)compareVO.getSgtNum()));
                        baseVO.setSgtMny(ComputeUtil.safeAdd((BigDecimal)baseVO.getSgtMny(), (BigDecimal)compareVO.getSgtMny()));
                        baseVO.setSgtPrice(ComputeUtil.safeDiv((BigDecimal)baseVO.getSgtMny(), (BigDecimal)baseVO.getSgtNum()));
                        continue;
                    }
                    if (!bugetType.equals(BudgetTypeEnum.\u4e2d\u6807\u9884\u7b97.getCode())) continue;
                    baseVO.setZbNum(ComputeUtil.safeAdd((BigDecimal)baseVO.getZbNum(), (BigDecimal)compareVO.getZbNum()));
                    baseVO.setZbMny(ComputeUtil.safeAdd((BigDecimal)baseVO.getZbMny(), (BigDecimal)compareVO.getZbMny()));
                    baseVO.setZbPrice(ComputeUtil.safeDiv((BigDecimal)baseVO.getZbMny(), (BigDecimal)baseVO.getZbNum()));
                }
            }
        }
        return baseCodeMap;
    }

    @Override
    public List<Map<String, Object>> queryProfitAnalyse(Long projectId) {
        LinkedList<ThreeCompareVO> result = new LinkedList<ThreeCompareVO>();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(BudgetProjectEntity::getProjectId, (Object)projectId);
        queryWrapper.in(BudgetProjectEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper.in(BudgetProjectEntity::getBudgetType, new Object[]{BudgetTypeEnum.\u65bd\u5de5\u56fe\u9884\u7b97.getCode(), BudgetTypeEnum.\u7b7e\u8bc1.getCode(), BudgetTypeEnum.\u5176\u4ed6.getCode()});
        List entities = this.budgetProjectService.list((Wrapper)queryWrapper);
        this.detailListUtil.setDetailList(entities);
        LambdaQueryWrapper costWrapper = Wrappers.lambdaQuery();
        costWrapper.eq(BudgetProjectProEntity::getProjectId, (Object)projectId);
        costWrapper.in(BudgetProjectProEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List costList = this.costService.list((Wrapper)costWrapper);
        this.detailListUtil.setDetailList(costList);
        Map<Integer, Map<String, BigDecimal>> costMap = costList.stream().map(BudgetProjectProEntity::getDetailList).flatMap(Collection::stream).filter(x -> null != x.getBudgetType() && ComputeUtil.isNotEmpty((BigDecimal)x.getMny()) != false).collect(Collectors.groupingBy(BudgetProjectDetailProEntity::getBudgetType, Collectors.toMap(x -> (x.getCode() == null ? "" : x.getCode()) + ":" + x.getName(), BudgetProjectDetailProEntity::getMny, ComputeUtil::safeAdd)));
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            List<BudgetProjectEntity> qtList;
            Map<String, ThreeCompareVO> baseCodeMap = new LinkedHashMap<String, ThreeCompareVO>();
            Map<Integer, List<BudgetProjectEntity>> map = entities.stream().collect(Collectors.groupingBy(BudgetProjectEntity::getBudgetType));
            List<BudgetProjectEntity> sgtList = map.get(BudgetTypeEnum.\u65bd\u5de5\u56fe\u9884\u7b97.getCode());
            if (CollectionUtils.isNotEmpty(sgtList)) {
                baseCodeMap = this.dealProfitReportData(sgtList, baseCodeMap, BudgetTypeEnum.\u65bd\u5de5\u56fe\u9884\u7b97.getCode(), costMap.get(BudgetTypeEnum.\u65bd\u5de5\u56fe\u9884\u7b97.getCode()));
            }
            if (!baseCodeMap.isEmpty()) {
                ThreeCompareVO compareVO = new ThreeCompareVO();
                compareVO.setId(Long.valueOf(IdWorker.getId()));
                compareVO.setName("\u5408\u540c\u5185");
                result.add(compareVO);
                for (ThreeCompareVO threeVO : baseCodeMap.values()) {
                    if (null == threeVO.getParentId()) {
                        threeVO.setParentId(compareVO.getId());
                    }
                    result.add(threeVO);
                }
            }
            baseCodeMap = new LinkedHashMap();
            List<BudgetProjectEntity> qzList = map.get(BudgetTypeEnum.\u7b7e\u8bc1.getCode());
            if (CollectionUtils.isNotEmpty(qzList)) {
                baseCodeMap = this.dealProfitReportData(qzList, baseCodeMap, BudgetTypeEnum.\u7ed3\u7b97\u9884\u7b97.getCode(), costMap.get(BudgetTypeEnum.\u7b7e\u8bc1.getCode()));
            }
            if (CollectionUtils.isNotEmpty(qtList = map.get(BudgetTypeEnum.\u5176\u4ed6.getCode()))) {
                baseCodeMap = this.dealProfitReportData(qtList, baseCodeMap, BudgetTypeEnum.\u7ed3\u7b97\u9884\u7b97.getCode(), costMap.get(BudgetTypeEnum.\u5176\u4ed6.getCode()));
            }
            if (!baseCodeMap.isEmpty()) {
                ThreeCompareVO compareVO = new ThreeCompareVO();
                compareVO.setId(Long.valueOf(IdWorker.getId()));
                compareVO.setName("\u5408\u540c\u5916");
                result.add(compareVO);
                for (ThreeCompareVO threeVO : baseCodeMap.values()) {
                    if (null == threeVO.getParentId()) {
                        threeVO.setParentId(compareVO.getId());
                    }
                    result.add(threeVO);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(result)) {
            this.generateSequences(result);
            List resultMapList = BeanMapper.mapList(result, Map.class);
            List treeData = TreeNodeBUtil.createTreeData((List)resultMapList);
            this.gatherProfitMny(null, treeData);
            return treeData.stream().sorted(BudgetProjectDetailServiceImpl::compareDetailIndex).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<BudgetSetDetailVO> queryBudgetSimilarByName(Long setId, String name) {
        return ((BudgetProjectDetailMapper)this.baseMapper).queryBudgetSimilarByName(setId, name);
    }

    @Override
    public Integer countBudgetSimilarByName(Long setId, String name) {
        return ((BudgetProjectDetailMapper)this.baseMapper).countBudgetSimilarByName(setId, name);
    }

    private Map<String, ThreeCompareVO> dealProfitReportData(List<BudgetProjectEntity> settles, Map<String, ThreeCompareVO> baseCodeMap, Integer bugetType, Map<String, BigDecimal> costMap) {
        for (int i = 0; i < settles.size(); ++i) {
            List<BudgetProjectDetailEntity> detailEntities = settles.get(i).getCheckList();
            if (!CollectionUtils.isNotEmpty(detailEntities)) continue;
            detailEntities = detailEntities.stream().sorted(BudgetProjectDetailServiceImpl::compareDetailIndex).collect(Collectors.toList());
            if (baseCodeMap.isEmpty()) {
                for (BudgetProjectDetailEntity budgetProjectDetailEntity : detailEntities) {
                    ThreeCompareVO compareVO = (ThreeCompareVO)BeanMapper.map((Object)((Object)budgetProjectDetailEntity), ThreeCompareVO.class);
                    if (bugetType.equals(BudgetTypeEnum.\u7ed3\u7b97\u9884\u7b97.getCode())) {
                        compareVO.setJsNum(budgetProjectDetailEntity.getNum());
                        compareVO.setJsPrice(budgetProjectDetailEntity.getPrice());
                        compareVO.setJsMny(budgetProjectDetailEntity.getMny());
                    } else if (bugetType.equals(BudgetTypeEnum.\u65bd\u5de5\u56fe\u9884\u7b97.getCode())) {
                        compareVO.setSgtNum(budgetProjectDetailEntity.getNum());
                        compareVO.setSgtPrice(budgetProjectDetailEntity.getPrice());
                        compareVO.setSgtMny(budgetProjectDetailEntity.getMny());
                    } else if (bugetType.equals(BudgetTypeEnum.\u4e2d\u6807\u9884\u7b97.getCode())) {
                        compareVO.setZbNum(budgetProjectDetailEntity.getNum());
                        compareVO.setZbPrice(budgetProjectDetailEntity.getPrice());
                        compareVO.setZbMny(budgetProjectDetailEntity.getMny());
                    }
                    if (MapUtil.isNotEmpty(costMap)) {
                        compareVO.setCostMny(costMap.get(this.createKey(compareVO)));
                        compareVO.setProfit(ComputeUtil.safeSub((BigDecimal)compareVO.getMny(), (BigDecimal)compareVO.getCostMny()));
                        compareVO.setProfitRate(ComputeUtil.bigDecimalPercent((BigDecimal)compareVO.getProfit(), (BigDecimal)compareVO.getMny(), (int)2));
                    }
                    baseCodeMap.put(this.createKey(compareVO), compareVO);
                }
                continue;
            }
            LinkedList<ThreeCompareVO> tmp = new LinkedList<ThreeCompareVO>();
            for (BudgetProjectDetailEntity detailEntity3 : detailEntities) {
                ThreeCompareVO compareVO = (ThreeCompareVO)BeanMapper.map((Object)((Object)detailEntity3), ThreeCompareVO.class);
                if (bugetType.equals(BudgetTypeEnum.\u7ed3\u7b97\u9884\u7b97.getCode())) {
                    compareVO.setJsNum(detailEntity3.getNum());
                    compareVO.setJsPrice(detailEntity3.getPrice());
                    compareVO.setJsMny(detailEntity3.getMny());
                } else if (bugetType.equals(BudgetTypeEnum.\u65bd\u5de5\u56fe\u9884\u7b97.getCode())) {
                    compareVO.setSgtNum(detailEntity3.getNum());
                    compareVO.setSgtPrice(detailEntity3.getPrice());
                    compareVO.setSgtMny(detailEntity3.getMny());
                } else if (bugetType.equals(BudgetTypeEnum.\u4e2d\u6807\u9884\u7b97.getCode())) {
                    compareVO.setZbNum(detailEntity3.getNum());
                    compareVO.setZbPrice(detailEntity3.getPrice());
                    compareVO.setZbMny(detailEntity3.getMny());
                }
                if (MapUtil.isNotEmpty(costMap)) {
                    compareVO.setCostMny(costMap.get(this.createKey(compareVO)));
                    compareVO.setProfit(ComputeUtil.safeSub((BigDecimal)compareVO.getMny(), (BigDecimal)compareVO.getCostMny()));
                    compareVO.setProfitRate(ComputeUtil.bigDecimalPercent((BigDecimal)compareVO.getProfit(), (BigDecimal)compareVO.getMny(), (int)2));
                }
                tmp.add(compareVO);
            }
            LinkedHashMap<Long, ThreeCompareVO> linkedHashMap = new LinkedHashMap<Long, ThreeCompareVO>();
            LinkedHashMap<String, ThreeCompareVO> cpreCodeMap = new LinkedHashMap<String, ThreeCompareVO>();
            for (ThreeCompareVO compareVO : tmp) {
                linkedHashMap.put(compareVO.getId(), compareVO);
                cpreCodeMap.put(this.createKey(compareVO), compareVO);
            }
            for (ThreeCompareVO compareVO : tmp) {
                String key = this.createKey(compareVO);
                if (!compareVO.getLeafFlag().booleanValue()) continue;
                String innerCode = compareVO.getInnerCode();
                for (String code : innerCode.split("\\|")) {
                    if (!key.equals(code) && !baseCodeMap.containsKey(code)) {
                        ThreeCompareVO threeCompareVO = (ThreeCompareVO)cpreCodeMap.get(code);
                        if (null != threeCompareVO.getParentId()) {
                            threeCompareVO.setParentId(baseCodeMap.get(this.createKey((ThreeCompareVO)linkedHashMap.get(threeCompareVO.getParentId()))).getId());
                        }
                        baseCodeMap.put(code, threeCompareVO);
                        continue;
                    }
                    if (!key.equals(code)) continue;
                    if (!baseCodeMap.containsKey(code)) {
                        compareVO.setParentId(baseCodeMap.get(this.createKey((ThreeCompareVO)linkedHashMap.get(compareVO.getParentId()))).getId());
                        baseCodeMap.put(key, compareVO);
                        continue;
                    }
                    ThreeCompareVO baseVO = baseCodeMap.get(key);
                    if (bugetType.equals(BudgetTypeEnum.\u7ed3\u7b97\u9884\u7b97.getCode())) {
                        baseVO.setJsNum(ComputeUtil.safeAdd((BigDecimal)baseVO.getJsNum(), (BigDecimal)compareVO.getJsNum()));
                        baseVO.setJsMny(ComputeUtil.safeAdd((BigDecimal)baseVO.getJsMny(), (BigDecimal)compareVO.getJsMny()));
                        baseVO.setJsPrice(ComputeUtil.safeDiv((BigDecimal)baseVO.getJsMny(), (BigDecimal)baseVO.getJsNum()));
                    } else if (bugetType.equals(BudgetTypeEnum.\u65bd\u5de5\u56fe\u9884\u7b97.getCode())) {
                        baseVO.setSgtNum(ComputeUtil.safeAdd((BigDecimal)baseVO.getSgtNum(), (BigDecimal)compareVO.getSgtNum()));
                        baseVO.setSgtMny(ComputeUtil.safeAdd((BigDecimal)baseVO.getSgtMny(), (BigDecimal)compareVO.getSgtMny()));
                        baseVO.setSgtPrice(ComputeUtil.safeDiv((BigDecimal)baseVO.getSgtMny(), (BigDecimal)baseVO.getSgtNum()));
                    } else if (bugetType.equals(BudgetTypeEnum.\u4e2d\u6807\u9884\u7b97.getCode())) {
                        baseVO.setZbNum(ComputeUtil.safeAdd((BigDecimal)baseVO.getZbNum(), (BigDecimal)compareVO.getZbNum()));
                        baseVO.setZbMny(ComputeUtil.safeAdd((BigDecimal)baseVO.getZbMny(), (BigDecimal)compareVO.getZbMny()));
                        baseVO.setZbPrice(ComputeUtil.safeDiv((BigDecimal)baseVO.getZbMny(), (BigDecimal)baseVO.getZbNum()));
                    }
                    baseVO.setNum(ComputeUtil.safeAdd((BigDecimal)baseVO.getNum(), (BigDecimal)compareVO.getNum()));
                    baseVO.setMny(ComputeUtil.safeAdd((BigDecimal)baseVO.getMny(), (BigDecimal)compareVO.getMny()));
                    baseVO.setPrice(ComputeUtil.safeDiv((BigDecimal)baseVO.getMny(), (BigDecimal)baseVO.getNum()));
                    baseVO.setCostMny(ComputeUtil.safeDiv((BigDecimal)baseVO.getCostMny(), (BigDecimal)compareVO.getCostMny()));
                    baseVO.setProfit(ComputeUtil.safeSub((BigDecimal)baseVO.getMny(), (BigDecimal)baseVO.getCostMny()));
                    baseVO.setProfitRate(ComputeUtil.bigDecimalPercent((BigDecimal)baseVO.getProfit(), (BigDecimal)baseVO.getMny(), (int)2));
                }
            }
        }
        return baseCodeMap;
    }

    private String createKey(ThreeCompareVO compareVO) {
        return (compareVO.getCode() == null ? "" : compareVO.getCode()) + ":" + compareVO.getName();
    }

    private static int compareDetailIndex(BudgetProjectDetailEntity detailEntity1, BudgetProjectDetailEntity detailEntity2) {
        String[] parts1 = detailEntity1.getDetailIndex().split("\\.");
        String[] parts2 = detailEntity1.getDetailIndex().split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int part2;
            int part1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = part2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (part1 == part2) continue;
            return Integer.compare(part1, part2);
        }
        return 0;
    }

    private static int compareDetailIndex(Map<String, Object> m1, Map<String, Object> m2) {
        String[] parts1 = ((String)m1.get("detailIndex")).split("\\.");
        String[] parts2 = ((String)m2.get("detailIndex")).split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int part2;
            int part1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = part2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (part1 == part2) continue;
            return Integer.compare(part1, part2);
        }
        return 0;
    }

    private void gatherMny(Map<String, Object> now, List<Map<String, Object>> list) {
        BigDecimal zbMny = null;
        BigDecimal sgtMny = null;
        BigDecimal jsMny = null;
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.gatherMny(ypd, (List)ypd.get("children"));
            }
            zbMny = ComputeUtil.safeAdd(zbMny, (BigDecimal)this.getBigDecimalValue(ypd, "zbMny"));
            sgtMny = ComputeUtil.safeAdd(sgtMny, (BigDecimal)this.getBigDecimalValue(ypd, "sgtMny"));
            jsMny = ComputeUtil.safeAdd(jsMny, (BigDecimal)this.getBigDecimalValue(ypd, "jsMny"));
        }
        if (now != null) {
            now.put("zbMny", zbMny);
            now.put("sgtMny", sgtMny);
            now.put("jsMny", jsMny);
        }
    }

    private void gatherProfitMny(Map<String, Object> now, List<Map<String, Object>> list) {
        BigDecimal zbMny = null;
        BigDecimal sgtMny = null;
        BigDecimal jsMny = null;
        BigDecimal mny = null;
        BigDecimal costMny = null;
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.gatherProfitMny(ypd, (List)ypd.get("children"));
            }
            zbMny = ComputeUtil.safeAdd(zbMny, (BigDecimal)this.getBigDecimalValue(ypd, "zbMny"));
            sgtMny = ComputeUtil.safeAdd(sgtMny, (BigDecimal)this.getBigDecimalValue(ypd, "sgtMny"));
            jsMny = ComputeUtil.safeAdd(jsMny, (BigDecimal)this.getBigDecimalValue(ypd, "jsMny"));
            mny = ComputeUtil.safeAdd(mny, (BigDecimal)this.getBigDecimalValue(ypd, "mny"));
            costMny = ComputeUtil.safeAdd(costMny, (BigDecimal)this.getBigDecimalValue(ypd, "costMny"));
        }
        if (now != null) {
            now.put("zbMny", zbMny);
            now.put("sgtMny", sgtMny);
            now.put("jsMny", jsMny);
            now.put("mny", mny);
            now.put("costMny", costMny);
            BigDecimal profit = ComputeUtil.safeSub(mny, costMny);
            BigDecimal profitRate = ComputeUtil.bigDecimalPercent((BigDecimal)profit, mny, (int)2);
            now.put("profit", profit);
            now.put("profitRate", profitRate);
        }
    }

    private BigDecimal getBigDecimalValue(Map<String, Object> ypd, String code) {
        return ypd.get(code) == null ? null : (BigDecimal)ypd.get(code);
    }

    private void treeToList(List<Map<String, Object>> list, List<ThreeCompareVO> voList) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), voList);
            }
            voList.add((ThreeCompareVO)BeanMapper.map(ypd, ThreeCompareVO.class));
        }
    }

    private void generateSequences(List<ThreeCompareVO> compareVOS) {
        LinkedHashMap<Long, ThreeCompareVO> compareVOMap = new LinkedHashMap<Long, ThreeCompareVO>();
        for (ThreeCompareVO compareVO : compareVOS) {
            compareVOMap.put(compareVO.getId(), compareVO);
        }
        int rootIndex = 1;
        for (ThreeCompareVO department : compareVOS) {
            if (department.getParentId() != null) continue;
            department.setDetailIndex(String.valueOf(rootIndex));
            this.setChildSequences(department, compareVOMap, String.valueOf(rootIndex));
            ++rootIndex;
        }
    }

    private void setChildSequences(ThreeCompareVO compareVO, Map<Long, ThreeCompareVO> compareVOMap, String parentSequence) {
        LinkedList<ThreeCompareVO> children = new LinkedList<ThreeCompareVO>();
        for (ThreeCompareVO department : compareVOMap.values()) {
            if (!compareVO.getId().equals(department.getParentId())) continue;
            children.add(department);
        }
        for (int i = 0; i < children.size(); ++i) {
            ThreeCompareVO child = (ThreeCompareVO)children.get(i);
            String sequence = parentSequence + "." + (i + 1);
            child.setDetailIndex(sequence);
            this.setChildSequences(child, compareVOMap, sequence);
        }
    }
}

