/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.ejianc.business.cost.bean.xml.ConstructionProject;
import com.ejianc.business.cost.bean.xml.DivisionalWorkInfo;
import com.ejianc.business.cost.bean.xml.ExtraItem;
import com.ejianc.business.cost.bean.xml.ListProjectInfo;
import com.ejianc.business.cost.bean.xml.Projectfee;
import com.ejianc.business.cost.bean.xml.SectionalWorks;
import com.ejianc.business.cost.bean.xml.StatutoryFeesItem;
import com.ejianc.business.cost.bean.xml.SummaryItemInfo;
import com.ejianc.business.cost.bean.xml.TaxItem;
import com.ejianc.business.cost.bean.xml.UnitWorks;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"ydbx"})
public class YdbxController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/excelImportZip"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportZip(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if (!"ydbx".equalsIgnoreCase(extName)) {
                return CommonResponse.error((String)"\u8bf7\u4e0a\u4f20.ydbx\u6587\u4ef6");
            }
            try {
                YdbxController.processYdbxAsZip(mf);
            }
            catch (Exception e) {
                this.logger.error("\u5904\u7406.ydbx\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                return CommonResponse.error((String)("\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage()));
            }
        }
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    public static ConstructionProject processYdbxAsZip(MultipartFile file) throws Exception {
        byte[] fileBytes = file.getBytes();
        ConstructionProject project = null;
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileBytes);
             ZipInputStream zis = new ZipInputStream(byteArrayInputStream);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (!"Projects.xml".equals(entry.getName())) continue;
                project = YdbxController.parseProjectsXml(zis);
                YdbxController.collectRequiredFiles(project, fileBytes);
                break;
            }
        }
        return project;
    }

    public static void collectRequiredFiles(ConstructionProject project, byte[] fileBytes) throws Exception {
        if (project.getProjectfee() != null && project.getProjectfee().getSectionalWorks() != null) {
            for (SectionalWorks sectionalWorks : project.getProjectfee().getSectionalWorks()) {
                if (sectionalWorks.getUnitWorks() == null) continue;
                block19: for (UnitWorks unitWork : sectionalWorks.getUnitWorks()) {
                    String relFileName = unitWork.getRelFileName();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileBytes);
                    Throwable throwable = null;
                    try {
                        ZipInputStream zis = new ZipInputStream(byteArrayInputStream);
                        Throwable throwable2 = null;
                        try {
                            ZipEntry entry;
                            while ((entry = zis.getNextEntry()) != null) {
                                if (!relFileName.equals(entry.getName())) continue;
                                List<SummaryItemInfo> summaryItemInfos = YdbxController.parseSummaryItemInfo(zis);
                                unitWork.setSummaryItemInfos(summaryItemInfos);
                                continue block19;
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (zis == null) continue;
                            if (throwable2 != null) {
                                try {
                                    zis.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            zis.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (byteArrayInputStream == null) continue;
                        if (throwable != null) {
                            try {
                                byteArrayInputStream.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        byteArrayInputStream.close();
                    }
                }
            }
        }
    }

    public static List<SummaryItemInfo> parseSummaryItemInfo(InputStream inputStream) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(inputStream);
        Element rootElement = document.getRootElement();
        Element Summary = rootElement.element("Summary");
        ArrayList<SummaryItemInfo> summaryItemInfos = new ArrayList<SummaryItemInfo>();
        List elements = Summary.elements("SummaryItem");
        if (ListUtil.isNotEmpty((List)elements)) {
            for (Element e : elements) {
                Element element;
                ListProjectInfo listProjectInfo;
                Element listProjectElement;
                Object billTableElement2;
                SummaryItemInfo summaryItemInfo = new SummaryItemInfo();
                summaryItemInfo.setOrdCode(e.attributeValue("OrdCode"));
                summaryItemInfo.setName(e.attributeValue("Name"));
                summaryItemInfo.setCalcVariable(e.attributeValue("CalcVariable"));
                summaryItemInfo.setCalcBasis(e.attributeValue("CalcBasis"));
                summaryItemInfo.setKindCode(e.attributeValue("KindCode"));
                summaryItemInfo.setFormula(e.attributeValue("Formula"));
                summaryItemInfo.setQfjs(e.attributeValue("Qfjs"));
                summaryItemInfo.setRate(e.attributeValue("Rate"));
                summaryItemInfo.setTotal(e.attributeValue("Total"));
                summaryItemInfo.setRemark(e.attributeValue("Remark"));
                if ("1".equals(e.attributeValue("OrdCode"))) {
                    Element BillTable = rootElement.element("BillTable");
                    ArrayList<DivisionalWorkInfo> billTablesList = new ArrayList<DivisionalWorkInfo>();
                    List billTableElements = BillTable.elements("DivisionalWorks");
                    if (ListUtil.isNotEmpty((List)billTableElements)) {
                        for (Object billTableElement2 : billTableElements) {
                            DivisionalWorkInfo divisionalWorkInfo = new DivisionalWorkInfo();
                            divisionalWorkInfo.setName(billTableElement2.attributeValue("Name"));
                            divisionalWorkInfo.setCode(billTableElement2.attributeValue("Code"));
                            divisionalWorkInfo.setAttr(billTableElement2.attributeValue("Attr"));
                            divisionalWorkInfo.setUnit(billTableElement2.attributeValue("Unit"));
                            divisionalWorkInfo.setQuantity(billTableElement2.attributeValue("Quantity"));
                            divisionalWorkInfo.setTotal(billTableElement2.attributeValue("Total"));
                            divisionalWorkInfo.setTotalCode(billTableElement2.attributeValue("TotalCode"));
                            divisionalWorkInfo.setRemark(billTableElement2.attributeValue("Remark"));
                            divisionalWorkInfo.setZgj(billTableElement2.attributeValue("Zgj"));
                            ArrayList<ListProjectInfo> listProjects = new ArrayList<ListProjectInfo>();
                            List listProjectElements = billTableElement2.elements("ListProjects");
                            if (ListUtil.isNotEmpty((List)listProjectElements)) {
                                for (Element listProjectElement2 : listProjectElements) {
                                    ListProjectInfo listProjectInfo2 = new ListProjectInfo();
                                    listProjectInfo2.setCode(listProjectElement2.attributeValue("Code"));
                                    listProjectInfo2.setName(listProjectElement2.attributeValue("Name"));
                                    listProjectInfo2.setAttr(listProjectElement2.attributeValue("Attr"));
                                    listProjectInfo2.setContent(listProjectElement2.attributeValue("Content"));
                                    listProjectInfo2.setUnit(listProjectElement2.attributeValue("Unit"));
                                    listProjectInfo2.setQuantity(listProjectElement2.attributeValue("Quantity"));
                                    listProjectInfo2.setPrice(listProjectElement2.attributeValue("Price"));
                                    listProjectInfo2.setCalcType(listProjectElement2.attributeValue("CalcType"));
                                    listProjectInfo2.setCalcBasis(listProjectElement2.attributeValue("CalcBasis"));
                                    listProjectInfo2.setFormula(listProjectElement2.attributeValue("Formula"));
                                    listProjectInfo2.setRate(listProjectElement2.attributeValue("Rate"));
                                    listProjectInfo2.setTotal(listProjectElement2.attributeValue("Total"));
                                    listProjectInfo2.setMajor(listProjectElement2.attributeValue("Major"));
                                    listProjectInfo2.setTotalCode(listProjectElement2.attributeValue("TotalCode"));
                                    listProjectInfo2.setSpecialty(listProjectElement2.attributeValue("Specialty"));
                                    listProjectInfo2.setListingIdentity(listProjectElement2.attributeValue("ListingIdentity"));
                                    listProjectInfo2.setRemark(listProjectElement2.attributeValue("Remark"));
                                    listProjects.add(listProjectInfo2);
                                }
                                divisionalWorkInfo.setListProjects(listProjects);
                            }
                            billTablesList.add(divisionalWorkInfo);
                        }
                        summaryItemInfo.setBillTables(billTablesList);
                    } else {
                        billTableElements = BillTable.elements("ListProjects");
                        if (ListUtil.isNotEmpty((List)billTableElements)) {
                            ArrayList<ListProjectInfo> billTableList = new ArrayList<ListProjectInfo>();
                            billTableElement2 = billTableElements.iterator();
                            while (billTableElement2.hasNext()) {
                                listProjectElement = (Element)billTableElement2.next();
                                listProjectInfo = new ListProjectInfo();
                                listProjectInfo.setCode(listProjectElement.attributeValue("Code"));
                                listProjectInfo.setName(listProjectElement.attributeValue("Name"));
                                listProjectInfo.setAttr(listProjectElement.attributeValue("Attr"));
                                listProjectInfo.setContent(listProjectElement.attributeValue("Content"));
                                listProjectInfo.setUnit(listProjectElement.attributeValue("Unit"));
                                listProjectInfo.setQuantity(listProjectElement.attributeValue("Quantity"));
                                listProjectInfo.setPrice(listProjectElement.attributeValue("Price"));
                                listProjectInfo.setCalcType(listProjectElement.attributeValue("CalcType"));
                                listProjectInfo.setCalcBasis(listProjectElement.attributeValue("CalcBasis"));
                                listProjectInfo.setFormula(listProjectElement.attributeValue("Formula"));
                                listProjectInfo.setRate(listProjectElement.attributeValue("Rate"));
                                listProjectInfo.setTotal(listProjectElement.attributeValue("Total"));
                                listProjectInfo.setMajor(listProjectElement.attributeValue("Major"));
                                listProjectInfo.setTotalCode(listProjectElement.attributeValue("TotalCode"));
                                listProjectInfo.setSpecialty(listProjectElement.attributeValue("Specialty"));
                                listProjectInfo.setListingIdentity(listProjectElement.attributeValue("ListingIdentity"));
                                listProjectInfo.setRemark(listProjectElement.attributeValue("Remark"));
                                billTableList.add(listProjectInfo);
                            }
                            summaryItemInfo.setBillTableList(billTableList);
                        }
                    }
                    summaryItemInfos.add(summaryItemInfo);
                    continue;
                }
                if ("2".equals(e.attributeValue("OrdCode"))) {
                    Object element2;
                    ArrayList<ListProjectInfo> listProjects;
                    List ListProjects;
                    Element PreliminariesByTotal = rootElement.element("PreliminariesTable").element("PreliminariesByTotal");
                    Element PreliminariesByPrice = rootElement.element("PreliminariesTable").element("PreliminariesByPrice");
                    if (PreliminariesByTotal != null) {
                        ListProjects = PreliminariesByTotal.elements("ListProjects");
                        listProjects = new ArrayList<ListProjectInfo>();
                        if (ListUtil.isNotEmpty((List)ListProjects)) {
                            billTableElement2 = ListProjects.iterator();
                            while (billTableElement2.hasNext()) {
                                listProjectElement = (Element)billTableElement2.next();
                                listProjectInfo = new ListProjectInfo();
                                listProjectInfo.setCode(listProjectElement.attributeValue("Code"));
                                listProjectInfo.setName(listProjectElement.attributeValue("Name"));
                                listProjectInfo.setAttr(listProjectElement.attributeValue("Attr"));
                                listProjectInfo.setContent(listProjectElement.attributeValue("Content"));
                                listProjectInfo.setUnit(listProjectElement.attributeValue("Unit"));
                                listProjectInfo.setQuantity(listProjectElement.attributeValue("Quantity"));
                                listProjectInfo.setPrice(listProjectElement.attributeValue("Price"));
                                listProjectInfo.setCalcType(listProjectElement.attributeValue("CalcType"));
                                listProjectInfo.setCalcBasis(listProjectElement.attributeValue("CalcBasis"));
                                listProjectInfo.setFormula(listProjectElement.attributeValue("Formula"));
                                listProjectInfo.setRate(listProjectElement.attributeValue("Rate"));
                                listProjectInfo.setTotal(listProjectElement.attributeValue("Total"));
                                listProjectInfo.setMajor(listProjectElement.attributeValue("Major"));
                                listProjectInfo.setTotalCode(listProjectElement.attributeValue("TotalCode"));
                                listProjectInfo.setSpecialty(listProjectElement.attributeValue("Specialty"));
                                listProjectInfo.setListingIdentity(listProjectElement.attributeValue("ListingIdentity"));
                                listProjectInfo.setRemark(listProjectElement.attributeValue("Remark"));
                                listProjects.add(listProjectInfo);
                            }
                        }
                        if ((element2 = PreliminariesByTotal.element("DivisionalWorks")) != null) {
                            ListProjectInfo listProjectInfo3 = new ListProjectInfo();
                            listProjectInfo3.setCode(element2.attributeValue("Code"));
                            listProjectInfo3.setName(element2.attributeValue("Name"));
                            listProjectInfo3.setAttr(element2.attributeValue("Attr"));
                            listProjectInfo3.setUnit(element2.attributeValue("Unit"));
                            listProjectInfo3.setRemark(element2.attributeValue("Remark"));
                            listProjects.add(listProjectInfo3);
                            List innerListProjects = element2.elements("ListProjects");
                            if (ListUtil.isNotEmpty((List)innerListProjects)) {
                                ArrayList<ListProjectInfo> innerListProjectList = new ArrayList<ListProjectInfo>();
                                for (Element listProjectElement2 : innerListProjects) {
                                    ListProjectInfo innerListProjectInfo = new ListProjectInfo();
                                    innerListProjectInfo.setCode(listProjectElement2.attributeValue("Code"));
                                    innerListProjectInfo.setName(listProjectElement2.attributeValue("Name"));
                                    innerListProjectInfo.setAttr(listProjectElement2.attributeValue("Attr"));
                                    innerListProjectInfo.setContent(listProjectElement2.attributeValue("Content"));
                                    innerListProjectInfo.setUnit(listProjectElement2.attributeValue("Unit"));
                                    innerListProjectInfo.setQuantity(listProjectElement2.attributeValue("Quantity"));
                                    innerListProjectInfo.setPrice(listProjectElement2.attributeValue("Price"));
                                    innerListProjectInfo.setCalcType(listProjectElement2.attributeValue("CalcType"));
                                    innerListProjectInfo.setCalcBasis(listProjectElement2.attributeValue("CalcBasis"));
                                    innerListProjectInfo.setFormula(listProjectElement2.attributeValue("Formula"));
                                    innerListProjectInfo.setRate(listProjectElement2.attributeValue("Rate"));
                                    innerListProjectInfo.setTotal(listProjectElement2.attributeValue("Total"));
                                    innerListProjectInfo.setMajor(listProjectElement2.attributeValue("Major"));
                                    innerListProjectInfo.setTotalCode(listProjectElement2.attributeValue("TotalCode"));
                                    innerListProjectInfo.setSpecialty(listProjectElement2.attributeValue("Specialty"));
                                    innerListProjectInfo.setListingIdentity(listProjectElement2.attributeValue("ListingIdentity"));
                                    innerListProjectInfo.setRemark(listProjectElement2.attributeValue("Remark"));
                                    innerListProjectList.add(innerListProjectInfo);
                                }
                                listProjectInfo3.setInnerListProjectInfos(innerListProjectList);
                            }
                        }
                        summaryItemInfo.setPreliminariesByTotal(listProjects);
                    }
                    if (PreliminariesByPrice != null) {
                        ListProjects = PreliminariesByPrice.elements("ListProjects");
                        listProjects = new ArrayList();
                        if (ListUtil.isNotEmpty((List)ListProjects)) {
                            element2 = ListProjects.iterator();
                            while (element2.hasNext()) {
                                listProjectElement = (Element)element2.next();
                                listProjectInfo = new ListProjectInfo();
                                listProjectInfo.setCode(listProjectElement.attributeValue("Code"));
                                listProjectInfo.setName(listProjectElement.attributeValue("Name"));
                                listProjectInfo.setAttr(listProjectElement.attributeValue("Attr"));
                                listProjectInfo.setContent(listProjectElement.attributeValue("Content"));
                                listProjectInfo.setUnit(listProjectElement.attributeValue("Unit"));
                                listProjectInfo.setQuantity(listProjectElement.attributeValue("Quantity"));
                                listProjectInfo.setPrice(listProjectElement.attributeValue("Price"));
                                listProjectInfo.setCalcType(listProjectElement.attributeValue("CalcType"));
                                listProjectInfo.setCalcBasis(listProjectElement.attributeValue("CalcBasis"));
                                listProjectInfo.setFormula(listProjectElement.attributeValue("Formula"));
                                listProjectInfo.setRate(listProjectElement.attributeValue("Rate"));
                                listProjectInfo.setTotal(listProjectElement.attributeValue("Total"));
                                listProjectInfo.setMajor(listProjectElement.attributeValue("Major"));
                                listProjectInfo.setTotalCode(listProjectElement.attributeValue("TotalCode"));
                                listProjectInfo.setSpecialty(listProjectElement.attributeValue("Specialty"));
                                listProjectInfo.setListingIdentity(listProjectElement.attributeValue("ListingIdentity"));
                                listProjectInfo.setRemark(listProjectElement.attributeValue("Remark"));
                                listProjects.add(listProjectInfo);
                            }
                        }
                        summaryItemInfo.setPreliminariesByPrice(listProjects);
                    }
                    summaryItemInfos.add(summaryItemInfo);
                    continue;
                }
                if ("3".equals(e.attributeValue("OrdCode"))) {
                    Element ExtraTable = rootElement.element("ExtraTable");
                    if (ExtraTable != null) {
                        List ExtraItems = ExtraTable.elements("ExtraItem");
                        ArrayList<ExtraItem> extraItems = new ArrayList<ExtraItem>();
                        if (ListUtil.isNotEmpty((List)ExtraItems)) {
                            for (Object element2 : ExtraItems) {
                                ExtraItem extraItem = new ExtraItem();
                                extraItem.setName(element2.attributeValue("Name"));
                                extraItem.setCode(element2.attributeValue("Code"));
                                extraItem.setCalcVariable(element2.attributeValue("CalcVariable"));
                                extraItem.setCalcBasis(element2.attributeValue("CalcBasis"));
                                extraItem.setUnit(element2.attributeValue("Unit"));
                                extraItem.setQuantity(element2.attributeValue("Quantity"));
                                extraItem.setPrice(element2.attributeValue("Price"));
                                extraItem.setFormula(element2.attributeValue("Formula"));
                                extraItem.setRate(element2.attributeValue("Rate"));
                                extraItem.setTotal(element2.attributeValue("Total"));
                                extraItem.setKind(element2.attributeValue("Kind"));
                                extraItem.setXmlb(element2.attributeValue("Xmlb"));
                                extraItem.setRemark(element2.attributeValue("Remark"));
                                extraItems.add(extraItem);
                            }
                        }
                        summaryItemInfo.setExtraTables(extraItems);
                    }
                    summaryItemInfos.add(summaryItemInfo);
                    continue;
                }
                if ("4".equals(e.attributeValue("OrdCode"))) {
                    element = rootElement.element("StatutoryFees").element("StatutoryFeesItem");
                    StatutoryFeesItem statutoryFeesItem = new StatutoryFeesItem();
                    statutoryFeesItem.setOrdCode(element.attributeValue("OrdCode"));
                    statutoryFeesItem.setCalcVariable(element.attributeValue("CalcVariable"));
                    statutoryFeesItem.setName(element.attributeValue("Name"));
                    statutoryFeesItem.setCalcBasis(element.attributeValue("CalcBasis"));
                    statutoryFeesItem.setKindCode(element.attributeValue("KindCode"));
                    statutoryFeesItem.setFormula(element.attributeValue("Formula"));
                    statutoryFeesItem.setRate(element.attributeValue("Rate"));
                    statutoryFeesItem.setTotal(element.attributeValue("Total"));
                    statutoryFeesItem.setRemark(element.attributeValue("Remark"));
                    summaryItemInfo.setStatutoryFeesItem(statutoryFeesItem);
                    summaryItemInfos.add(summaryItemInfo);
                    continue;
                }
                if ("6".equals(e.attributeValue("OrdCode"))) {
                    element = rootElement.element("TaxTable").element("TaxItem");
                    TaxItem taxItem = new TaxItem();
                    taxItem.setOrdCode(element.attributeValue("OrdCode"));
                    taxItem.setCalcVariable(element.attributeValue("CalcVariable"));
                    taxItem.setName(element.attributeValue("Name"));
                    taxItem.setCalcBasis(element.attributeValue("CalcBasis"));
                    taxItem.setKindCode(element.attributeValue("KindCode"));
                    taxItem.setFormula(element.attributeValue("Formula"));
                    taxItem.setRate(element.attributeValue("Rate"));
                    taxItem.setTotal(element.attributeValue("Total"));
                    taxItem.setRemark(element.attributeValue("Remark"));
                    summaryItemInfo.setTaxItem(taxItem);
                    summaryItemInfos.add(summaryItemInfo);
                    continue;
                }
                if (!"5".equals(e.attributeValue("OrdCode")) && !"7".equals(e.attributeValue("OrdCode"))) continue;
                summaryItemInfos.add(summaryItemInfo);
            }
        }
        return summaryItemInfos;
    }

    public static ConstructionProject parseProjectsXml(InputStream inputStream) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(inputStream);
        Element rootElement = document.getRootElement();
        ConstructionProject project = new ConstructionProject();
        project.setNumber(rootElement.attributeValue("Number"));
        project.setName(rootElement.attributeValue("Name"));
        project.setSegment(rootElement.attributeValue("Segment"));
        project.setProjectAdress(rootElement.attributeValue("ProjectAdress"));
        project.setFileKind(rootElement.attributeValue("FileKind"));
        project.setStandardName(rootElement.attributeValue("StandardName"));
        project.setScale(rootElement.attributeValue("Scale"));
        project.setExplains(rootElement.attributeValue("Explains"));
        project.setVersion(rootElement.attributeValue("Version"));
        Element projectfeeElement = rootElement.element("Projectfee");
        if (projectfeeElement != null) {
            Projectfee projectfee = YdbxController.parseProjectfee(projectfeeElement);
            project.setProjectfee(projectfee);
        }
        return project;
    }

    public static Projectfee parseProjectfee(Element projectfeeElement) {
        Projectfee projectfee = new Projectfee();
        projectfee.setName(projectfeeElement.attributeValue("Name"));
        projectfee.setTotal(projectfeeElement.attributeValue("Total"));
        projectfee.setSoftNum(projectfeeElement.attributeValue("SoftNum"));
        projectfee.setScale(projectfeeElement.attributeValue("Scale"));
        projectfee.setRemark(projectfeeElement.attributeValue("Remark"));
        List sectionalWorksElements = projectfeeElement.elements("SectionalWorks");
        ArrayList<SectionalWorks> sectionalWorksList = new ArrayList<SectionalWorks>();
        for (Element sectionalWorksElement : sectionalWorksElements) {
            SectionalWorks sectionalWorks = YdbxController.parseSectionalWorks(sectionalWorksElement);
            sectionalWorksList.add(sectionalWorks);
        }
        projectfee.setSectionalWorks(sectionalWorksList);
        return projectfee;
    }

    public static SectionalWorks parseSectionalWorks(Element sectionalWorksElement) {
        SectionalWorks sectionalWorks = new SectionalWorks();
        sectionalWorks.setName(sectionalWorksElement.attributeValue("Name"));
        sectionalWorks.setTotal(sectionalWorksElement.attributeValue("Total"));
        sectionalWorks.setScale(sectionalWorksElement.attributeValue("Scale"));
        sectionalWorks.setSegment(sectionalWorksElement.attributeValue("Segment"));
        sectionalWorks.setRatios(sectionalWorksElement.attributeValue("Ratios"));
        sectionalWorks.setRemark(sectionalWorksElement.attributeValue("Remark"));
        List unitWorksElements = sectionalWorksElement.elements("UnitWorks");
        ArrayList<UnitWorks> unitWorksList = new ArrayList<UnitWorks>();
        for (Element unitWorksElement : unitWorksElements) {
            UnitWorks unitWorks = new UnitWorks();
            unitWorks.setRelFileName(unitWorksElement.attributeValue("RelFileName"));
            unitWorks.setNumber(unitWorksElement.attributeValue("Number"));
            unitWorks.setName(unitWorksElement.attributeValue("Name"));
            unitWorks.setSoftNum(unitWorksElement.attributeValue("SoftNum"));
            unitWorks.setTotal(unitWorksElement.attributeValue("Total"));
            unitWorks.setSpecialty(unitWorksElement.attributeValue("Specialty"));
            unitWorks.setPurposes(unitWorksElement.attributeValue("Purposes"));
            unitWorks.setScale(unitWorksElement.attributeValue("Scale"));
            unitWorks.setValuationMethod(unitWorksElement.attributeValue("ValuationMethod"));
            unitWorks.setTaxModel(unitWorksElement.attributeValue("TaxModel"));
            unitWorks.setListingIdentity(unitWorksElement.attributeValue("ListingIdentity"));
            unitWorks.setNormIdentity(unitWorksElement.attributeValue("NormIdentity"));
            unitWorks.setRemark(unitWorksElement.attributeValue("Remark"));
            unitWorksList.add(unitWorks);
        }
        sectionalWorks.setUnitWorks(unitWorksList);
        return sectionalWorks;
    }
}

