package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.ejianc.business.cost.bean.ForecastContractDetailEntity;
import com.ejianc.business.cost.mapper.ForecastContractDetailChangeMapper;
import com.ejianc.business.cost.service.IForecastContractDetailService;
import com.ejianc.business.cost.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.ForecastContractDetailChangeEntity;
import com.ejianc.business.cost.service.IForecastContractDetailChangeService;

/**
 * 合同成本关门预估变更控制明细
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("forecastContractDetailChange")
public class ForecastContractDetailChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IForecastContractDetailChangeService service;

    @Autowired
    private IForecastContractDetailService iForecastContractDetailService;

    @Autowired
    private ForecastContractDetailChangeMapper forecastContractDetailChangeMapper;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ForecastContractDetailChangeVO> saveOrUpdate(@RequestBody ForecastContractDetailChangeVO saveOrUpdateVO) {
    	ForecastContractDetailChangeEntity entity = BeanMapper.map(saveOrUpdateVO, ForecastContractDetailChangeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ForecastContractDetailChangeVO vo = BeanMapper.map(entity, ForecastContractDetailChangeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ForecastContractDetailChangeVO> queryDetail(Long id) {
    	ForecastContractDetailChangeEntity entity = service.selectById(id);
    	ForecastContractDetailChangeVO vo = BeanMapper.map(entity, ForecastContractDetailChangeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ForecastContractDetailChangeVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ForecastContractDetailChangeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ForecastContractDetailChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ForecastContractDetailChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ForecastContractDetailChangeEntity> page = service.queryPage(param,false);
        IPage<ForecastContractDetailChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ForecastContractDetailChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ForecastContractDetailChangeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ForecastContractDetailChange-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refForecastContractDetailChangeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ForecastContractDetailChangeVO>> refForecastContractDetailChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ForecastContractDetailChangeEntity> page = service.queryPage(param,false);
        IPage<ForecastContractDetailChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ForecastContractDetailChangeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 根据项目查询物资合同
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/querySubContractByProjectIdMaterial", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ForecastChangeMaterialcontractDetailVO>> refProjectDataMaterial(@RequestParam(value = "projectId", required = false) String projectId) {
        List<ForecastChangeMaterialcontractDetailVO> resultList = service.querySubContractByProjectIdMaterial(projectId);
        return CommonResponse.success("查询数据成功！",resultList);
    }

    /**
     * @Description 根据项目查询机械合同
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/querySubContractByProjectIdMachine", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ForecastChangeMachinecontractDetailVO>> refProjectDataMachine(@RequestParam(value = "projectId", required = false) String projectId) {
        List<ForecastChangeMachinecontractDetailVO> resultList = service.querySubContractByProjectIdMachine(projectId);
        return CommonResponse.success("查询数据成功！",resultList);
    }

    /**
     * @Description 根据项目查询其他合同
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/querySubContractByProjectIdOther", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ForecastChangeOthercontractDetailVO>> refProjectDataOther(@RequestParam(value = "projectId", required = false) String projectId) {
        List<ForecastChangeOthercontractDetailVO> resultList = service.querySubContractByProjectIdOther(projectId);
        return CommonResponse.success("查询数据成功！",resultList);
    }

    /**
     * @Description 根据项目查询物资合同
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/querySubContractByIdMaterial", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ForecastChangeMaterialcontractDetailVO>> refProjectDataMaterial(@RequestParam(value = "id", required = false) Long id) {
        List<ForecastChangeMaterialcontractDetailVO> resultList = service.querySubContractByIdMaterial(id);
        return CommonResponse.success("查询数据成功！",resultList);
    }

    /**
     * @Description 根据项目查询机械合同
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/querySubContractByIdMachine", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ForecastChangeMachinecontractDetailVO>> refProjectDataMachine(@RequestParam(value = "id", required = false) Long id) {
        List<ForecastChangeMachinecontractDetailVO> resultList = service.querySubContractByIdMachine(id);
        return CommonResponse.success("查询数据成功！",resultList);
    }

    /**
     * @Description 根据项目查询其他合同
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/querySubContractByIdOther", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ForecastChangeOthercontractDetailVO>> refProjectDataOther(@RequestParam(value = "id", required = false) Long id) {
        List<ForecastChangeOthercontractDetailVO> resultList = service.querySubContractByIdOther(id);
        return CommonResponse.success("查询数据成功！",resultList);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/queryAllSubDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ForecastContractDetailVO>> queryAllSubDetail(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                                     String condition,
                                                                                                     String searchObject,
                                                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractType");
        fuzzyFields.add("subOrg");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotBlank(condition)) {
            logger.debug("condition is " + condition);
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            /** 根据项目过滤 */
            if(null != conditionMap.get("costClosingForecastId")) {
                Long costClosingForecastId =  Long.valueOf(conditionMap.get("costClosingForecastId").toString());
                param.getParams().put("costClosingForecastId", new Parameter(QueryParam.EQ, costClosingForecastId));
            }
        }
        IPage<ForecastContractDetailEntity> page = iForecastContractDetailService.queryPage(param,false);
        IPage<ForecastContractDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ForecastContractDetailVO.class));


        return CommonResponse.success("查询参照数据成功！",pageData);
    }
}
