package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.CostClosingEntity;
import com.ejianc.business.cost.vo.CostClosingVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.CostClosingLastMapper;
import com.ejianc.business.cost.bean.CostClosingLastEntity;
import com.ejianc.business.cost.service.ICostClosingLastService;

import java.util.Map;

/**
 * 最终成本关门通知
 *
 * @author generator
 *
 */
@Service("costClosingLastService")
public class CostClosingLastServiceImpl extends BaseServiceImpl<CostClosingLastMapper, CostClosingLastEntity> implements ICostClosingLastService{


    @Override
    public CostClosingVO getCostClosing(String id) {
        CostClosingEntity costClosing = this.baseMapper.getCostClosing(id);
        CostClosingVO vo = BeanMapper.map(costClosing, CostClosingVO.class);
        return vo;
    }

    @Override
    public String addProjectCheck(Long projectId,Long id) {
        String message = "";
        Integer total = this.baseMapper.querytotal(projectId,id);
        if(total != 0) {
            message ="该项目已经存在最终成本关门通知单！";
        }
        return message;
    }


    @Override
    public String checkchange(Long id) {
        String message = "";
        CostClosingLastEntity entity = this.selectById(id);
        Integer total = this.baseMapper.querychange(id);
        if(total != 0) {
            message ="当前选中最终通知单存在尚未提交或审核的变更单，请提交或审核后再进行变更！";
        }
        Integer sumtotal = this.baseMapper.querysum(entity.getProjectId());
        if(sumtotal != 0) {
            message ="当前选中最终通知单已完成最终成本关门汇总，禁止变更！";
        }
        return message;
    }
}
