/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.cost.bean.AccountingProjectEntity;
import com.ejianc.business.cost.service.IAccountingProjectService;
import com.ejianc.business.cost.vo.AccountingProjectImportVO;
import com.ejianc.business.cost.vo.AccountingProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"accountingProject"})
public class AccountingProjectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    private static final String ACCOUNTING_PROJECT = "BT211012000000006";
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IAccountingProjectService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AccountingProjectVO> saveOrUpdate(@RequestBody AccountingProjectVO saveorUpdateVO) {
        return this.service.saveOrUpdate(saveorUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AccountingProjectVO> queryDetail(Long id) {
        AccountingProjectEntity entity = (AccountingProjectEntity)((Object)this.service.selectById(id));
        AccountingProjectVO vo = (AccountingProjectVO)BeanMapper.map((Object)((Object)entity), AccountingProjectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AccountingProjectVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        for (Long billId : ids) {
            CommonResponse res = this.billTypeApi.checkQuote(ACCOUNTING_PROJECT, billId);
            this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
            if (res.isSuccess()) continue;
            throw new BusinessException("\u5b58\u5728\u88ab\u7ed3\u7b97\u5355\u5f15\u7528\u7684\u6863\u6848\uff0c\u8bf7\u5904\u7406\u540e\u518d\u5220\u9664\uff01");
        }
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("accountingName");
        fuzzyFields.add("accountingCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("accountingCode", "asc");
        List list = this.service.queryList(param, false);
        List resultMapList = BeanMapper.mapList((Iterable)list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("AccountingProject-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refAccountingProjectData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refAccountingProjectData(@RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("accountingName");
        param.getFuzzyFields().add("accountingCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null == conditionMap.get("projectId")) {
                throw new BusinessException("\u8bf7\u5148\u9009\u62e9\u9879\u76ee\uff01");
            }
        } else {
            throw new BusinessException("\u8bf7\u5148\u9009\u62e9\u9879\u76ee\uff01");
        }
        Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        param.getOrderMap().put("accountingCode", "asc");
        List list = this.service.queryList(param, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (AccountingProjectEntity entity : list) {
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getAccountingName());
            map.put("code", entity.getAccountingCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("orgAccountingId", entity.getOrgAccountingId());
            map.put("innerCode", entity.getInnerCode());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/importOrgAccounting"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> importOrgSubject(@RequestBody AccountingProjectImportVO importVo) {
        this.service.importOrgSubject(importVo);
        return CommonResponse.success((String)"\u5f15\u5165\u6210\u529f\uff01");
    }
}

