/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.cost.bean.CostClosingChangesEntity;
import com.ejianc.business.cost.bean.CostClosingEntity;
import com.ejianc.business.cost.mapper.CostClosingChangesMapper;
import com.ejianc.business.cost.mapper.CostClosingMapper;
import com.ejianc.business.cost.service.ICostClosingChangesService;
import com.ejianc.business.cost.service.ICostClosingService;
import com.ejianc.business.cost.vo.CostClosingChangesVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="costClosingChangesService")
public class CostClosingChangesServiceImpl
extends BaseServiceImpl<CostClosingChangesMapper, CostClosingChangesEntity>
implements ICostClosingChangesService {
    private static final String BILL_CODE_ROLE = "COST_CLOSING_CODE_CHANGES";
    @Autowired
    CostClosingMapper costClosingMapper;
    @Autowired
    private ICostClosingService costClosingService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<CostClosingChangesVO> saveOrUpdate(CostClosingChangesVO changeVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        CostClosingChangesEntity entity = null;
        String operateType = null;
        if (changeVo.getId() != null && changeVo.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)changeVo.getBillCode())) {
                changeVo.setBillCode(null);
            }
            entity = (CostClosingChangesEntity)((Object)BeanMapper.map((Object)changeVo, CostClosingChangesEntity.class));
            operateType = "edit";
        } else {
            if (null == changeVo.getChangeVersion() || changeVo.getChangeVersion() == 0) {
                changeVo.setChangeVersion(Integer.valueOf(1));
            } else {
                changeVo.setChangeVersion(Integer.valueOf(changeVo.getChangeVersion() + 1));
            }
            if (2 == changeVo.getChangeStatus()) {
                throw new BusinessException("\u6210\u672c\u5173\u95e8\u901a\u77e5\u5355\u5b58\u5728\u53d8\u66f4\u4e2d\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            if (StringUtils.isEmpty((CharSequence)changeVo.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE_ROLE, tenantId);
                if (billCode.isSuccess()) {
                    changeVo.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (CostClosingChangesEntity)((Object)BeanMapper.map((Object)changeVo, CostClosingChangesEntity.class));
            operateType = "add";
        }
        super.saveOrUpdate((Object)entity);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(CostClosingEntity::getNewCostClosingTime, (Object)changeVo.getCostClosingTime());
        updateWrapper.set(CostClosingEntity::getDays, (Object)changeVo.getDays());
        updateWrapper.set(CostClosingEntity::getChangeId, (Object)entity.getId());
        updateWrapper.set(CostClosingEntity::getOldCostClosingTime, (Object)entity.getOldCostClosingTime());
        updateWrapper.set(CostClosingEntity::getChangeStatus, (Object)3);
        updateWrapper.set(CostClosingEntity::getChangeStatusName, (Object)"\u5df2\u53d8\u66f4");
        updateWrapper.set(CostClosingEntity::getChangeCode, (Object)entity.getBillCode());
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getClosNoticeId());
        this.costClosingService.update((Wrapper)updateWrapper);
        CostClosingChangesEntity costClosingChangesEntity = (CostClosingChangesEntity)((Object)super.selectById((Serializable)entity.getId()));
        CostClosingChangesVO vo = (CostClosingChangesVO)BeanMapper.map((Object)((Object)costClosingChangesEntity), CostClosingChangesVO.class);
        return CommonResponse.success((Object)vo);
    }

    @Override
    public CostClosingChangesVO queryDetailChange(Long id) {
        CostClosingEntity costClosingChangesEntity = (CostClosingEntity)((Object)this.costClosingMapper.selectById(id));
        if (!ObjectUtil.isEmpty((Object)((Object)costClosingChangesEntity))) {
            CostClosingChangesVO contractVo = (CostClosingChangesVO)BeanMapper.map((Object)((Object)costClosingChangesEntity), CostClosingChangesVO.class);
            contractVo.setOldCostClosingTime(costClosingChangesEntity.getCostClosingTime());
            contractVo.setCostClosingTime(costClosingChangesEntity.getCostClosingTime());
            contractVo.setBillState(null);
            contractVo.setCreateUserCode(null);
            contractVo.setCreateTime(null);
            contractVo.setUpdateUserCode(null);
            contractVo.setUpdateTime(null);
            contractVo.setMemo(null);
            return contractVo;
        }
        return null;
    }

    @Override
    public void deleteChange(List<CostClosingChangesVO> vos) {
        for (CostClosingChangesVO vo : vos) {
            CostClosingChangesEntity changeEntity = (CostClosingChangesEntity)((Object)super.selectById((Serializable)vo.getId()));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(CostClosingEntity::getDays, null);
            updateWrapper.set(CostClosingEntity::getNewCostClosingTime, null);
            if (changeEntity.getChangeVersion() == 1) {
                updateWrapper.set(CostClosingEntity::getChangeStatus, (Object)1);
                updateWrapper.set(CostClosingEntity::getChangeStatusName, (Object)"\u672a\u53d8\u66f4");
            } else {
                updateWrapper.set(CostClosingEntity::getChangeStatus, (Object)3);
                updateWrapper.set(CostClosingEntity::getChangeStatusName, (Object)"\u5df2\u53d8\u66f4");
            }
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getClosNoticeId());
            this.costClosingService.update((Wrapper)updateWrapper);
            super.removeById((Serializable)vo, false);
        }
    }
}

