/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.CostClosingForecastChangeEntity;
import com.ejianc.business.cost.bean.CostClosingForecastEntity;
import com.ejianc.business.cost.bean.CostClosingLastChangeEntity;
import com.ejianc.business.cost.bean.CostClosingLastEntity;
import com.ejianc.business.cost.bean.CostDetailEntity;
import com.ejianc.business.cost.bean.CostFinContractDetailEntity;
import com.ejianc.business.cost.bean.CostFinCostSummaryReportingEntity;
import com.ejianc.business.cost.bean.CostFinOtherDetailEntity;
import com.ejianc.business.cost.bean.FinMachineContractEntity;
import com.ejianc.business.cost.bean.FinMaterialContractEntity;
import com.ejianc.business.cost.bean.FinOtherContractEntity;
import com.ejianc.business.cost.bean.ForecastChangeMachinecontractDetailEntity;
import com.ejianc.business.cost.bean.ForecastChangeMaterialcontractDetailEntity;
import com.ejianc.business.cost.bean.ForecastChangeOthercontractDetailEntity;
import com.ejianc.business.cost.bean.ForecastContractDetailChangeEntity;
import com.ejianc.business.cost.bean.ForecastContractDetailEntity;
import com.ejianc.business.cost.bean.ForecastMachinecontractDetailEntity;
import com.ejianc.business.cost.bean.ForecastMaterialcontractDetailEntity;
import com.ejianc.business.cost.bean.ForecastOthercontractDetailEntity;
import com.ejianc.business.cost.bean.SubjectOrgEntity;
import com.ejianc.business.cost.bean.TargetLiabilityCostEntity;
import com.ejianc.business.cost.mapper.CostClosingForecastChangeMapper;
import com.ejianc.business.cost.mapper.CostClosingForecastMapper;
import com.ejianc.business.cost.mapper.CostClosingLastMapper;
import com.ejianc.business.cost.mapper.CostFinContractDetailMapper;
import com.ejianc.business.cost.mapper.CostFinCostSummaryReportingMapper;
import com.ejianc.business.cost.mapper.CostFinOtherDetailMapper;
import com.ejianc.business.cost.mapper.FinMachineContractMapper;
import com.ejianc.business.cost.mapper.FinMaterialContractMapper;
import com.ejianc.business.cost.mapper.FinOtherContractMapper;
import com.ejianc.business.cost.mapper.ForecastContractDetailChangeMapper;
import com.ejianc.business.cost.mapper.ForecastContractDetailMapper;
import com.ejianc.business.cost.mapper.ForecastMachinecontractDetailMapper;
import com.ejianc.business.cost.mapper.ForecastMaterialcontractDetailMapper;
import com.ejianc.business.cost.mapper.ForecastOtherDetailChangeMapper;
import com.ejianc.business.cost.mapper.ForecastOtherDetailMapper;
import com.ejianc.business.cost.mapper.ForecastOthercontractDetailMapper;
import com.ejianc.business.cost.mapper.ReportMapper;
import com.ejianc.business.cost.service.IAccountingOrgService;
import com.ejianc.business.cost.service.IAccountingProjectService;
import com.ejianc.business.cost.service.IReportService;
import com.ejianc.business.cost.service.ISubjectOrgService;
import com.ejianc.business.cost.service.ISubjectProjectService;
import com.ejianc.business.cost.service.ITargetLiabilityCostService;
import com.ejianc.business.cost.utils.MathUtil;
import com.ejianc.business.cost.vo.AccountingOrgVO;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.cost.vo.SubjectOrgVO;
import com.ejianc.business.cost.vo.report.AccountingCostVO;
import com.ejianc.business.cost.vo.report.OrgSubjectReportVO;
import com.ejianc.business.cost.vo.report.ProductionVersusCostAccountingVO;
import com.ejianc.business.cost.vo.report.ProductionVersusCostCompanyVO;
import com.ejianc.business.cost.vo.report.ProjectCostThreeVo;
import com.ejianc.business.cost.vo.report.ProjectProductionCostTwoVO;
import com.ejianc.business.cost.vo.report.SubjectCostVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
extends BaseServiceImpl<ReportMapper, CostDetailEntity>
implements IReportService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private ISubjectOrgService subjectOrgService;
    @Autowired
    private IAccountingOrgService accountingOrgService;
    @Autowired
    private IAccountingProjectService accountingProjectService;
    @Autowired
    private ITargetLiabilityCostService iTargetLiabilityCostService;
    @Autowired
    private CostFinContractDetailMapper costFinContractDetailMapper;
    @Autowired
    private CostFinCostSummaryReportingMapper costFinCostSummaryReportingMapper;
    @Autowired
    private CostFinOtherDetailMapper costFinOtherDetailMapper;
    @Autowired
    private FinMaterialContractMapper finMaterialContractMapper;
    @Autowired
    private FinMachineContractMapper finMachineContractMapper;
    @Autowired
    private FinOtherContractMapper finOtherContractMapper;
    @Autowired
    private ForecastOtherDetailMapper forecastOtherDetailMapper;
    @Autowired
    private CostClosingForecastMapper costClosingForecastMapper;
    @Autowired
    private ForecastContractDetailMapper forecastContractDetailMapper;
    @Autowired
    private ForecastMaterialcontractDetailMapper forecastMaterialcontractDetailMapper;
    @Autowired
    private ForecastMachinecontractDetailMapper forecastMachinecontractDetailMapper;
    @Autowired
    private ForecastOthercontractDetailMapper forecastOthercontractDetailMapper;
    @Autowired
    private CostClosingLastMapper costClosingLastMapper;
    @Autowired
    private ForecastOtherDetailChangeMapper forecastOtherDetailChangeMapper;
    @Autowired
    private CostClosingForecastChangeMapper costClosingForecastChangeMapper;
    @Autowired
    private ForecastContractDetailChangeMapper forecastContractDetailChangeMapper;
    @Autowired
    private ISubjectProjectService subjectProjectService;

    @Override
    public JSONObject subjectCostList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        List<Object> list = new ArrayList();
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        if (param.getParams().containsKey("subjectId") && param.getParams().containsKey("countMonth")) {
            String countMonth = (String)((Parameter)param.getParams().get("countMonth")).getValue();
            param.getParams().remove("countMonth");
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            List orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            param.getParams().put("projectDepartmentId", new Parameter("in", orgIds));
            Long subjectId = Long.valueOf((String)((Parameter)param.getParams().get("subjectId")).getValue());
            List<SubjectOrgVO> childList = this.subjectOrgService.getChildrenByPid(subjectId);
            param.getParams().put("subjectId", new Parameter("in", childList.stream().map(BaseVO::getId).collect(Collectors.toList())));
            QueryWrapper wrapper = ReportServiceImpl.changeToQueryWrapper((QueryParam)param);
            list = ((ReportMapper)this.baseMapper).subjectCostList(pages, wrapper, countMonth);
            Map map = list.stream().collect(Collectors.toMap(x -> x.getProjectId() + "-" + x.getSubjectId(), Function.identity()));
            if (CollectionUtils.isNotEmpty(list)) {
                for (SubjectCostVO vo : list) {
                    String parentKey = vo.getProjectId() + "-" + subjectId;
                    SubjectCostVO parent = new SubjectCostVO();
                    if (map.containsKey(parentKey)) {
                        if (subjectId.equals(vo.getSubjectId())) continue;
                        parent = (SubjectCostVO)map.get(parentKey);
                        parent.setMonthCostMny(ComputeUtil.safeAdd((BigDecimal)parent.getMonthCostMny(), (BigDecimal)vo.getMonthCostMny()));
                        parent.setMonthCostTaxMny(ComputeUtil.safeAdd((BigDecimal)parent.getMonthCostTaxMny(), (BigDecimal)vo.getMonthCostTaxMny()));
                        parent.setYearCostMny(ComputeUtil.safeAdd((BigDecimal)parent.getYearCostMny(), (BigDecimal)vo.getYearCostMny()));
                        parent.setYearCostTaxMny(ComputeUtil.safeAdd((BigDecimal)parent.getYearCostTaxMny(), (BigDecimal)vo.getYearCostTaxMny()));
                        parent.setTotalCostMny(ComputeUtil.safeAdd((BigDecimal)parent.getTotalCostMny(), (BigDecimal)vo.getTotalCostMny()));
                        parent.setTotalCostTaxMny(ComputeUtil.safeAdd((BigDecimal)parent.getTotalCostTaxMny(), (BigDecimal)vo.getTotalCostTaxMny()));
                        continue;
                    }
                    parent = (SubjectCostVO)BeanMapper.map((Object)vo, SubjectCostVO.class);
                    parent.setSubjectId(subjectId);
                    map.put(parentKey, parent);
                }
            }
            list = new ArrayList();
            if (MapUtils.isNotEmpty(map)) {
                list = map.values().stream().filter(x -> subjectId.equals(x.getSubjectId())).sorted(Comparator.comparing(SubjectCostVO::getProjectId)).collect(Collectors.toList());
            }
        }
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public JSONObject getProductionVersusCostCompanyList(QueryParam param) {
        int total = 0;
        int current = param.getPageIndex();
        int size = param.getPageSize();
        int pages = 0;
        JSONObject page = new JSONObject();
        if (param.getParams().get("countMonth") == null) {
            page.put("records", new ArrayList());
            page.put("total", (Object)total);
            page.put("current", (Object)current);
            page.put("size", (Object)size);
            page.put("pages", (Object)pages);
            return page;
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        String countMonth = (String)((Parameter)param.getParams().get("countMonth")).getValue();
        List<ProductionVersusCostCompanyVO> thisYearProductionAndCost = ((ReportMapper)this.baseMapper).getThisYearProductionAndCost(tenantId, countMonth);
        for (ProductionVersusCostCompanyVO productionVersusCostCompany : thisYearProductionAndCost) {
            productionVersusCostCompany.setCountMonth(countMonth);
            if (productionVersusCostCompany.getMonthProduction() == null || productionVersusCostCompany.getMonthProduction().equals(new BigDecimal("0E-8"))) {
                productionVersusCostCompany.setMonthProduction(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getYearProduction() == null || productionVersusCostCompany.getYearProduction().equals(new BigDecimal("0E-8"))) {
                productionVersusCostCompany.setYearProduction(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getMonthProductionTax() == null || productionVersusCostCompany.getMonthProductionTax().equals(new BigDecimal("0E-8"))) {
                productionVersusCostCompany.setMonthProductionTax(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getYearProductionTax() == null || productionVersusCostCompany.getYearProductionTax().equals(new BigDecimal("0E-8"))) {
                productionVersusCostCompany.setYearProductionTax(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getMonthCost() == null || productionVersusCostCompany.getMonthCost().equals(new BigDecimal("0E-8"))) {
                productionVersusCostCompany.setMonthCost(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getYearCost() == null || productionVersusCostCompany.getYearCost().equals(new BigDecimal("0E-8"))) {
                productionVersusCostCompany.setYearCost(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getMonthCostTax() == null || productionVersusCostCompany.getMonthCostTax().equals(new BigDecimal("0E-8"))) {
                productionVersusCostCompany.setMonthCostTax(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getYearCostTax() == null || productionVersusCostCompany.getYearCostTax().equals(new BigDecimal("0E-8"))) {
                productionVersusCostCompany.setYearCostTax(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getMonthProfit() == null || productionVersusCostCompany.getMonthProfit().equals(new BigDecimal("0E-8"))) {
                productionVersusCostCompany.setMonthProfit(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getYearProfit() == null || productionVersusCostCompany.getYearProfit().equals(new BigDecimal("0E-8"))) {
                productionVersusCostCompany.setYearProfit(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getMonthProfitMargin() == null || productionVersusCostCompany.getMonthProfitMargin().equals(new BigDecimal("0E-8"))) {
                productionVersusCostCompany.setMonthProfitMargin(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getYearProfitMargin() != null && !productionVersusCostCompany.getYearProfitMargin().equals(new BigDecimal("0E-8"))) continue;
            productionVersusCostCompany.setYearProfitMargin(BigDecimal.ZERO);
        }
        Map thisYearProductionAndCostMap = thisYearProductionAndCost.stream().collect(Collectors.toMap(ProductionVersusCostCompanyVO::getId, Function.identity()));
        Long topOrgId = ((OrgVO)this.orgApi.findOrgByTenantId(tenantId).getData()).getId();
        List allSecondAndNextOrg = (List)this.orgApi.findChildrenByParentId(topOrgId).getData();
        List secondOrg = ((List)this.orgApi.getDirectChildrenByPid(topOrgId, null).getData()).stream().filter(e -> e.getOrgType() == 2).collect(Collectors.toList());
        ArrayList<ProductionVersusCostCompanyVO> companyListMny = new ArrayList<ProductionVersusCostCompanyVO>();
        for (OrgVO second : secondOrg) {
            ProductionVersusCostCompanyVO sum = new ProductionVersusCostCompanyVO();
            sum.setCountMonth(countMonth);
            sum.setId(second.getId());
            sum.setOrgCode(second.getCode());
            sum.setName(second.getName());
            BigDecimal monthProductionMny = BigDecimal.ZERO;
            BigDecimal yearProductionMny = BigDecimal.ZERO;
            BigDecimal monthProductionMnyTax = BigDecimal.ZERO;
            BigDecimal yearProductionMnyTax = BigDecimal.ZERO;
            BigDecimal monthCost = BigDecimal.ZERO;
            BigDecimal yearCost = BigDecimal.ZERO;
            BigDecimal monthCostTax = BigDecimal.ZERO;
            BigDecimal yearCostTax = BigDecimal.ZERO;
            BigDecimal monthProfit = BigDecimal.ZERO;
            BigDecimal yearProfit = BigDecimal.ZERO;
            BigDecimal monthProfitMargin = BigDecimal.ZERO;
            BigDecimal yearProfitMargin = BigDecimal.ZERO;
            for (OrgVO allSecondAndNext : allSecondAndNextOrg) {
                if (allSecondAndNext.getInnerCode().indexOf(second.getInnerCode()) == -1 || !thisYearProductionAndCostMap.containsKey(allSecondAndNext.getId())) continue;
                ProductionVersusCostCompanyVO productionVersusCostCompany = (ProductionVersusCostCompanyVO)thisYearProductionAndCostMap.get(allSecondAndNext.getId());
                monthProductionMny = MathUtil.safeAdd(monthProductionMny, productionVersusCostCompany.getMonthProduction());
                yearProductionMny = MathUtil.safeAdd(yearProductionMny, productionVersusCostCompany.getYearProduction());
                monthProductionMnyTax = MathUtil.safeAdd(monthProductionMnyTax, productionVersusCostCompany.getMonthProductionTax());
                yearProductionMnyTax = MathUtil.safeAdd(yearProductionMnyTax, productionVersusCostCompany.getYearProductionTax());
                monthCost = MathUtil.safeAdd(monthCost, productionVersusCostCompany.getMonthCost());
                yearCost = MathUtil.safeAdd(yearCost, productionVersusCostCompany.getYearCost());
                monthCostTax = MathUtil.safeAdd(monthCostTax, productionVersusCostCompany.getMonthCostTax());
                yearCostTax = MathUtil.safeAdd(yearCostTax, productionVersusCostCompany.getYearCostTax());
                monthProfit = MathUtil.safeAdd(monthProfit, productionVersusCostCompany.getMonthProfit());
                yearProfit = MathUtil.safeAdd(yearProfit, productionVersusCostCompany.getYearProfit());
            }
            sum.setMonthProduction(monthProductionMny);
            sum.setYearProduction(yearProductionMny);
            sum.setMonthProductionTax(monthProductionMnyTax);
            sum.setYearProductionTax(yearProductionMnyTax);
            sum.setMonthCost(monthCost);
            sum.setYearCost(yearCost);
            sum.setMonthCostTax(monthCostTax);
            sum.setYearCostTax(yearCostTax);
            sum.setMonthProfit(monthProfit);
            sum.setYearProfit(yearProfit);
            monthProfitMargin = MathUtil.safeMultiply(MathUtil.safeDiv(monthProfit, monthProductionMny), new BigDecimal(100));
            yearProfitMargin = MathUtil.safeMultiply(MathUtil.safeDiv(yearProfit, yearProductionMny), new BigDecimal(100));
            sum.setMonthProfitMargin(monthProfitMargin);
            sum.setYearProfitMargin(yearProfitMargin);
            companyListMny.add(sum);
        }
        if (CollectionUtils.isEmpty(companyListMny)) {
            page.put("records", new ArrayList());
            page.put("total", (Object)total);
            page.put("current", (Object)current);
            page.put("size", (Object)size);
            page.put("pages", (Object)pages);
            return page;
        }
        total = companyListMny.size();
        if (total % size > 0) {
            pages = total / size + 1;
        } else if (total % size == 0) {
            pages = total / size;
        }
        page.put("records", companyListMny);
        page.put("total", (Object)total);
        page.put("current", (Object)current);
        page.put("size", (Object)size);
        page.put("pages", (Object)pages);
        return page;
    }

    @Override
    public JSONObject queryProjectProductionCostTwo(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        CommonResponse projectResponse = this.projectApi.queryChildrenProjectByOrgId(InvocationInfoProxy.getOrgId());
        ArrayList<Long> projectIds = new ArrayList();
        if (!projectResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u5931\u8d25\uff01");
        }
        projectIds = ((List)projectResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        List<Object> resultList = new ArrayList();
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        if (param.getParams().containsKey("countMonth")) {
            String countMonth = (String)((Parameter)param.getParams().get("countMonth")).getValue();
            param.getParams().remove("countMonth");
            param.getParams().put("projectId", new Parameter("in", projectIds));
            QueryWrapper wrapper = ReportServiceImpl.changeToQueryWrapper((QueryParam)param);
            resultList = ((ReportMapper)this.baseMapper).queryProjectProductionCostTwo(pages, wrapper, projectIds, InvocationInfoProxy.getTenantid(), countMonth);
        }
        for (ProjectProductionCostTwoVO vo : resultList) {
            vo.setMonthProfit(MathUtil.safeSub(vo.getMonthProduction(), vo.getMonthCost()));
            vo.setYearProfit(MathUtil.safeSub(vo.getYearProduction(), vo.getYearCost()));
            vo.setMonthProfitMargin(MathUtil.safeMultiply(MathUtil.safeDiv(vo.getMonthProfit(), vo.getMonthProduction()), new BigDecimal("100")));
            vo.setYearProfitMargin(MathUtil.safeMultiply(MathUtil.safeDiv(vo.getYearProfit(), vo.getYearProduction()), new BigDecimal("100")));
        }
        JSONObject page = new JSONObject();
        page.put("records", resultList);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public JSONObject queryProjectCostThree(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        CommonResponse projectResponse = this.projectApi.queryChildrenProjectByOrgId(InvocationInfoProxy.getOrgId());
        ArrayList<Long> projectIds = new ArrayList();
        if (!projectResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u5931\u8d25\uff01");
        }
        projectIds = ((List)projectResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("projectId", new Parameter("in", projectIds));
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = ReportServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ProjectCostThreeVo> resultList = ((ReportMapper)this.baseMapper).queryProjectCostThree(pages, wrapper, projectIds, InvocationInfoProxy.getTenantid());
        List<TargetLiabilityCostEntity> list = this.getTargetRate(projectIds);
        for (TargetLiabilityCostEntity entity : list) {
            for (ProjectCostThreeVo vo : resultList) {
                if (!entity.getProjectId().equals(vo.getProjectId())) continue;
                vo.setTargetRate(entity.getTargetRate());
            }
        }
        for (ProjectCostThreeVo vo : resultList) {
            vo.setActualProfit(MathUtil.safeSub(vo.getProductionMny(), vo.getCostMny()));
            vo.setActualProfitMargin(MathUtil.safeMultiply(MathUtil.safeDiv(vo.getActualProfit(), vo.getProductionMny()), new BigDecimal("100")));
            vo.setTargetProfit(MathUtil.safeSub(vo.getProductionMny(), vo.getTargetCostMny()));
            vo.setTargetProfitMargin(MathUtil.safeMultiply(MathUtil.safeDiv(vo.getTargetProfit(), vo.getProductionMny()), new BigDecimal("100")));
            vo.setDifference(MathUtil.safeSub(vo.getTargetCostMny(), vo.getCostMny()));
            vo.setDifferenceMargin(MathUtil.safeMultiply(MathUtil.safeDiv(vo.getDifference(), vo.getTargetCostMny()), new BigDecimal("100")));
        }
        JSONObject page = new JSONObject();
        page.put("records", resultList);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    private List<TargetLiabilityCostEntity> getTargetRate(List<Long> projectIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"project_id,target_rate"});
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.in((Object)"project_id", projectIds);
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.groupBy((Object[])new String[]{"project_id"});
        List entityList = this.iTargetLiabilityCostService.list((Wrapper)queryWrapper);
        return entityList;
    }

    @Override
    public List<Map<String, Object>> getProductionVersusCostAccountingTreeList(Long projectId, String happenDate) {
        List<ProductionVersusCostAccountingVO> productionVersusCostAccountingTree = ((ReportMapper)this.baseMapper).getProductionVersusCostAccountingTree(InvocationInfoProxy.getTenantid(), projectId, happenDate);
        for (ProductionVersusCostAccountingVO accountingVO : productionVersusCostAccountingTree) {
            accountingVO.setCountMonth(happenDate);
            if (accountingVO.getMonthProduction() == null || accountingVO.getMonthProduction().equals(new BigDecimal("0E-8"))) {
                accountingVO.setMonthProduction(BigDecimal.ZERO);
            }
            if (accountingVO.getYearProduction() == null || accountingVO.getYearProduction().equals(new BigDecimal("0E-8"))) {
                accountingVO.setYearProduction(BigDecimal.ZERO);
            }
            if (accountingVO.getMonthProductionTax() == null || accountingVO.getMonthProductionTax().equals(new BigDecimal("0E-8"))) {
                accountingVO.setMonthProductionTax(BigDecimal.ZERO);
            }
            if (accountingVO.getYearProductionTax() == null || accountingVO.getYearProductionTax().equals(new BigDecimal("0E-8"))) {
                accountingVO.setYearProductionTax(BigDecimal.ZERO);
            }
            if (accountingVO.getMonthCost() == null || accountingVO.getMonthCost().equals(new BigDecimal("0E-8"))) {
                accountingVO.setMonthCost(BigDecimal.ZERO);
            }
            if (accountingVO.getYearCost() == null || accountingVO.getYearCost().equals(new BigDecimal("0E-8"))) {
                accountingVO.setYearCost(BigDecimal.ZERO);
            }
            if (accountingVO.getMonthCostTax() == null || accountingVO.getMonthCostTax().equals(new BigDecimal("0E-8"))) {
                accountingVO.setMonthCost(BigDecimal.ZERO);
            }
            if (accountingVO.getYearCostTax() != null && !accountingVO.getYearCostTax().equals(new BigDecimal("0E-8"))) continue;
            accountingVO.setYearCost(BigDecimal.ZERO);
        }
        List resultMapList = BeanMapper.mapList(productionVersusCostAccountingTree, Map.class);
        List subTree = ResultAsTree.createTreeData((List)resultMapList);
        List<Map<String, Object>> automatic = this.automatic(subTree);
        return automatic;
    }

    private List<Map<String, Object>> automatic(List<Map<String, Object>> list) {
        for (Map<String, Object> map : list) {
            List child = (List)map.get("children");
            if (child != null) {
                List<Map<String, Object>> newChildren = this.automatic(child);
                map.put("children", newChildren);
                BigDecimal monthProduction = (BigDecimal)map.get("monthProduction");
                BigDecimal newMonthProduction = MathUtil.safeAdd(monthProduction, this.childSum(newChildren, "monthProduction"));
                map.put("monthProduction", newMonthProduction.compareTo(BigDecimal.ZERO) == 0 ? null : newMonthProduction);
                BigDecimal yearProduction = (BigDecimal)map.get("yearProduction");
                BigDecimal newYearProduction = MathUtil.safeAdd(yearProduction, this.childSum(newChildren, "yearProduction"));
                map.put("yearProduction", newYearProduction.compareTo(BigDecimal.ZERO) == 0 ? null : newYearProduction);
                BigDecimal monthProductionTax = (BigDecimal)map.get("monthProductionTax");
                BigDecimal newMonthProductionTax = MathUtil.safeAdd(monthProductionTax, this.childSum(newChildren, "monthProductionTax"));
                map.put("monthProductionTax", newMonthProductionTax.compareTo(BigDecimal.ZERO) == 0 ? null : newMonthProductionTax);
                BigDecimal yearProductionTax = (BigDecimal)map.get("yearProductionTax");
                BigDecimal newYearProductionTax = MathUtil.safeAdd(yearProductionTax, this.childSum(newChildren, "yearProductionTax"));
                map.put("yearProductionTax", newYearProductionTax.compareTo(BigDecimal.ZERO) == 0 ? null : newYearProductionTax);
                BigDecimal monthCost = (BigDecimal)map.get("monthCost");
                BigDecimal newMonthCost = MathUtil.safeAdd(monthCost, this.childSum(newChildren, "monthCost"));
                map.put("monthCost", newMonthCost.compareTo(BigDecimal.ZERO) == 0 ? null : newMonthCost);
                BigDecimal yearCost = (BigDecimal)map.get("yearCost");
                BigDecimal newYearCost = MathUtil.safeAdd(yearCost, this.childSum(newChildren, "yearCost"));
                map.put("yearCost", newYearCost.compareTo(BigDecimal.ZERO) == 0 ? null : newYearCost);
                BigDecimal monthCostTax = (BigDecimal)map.get("monthCostTax");
                BigDecimal newMonthCostTax = MathUtil.safeAdd(monthCostTax, this.childSum(newChildren, "monthCostTax"));
                map.put("monthCostTax", newMonthCostTax.compareTo(BigDecimal.ZERO) == 0 ? null : newMonthCostTax);
                BigDecimal yearCostTax = (BigDecimal)map.get("yearCostTax");
                BigDecimal newYearCostTax = MathUtil.safeAdd(yearCostTax, this.childSum(newChildren, "yearCostTax"));
                map.put("yearCostTax", newYearCostTax.compareTo(BigDecimal.ZERO) == 0 ? null : newYearCostTax);
                BigDecimal monthProfit = (BigDecimal)map.get("monthProfit");
                BigDecimal newMonthProfit = MathUtil.safeAdd(monthProfit, this.childSum(newChildren, "monthProfit"));
                map.put("monthProfit", newMonthProfit.compareTo(BigDecimal.ZERO) == 0 ? null : newMonthProfit);
                BigDecimal yearProfit = (BigDecimal)map.get("yearProfit");
                BigDecimal newYearProfit = MathUtil.safeAdd(yearProfit, this.childSum(newChildren, "yearProfit"));
                map.put("yearProfit", newYearProfit.compareTo(BigDecimal.ZERO) == 0 ? null : newYearProfit);
                BigDecimal monthProfitMargin = MathUtil.safeMultiply(MathUtil.safeDiv(newMonthProfit, newMonthProduction), new BigDecimal("100"));
                map.put("monthProfitMargin", monthProfitMargin);
                BigDecimal yearProfitMargin = MathUtil.safeMultiply(MathUtil.safeDiv(newYearProfit, newYearProduction), new BigDecimal("100"));
                map.put("yearProfitMargin", yearProfitMargin);
                continue;
            }
            BigDecimal monthProduction = (BigDecimal)map.get("monthProduction");
            map.put("monthProduction", monthProduction == null || monthProduction.compareTo(BigDecimal.ZERO) == 0 ? null : monthProduction);
            BigDecimal yearProduction = (BigDecimal)map.get("yearProduction");
            map.put("yearProduction", yearProduction == null || yearProduction.compareTo(BigDecimal.ZERO) == 0 ? null : yearProduction);
            BigDecimal monthProductionTax = (BigDecimal)map.get("monthProductionTax");
            map.put("monthProductionTax", monthProductionTax == null || monthProductionTax.compareTo(BigDecimal.ZERO) == 0 ? null : monthProductionTax);
            BigDecimal yearProductionTax = (BigDecimal)map.get("yearProductionTax");
            map.put("yearProductionTax", yearProductionTax == null || yearProductionTax.compareTo(BigDecimal.ZERO) == 0 ? null : yearProductionTax);
            BigDecimal monthCost = (BigDecimal)map.get("monthCost");
            map.put("monthCost", monthCost == null || monthCost.compareTo(BigDecimal.ZERO) == 0 ? null : monthCost);
            BigDecimal yearCost = (BigDecimal)map.get("yearCost");
            map.put("yearCost", yearCost == null || yearCost.compareTo(BigDecimal.ZERO) == 0 ? null : yearCost);
            BigDecimal monthCostTax = (BigDecimal)map.get("monthCostTax");
            map.put("monthCostTax", monthCostTax == null || monthCostTax.compareTo(BigDecimal.ZERO) == 0 ? null : monthCostTax);
            BigDecimal yearCostTax = (BigDecimal)map.get("yearCostTax");
            map.put("yearCostTax", yearCostTax == null || yearCostTax.compareTo(BigDecimal.ZERO) == 0 ? null : yearCostTax);
            BigDecimal monthProfit = (BigDecimal)map.get("monthProfit");
            map.put("monthProfit", monthProfit == null || monthProfit.compareTo(BigDecimal.ZERO) == 0 ? null : monthProfit);
            BigDecimal yearProfit = (BigDecimal)map.get("yearProfit");
            map.put("yearProfit", yearProfit == null || yearProfit.compareTo(BigDecimal.ZERO) == 0 ? null : yearProfit);
            BigDecimal monthProfitMargin = MathUtil.safeMultiply(MathUtil.safeDiv(monthProfit, monthProduction), new BigDecimal("100"));
            map.put("monthProfitMargin", monthProfitMargin);
            BigDecimal yearProfitMargin = MathUtil.safeMultiply(MathUtil.safeDiv(yearProfit, yearProduction), new BigDecimal("100"));
            map.put("yearProfitMargin", yearProfitMargin);
        }
        return list;
    }

    private BigDecimal childSum(List<Map<String, Object>> list, String colums) {
        BigDecimal allMny = BigDecimal.ZERO;
        for (Map<String, Object> map : list) {
            BigDecimal mny = (BigDecimal)map.get(colums);
            allMny = MathUtil.safeAdd(allMny, mny);
        }
        return allMny;
    }

    @Override
    public JSONObject accountingCostList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        List<Object> list = new ArrayList();
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        if (param.getParams().containsKey("accountingId") && param.getParams().containsKey("countMonth")) {
            String countMonth = (String)((Parameter)param.getParams().get("countMonth")).getValue();
            param.getParams().remove("countMonth");
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            List orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            param.getParams().put("projectDepartmentId", new Parameter("in", orgIds));
            Long accountingId = Long.valueOf((String)((Parameter)param.getParams().get("accountingId")).getValue());
            List<AccountingOrgVO> childList = this.accountingOrgService.getChildrenByPid(accountingId);
            param.getParams().put("accountingId", new Parameter("in", childList.stream().map(BaseVO::getId).collect(Collectors.toList())));
            QueryWrapper wrapper = ReportServiceImpl.changeToQueryWrapper((QueryParam)param);
            list = ((ReportMapper)this.baseMapper).accountingCostList(pages, wrapper, countMonth);
            Map map = list.stream().collect(Collectors.toMap(x -> x.getProjectId() + "-" + x.getAccountingId(), Function.identity()));
            if (CollectionUtils.isNotEmpty(list)) {
                for (AccountingCostVO vo : list) {
                    String parentKey = vo.getProjectId() + "-" + accountingId;
                    AccountingCostVO parent = new AccountingCostVO();
                    if (map.containsKey(parentKey)) {
                        if (accountingId.equals(vo.getAccountingId())) continue;
                        parent = (AccountingCostVO)map.get(parentKey);
                        parent.setMonthCostMny(ComputeUtil.safeAdd((BigDecimal)parent.getMonthCostMny(), (BigDecimal)vo.getMonthCostMny()));
                        parent.setMonthCostTaxMny(ComputeUtil.safeAdd((BigDecimal)parent.getMonthCostTaxMny(), (BigDecimal)vo.getMonthCostTaxMny()));
                        parent.setYearCostMny(ComputeUtil.safeAdd((BigDecimal)parent.getYearCostMny(), (BigDecimal)vo.getYearCostMny()));
                        parent.setYearCostTaxMny(ComputeUtil.safeAdd((BigDecimal)parent.getYearCostTaxMny(), (BigDecimal)vo.getYearCostTaxMny()));
                        parent.setTotalCostMny(ComputeUtil.safeAdd((BigDecimal)parent.getTotalCostMny(), (BigDecimal)vo.getTotalCostMny()));
                        parent.setTotalCostTaxMny(ComputeUtil.safeAdd((BigDecimal)parent.getTotalCostTaxMny(), (BigDecimal)vo.getTotalCostTaxMny()));
                        continue;
                    }
                    parent = (AccountingCostVO)BeanMapper.map((Object)vo, AccountingCostVO.class);
                    parent.setAccountingId(accountingId);
                    map.put(parentKey, parent);
                }
            }
            list = new ArrayList();
            if (MapUtils.isNotEmpty(map)) {
                list = map.values().stream().filter(x -> accountingId.equals(x.getAccountingId())).sorted(Comparator.comparing(AccountingCostVO::getProjectId)).collect(Collectors.toList());
            }
        }
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public List<OrgSubjectReportVO> querySubjectCostList(Integer yearFlag) {
        CommonResponse response = this.projectApi.queryChildrenProjectByOrgId(InvocationInfoProxy.getOrgId());
        if (!response.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List projectList = (List)response.getData();
        List<Long> idsList = projectList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<Object> costList = new ArrayList();
        if (CollectionUtils.isNotEmpty(idsList)) {
            costList = ((ReportMapper)this.baseMapper).querySubjectCostList(yearFlag, idsList);
        }
        BigDecimal totalHappenMny = costList.stream().map(CostDetailVO::getHappenMny).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List list = this.subjectOrgService.list((Wrapper)wrapper);
        Map map = list.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        List oneNodeList = list.stream().filter(i -> i.getParentId() == null).collect(Collectors.toList());
        HashMap<String, OrgSubjectReportVO> resultMap = new HashMap<String, OrgSubjectReportVO>();
        for (CostDetailVO costDetailVO : costList) {
            OrgSubjectReportVO reportVO;
            if (!map.containsKey(costDetailVO.getOrgSubjectId())) continue;
            String innerCode = ((SubjectOrgEntity)((Object)map.get(costDetailVO.getOrgSubjectId()))).getInnerCode();
            List entityList = oneNodeList.stream().filter(i -> innerCode.contains(i.getInnerCode())).collect(Collectors.toList());
            if (!ListUtil.isNotEmpty(entityList)) continue;
            SubjectOrgEntity entity = (SubjectOrgEntity)((Object)entityList.get(0));
            String subjectName = entity.getSubjectName();
            BigDecimal happenMny = MathUtil.judgeZeroError(costDetailVO.getHappenMny());
            if (resultMap.containsKey(subjectName)) {
                reportVO = (OrgSubjectReportVO)resultMap.get(subjectName);
                reportVO.setHappenMny(ComputeUtil.safeAdd((BigDecimal)happenMny, (BigDecimal)reportVO.getHappenMny()));
                reportVO.setTaxRate(MathUtil.judgeZeroError(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)reportVO.getHappenMny(), (BigDecimal)totalHappenMny), (BigDecimal)new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP)));
                resultMap.put(subjectName, reportVO);
                continue;
            }
            reportVO = new OrgSubjectReportVO();
            reportVO.setSubjectName(subjectName);
            reportVO.setHappenMny(happenMny);
            reportVO.setTaxRate(MathUtil.judgeZeroError(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)happenMny, (BigDecimal)totalHappenMny), (BigDecimal)new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP)));
            reportVO.setTotalHappenTaxMny(totalHappenMny);
            resultMap.put(subjectName, reportVO);
        }
        return new ArrayList<OrgSubjectReportVO>(resultMap.values());
    }

    @Override
    public List<Map<String, Object>> projectCompletionSum(Long projectId) {
        Long fin = this.forecastContractDetailMapper.queryId(String.valueOf(projectId));
        if (fin != null) {
            ArrayList<Map<String, Object>> alldata = new ArrayList<Map<String, Object>>();
            CostClosingForecastEntity costClosingForecastEntity = (CostClosingForecastEntity)((Object)this.costClosingForecastMapper.selectById(fin));
            List<ForecastContractDetailEntity> sublist = this.forecastContractDetailMapper.querySubdetailLW(fin);
            List<ForecastContractDetailEntity> zysublist = this.forecastContractDetailMapper.querySubdetailZY(fin);
            List<CostFinOtherDetailEntity> othlist = this.costFinOtherDetailMapper.querySubjectByProjectId(String.valueOf(projectId));
            List<ForecastMaterialcontractDetailEntity> matlist = this.forecastContractDetailMapper.queryMaterialdetail(fin);
            List<ForecastMachinecontractDetailEntity> maclist = this.forecastContractDetailMapper.queryMachinedetail(fin);
            List<ForecastOthercontractDetailEntity> oclist = this.forecastContractDetailMapper.queryOthercontractdetail(fin);
            HashMap<String, Object> lw = new HashMap<String, Object>();
            lw.put("no", "1");
            lw.put("id", "1");
            lw.put("costItems", "\u52b3\u52a1\u5206\u5305\u8d39\uff08\u52b3\u52a1\u5206\u5305\u5408\u540c\uff09");
            alldata.add(lw);
            BigDecimal lwcontractamount = new BigDecimal("0");
            BigDecimal lwsettleNotax = new BigDecimal("0");
            BigDecimal lwsettleTax = new BigDecimal("0");
            BigDecimal lwsettle = new BigDecimal("0");
            BigDecimal lwforecastamountNotax = new BigDecimal("0");
            BigDecimal lwforecastamountTax = new BigDecimal("0");
            BigDecimal lwforecastamount = new BigDecimal("0");
            BigDecimal lwallamount = new BigDecimal("0");
            ArrayList newChildren = new ArrayList();
            if (sublist != null && sublist.size() > 0) {
                for (int s = 0; s < sublist.size(); ++s) {
                    ForecastContractDetailEntity materialContractEntity = sublist.get(s);
                    Integer no = s;
                    Integer noo = no + 1;
                    HashMap<String, Object> matmap = new HashMap<String, Object>();
                    matmap.put("no", "1." + noo);
                    matmap.put("id", "1." + noo);
                    matmap.put("costItems", materialContractEntity.getContractType());
                    matmap.put("contractName", materialContractEntity.getContractName());
                    matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    lwcontractamount = lwcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("taxRate", materialContractEntity.getTaxRate());
                    matmap.put("subName", materialContractEntity.getSubOrg());
                    matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    lwsettleNotax = lwsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                    lwsettleTax = lwsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                    lwsettle = lwsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                    BigDecimal ygnamount = this.costFinContractDetailMapper.queryForecastnotax(materialContractEntity.getContractCode());
                    BigDecimal bgnamount = this.costFinContractDetailMapper.queryForecastChangenotax(materialContractEntity.getContractCode());
                    BigDecimal notax = ygnamount.add(bgnamount);
                    matmap.put("forecastNotax", notax.setScale(2, RoundingMode.HALF_UP));
                    lwforecastamountNotax = lwforecastamountNotax.add(notax.setScale(2, RoundingMode.HALF_UP));
                    BigDecimal ygtaxamount = this.costFinContractDetailMapper.queryForecasttax(materialContractEntity.getContractCode());
                    BigDecimal bgtaxamount = this.costFinContractDetailMapper.queryForecastChangetax(materialContractEntity.getContractCode());
                    BigDecimal tax = ygtaxamount.add(bgtaxamount);
                    matmap.put("forecastTax", tax.setScale(2, RoundingMode.HALF_UP));
                    lwforecastamountTax = lwforecastamountTax.add(tax.setScale(2, RoundingMode.HALF_UP));
                    BigDecimal ygamount = this.costFinContractDetailMapper.queryForecastamount(materialContractEntity.getContractCode());
                    BigDecimal bgamount = this.costFinContractDetailMapper.queryForecastChangeamount(materialContractEntity.getContractCode());
                    BigDecimal amount = ygamount.add(bgamount);
                    matmap.put("forecastAmount", amount.setScale(2, RoundingMode.HALF_UP));
                    lwforecastamount = lwforecastamount.add(amount.setScale(2, RoundingMode.HALF_UP));
                    BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP).add(notax.setScale(2, RoundingMode.HALF_UP));
                    matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                    lwallamount = lwallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                    newChildren.add(matmap);
                }
            }
            lw.put("children", newChildren);
            lw.put("contractAmount", lwcontractamount);
            lw.put("settleNotax", lwsettleNotax);
            lw.put("settleTax", lwsettleTax);
            lw.put("settleAmount", lwsettle);
            lw.put("forecastNotax", lwforecastamountNotax);
            lw.put("forecastTax", lwforecastamountTax);
            lw.put("forecastAmount", lwforecastamount);
            lw.put("allCostNotax", lwallamount);
            alldata.set(0, lw);
            HashMap<String, Object> cl = new HashMap<String, Object>();
            cl.put("no", "2");
            cl.put("id", "2");
            cl.put("costItems", "\u6750\u6599\u8d39\uff08\u6750\u6599\u5408\u540c\u3001\u542b\u5468\u8f6c\u6750\u79df\u8d41\uff09");
            Integer allsize = alldata.size();
            alldata.add(cl);
            BigDecimal clcontractamount = new BigDecimal("0");
            BigDecimal clsettleNotax = new BigDecimal("0");
            BigDecimal clsettleTax = new BigDecimal("0");
            BigDecimal clsettle = new BigDecimal("0");
            BigDecimal clallamount = new BigDecimal("0");
            ArrayList newChildren2 = new ArrayList();
            if (matlist != null && matlist.size() > 0) {
                for (int s = 0; s < matlist.size(); ++s) {
                    ForecastMaterialcontractDetailEntity materialContractEntity = matlist.get(s);
                    Integer no = s;
                    Integer noo = no + 1;
                    HashMap<String, Object> matmap = new HashMap<String, Object>();
                    matmap.put("no", "2." + noo);
                    matmap.put("id", "2." + noo);
                    matmap.put("costItems", materialContractEntity.getContractType());
                    matmap.put("contractName", materialContractEntity.getContractName());
                    matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    clcontractamount = clcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("taxRate", materialContractEntity.getTaxRate());
                    matmap.put("subName", materialContractEntity.getSubOrg());
                    matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    clsettleNotax = clsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                    clsettleTax = clsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                    clsettle = clsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                    BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                    matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                    clallamount = clallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                    newChildren2.add(matmap);
                }
            }
            cl.put("children", newChildren2);
            cl.put("contractAmount", clcontractamount);
            cl.put("settleNotax", clsettleNotax);
            cl.put("settleTax", clsettleTax);
            cl.put("settleAmount", clsettle);
            cl.put("allCostNotax", clallamount);
            alldata.set(allsize, cl);
            HashMap<String, Object> jx = new HashMap<String, Object>();
            jx.put("no", "3");
            jx.put("id", "3");
            jx.put("costItems", "\u673a\u68b0\u8d39\uff08\u673a\u68b0\u5408\u540c\u3001\u542b\u8bbe\u5907\u91c7\u8d2d\uff09");
            Integer jxsize = alldata.size();
            alldata.add(jx);
            BigDecimal jxcontractamount = new BigDecimal("0");
            BigDecimal jxsettleNotax = new BigDecimal("0");
            BigDecimal jxsettleTax = new BigDecimal("0");
            BigDecimal jxsettle = new BigDecimal("0");
            BigDecimal jxallamount = new BigDecimal("0");
            ArrayList newChildren3 = new ArrayList();
            if (maclist != null && maclist.size() > 0) {
                for (int s = 0; s < maclist.size(); ++s) {
                    ForecastMachinecontractDetailEntity materialContractEntity = maclist.get(s);
                    Integer no = s;
                    Integer noo = no + 1;
                    HashMap<String, Object> matmap = new HashMap<String, Object>();
                    matmap.put("no", "3." + noo);
                    matmap.put("id", "3." + noo);
                    matmap.put("costItems", materialContractEntity.getContractType());
                    matmap.put("contractName", materialContractEntity.getContractName());
                    matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    jxcontractamount = jxcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("taxRate", materialContractEntity.getTaxRate());
                    matmap.put("subName", materialContractEntity.getSubOrg());
                    matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    jxsettleNotax = jxsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                    jxsettleTax = jxsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                    jxsettle = jxsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                    BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                    matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                    jxallamount = jxallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                    newChildren3.add(matmap);
                }
            }
            jx.put("children", newChildren3);
            jx.put("contractAmount", jxcontractamount);
            jx.put("settleNotax", jxsettleNotax);
            jx.put("settleTax", jxsettleTax);
            jx.put("settleAmount", jxsettle);
            jx.put("allCostNotax", jxallamount);
            alldata.set(jxsize, jx);
            HashMap<String, Object> zy = new HashMap<String, Object>();
            zy.put("no", "4");
            zy.put("id", "4");
            zy.put("costItems", "\u4e13\u4e1a\u5206\u5305\u5de5\u7a0b\u8d39\uff08\u4e13\u4e1a\u5206\u5305\u5408\u540c\uff09");
            Integer zysize = alldata.size();
            alldata.add(zy);
            BigDecimal zycontractamount = new BigDecimal("0");
            BigDecimal zysettleNotax = new BigDecimal("0");
            BigDecimal zysettleTax = new BigDecimal("0");
            BigDecimal zysettle = new BigDecimal("0");
            BigDecimal zyforecastamountNotax = new BigDecimal("0");
            BigDecimal zyforecastamountTax = new BigDecimal("0");
            BigDecimal zyforecastamount = new BigDecimal("0");
            BigDecimal zyallamount = new BigDecimal("0");
            ArrayList newChildren4 = new ArrayList();
            if (zysublist != null && zysublist.size() > 0) {
                for (int s = 0; s < zysublist.size(); ++s) {
                    ForecastContractDetailEntity materialContractEntity = zysublist.get(s);
                    Integer no = s;
                    Integer noo = no + 1;
                    HashMap<String, Object> matmap = new HashMap<String, Object>();
                    matmap.put("no", "4." + noo);
                    matmap.put("id", "4." + noo);
                    matmap.put("costItems", materialContractEntity.getContractType());
                    matmap.put("contractName", materialContractEntity.getContractName());
                    matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    zycontractamount = zycontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("taxRate", materialContractEntity.getTaxRate());
                    matmap.put("subName", materialContractEntity.getSubOrg());
                    matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    zysettleNotax = zysettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                    zysettleTax = zysettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                    zysettle = zysettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                    BigDecimal ygnamount = this.costFinContractDetailMapper.queryForecastnotax(materialContractEntity.getContractCode());
                    BigDecimal bgnamount = this.costFinContractDetailMapper.queryForecastChangenotax(materialContractEntity.getContractCode());
                    BigDecimal notax = ygnamount.add(bgnamount);
                    matmap.put("forecastNotax", notax.setScale(2, RoundingMode.HALF_UP));
                    zyforecastamountNotax = zyforecastamountNotax.add(notax.setScale(2, RoundingMode.HALF_UP));
                    BigDecimal ygtaxamount = this.costFinContractDetailMapper.queryForecasttax(materialContractEntity.getContractCode());
                    BigDecimal bgtaxamount = this.costFinContractDetailMapper.queryForecastChangetax(materialContractEntity.getContractCode());
                    BigDecimal tax = ygtaxamount.add(bgtaxamount);
                    matmap.put("forecastTax", tax.setScale(2, RoundingMode.HALF_UP));
                    zyforecastamountTax = zyforecastamountTax.add(tax.setScale(2, RoundingMode.HALF_UP));
                    BigDecimal ygamount = this.costFinContractDetailMapper.queryForecastamount(materialContractEntity.getContractCode());
                    BigDecimal bgamount = this.costFinContractDetailMapper.queryForecastChangeamount(materialContractEntity.getContractCode());
                    BigDecimal amount = ygamount.add(bgamount);
                    matmap.put("forecastAmount", amount.setScale(2, RoundingMode.HALF_UP));
                    zyforecastamount = zyforecastamount.add(amount.setScale(2, RoundingMode.HALF_UP));
                    BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP).add(notax.setScale(2, RoundingMode.HALF_UP));
                    matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                    zyallamount = zyallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                    newChildren4.add(matmap);
                }
            }
            zy.put("children", newChildren4);
            zy.put("contractAmount", zycontractamount);
            zy.put("settleNotax", zysettleNotax);
            zy.put("settleTax", zysettleTax);
            zy.put("settleAmount", zysettle);
            zy.put("forecastNotax", zyforecastamountNotax);
            zy.put("forecastTax", zyforecastamountTax);
            zy.put("forecastAmount", zyforecastamount);
            zy.put("allCostNotax", zyallamount);
            alldata.set(zysize, zy);
            HashMap<String, Object> oc = new HashMap<String, Object>();
            oc.put("no", "5");
            oc.put("id", "5");
            oc.put("costItems", "\u5176\u4ed6\u8d39\u7528\uff08\u6709\u5408\u540c\u7684\uff09");
            Integer ocsize = alldata.size();
            alldata.add(oc);
            BigDecimal occontractamount = new BigDecimal("0");
            BigDecimal ocsettleNotax = new BigDecimal("0");
            BigDecimal ocsettleTax = new BigDecimal("0");
            BigDecimal ocsettle = new BigDecimal("0");
            BigDecimal ocallamount = new BigDecimal("0");
            ArrayList newChildren5 = new ArrayList();
            for (int s = 0; s < oclist.size(); ++s) {
                ForecastOthercontractDetailEntity materialContractEntity = oclist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "5." + noo);
                matmap.put("id", "5." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                occontractamount = occontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());
                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                ocsettleNotax = ocsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                ocsettleTax = ocsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                ocsettle = ocsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                ocallamount = ocallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                newChildren5.add(matmap);
            }
            oc.put("children", newChildren5);
            oc.put("contractAmount", occontractamount);
            oc.put("settleNotax", ocsettleNotax);
            oc.put("settleTax", ocsettleTax);
            oc.put("settleAmount", ocsettle);
            oc.put("allCostNotax", ocallamount);
            alldata.set(ocsize, oc);
            HashMap<String, Object> ot = new HashMap<String, Object>();
            ot.put("no", "6");
            ot.put("id", "6");
            ot.put("costItems", "\u5176\u4ed6\u8d39\u7528\uff08\u65e0\u5408\u540c\u7684\u95f4\u63a5\u8d39\uff09");
            Integer otsize = alldata.size();
            alldata.add(ot);
            BigDecimal otsettleNotax = new BigDecimal("0");
            BigDecimal zOtsettleNotax = BigDecimal.ZERO;
            BigDecimal ygOtherNotax = BigDecimal.ZERO;
            BigDecimal forecastTaxSum = BigDecimal.ZERO;
            BigDecimal forecastAmountSum = BigDecimal.ZERO;
            ArrayList<Long> subjectIdList = new ArrayList<Long>();
            ArrayList newChildren6 = new ArrayList();
            if (othlist != null && othlist.size() > 0) {
                for (int t = 0; t < othlist.size(); ++t) {
                    CostFinOtherDetailEntity materialContractEntity = othlist.get(t);
                    Integer no = t;
                    Integer noo = no + 1;
                    HashMap<String, Object> matmap = new HashMap<String, Object>();
                    matmap.put("no", "6." + noo);
                    matmap.put("id", "6." + noo);
                    String fylb = this.forecastOtherDetailMapper.querytypename(materialContractEntity.getCostTypeId());
                    matmap.put("contractName", fylb);
                    String objid = String.valueOf(materialContractEntity.getId());
                    String cbkm = this.forecastOtherDetailMapper.queryname(materialContractEntity.getSubjectId());
                    subjectIdList.add(materialContractEntity.getSubjectId());
                    matmap.put("taxRate", cbkm);
                    SimpleDateFormat smart = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String formatdate = smart.format(costClosingForecastEntity.getCreateTime());
                    BigDecimal settleAmount = this.forecastOtherDetailMapper.queryPaymnytime(projectId, materialContractEntity.getSubjectId(), formatdate);
                    matmap.put("settleAmount", settleAmount.setScale(2, RoundingMode.HALF_UP));
                    otsettleNotax = otsettleNotax.add(settleAmount.setScale(2, RoundingMode.HALF_UP));
                    matmap.put("allCostNotax", settleAmount.setScale(2, RoundingMode.HALF_UP));
                    zOtsettleNotax = zOtsettleNotax.add(settleAmount.setScale(2, RoundingMode.HALF_UP));
                    newChildren6.add(matmap);
                }
            }
            ot.put("children", newChildren6);
            ot.put("settleAmount", otsettleNotax);
            ot.put("allCostNotax", zOtsettleNotax);
            alldata.set(otsize, ot);
            BigDecimal zOtsettleNotaxSum = BigDecimal.ZERO;
            HashMap<String, Object> ot00 = new HashMap<String, Object>();
            ot00.put("no", "7");
            ot00.put("id", "7");
            ot00.put("costItems", "\u5176\u4ed6\u9884\u4f30\u6210\u672c");
            Integer ot0size = alldata.size();
            alldata.add(ot00);
            ArrayList newChildren7 = new ArrayList();
            HashMap<String, Object> ot1 = new HashMap<String, Object>();
            ot1.put("no", "7.1");
            ot1.put("id", "7.1");
            ot1.put("costItems", "\u95f4\u63a5\u8d39\u9884\u4f30");
            BigDecimal jjtotalnt = this.forecastOtherDetailMapper.queryjjtotal(projectId);
            ot1.put("forecastNotax", jjtotalnt);
            BigDecimal jjtotalt = this.forecastOtherDetailMapper.queryjjtotaltax(projectId);
            ot1.put("forecastTax", jjtotalt);
            BigDecimal jjtotal = this.forecastOtherDetailMapper.queryjjtotalamount(projectId);
            ot1.put("forecastAmount", jjtotal);
            ot1.put("allCostNotax", jjtotalnt);
            zOtsettleNotaxSum = zOtsettleNotaxSum.add(jjtotalnt);
            newChildren7.add(ot1);
            HashMap<String, Object> ot2 = new HashMap<String, Object>();
            ot2.put("no", "7.2");
            ot2.put("id", "7.2");
            ot2.put("costItems", "\u6536\u5c3e\u9636\u6bb5\u53d1\u751f\u7684\u5176\u4ed6\u8d39\u9884\u4f30");
            BigDecimal qttotalnt = this.forecastOtherDetailMapper.queryqttotal(projectId);
            ot2.put("forecastNotax", qttotalnt);
            BigDecimal qttotalt = this.forecastOtherDetailMapper.queryqttotaltax(projectId);
            ot2.put("forecastTax", qttotalt);
            BigDecimal qttotal = this.forecastOtherDetailMapper.queryqttotalamount(projectId);
            ot2.put("forecastAmount", qttotal);
            ot2.put("allCostNotax", qttotalnt);
            zOtsettleNotaxSum = zOtsettleNotaxSum.add(qttotalnt);
            newChildren7.add(ot2);
            ot00.put("children", newChildren7);
            ot00.put("forecastNotax", jjtotalnt.add(qttotalnt));
            ot00.put("forecastTax", jjtotalt.add(qttotalt));
            ot00.put("forecastAmount", jjtotal.add(qttotal));
            ot00.put("allCostNotax", zOtsettleNotaxSum);
            alldata.set(ot0size, ot00);
            return alldata;
        }
        throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5c1a\u672a\u521b\u5efa\u6210\u672c\u9884\u4f30\u5355\uff0c\u8bf7\u5148\u521b\u5efa\u3002");
    }

    @Override
    public List<Map<String, Object>> projectCompletionSumRealtime(Long projectId) {
        Integer idtotal = this.costClosingForecastChangeMapper.queryIdtotal(projectId);
        if (idtotal != 0) {
            ArrayList<Map<String, Object>> alldata = new ArrayList<Map<String, Object>>();
            List<ForecastContractDetailChangeEntity> sublistlw = this.forecastContractDetailChangeMapper.querySubContractByProjectIdLWALL(projectId);
            List<ForecastContractDetailChangeEntity> zysublistzy = this.forecastContractDetailChangeMapper.querySubContractByProjectIdZYALL(projectId);
            List<CostFinOtherDetailEntity> othlistot = this.costFinOtherDetailMapper.querySubjectByProjectId(String.valueOf(projectId));
            List<ForecastChangeMaterialcontractDetailEntity> matlist = this.forecastContractDetailChangeMapper.queryMaterialdetailALL(projectId);
            List<ForecastChangeMachinecontractDetailEntity> maclist = this.forecastContractDetailChangeMapper.queryMachinedetailALL(projectId);
            List<ForecastChangeOthercontractDetailEntity> oclist = this.forecastContractDetailChangeMapper.queryOtherdetailALL(projectId);
            HashMap<String, Object> lw = new HashMap<String, Object>();
            lw.put("no", "1");
            lw.put("id", "1");
            lw.put("costItems", "\u52b3\u52a1\u5206\u5305\u8d39\uff08\u52b3\u52a1\u5206\u5305\u5408\u540c\uff09");
            alldata.add(lw);
            BigDecimal lwcontractamount = new BigDecimal("0");
            BigDecimal lwsettleNotax = new BigDecimal("0");
            BigDecimal lwforecastamount = new BigDecimal("0");
            BigDecimal lwallamount = new BigDecimal("0");
            ArrayList newChildren = new ArrayList();
            if (sublistlw != null && sublistlw.size() > 0) {
                ArrayList<ForecastContractDetailChangeEntity> sublist = new ArrayList<ForecastContractDetailChangeEntity>();
                for (ForecastContractDetailChangeEntity entity : sublistlw) {
                    if (sublist != null && sublist.size() > 0) {
                        String iscf = "N";
                        for (int a = 0; a < sublist.size(); ++a) {
                            ForecastContractDetailChangeEntity ent = (ForecastContractDetailChangeEntity)((Object)sublist.get(a));
                            if (!ent.getContractId().equals(entity.getContractId())) continue;
                            if (entity.getCreateTime().compareTo(ent.getCreateTime()) == 1) {
                                iscf = "Y";
                                sublist.set(a, entity);
                                continue;
                            }
                            iscf = "Y";
                        }
                        if (iscf != "N") continue;
                        sublist.add(entity);
                        continue;
                    }
                    sublist.add(entity);
                }
                for (int s = 0; s < sublist.size(); ++s) {
                    ForecastContractDetailChangeEntity materialContractEntity = (ForecastContractDetailChangeEntity)((Object)sublist.get(s));
                    Integer no = s;
                    Integer noo = no + 1;
                    HashMap<String, Object> matmap = new HashMap<String, Object>();
                    matmap.put("no", "1." + noo);
                    matmap.put("id", "1." + noo);
                    matmap.put("costItems", materialContractEntity.getContractType());
                    matmap.put("contractName", materialContractEntity.getContractName());
                    matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    lwcontractamount = lwcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("taxRate", materialContractEntity.getTaxRate());
                    matmap.put("subName", materialContractEntity.getSubOrg());
                    matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    lwsettleNotax = lwsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    BigDecimal ygamount = this.costFinContractDetailMapper.queryForecastnotax(materialContractEntity.getContractCode());
                    matmap.put("forecastamount", ygamount.setScale(2, RoundingMode.HALF_UP));
                    lwforecastamount = lwforecastamount.add(ygamount.setScale(2, RoundingMode.HALF_UP));
                    matmap.put("klamountnotax", new BigDecimal("0"));
                    BigDecimal bgamount = this.costFinContractDetailMapper.queryForecastChangenotax(materialContractEntity.getContractCode());
                    matmap.put("forecastchangeamount", bgamount.setScale(2, RoundingMode.HALF_UP));
                    BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP).add(ygamount).add(bgamount);
                    matmap.put("allamount", allamount.setScale(2, RoundingMode.HALF_UP));
                    lwallamount = lwallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                    newChildren.add(matmap);
                }
            }
            lw.put("children", newChildren);
            lw.put("contractAmount", lwcontractamount);
            lw.put("settleNotax", lwsettleNotax);
            lw.put("forecastamount", lwforecastamount);
            lw.put("allamount", lwallamount);
            alldata.set(0, lw);
            HashMap<String, Object> cl = new HashMap<String, Object>();
            cl.put("no", "2");
            cl.put("id", "2");
            cl.put("costItems", "\u6750\u6599\u8d39\uff08\u6750\u6599\u5408\u540c\u3001\u542b\u5468\u8f6c\u6750\u79df\u8d41\uff09");
            Integer allsize = alldata.size();
            alldata.add(cl);
            BigDecimal clcontractamount = new BigDecimal("0");
            BigDecimal clsettleNotax = new BigDecimal("0");
            ArrayList newChildren2 = new ArrayList();
            if (matlist != null && matlist.size() > 0) {
                for (int m = 0; m < matlist.size(); ++m) {
                    ForecastChangeMaterialcontractDetailEntity materialContractEntity = matlist.get(m);
                    Integer no = m;
                    Integer noo = no + 1;
                    HashMap<String, Object> matmap = new HashMap<String, Object>();
                    matmap.put("no", "2." + noo);
                    matmap.put("id", "2." + noo);
                    matmap.put("costItems", materialContractEntity.getContractType());
                    matmap.put("contractName", materialContractEntity.getContractName());
                    matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    clcontractamount = clcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("taxRate", materialContractEntity.getTaxRate());
                    matmap.put("subName", materialContractEntity.getSubOrg());
                    matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    clsettleNotax = clsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("klamountnotax", new BigDecimal("0"));
                    matmap.put("allamount", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    newChildren2.add(matmap);
                }
            }
            cl.put("children", newChildren2);
            cl.put("contractAmount", clcontractamount);
            cl.put("settleNotax", clsettleNotax);
            cl.put("allamount", clsettleNotax);
            alldata.set(allsize, cl);
            HashMap<String, Object> jx = new HashMap<String, Object>();
            jx.put("no", "3");
            jx.put("id", "3");
            jx.put("costItems", "\u673a\u68b0\u8d39\uff08\u673a\u68b0\u5408\u540c\u3001\u542b\u8bbe\u5907\u91c7\u8d2d\uff09");
            Integer jxsize = alldata.size();
            alldata.add(jx);
            BigDecimal jxcontractamount = new BigDecimal("0");
            BigDecimal jxsettleNotax = new BigDecimal("0");
            ArrayList newChildren3 = new ArrayList();
            if (maclist != null && maclist.size() > 0) {
                for (int j = 0; j < maclist.size(); ++j) {
                    ForecastChangeMachinecontractDetailEntity materialContractEntity = maclist.get(j);
                    Integer no = j;
                    Integer noo = no + 1;
                    HashMap<String, Object> matmap = new HashMap<String, Object>();
                    matmap.put("no", "3." + noo);
                    matmap.put("id", "3." + noo);
                    matmap.put("costItems", materialContractEntity.getContractType());
                    matmap.put("contractName", materialContractEntity.getContractName());
                    matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    jxcontractamount = jxcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("taxRate", materialContractEntity.getTaxRate());
                    matmap.put("subName", materialContractEntity.getSubOrg());
                    matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    jxsettleNotax = jxsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("forecastamount", "\u2014\u2014");
                    matmap.put("klamountnotax", new BigDecimal("0"));
                    matmap.put("forecastchangeamount", "\u2014\u2014");
                    matmap.put("allamount", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    newChildren3.add(matmap);
                }
            }
            jx.put("children", newChildren3);
            jx.put("contractAmount", jxcontractamount);
            jx.put("settleNotax", jxsettleNotax);
            jx.put("allamount", jxsettleNotax);
            alldata.set(jxsize, jx);
            HashMap<String, Object> zy = new HashMap<String, Object>();
            zy.put("no", "4");
            zy.put("id", "4");
            zy.put("costItems", "\u4e13\u4e1a\u5206\u5305\u5de5\u7a0b\u8d39\uff08\u4e13\u4e1a\u5206\u5305\u5408\u540c\uff09");
            Integer zysize = alldata.size();
            alldata.add(zy);
            BigDecimal zycontractamount = new BigDecimal("0");
            BigDecimal zysettleNotax = new BigDecimal("0");
            BigDecimal zyforecastamount = new BigDecimal("0");
            BigDecimal zyallamount = new BigDecimal("0");
            ArrayList newChildren4 = new ArrayList();
            if (zysublistzy != null && zysublistzy.size() > 0) {
                ArrayList<ForecastContractDetailChangeEntity> zysublist = new ArrayList<ForecastContractDetailChangeEntity>();
                for (ForecastContractDetailChangeEntity entity : zysublistzy) {
                    if (zysublist != null && zysublist.size() > 0) {
                        String iscf = "N";
                        for (int a = 0; a < zysublist.size(); ++a) {
                            ForecastContractDetailChangeEntity ent = (ForecastContractDetailChangeEntity)((Object)zysublist.get(a));
                            if (!ent.getContractId().equals(entity.getContractId())) continue;
                            if (entity.getCreateTime().compareTo(ent.getCreateTime()) == 1) {
                                iscf = "Y";
                                zysublist.set(a, entity);
                                continue;
                            }
                            iscf = "Y";
                        }
                        if (iscf != "N") continue;
                        zysublist.add(entity);
                        continue;
                    }
                    zysublist.add(entity);
                }
                for (int z = 0; z < zysublist.size(); ++z) {
                    ForecastContractDetailChangeEntity materialContractEntity = (ForecastContractDetailChangeEntity)((Object)zysublist.get(z));
                    Integer no = z;
                    Integer noo = no + 1;
                    HashMap<String, Object> matmap = new HashMap<String, Object>();
                    matmap.put("no", "4." + noo);
                    matmap.put("id", "4." + noo);
                    matmap.put("costItems", materialContractEntity.getContractType());
                    matmap.put("contractName", materialContractEntity.getContractName());
                    matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    zycontractamount = zycontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("taxRate", materialContractEntity.getTaxRate());
                    matmap.put("subName", materialContractEntity.getSubOrg());
                    matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    zysettleNotax = zysettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    BigDecimal ygamount = this.costFinContractDetailMapper.queryForecastnotax(materialContractEntity.getContractCode());
                    matmap.put("forecastamount", ygamount.setScale(2, RoundingMode.HALF_UP));
                    zyforecastamount = zyforecastamount.add(ygamount.setScale(2, RoundingMode.HALF_UP));
                    matmap.put("klamountnotax", new BigDecimal("0"));
                    BigDecimal bgamount = this.costFinContractDetailMapper.queryForecastChangenotax(materialContractEntity.getContractCode());
                    matmap.put("forecastchangeamount", bgamount.setScale(2, RoundingMode.HALF_UP));
                    BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP).add(ygamount).add(bgamount);
                    matmap.put("allamount", allamount.setScale(2, RoundingMode.HALF_UP));
                    zyallamount = zyallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                    newChildren4.add(matmap);
                }
            }
            zy.put("children", newChildren4);
            zy.put("contractAmount", zycontractamount);
            zy.put("settleNotax", zysettleNotax);
            zy.put("forecastamount", zyforecastamount);
            zy.put("allamount", zyallamount);
            alldata.set(zysize, zy);
            HashMap<String, Object> oc = new HashMap<String, Object>();
            oc.put("no", "5");
            oc.put("id", "5");
            oc.put("costItems", "\u5176\u4ed6\u8d39\u7528\uff08\u6709\u5408\u540c\u7684\uff09");
            Integer ocsize = alldata.size();
            alldata.add(oc);
            BigDecimal occontractamount = new BigDecimal("0");
            BigDecimal ocsettleNotax = new BigDecimal("0");
            ArrayList newChildren5 = new ArrayList();
            if (oclist != null && oclist.size() > 0) {
                for (int c = 0; c < oclist.size(); ++c) {
                    ForecastChangeOthercontractDetailEntity materialContractEntity = oclist.get(c);
                    Integer no = c;
                    Integer noo = no + 1;
                    HashMap<String, Object> matmap = new HashMap<String, Object>();
                    matmap.put("no", "5." + noo);
                    matmap.put("id", "5." + noo);
                    matmap.put("costItems", "\u95f4\u63a5\u8d39\u5408\u540c");
                    matmap.put("contractName", materialContractEntity.getContractName());
                    matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    occontractamount = occontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("taxRate", materialContractEntity.getTaxRate());
                    matmap.put("subName", materialContractEntity.getSubOrg());
                    matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    ocsettleNotax = ocsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("forecastamount", "\u2014\u2014");
                    matmap.put("klamountnotax", new BigDecimal("0"));
                    matmap.put("forecastchangeamount", "\u2014\u2014");
                    matmap.put("allamount", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    newChildren5.add(matmap);
                }
            }
            oc.put("children", newChildren5);
            oc.put("contractAmount", occontractamount);
            oc.put("settleNotax", ocsettleNotax);
            oc.put("allamount", ocsettleNotax);
            alldata.set(ocsize, oc);
            HashMap<String, Object> ot = new HashMap<String, Object>();
            ot.put("no", "6");
            ot.put("id", "6");
            ot.put("costItems", "\u5176\u4ed6\u8d39\u7528\uff08\u65e0\u5408\u540c\u7684\u95f4\u63a5\u8d39\uff09");
            Integer otsize = alldata.size();
            alldata.add(ot);
            BigDecimal otsettleNotax = new BigDecimal("0");
            ArrayList newChildren6 = new ArrayList();
            if (othlistot != null && othlistot.size() > 0) {
                for (int t = 0; t < othlistot.size(); ++t) {
                    CostFinOtherDetailEntity materialContractEntity = othlistot.get(t);
                    Integer no = t;
                    Integer noo = no + 1;
                    HashMap<String, Object> matmap = new HashMap<String, Object>();
                    matmap.put("no", "6." + noo);
                    matmap.put("id", "6." + noo);
                    Long objid = materialContractEntity.getSubjectId();
                    BigDecimal settleAmount = this.forecastOtherDetailMapper.queryPaymny(projectId, objid);
                    String typename = this.forecastOtherDetailMapper.querytype(projectId, objid);
                    String changetypename = this.forecastOtherDetailMapper.querytypechange(projectId, objid);
                    if (typename == null) {
                        matmap.put("contractName", changetypename);
                    } else {
                        matmap.put("contractName", typename);
                    }
                    matmap.put("taxRate", materialContractEntity.getSubjectName());
                    matmap.put("settleNotax", settleAmount.setScale(2, RoundingMode.HALF_UP));
                    otsettleNotax = otsettleNotax.add(settleAmount.setScale(2, RoundingMode.HALF_UP));
                    matmap.put("allamount", settleAmount.setScale(2, RoundingMode.HALF_UP));
                    newChildren6.add(matmap);
                }
            }
            ot.put("children", newChildren6);
            ot.put("settleNotax", otsettleNotax);
            ot.put("allamount", otsettleNotax);
            alldata.set(otsize, ot);
            HashMap<String, Object> ot00 = new HashMap<String, Object>();
            ot00.put("no", "7");
            ot00.put("id", "7");
            ot00.put("costItems", "\u5176\u4ed6\u9884\u4f30\u6210\u672c");
            Integer ot0size = alldata.size();
            alldata.add(ot00);
            ArrayList newChildren7 = new ArrayList();
            HashMap<String, Object> ot1 = new HashMap<String, Object>();
            ot1.put("no", "7.1");
            ot1.put("id", "7.1");
            ot1.put("costItems", "\u95f4\u63a5\u8d39\u9884\u4f30");
            BigDecimal jjtotal = this.forecastOtherDetailMapper.queryjjtotal(projectId);
            ot1.put("forecastamount", jjtotal);
            BigDecimal jjchangetotal = this.forecastOtherDetailMapper.queryjjchangetotal(projectId);
            ot1.put("forecastchangeamount", jjchangetotal);
            BigDecimal altotal = jjtotal.add(jjchangetotal);
            ot1.put("allamount", altotal);
            newChildren7.add(ot1);
            HashMap<String, Object> ot2 = new HashMap<String, Object>();
            ot2.put("no", "7.2");
            ot2.put("id", "7.2");
            ot2.put("costItems", "\u6536\u5c3e\u9636\u6bb5\u53d1\u751f\u7684\u5176\u4ed6\u8d39\u9884\u4f30");
            BigDecimal qttotal = this.forecastOtherDetailMapper.queryqttotal(projectId);
            ot2.put("forecastamount", qttotal);
            BigDecimal qtchangetotal = this.forecastOtherDetailMapper.queryqtchangetotal(projectId);
            ot2.put("forecastchangeamount", qtchangetotal);
            BigDecimal qtaltotal = qttotal.add(qtchangetotal);
            ot2.put("allamount", qtaltotal);
            newChildren7.add(ot2);
            ot00.put("children", newChildren7);
            ot00.put("forecastamount", qttotal.add(jjtotal));
            ot00.put("forecastchangeamount", jjchangetotal.add(qtchangetotal));
            ot00.put("allamount", altotal.add(qtaltotal));
            alldata.set(ot0size, ot00);
            return alldata;
        }
        throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5c1a\u672a\u521b\u5efa\u6210\u672c\u9884\u4f30\u53d8\u66f4\u5355\uff0c\u8bf7\u5148\u521b\u5efa\u3002");
    }

    @Override
    public JSONObject costSummaryList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        List<Object> list = new ArrayList();
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        if (param.getParams().containsKey("subjectId") && param.getParams().containsKey("countMonth")) {
            String countMonth = (String)((Parameter)param.getParams().get("countMonth")).getValue();
            param.getParams().remove("countMonth");
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            List orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            param.getParams().put("projectDepartmentId", new Parameter("in", orgIds));
            Long subjectId = Long.valueOf((String)((Parameter)param.getParams().get("subjectId")).getValue());
            List<SubjectOrgVO> childList = this.subjectOrgService.getChildrenByPid(subjectId);
            param.getParams().put("subjectId", new Parameter("in", childList.stream().map(BaseVO::getId).collect(Collectors.toList())));
            QueryWrapper wrapper = ReportServiceImpl.changeToQueryWrapper((QueryParam)param);
            list = ((ReportMapper)this.baseMapper).subjectCostList(pages, wrapper, countMonth);
            Map map = list.stream().collect(Collectors.toMap(x -> x.getProjectId() + "-" + x.getSubjectId(), Function.identity()));
            if (CollectionUtils.isNotEmpty(list)) {
                for (SubjectCostVO vo : list) {
                    String parentKey = vo.getProjectId() + "-" + subjectId;
                    SubjectCostVO parent = new SubjectCostVO();
                    if (map.containsKey(parentKey)) {
                        if (subjectId.equals(vo.getSubjectId())) continue;
                        parent = (SubjectCostVO)map.get(parentKey);
                        parent.setMonthCostMny(ComputeUtil.safeAdd((BigDecimal)parent.getMonthCostMny(), (BigDecimal)vo.getMonthCostMny()));
                        parent.setMonthCostTaxMny(ComputeUtil.safeAdd((BigDecimal)parent.getMonthCostTaxMny(), (BigDecimal)vo.getMonthCostTaxMny()));
                        parent.setYearCostMny(ComputeUtil.safeAdd((BigDecimal)parent.getYearCostMny(), (BigDecimal)vo.getYearCostMny()));
                        parent.setYearCostTaxMny(ComputeUtil.safeAdd((BigDecimal)parent.getYearCostTaxMny(), (BigDecimal)vo.getYearCostTaxMny()));
                        parent.setTotalCostMny(ComputeUtil.safeAdd((BigDecimal)parent.getTotalCostMny(), (BigDecimal)vo.getTotalCostMny()));
                        parent.setTotalCostTaxMny(ComputeUtil.safeAdd((BigDecimal)parent.getTotalCostTaxMny(), (BigDecimal)vo.getTotalCostTaxMny()));
                        continue;
                    }
                    parent = (SubjectCostVO)BeanMapper.map((Object)vo, SubjectCostVO.class);
                    parent.setSubjectId(subjectId);
                    map.put(parentKey, parent);
                }
            }
            list = new ArrayList();
            if (MapUtils.isNotEmpty(map)) {
                list = map.values().stream().filter(x -> subjectId.equals(x.getSubjectId())).sorted(Comparator.comparing(SubjectCostVO::getProjectId)).collect(Collectors.toList());
            }
        }
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public List<Map<String, Object>> revenueExpenditureSummary() {
        ArrayList<Map<String, Object>> alldata = new ArrayList<Map<String, Object>>();
        List<CostClosingForecastEntity> allproject = this.costClosingForecastMapper.revenueExpenditureSummary();
        if (allproject != null && allproject.size() > 0) {
            for (int s = 0; s < allproject.size(); ++s) {
                BigDecimal maxsettlement;
                CostClosingForecastEntity materialContractEntity = allproject.get(s);
                Long trueprojectId = materialContractEntity.getProjectId();
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", noo);
                matmap.put("projectName", materialContractEntity.getProjectName());
                String zt = this.costClosingForecastMapper.getprojectstatus(trueprojectId);
                String ztname = new String();
                if (zt != null) {
                    if (zt.equals("0")) {
                        ztname = "\u672a\u5f00\u5de5";
                    }
                    if (zt.equals("1")) {
                        ztname = "\u5728\u5efa";
                    }
                    if (zt.equals("2")) {
                        ztname = "\u5b8c\u5de5\u672a\u9a8c\u6536";
                    }
                    if (zt.equals("3")) {
                        ztname = "\u5b8c\u5de5\u9a8c\u6536";
                    }
                    if (zt.equals("4")) {
                        ztname = "\u5df2\u9a8c\u6536\u672a\u7ed3\u7b97";
                    }
                    if (zt.equals("5")) {
                        ztname = "\u5df2\u7ed3\u7b97";
                    }
                }
                matmap.put("engineerType", ztname);
                CostClosingLastEntity entity = this.costClosingForecastMapper.querysubcontract(trueprojectId);
                BigDecimal sump = new BigDecimal("0");
                if (entity != null) {
                    Date start = entity.getCompletionTime();
                    Date end = entity.getCompletionAcceptanceTime();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    if (start != null) {
                        String startdateString = sdf.format(start);
                        matmap.put("actualStart", startdateString);
                    }
                    if (end != null) {
                        String enddateString = sdf.format(end);
                        matmap.put("completionAcceptanceTime", enddateString);
                    }
                    matmap.put("projectCost", entity.getSumProductionTaxMny());
                    matmap.put("sumProductionMny", entity.getSettlementTax());
                    matmap.put("calculateExcludtax", entity.getSumProductionMny());
                    sump = entity.getSumProductionMny();
                }
                if ((maxsettlement = materialContractEntity.getMaxSettlement()) == null) {
                    maxsettlement = new BigDecimal("0");
                }
                matmap.put("maxSettlement", maxsettlement);
                BigDecimal conservativesettlement = materialContractEntity.getConservativeSettlement();
                if (conservativesettlement == null) {
                    conservativesettlement = new BigDecimal("0");
                }
                matmap.put("conservativeSettlement", conservativesettlement);
                BigDecimal Damount = conservativesettlement;
                BigDecimal subsettle = this.costClosingForecastMapper.subsettle(trueprojectId);
                BigDecimal materialsettle = this.costClosingForecastMapper.materialsettle(trueprojectId);
                BigDecimal machinesettle = this.costClosingForecastMapper.machinesettle(trueprojectId);
                BigDecimal othersettle = this.costClosingForecastMapper.othersettle(trueprojectId);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String formatdate = format.format(materialContractEntity.getCreateTime());
                BigDecimal ljfk = this.forecastOtherDetailMapper.queryPaymnybyprojectId(trueprojectId, formatdate);
                BigDecimal yjs = subsettle.add(materialsettle).add(machinesettle).add(othersettle).add(ljfk);
                matmap.put("closeCosty", yjs);
                BigDecimal subnotax = this.costClosingForecastMapper.subnotax(trueprojectId);
                BigDecimal othnotax = this.costClosingForecastMapper.othnotax(trueprojectId);
                BigDecimal yg = subnotax.add(othnotax);
                matmap.put("closeCostv", yg);
                BigDecimal wgzcb = yjs.add(yg);
                matmap.put("totalCost", wgzcb);
                BigDecimal lr = Damount.subtract(wgzcb);
                matmap.put("expectprofitax", lr);
                BigDecimal lrl = new BigDecimal("0.00");
                if (lr.compareTo(BigDecimal.ZERO) != 0 && Damount.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal hundred = new BigDecimal("100");
                    lrl = lr.divide(Damount, 8, 4).multiply(hundred);
                    lrl = lrl.setScale(2, 4);
                }
                matmap.put("expectprofits", lrl);
                BigDecimal mblr = this.costClosingForecastMapper.querylrl(trueprojectId);
                matmap.put("targetprofitax", mblr);
                alldata.add(matmap);
            }
        }
        return alldata;
    }

    @Override
    public List<Map<String, Object>> ExpenditureSummaryRealTime() {
        ArrayList<Map<String, Object>> alldatareal = new ArrayList<Map<String, Object>>();
        List<CostClosingForecastChangeEntity> allrealproject = this.costClosingForecastChangeMapper.revenueExpenditureSummaryRealTime();
        if (allrealproject != null && allrealproject.size() > 0) {
            for (int s = 0; s < allrealproject.size(); ++s) {
                BigDecimal maxsettlement;
                CostClosingForecastChangeEntity costClosingLastEntity = allrealproject.get(s);
                Long realprojectId = costClosingLastEntity.getProjectId();
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", noo);
                matmap.put("projectName", costClosingLastEntity.getProjectName());
                String zt = this.costClosingForecastMapper.getprojectstatus(realprojectId);
                String ztname = new String();
                if (zt != null) {
                    if (zt.equals("0")) {
                        ztname = "\u672a\u5f00\u5de5";
                    }
                    if (zt.equals("1")) {
                        ztname = "\u5728\u5efa";
                    }
                    if (zt.equals("2")) {
                        ztname = "\u5b8c\u5de5\u672a\u9a8c\u6536";
                    }
                    if (zt.equals("3")) {
                        ztname = "\u5b8c\u5de5\u9a8c\u6536";
                    }
                    if (zt.equals("4")) {
                        ztname = "\u5df2\u9a8c\u6536\u672a\u7ed3\u7b97";
                    }
                    if (zt.equals("5")) {
                        ztname = "\u5df2\u7ed3\u7b97";
                    }
                }
                matmap.put("engineerType", ztname);
                CostClosingLastEntity entity = this.costClosingForecastMapper.querysubcontract(realprojectId);
                BigDecimal sump = new BigDecimal("0");
                if (entity != null) {
                    Date start = entity.getCompletionTime();
                    Date end = entity.getCompletionAcceptanceTime();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    if (start != null) {
                        String startdateString = sdf.format(start);
                        matmap.put("actualStart", startdateString);
                    }
                    if (end != null) {
                        String enddateString = sdf.format(end);
                        matmap.put("completionAcceptanceTime", enddateString);
                    }
                    matmap.put("projectCost", entity.getSumProductionTaxMny());
                    matmap.put("sumProductionMny", entity.getSettlementTax());
                    matmap.put("calculateExcludtax", entity.getSumProductionMny());
                    sump = entity.getSumProductionMny();
                }
                if ((maxsettlement = costClosingLastEntity.getMaxSettlement()) == null) {
                    maxsettlement = new BigDecimal("0");
                }
                matmap.put("maxSettlement", maxsettlement);
                BigDecimal conservativesettlement = costClosingLastEntity.getConservativeSettlement();
                if (conservativesettlement == null) {
                    conservativesettlement = new BigDecimal("0");
                }
                matmap.put("conservativeSettlement", conservativesettlement);
                BigDecimal Damount = sump.add(conservativesettlement);
                BigDecimal subsettle = this.costClosingForecastMapper.subchangenotaxset(realprojectId);
                BigDecimal materialsettle = this.costClosingForecastMapper.materialchangenotax(realprojectId);
                BigDecimal machinesettle = this.costClosingForecastMapper.machinechangesettle(realprojectId);
                BigDecimal othersettle = this.costClosingForecastMapper.otherchangesettle(realprojectId);
                BigDecimal ljfk = this.costClosingForecastMapper.ljfk(realprojectId);
                BigDecimal yjs = subsettle.add(materialsettle).add(machinesettle).add(othersettle).add(ljfk);
                matmap.put("closeCosty", yjs);
                BigDecimal realsubnotax = this.costClosingForecastMapper.subnotax(realprojectId);
                BigDecimal realsubchangenotax = this.costClosingForecastMapper.subchangenotax(realprojectId);
                BigDecimal realothnotax = this.costClosingForecastMapper.othnotax(realprojectId);
                BigDecimal realothchangenotax = this.costClosingForecastMapper.othchangenotax(realprojectId);
                BigDecimal yyg = realsubnotax.add(realothnotax);
                matmap.put("closeCostv", yyg);
                BigDecimal cyg = realsubchangenotax.add(realothchangenotax);
                matmap.put("forecastChangeAmount", cyg);
                BigDecimal wgzcb = yjs.add(yyg).add(cyg);
                matmap.put("totalCost", wgzcb);
                BigDecimal lr = Damount.subtract(wgzcb);
                matmap.put("expectprofitax", lr);
                BigDecimal lrl = new BigDecimal("0.00");
                if (lr.compareTo(BigDecimal.ZERO) != 0 && Damount.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal hundred = new BigDecimal("100");
                    lrl = lr.divide(Damount, 8, 4).multiply(hundred);
                    lrl = lrl.setScale(2, 4);
                }
                matmap.put("expectprofits", lrl);
                BigDecimal mblr = this.costClosingForecastMapper.querylrl(realprojectId);
                matmap.put("targetprofitax", mblr);
                alldatareal.add(matmap);
            }
        }
        return alldatareal;
    }

    @Override
    public List<Map<String, Object>> lastRevenueExpenditureSummary() {
        ArrayList<Map<String, Object>> alldata = new ArrayList<Map<String, Object>>();
        List<CostClosingLastEntity> allproject = this.costClosingLastMapper.lastRevenueExpenditureSummary();
        if (allproject != null && allproject.size() > 0) {
            Integer no = 1;
            for (int s = 0; s < allproject.size(); ++s) {
                CostClosingLastEntity materialContractEntity = allproject.get(s);
                Long trueprojectId = materialContractEntity.getProjectId();
                Long truecontract = materialContractEntity.getContractId();
                CostFinCostSummaryReportingEntity costFinCostSummaryReportingEntity = this.costFinCostSummaryReportingMapper.queryByProject(trueprojectId);
                CostClosingLastEntity costlast = this.costClosingLastMapper.selectByPC(truecontract);
                List<CostClosingLastChangeEntity> lastlist = this.costClosingLastMapper.querylastchangeList(costlast.getId());
                if (costFinCostSummaryReportingEntity == null) continue;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", no);
                Integer n = no;
                Integer n2 = no = Integer.valueOf(no + 1);
                matmap.put("projectName", materialContractEntity.getProjectName());
                Date start = materialContractEntity.getCompletionTime();
                Date end = materialContractEntity.getCompletionAcceptanceTime();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                if (start != null) {
                    String startdateString = sdf.format(start);
                    matmap.put("actualStart", startdateString);
                }
                if (end != null) {
                    String enddateString = sdf.format(end);
                    matmap.put("completionAcceptanceTime", enddateString);
                }
                matmap.put("projectCost", materialContractEntity.getSumProductionTaxMny());
                matmap.put("sumProductionMny", materialContractEntity.getSettlementTax());
                if (lastlist == null || lastlist.size() <= 0) {
                    matmap.put("settleAuditAmount", costlast.getLastOutputValue());
                } else {
                    matmap.put("settleAuditAmount", lastlist.get(0).getLastOutputValue());
                }
                BigDecimal subsettle = this.costClosingForecastMapper.finsubsettle(trueprojectId);
                BigDecimal materialsettle = this.costClosingForecastMapper.finmaterialsettle(trueprojectId);
                BigDecimal machinesettle = this.costClosingForecastMapper.finmachinesettle(trueprojectId);
                BigDecimal othersettle = this.costClosingForecastMapper.finothersettle(trueprojectId);
                BigDecimal ljfk = this.costClosingForecastMapper.ljfk(trueprojectId);
                BigDecimal yjs = subsettle.add(materialsettle).add(machinesettle).add(othersettle).add(ljfk);
                matmap.put("closeCosty", yjs);
                matmap.put("totalCost", yjs);
                BigDecimal lr = materialContractEntity.getSumProductionMny().subtract(yjs);
                matmap.put("expectprofitax", lr);
                BigDecimal lrl = new BigDecimal("0.00");
                if (lr.compareTo(BigDecimal.ZERO) != 0 && materialContractEntity.getSumProductionMny().compareTo(BigDecimal.ZERO) != 0) {
                    lrl = lr.divide(materialContractEntity.getSumProductionMny(), 2, 4);
                }
                matmap.put("expectprofits", lrl);
                BigDecimal mblr = this.costClosingForecastMapper.querylrl(trueprojectId);
                matmap.put("targetprofitax", mblr);
                alldata.add(matmap);
            }
        }
        return alldata;
    }

    @Override
    public List<Map<String, Object>> projectFinCompletionSum(Long projectId) {
        Long fin = this.costFinContractDetailMapper.queryId(String.valueOf(projectId));
        ArrayList<Map<String, Object>> alldata = new ArrayList<Map<String, Object>>();
        List<CostFinContractDetailEntity> sublist = this.costFinContractDetailMapper.querySubdetailLW(fin);
        List<CostFinContractDetailEntity> zysublist = this.costFinContractDetailMapper.querySubdetailZY(fin);
        List<CostFinOtherDetailEntity> othlist = this.costFinContractDetailMapper.queryotherdetail(fin);
        List<FinMaterialContractEntity> matlist = this.costFinContractDetailMapper.queryMaterialdetail(fin);
        List<FinMachineContractEntity> maclist = this.costFinContractDetailMapper.queryMachinedetail(fin);
        List<FinOtherContractEntity> oclist = this.costFinContractDetailMapper.queryOthercontractdetail(fin);
        HashMap<String, Object> lw = new HashMap<String, Object>();
        lw.put("no", "1");
        lw.put("id", "1");
        lw.put("costItems", "\u52b3\u52a1\u5206\u5305\u8d39\uff08\u52b3\u52a1\u5206\u5305\u5408\u540c\uff09");
        alldata.add(lw);
        BigDecimal lwcontractamount = new BigDecimal("0");
        BigDecimal lwsettleNotax = new BigDecimal("0");
        BigDecimal lwsettleTax = new BigDecimal("0");
        BigDecimal lwsettle = new BigDecimal("0");
        BigDecimal lwforecastamountNotax = new BigDecimal("0");
        BigDecimal lwforecastamountTax = new BigDecimal("0");
        BigDecimal lwforecastamount = new BigDecimal("0");
        BigDecimal lwallamount = new BigDecimal("0");
        ArrayList newChildren = new ArrayList();
        if (sublist != null && sublist.size() > 0) {
            for (int s = 0; s < sublist.size(); ++s) {
                CostFinContractDetailEntity materialContractEntity = sublist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "1." + noo);
                matmap.put("id", "1." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                lwcontractamount = lwcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());
                matmap.put("settleNotax", materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                lwsettleNotax = lwsettleNotax.add(materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                lwsettleTax = lwsettleTax.add(materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                lwsettle = lwsettle.add(materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                BigDecimal allamount = materialContractEntity.getEstimatedAmountNotax();
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                lwallamount = lwallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                newChildren.add(matmap);
            }
        }
        lw.put("children", newChildren);
        lw.put("contractAmount", lwcontractamount);
        lw.put("settleNotax", lwsettleNotax);
        lw.put("settleTax", lwsettleTax);
        lw.put("settleAmount", lwsettle);
        lw.put("allCostNotax", lwallamount);
        alldata.set(0, lw);
        HashMap<String, Object> cl = new HashMap<String, Object>();
        cl.put("no", "2");
        cl.put("id", "2");
        cl.put("costItems", "\u6750\u6599\u8d39\uff08\u6750\u6599\u5408\u540c\u3001\u542b\u5468\u8f6c\u6750\u79df\u8d41\uff09");
        Integer allsize = alldata.size();
        alldata.add(cl);
        BigDecimal clcontractamount = new BigDecimal("0");
        BigDecimal clsettleNotax = new BigDecimal("0");
        BigDecimal clsettleTax = new BigDecimal("0");
        BigDecimal clsettle = new BigDecimal("0");
        BigDecimal clallamount = new BigDecimal("0");
        ArrayList newChildren2 = new ArrayList();
        if (matlist != null && matlist.size() > 0) {
            for (int s = 0; s < matlist.size(); ++s) {
                FinMaterialContractEntity materialContractEntity = matlist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "2." + noo);
                matmap.put("id", "2." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                clcontractamount = clcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());
                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                clsettleNotax = clsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                clsettleTax = clsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                clsettle = clsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                clallamount = clallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                newChildren2.add(matmap);
            }
        }
        cl.put("children", newChildren2);
        cl.put("contractAmount", clcontractamount);
        cl.put("settleNotax", clsettleNotax);
        cl.put("settleTax", clsettleTax);
        cl.put("settleAmount", clsettle);
        cl.put("allCostNotax", clallamount);
        alldata.set(allsize, cl);
        HashMap<String, Object> jx = new HashMap<String, Object>();
        jx.put("no", "3");
        jx.put("id", "3");
        jx.put("costItems", "\u673a\u68b0\u8d39\uff08\u673a\u68b0\u5408\u540c\u3001\u542b\u8bbe\u5907\u91c7\u8d2d\uff09");
        Integer jxsize = alldata.size();
        alldata.add(jx);
        BigDecimal jxcontractamount = new BigDecimal("0");
        BigDecimal jxsettleNotax = new BigDecimal("0");
        BigDecimal jxsettleTax = new BigDecimal("0");
        BigDecimal jxsettle = new BigDecimal("0");
        BigDecimal jxallamount = new BigDecimal("0");
        ArrayList newChildren3 = new ArrayList();
        if (maclist != null && maclist.size() > 0) {
            for (int s = 0; s < maclist.size(); ++s) {
                FinMachineContractEntity materialContractEntity = maclist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "3." + noo);
                matmap.put("id", "3." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                jxcontractamount = jxcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());
                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                jxsettleNotax = jxsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                jxsettleTax = jxsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                jxsettle = jxsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                jxallamount = jxallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                newChildren3.add(matmap);
            }
        }
        jx.put("children", newChildren3);
        jx.put("contractAmount", jxcontractamount);
        jx.put("settleNotax", jxsettleNotax);
        jx.put("settleTax", jxsettleTax);
        jx.put("settleAmount", jxsettle);
        jx.put("allCostNotax", jxallamount);
        alldata.set(jxsize, jx);
        HashMap<String, Object> zy = new HashMap<String, Object>();
        zy.put("no", "4");
        zy.put("id", "4");
        zy.put("costItems", "\u4e13\u4e1a\u5206\u5305\u5de5\u7a0b\u8d39\uff08\u4e13\u4e1a\u5206\u5305\u5408\u540c\uff09");
        Integer zysize = alldata.size();
        alldata.add(zy);
        BigDecimal zycontractamount = new BigDecimal("0");
        BigDecimal zysettleNotax = new BigDecimal("0");
        BigDecimal zysettleTax = new BigDecimal("0");
        BigDecimal zysettle = new BigDecimal("0");
        BigDecimal zyforecastamountNotax = new BigDecimal("0");
        BigDecimal zyforecastamountTax = new BigDecimal("0");
        BigDecimal zyforecastamount = new BigDecimal("0");
        BigDecimal zyallamount = new BigDecimal("0");
        ArrayList newChildren4 = new ArrayList();
        if (zysublist != null && zysublist.size() > 0) {
            for (int s = 0; s < zysublist.size(); ++s) {
                CostFinContractDetailEntity materialContractEntity = zysublist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "4." + noo);
                matmap.put("id", "4." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                zycontractamount = zycontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());
                matmap.put("settleNotax", materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                zysettleNotax = zysettleNotax.add(materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                zysettleTax = zysettleTax.add(materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                zysettle = zysettle.add(materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                BigDecimal allamount = materialContractEntity.getEstimatedAmountNotax();
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                zyallamount = zyallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                newChildren4.add(matmap);
            }
        }
        zy.put("children", newChildren4);
        zy.put("contractAmount", zycontractamount);
        zy.put("settleNotax", zysettleNotax);
        zy.put("settleTax", zysettleTax);
        zy.put("settleAmount", zysettle);
        zy.put("allCostNotax", zyallamount);
        alldata.set(zysize, zy);
        HashMap<String, Object> oc = new HashMap<String, Object>();
        oc.put("no", "5");
        oc.put("id", "5");
        oc.put("costItems", "\u5176\u4ed6\u8d39\u7528\uff08\u6709\u5408\u540c\u7684\uff09");
        Integer ocsize = alldata.size();
        alldata.add(oc);
        BigDecimal occontractamount = new BigDecimal("0");
        BigDecimal ocsettleNotax = new BigDecimal("0");
        BigDecimal ocsettleTax = new BigDecimal("0");
        BigDecimal ocsettle = new BigDecimal("0");
        BigDecimal ocallamount = new BigDecimal("0");
        ArrayList newChildren5 = new ArrayList();
        if (oclist != null && oclist.size() > 0) {
            for (int s = 0; s < oclist.size(); ++s) {
                FinOtherContractEntity materialContractEntity = oclist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "5." + noo);
                matmap.put("id", "5." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                occontractamount = occontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());
                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                ocsettleNotax = ocsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                ocsettleTax = ocsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                ocsettle = ocsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                ocallamount = ocallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                newChildren5.add(matmap);
            }
        }
        oc.put("children", newChildren5);
        oc.put("contractAmount", occontractamount);
        oc.put("settleNotax", ocsettleNotax);
        oc.put("settleTax", ocsettleTax);
        oc.put("settleAmount", ocsettle);
        oc.put("allCostNotax", ocallamount);
        alldata.set(ocsize, oc);
        HashMap<String, Object> ot = new HashMap<String, Object>();
        ot.put("no", "6");
        ot.put("id", "6");
        ot.put("costItems", "\u5176\u4ed6\u8d39\u7528\uff08\u65e0\u5408\u540c\u7684\u95f4\u63a5\u8d39\uff09");
        Integer otsize = alldata.size();
        alldata.add(ot);
        BigDecimal otsettleNotax = new BigDecimal("0");
        ArrayList newChildren6 = new ArrayList();
        if (othlist != null && othlist.size() > 0) {
            for (int t = 0; t < othlist.size(); ++t) {
                CostFinOtherDetailEntity materialContractEntity = othlist.get(t);
                Integer no = t;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "6." + noo);
                matmap.put("id", "6." + noo);
                if (materialContractEntity.getCostTypeId() != null) {
                    String typename = this.forecastOtherDetailMapper.querytypename(materialContractEntity.getCostTypeId());
                    matmap.put("contractName", typename);
                }
                matmap.put("taxRate", materialContractEntity.getSubjectName());
                BigDecimal settleAmount = this.forecastOtherDetailMapper.queryPaymny(projectId, materialContractEntity.getSubjectId());
                matmap.put("settleAmount", settleAmount.setScale(2, RoundingMode.HALF_UP));
                otsettleNotax = otsettleNotax.add(settleAmount.setScale(2, RoundingMode.HALF_UP));
                matmap.put("allCostNotax", settleAmount.setScale(2, RoundingMode.HALF_UP));
                newChildren6.add(matmap);
            }
        }
        ot.put("children", newChildren6);
        ot.put("settleAmount", otsettleNotax);
        ot.put("allCostNotax", otsettleNotax);
        alldata.set(otsize, ot);
        HashMap<String, Object> ot00 = new HashMap<String, Object>();
        ot00.put("no", "7");
        ot00.put("id", "7");
        ot00.put("costItems", "\u5176\u4ed6\u9884\u4f30\u6210\u672c");
        Integer ot0size = alldata.size();
        alldata.add(ot00);
        ArrayList newChildren7 = new ArrayList();
        HashMap<String, Object> ot1 = new HashMap<String, Object>();
        ot1.put("no", "7.1");
        ot1.put("id", "7.1");
        ot1.put("costItems", "\u95f4\u63a5\u8d39\u9884\u4f30");
        BigDecimal jjtotalnt = this.forecastOtherDetailMapper.queryjjtotal(projectId);
        ot1.put("forecastNotax", jjtotalnt);
        BigDecimal jjtotalt = this.forecastOtherDetailMapper.queryjjtotaltax(projectId);
        ot1.put("forecastTax", jjtotalt);
        BigDecimal jjtotal = this.forecastOtherDetailMapper.queryjjtotalamount(projectId);
        ot1.put("forecastAmount", jjtotal);
        newChildren7.add(ot1);
        HashMap<String, Object> ot2 = new HashMap<String, Object>();
        ot2.put("no", "7.2");
        ot2.put("id", "7.2");
        ot2.put("costItems", "\u6536\u5c3e\u9636\u6bb5\u53d1\u751f\u7684\u5176\u4ed6\u8d39\u9884\u4f30");
        BigDecimal qttotalnt = this.forecastOtherDetailMapper.queryqttotal(projectId);
        ot2.put("forecastNotax", qttotalnt);
        BigDecimal qttotalt = this.forecastOtherDetailMapper.queryqttotaltax(projectId);
        ot2.put("forecastTax", qttotalt);
        BigDecimal qttotal = this.forecastOtherDetailMapper.queryqttotalamount(projectId);
        ot2.put("forecastAmount", qttotal);
        newChildren7.add(ot2);
        ot00.put("children", newChildren7);
        ot00.put("forecastNotax", jjtotalnt.add(qttotalnt));
        ot00.put("forecastTax", jjtotalt.add(qttotalt));
        ot00.put("forecastAmount", jjtotal.add(qttotal));
        alldata.set(ot0size, ot00);
        return alldata;
    }

    @Override
    public List<Map<String, Object>> projectFinExhaustedSum(Long projectId) {
        ArrayList<Map<String, Object>> alldata = new ArrayList<Map<String, Object>>();
        List<CostFinContractDetailEntity> sublist = this.costFinContractDetailMapper.querySubContractByProjectIdLW(String.valueOf(projectId));
        List<CostFinContractDetailEntity> zysublist = this.costFinContractDetailMapper.querySubContractByProjectIdZY(String.valueOf(projectId));
        List<CostFinOtherDetailEntity> othlist = this.costFinOtherDetailMapper.querySubjectByProjectId(String.valueOf(projectId));
        List<FinMaterialContractEntity> matlist = this.costFinContractDetailMapper.querySubContractByProjectIdMaterial(String.valueOf(projectId));
        List<FinMachineContractEntity> maclist = this.costFinContractDetailMapper.querySubContractByProjectIdMachine(String.valueOf(projectId));
        List<FinOtherContractEntity> oclist = this.costFinContractDetailMapper.querySubContractByProjectIdOther(String.valueOf(projectId));
        HashMap<String, Object> lw = new HashMap<String, Object>();
        lw.put("no", "1");
        lw.put("id", "1");
        lw.put("costItems", "\u52b3\u52a1\u5206\u5305\u8d39\uff08\u52b3\u52a1\u5206\u5305\u5408\u540c\uff09");
        alldata.add(lw);
        BigDecimal lwcontractamount = new BigDecimal("0");
        BigDecimal lwsettleNotax = new BigDecimal("0");
        BigDecimal lwsettleTax = new BigDecimal("0");
        BigDecimal lwsettle = new BigDecimal("0");
        BigDecimal lwallamount = new BigDecimal("0");
        ArrayList newChildren = new ArrayList();
        if (sublist != null && sublist.size() > 0) {
            for (int s = 0; s < sublist.size(); ++s) {
                CostFinContractDetailEntity materialContractEntity = sublist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "1." + noo);
                matmap.put("id", "1." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                lwcontractamount = lwcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());
                matmap.put("settleNotax", materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                lwsettleNotax = lwsettleNotax.add(materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                lwsettleTax = lwsettleTax.add(materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                lwsettle = lwsettle.add(materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                BigDecimal allamount = materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                lwallamount = lwallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                newChildren.add(matmap);
            }
        }
        lw.put("children", newChildren);
        lw.put("contractAmount", lwcontractamount);
        lw.put("settleNotax", lwsettleNotax);
        lw.put("settleTax", lwsettleTax);
        lw.put("settleAmount", lwsettle);
        lw.put("allCostNotax", lwallamount);
        alldata.set(0, lw);
        HashMap<String, Object> cl = new HashMap<String, Object>();
        cl.put("no", "2");
        cl.put("id", "2");
        cl.put("costItems", "\u6750\u6599\u8d39\uff08\u6750\u6599\u5408\u540c\u3001\u542b\u5468\u8f6c\u6750\u79df\u8d41\uff09");
        Integer allsize = alldata.size();
        alldata.add(cl);
        BigDecimal clcontractamount = new BigDecimal("0");
        BigDecimal clsettleNotax = new BigDecimal("0");
        BigDecimal clsettleTax = new BigDecimal("0");
        BigDecimal clsettle = new BigDecimal("0");
        BigDecimal clallamount = new BigDecimal("0");
        ArrayList newChildren2 = new ArrayList();
        if (matlist != null && matlist.size() > 0) {
            for (int s = 0; s < matlist.size(); ++s) {
                FinMaterialContractEntity materialContractEntity = matlist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "2." + noo);
                matmap.put("id", "2." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                clcontractamount = clcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());
                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                clsettleNotax = clsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                clsettleTax = clsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                clsettle = clsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                clallamount = clallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                newChildren2.add(matmap);
            }
        }
        cl.put("children", newChildren2);
        cl.put("contractAmount", clcontractamount);
        cl.put("settleNotax", clsettleNotax);
        cl.put("settleTax", clsettleTax);
        cl.put("settleAmount", clsettle);
        cl.put("allCostNotax", clallamount);
        alldata.set(allsize, cl);
        HashMap<String, Object> jx = new HashMap<String, Object>();
        jx.put("no", "3");
        jx.put("id", "3");
        jx.put("costItems", "\u673a\u68b0\u8d39\uff08\u673a\u68b0\u5408\u540c\u3001\u542b\u8bbe\u5907\u91c7\u8d2d\uff09");
        Integer jxsize = alldata.size();
        alldata.add(jx);
        BigDecimal jxcontractamount = new BigDecimal("0");
        BigDecimal jxsettleNotax = new BigDecimal("0");
        BigDecimal jxsettleTax = new BigDecimal("0");
        BigDecimal jxsettle = new BigDecimal("0");
        BigDecimal jxallamount = new BigDecimal("0");
        ArrayList newChildren3 = new ArrayList();
        if (maclist != null && maclist.size() > 0) {
            for (int s = 0; s < maclist.size(); ++s) {
                FinMachineContractEntity materialContractEntity = maclist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "3." + noo);
                matmap.put("id", "3." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                jxcontractamount = jxcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());
                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                jxsettleNotax = jxsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                jxsettleTax = jxsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                jxsettle = jxsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                jxallamount = jxallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                newChildren3.add(matmap);
            }
        }
        jx.put("children", newChildren3);
        jx.put("contractAmount", jxcontractamount);
        jx.put("settleNotax", jxsettleNotax);
        jx.put("settleTax", jxsettleTax);
        jx.put("settleAmount", jxsettle);
        jx.put("allCostNotax", jxallamount);
        alldata.set(jxsize, jx);
        HashMap<String, Object> zy = new HashMap<String, Object>();
        zy.put("no", "4");
        zy.put("id", "4");
        zy.put("costItems", "\u4e13\u4e1a\u5206\u5305\u5de5\u7a0b\u8d39\uff08\u4e13\u4e1a\u5206\u5305\u5408\u540c\uff09");
        Integer zysize = alldata.size();
        alldata.add(zy);
        BigDecimal zycontractamount = new BigDecimal("0");
        BigDecimal zysettleNotax = new BigDecimal("0");
        BigDecimal zysettleTax = new BigDecimal("0");
        BigDecimal zysettle = new BigDecimal("0");
        BigDecimal zyallamount = new BigDecimal("0");
        ArrayList newChildren4 = new ArrayList();
        if (zysublist != null && zysublist.size() > 0) {
            for (int s = 0; s < zysublist.size(); ++s) {
                CostFinContractDetailEntity materialContractEntity = zysublist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "4." + noo);
                matmap.put("id", "4." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                zycontractamount = zycontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());
                matmap.put("settleNotax", materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                zysettleNotax = zysettleNotax.add(materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                zysettleTax = zysettleTax.add(materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                zysettle = zysettle.add(materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                BigDecimal allamount = materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                zyallamount = zyallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                newChildren4.add(matmap);
            }
        }
        zy.put("children", newChildren4);
        zy.put("contractAmount", zycontractamount);
        zy.put("settleNotax", zysettleNotax);
        zy.put("settleTax", zysettleTax);
        zy.put("settleAmount", zysettle);
        zy.put("allCostNotax", zyallamount);
        alldata.set(zysize, zy);
        HashMap<String, Object> oc = new HashMap<String, Object>();
        oc.put("no", "5");
        oc.put("id", "5");
        oc.put("costItems", "\u5176\u4ed6\u8d39\u7528\uff08\u6709\u5408\u540c\u7684\uff09");
        Integer ocsize = alldata.size();
        alldata.add(oc);
        BigDecimal occontractamount = new BigDecimal("0");
        BigDecimal ocsettleNotax = new BigDecimal("0");
        BigDecimal ocsettleTax = new BigDecimal("0");
        BigDecimal ocsettle = new BigDecimal("0");
        BigDecimal ocallamount = new BigDecimal("0");
        ArrayList newChildren5 = new ArrayList();
        if (oclist != null && oclist.size() > 0) {
            for (int s = 0; s < oclist.size(); ++s) {
                FinOtherContractEntity materialContractEntity = oclist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "5." + noo);
                matmap.put("id", "5." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount() == null ? new BigDecimal("0") : materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                occontractamount = occontractamount.add(materialContractEntity.getContractAmount() == null ? new BigDecimal("0") : materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());
                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                ocsettleNotax = ocsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                ocsettleTax = ocsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                ocsettle = ocsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                ocallamount = ocallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                newChildren5.add(matmap);
            }
        }
        oc.put("children", newChildren5);
        oc.put("contractAmount", occontractamount);
        oc.put("settleNotax", ocsettleNotax);
        oc.put("settleTax", ocsettleTax);
        oc.put("settleAmount", ocsettle);
        oc.put("allCostNotax", ocallamount);
        alldata.set(ocsize, oc);
        HashMap<String, Object> ot = new HashMap<String, Object>();
        ot.put("no", "6");
        ot.put("id", "6");
        ot.put("costItems", "\u5176\u4ed6\u8d39\u7528\uff08\u65e0\u5408\u540c\u7684\u95f4\u63a5\u8d39\uff09");
        Integer otsize = alldata.size();
        alldata.add(ot);
        BigDecimal otsettleNotax = new BigDecimal("0");
        ArrayList newChildren6 = new ArrayList();
        if (othlist != null && othlist.size() > 0) {
            for (int t = 0; t < othlist.size(); ++t) {
                CostFinOtherDetailEntity materialContractEntity = othlist.get(t);
                Integer no = t;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "6." + noo);
                matmap.put("id", "6." + noo);
                Long objid = materialContractEntity.getSubjectId();
                String typename = this.forecastOtherDetailMapper.querytype(projectId, objid);
                String changetypename = this.forecastOtherDetailMapper.querytypechange(projectId, objid);
                if (typename == null) {
                    matmap.put("contractName", changetypename);
                } else {
                    matmap.put("contractName", typename);
                }
                matmap.put("taxRate", materialContractEntity.getSubjectName());
                BigDecimal settleAmount = this.forecastOtherDetailMapper.queryPaymny(projectId, materialContractEntity.getSubjectId());
                matmap.put("settleAmount", settleAmount.setScale(2, RoundingMode.HALF_UP));
                otsettleNotax = otsettleNotax.add(settleAmount.setScale(2, RoundingMode.HALF_UP));
                matmap.put("allCostNotax", settleAmount.setScale(2, RoundingMode.HALF_UP));
                newChildren6.add(matmap);
            }
        }
        ot.put("settleAmount", otsettleNotax);
        ot.put("allCostNotax", otsettleNotax);
        ot.put("children", newChildren6);
        alldata.set(otsize, ot);
        return alldata;
    }

    @Override
    public List<Map<String, Object>> projectFinClosingSumRealTime(Long projectId) {
        Long fin = this.costFinContractDetailMapper.queryId(String.valueOf(projectId));
        ArrayList<Map<String, Object>> alldata = new ArrayList<Map<String, Object>>();
        List<CostFinContractDetailEntity> sublist = this.costFinContractDetailMapper.querySubContractByProjectIdLW(String.valueOf(projectId));
        List<CostFinContractDetailEntity> zysublist = this.costFinContractDetailMapper.querySubContractByProjectIdZY(String.valueOf(projectId));
        List<CostFinOtherDetailEntity> othlist = this.costFinOtherDetailMapper.querySubjectByProjectId(String.valueOf(projectId));
        List<FinMaterialContractEntity> matlist = this.costFinContractDetailMapper.querySubContractByProjectIdMaterial(String.valueOf(projectId));
        List<FinMachineContractEntity> maclist = this.costFinContractDetailMapper.querySubContractByProjectIdMachine(String.valueOf(projectId));
        List<FinOtherContractEntity> oclist = this.costFinContractDetailMapper.querySubContractByProjectIdOther(String.valueOf(projectId));
        HashMap<String, Object> lw = new HashMap<String, Object>();
        lw.put("no", "1");
        lw.put("id", "1");
        lw.put("costItems", "\u52b3\u52a1\u5206\u5305\u8d39\uff08\u52b3\u52a1\u5206\u5305\u5408\u540c\uff09");
        alldata.add(lw);
        BigDecimal lwcontractamount = new BigDecimal("0");
        BigDecimal lwsettleNotax = new BigDecimal("0");
        BigDecimal lwsettleTax = new BigDecimal("0");
        BigDecimal lwsettle = new BigDecimal("0");
        BigDecimal lwforecastamountNotax = new BigDecimal("0");
        BigDecimal lwforecastamountTax = new BigDecimal("0");
        BigDecimal lwforecastamount = new BigDecimal("0");
        BigDecimal lwallamount = new BigDecimal("0");
        ArrayList newChildren = new ArrayList();
        if (sublist != null && sublist.size() > 0) {
            for (int s = 0; s < sublist.size(); ++s) {
                CostFinContractDetailEntity materialContractEntity = sublist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "1." + noo);
                matmap.put("id", "1." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                lwcontractamount = lwcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());
                matmap.put("settleNotax", materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                lwsettleNotax = lwsettleNotax.add(materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                lwsettleTax = lwsettleTax.add(materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                lwsettle = lwsettle.add(materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                BigDecimal ygnamount = this.costFinContractDetailMapper.queryForecastnotax(materialContractEntity.getContractCode());
                BigDecimal bgnamount = this.costFinContractDetailMapper.queryForecastChangenotax(materialContractEntity.getContractCode());
                BigDecimal notax = ygnamount.add(bgnamount);
                matmap.put("forecastNotax", notax.setScale(2, RoundingMode.HALF_UP));
                lwforecastamountNotax = lwforecastamountNotax.add(notax.setScale(2, RoundingMode.HALF_UP));
                BigDecimal ygtaxamount = this.costFinContractDetailMapper.queryForecasttax(materialContractEntity.getContractCode());
                BigDecimal bgtaxamount = this.costFinContractDetailMapper.queryForecastChangetax(materialContractEntity.getContractCode());
                BigDecimal tax = ygtaxamount.add(bgtaxamount);
                matmap.put("forecastTax", tax.setScale(2, RoundingMode.HALF_UP));
                lwforecastamountTax = lwforecastamountTax.add(tax.setScale(2, RoundingMode.HALF_UP));
                BigDecimal ygamount = this.costFinContractDetailMapper.queryForecastamount(materialContractEntity.getContractCode());
                BigDecimal bgamount = this.costFinContractDetailMapper.queryForecastChangeamount(materialContractEntity.getContractCode());
                BigDecimal amount = ygamount.add(bgamount);
                matmap.put("forecastAmount", amount.setScale(2, RoundingMode.HALF_UP));
                lwforecastamount = lwforecastamount.add(amount.setScale(2, RoundingMode.HALF_UP));
                BigDecimal allamount = materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP).add(notax.setScale(2, RoundingMode.HALF_UP));
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                lwallamount = lwallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                newChildren.add(matmap);
            }
        }
        lw.put("children", newChildren);
        lw.put("contractAmount", lwcontractamount);
        lw.put("settleNotax", lwsettleNotax);
        lw.put("settleTax", lwsettleTax);
        lw.put("settleAmount", lwsettle);
        lw.put("forecastNotax", lwforecastamountNotax);
        lw.put("forecastTax", lwforecastamountTax);
        lw.put("forecastAmount", lwforecastamount);
        lw.put("allCostNotax", lwallamount);
        alldata.set(0, lw);
        HashMap<String, Object> cl = new HashMap<String, Object>();
        cl.put("no", "2");
        cl.put("id", "2");
        cl.put("costItems", "\u6750\u6599\u8d39\uff08\u6750\u6599\u5408\u540c\u3001\u542b\u5468\u8f6c\u6750\u79df\u8d41\uff09");
        Integer allsize = alldata.size();
        alldata.add(cl);
        BigDecimal clcontractamount = new BigDecimal("0");
        BigDecimal clsettleNotax = new BigDecimal("0");
        BigDecimal clsettleTax = new BigDecimal("0");
        BigDecimal clsettle = new BigDecimal("0");
        BigDecimal clallamount = new BigDecimal("0");
        ArrayList newChildren2 = new ArrayList();
        if (matlist != null && matlist.size() > 0) {
            for (int s = 0; s < matlist.size(); ++s) {
                FinMaterialContractEntity materialContractEntity = matlist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "2." + noo);
                matmap.put("id", "2." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                clcontractamount = clcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());
                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                clsettleNotax = clsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                clsettleTax = clsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                clsettle = clsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                clallamount = clallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                newChildren2.add(matmap);
            }
        }
        cl.put("children", newChildren2);
        cl.put("contractAmount", clcontractamount);
        cl.put("settleNotax", clsettleNotax);
        cl.put("settleTax", clsettleTax);
        cl.put("settleAmount", clsettle);
        cl.put("allCostNotax", clallamount);
        alldata.set(allsize, cl);
        HashMap<String, Object> jx = new HashMap<String, Object>();
        jx.put("no", "3");
        jx.put("id", "3");
        jx.put("costItems", "\u673a\u68b0\u8d39\uff08\u673a\u68b0\u5408\u540c\u3001\u542b\u8bbe\u5907\u91c7\u8d2d\uff09");
        Integer jxsize = alldata.size();
        alldata.add(jx);
        BigDecimal jxcontractamount = new BigDecimal("0");
        BigDecimal jxsettleNotax = new BigDecimal("0");
        BigDecimal jxsettleTax = new BigDecimal("0");
        BigDecimal jxsettle = new BigDecimal("0");
        BigDecimal jxallamount = new BigDecimal("0");
        ArrayList newChildren3 = new ArrayList();
        if (maclist != null && maclist.size() > 0) {
            for (int s = 0; s < maclist.size(); ++s) {
                FinMachineContractEntity materialContractEntity = maclist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "3." + noo);
                matmap.put("id", "3." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                jxcontractamount = jxcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());
                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                jxsettleNotax = jxsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                jxsettleTax = jxsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                jxsettle = jxsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                jxallamount = jxallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                newChildren3.add(matmap);
            }
        }
        jx.put("children", newChildren3);
        jx.put("contractAmount", jxcontractamount);
        jx.put("settleNotax", jxsettleNotax);
        jx.put("settleTax", jxsettleTax);
        jx.put("settleAmount", jxsettle);
        jx.put("allCostNotax", jxallamount);
        alldata.set(jxsize, jx);
        HashMap<String, Object> zy = new HashMap<String, Object>();
        zy.put("no", "4");
        zy.put("id", "4");
        zy.put("costItems", "\u4e13\u4e1a\u5206\u5305\u5de5\u7a0b\u8d39\uff08\u4e13\u4e1a\u5206\u5305\u5408\u540c\uff09");
        Integer zysize = alldata.size();
        alldata.add(zy);
        BigDecimal zycontractamount = new BigDecimal("0");
        BigDecimal zysettleNotax = new BigDecimal("0");
        BigDecimal zysettleTax = new BigDecimal("0");
        BigDecimal zysettle = new BigDecimal("0");
        BigDecimal zyforecastamountNotax = new BigDecimal("0");
        BigDecimal zyforecastamountTax = new BigDecimal("0");
        BigDecimal zyforecastamount = new BigDecimal("0");
        BigDecimal zyallamount = new BigDecimal("0");
        ArrayList newChildren4 = new ArrayList();
        if (zysublist != null && zysublist.size() > 0) {
            for (int s = 0; s < zysublist.size(); ++s) {
                CostFinContractDetailEntity materialContractEntity = zysublist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "4." + noo);
                matmap.put("id", "4." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                zycontractamount = zycontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());
                matmap.put("settleNotax", materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                zysettleNotax = zysettleNotax.add(materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                zysettleTax = zysettleTax.add(materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                zysettle = zysettle.add(materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                BigDecimal ygnamount = this.costFinContractDetailMapper.queryForecastnotax(materialContractEntity.getContractCode());
                BigDecimal bgnamount = this.costFinContractDetailMapper.queryForecastChangenotax(materialContractEntity.getContractCode());
                BigDecimal notax = ygnamount.add(bgnamount);
                matmap.put("forecastNotax", notax.setScale(2, RoundingMode.HALF_UP));
                zyforecastamountNotax = zyforecastamountNotax.add(notax.setScale(2, RoundingMode.HALF_UP));
                BigDecimal ygtaxamount = this.costFinContractDetailMapper.queryForecasttax(materialContractEntity.getContractCode());
                BigDecimal bgtaxamount = this.costFinContractDetailMapper.queryForecastChangetax(materialContractEntity.getContractCode());
                BigDecimal tax = ygtaxamount.add(bgtaxamount);
                matmap.put("forecastTax", tax.setScale(2, RoundingMode.HALF_UP));
                zyforecastamountTax = zyforecastamountTax.add(tax.setScale(2, RoundingMode.HALF_UP));
                BigDecimal ygamount = this.costFinContractDetailMapper.queryForecastamount(materialContractEntity.getContractCode());
                BigDecimal bgamount = this.costFinContractDetailMapper.queryForecastChangeamount(materialContractEntity.getContractCode());
                BigDecimal amount = ygamount.add(bgamount);
                matmap.put("forecastAmount", amount.setScale(2, RoundingMode.HALF_UP));
                zyforecastamount = zyforecastamount.add(amount.setScale(2, RoundingMode.HALF_UP));
                BigDecimal allamount = materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP).add(notax.setScale(2, RoundingMode.HALF_UP));
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                zyallamount = zyallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                newChildren4.add(matmap);
            }
        }
        zy.put("children", newChildren4);
        zy.put("contractAmount", zycontractamount);
        zy.put("settleNotax", zysettleNotax);
        zy.put("settleTax", zysettleTax);
        zy.put("settleAmount", zysettle);
        zy.put("forecastNotax", zyforecastamountNotax);
        zy.put("forecastTax", zyforecastamountTax);
        zy.put("forecastAmount", zyforecastamount);
        zy.put("allCostNotax", zyallamount);
        alldata.set(zysize, zy);
        HashMap<String, Object> oc = new HashMap<String, Object>();
        oc.put("no", "5");
        oc.put("id", "5");
        oc.put("costItems", "\u5176\u4ed6\u8d39\u7528\uff08\u6709\u5408\u540c\u7684\uff09");
        Integer ocsize = alldata.size();
        alldata.add(oc);
        BigDecimal occontractamount = new BigDecimal("0");
        BigDecimal ocsettleNotax = new BigDecimal("0");
        BigDecimal ocsettleTax = new BigDecimal("0");
        BigDecimal ocsettle = new BigDecimal("0");
        BigDecimal ocallamount = new BigDecimal("0");
        ArrayList newChildren5 = new ArrayList();
        if (oclist != null && oclist.size() > 0) {
            for (int s = 0; s < oclist.size(); ++s) {
                FinOtherContractEntity materialContractEntity = oclist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "5." + noo);
                matmap.put("id", "5." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                occontractamount = occontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());
                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                ocsettleNotax = ocsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                ocsettleTax = ocsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                ocsettle = ocsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                ocallamount = ocallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));
                newChildren5.add(matmap);
            }
        }
        oc.put("children", newChildren5);
        oc.put("contractAmount", occontractamount);
        oc.put("settleNotax", ocsettleNotax);
        oc.put("settleTax", ocsettleTax);
        oc.put("settleAmount", ocsettle);
        oc.put("allCostNotax", ocallamount);
        alldata.set(ocsize, oc);
        HashMap<String, Object> ot = new HashMap<String, Object>();
        ot.put("no", "6");
        ot.put("id", "6");
        ot.put("costItems", "\u5176\u4ed6\u8d39\u7528\uff08\u65e0\u5408\u540c\u7684\u95f4\u63a5\u8d39\uff09");
        Integer otsize = alldata.size();
        alldata.add(ot);
        BigDecimal otsettleNotax = new BigDecimal("0");
        ArrayList newChildren6 = new ArrayList();
        if (othlist != null && othlist.size() > 0) {
            for (int t = 0; t < othlist.size(); ++t) {
                CostFinOtherDetailEntity materialContractEntity = othlist.get(t);
                Integer no = t;
                Integer noo = no + 1;
                HashMap<String, Object> matmap = new HashMap<String, Object>();
                matmap.put("no", "6." + noo);
                matmap.put("id", "6." + noo);
                Long objid = materialContractEntity.getSubjectId();
                String typename = this.forecastOtherDetailMapper.querytype(projectId, objid);
                String changetypename = this.forecastOtherDetailMapper.querytypechange(projectId, objid);
                if (typename == null) {
                    matmap.put("contractName", changetypename);
                } else {
                    matmap.put("contractName", typename);
                }
                matmap.put("taxRate", materialContractEntity.getSubjectName());
                BigDecimal settleAmount = this.forecastOtherDetailMapper.queryPaymny(projectId, materialContractEntity.getSubjectId());
                matmap.put("settleAmount", settleAmount.setScale(2, RoundingMode.HALF_UP));
                otsettleNotax = otsettleNotax.add(settleAmount.setScale(2, RoundingMode.HALF_UP));
                matmap.put("allCostNotax", settleAmount.setScale(2, RoundingMode.HALF_UP));
                newChildren6.add(matmap);
            }
        }
        ot.put("children", newChildren6);
        ot.put("settleAmount", otsettleNotax);
        ot.put("allCostNotax", otsettleNotax);
        alldata.set(otsize, ot);
        BigDecimal zOtsettleNotaxSum = BigDecimal.ZERO;
        HashMap<String, Object> ot00 = new HashMap<String, Object>();
        ot00.put("no", "7");
        ot00.put("id", "7");
        ot00.put("costItems", "\u5176\u4ed6\u9884\u4f30\u6210\u672c");
        Integer ot0size = alldata.size();
        alldata.add(ot00);
        ArrayList newChildren7 = new ArrayList();
        HashMap<String, Object> ot1 = new HashMap<String, Object>();
        ot1.put("no", "7.1");
        ot1.put("id", "7.1");
        ot1.put("costItems", "\u95f4\u63a5\u8d39\u9884\u4f30");
        BigDecimal jjtotalnt = this.forecastOtherDetailMapper.queryjjtotal(projectId);
        ot1.put("forecastNotax", jjtotalnt);
        BigDecimal jjtotalt = this.forecastOtherDetailMapper.queryjjtotaltax(projectId);
        ot1.put("forecastTax", jjtotalt);
        BigDecimal jjtotal = this.forecastOtherDetailMapper.queryjjtotalamount(projectId);
        ot1.put("forecastAmount", jjtotal);
        ot1.put("allCostNotax", jjtotalnt);
        zOtsettleNotaxSum = zOtsettleNotaxSum.add(jjtotalnt);
        newChildren7.add(ot1);
        HashMap<String, Object> ot2 = new HashMap<String, Object>();
        ot2.put("no", "7.2");
        ot2.put("id", "7.2");
        ot2.put("costItems", "\u6536\u5c3e\u9636\u6bb5\u53d1\u751f\u7684\u5176\u4ed6\u8d39\u9884\u4f30");
        BigDecimal qttotalnt = this.forecastOtherDetailMapper.queryqttotal(projectId);
        ot2.put("forecastNotax", qttotalnt);
        BigDecimal qttotalt = this.forecastOtherDetailMapper.queryqttotaltax(projectId);
        ot2.put("forecastTax", qttotalt);
        BigDecimal qttotal = this.forecastOtherDetailMapper.queryqttotalamount(projectId);
        ot2.put("forecastAmount", qttotal);
        ot2.put("allCostNotax", qttotalnt);
        zOtsettleNotaxSum = zOtsettleNotaxSum.add(qttotalnt);
        newChildren7.add(ot2);
        ot00.put("children", newChildren7);
        ot00.put("forecastNotax", jjtotalnt.add(qttotalnt));
        ot00.put("forecastTax", jjtotalt.add(qttotalt));
        ot00.put("forecastAmount", jjtotal.add(qttotal));
        ot00.put("allCostNotax", zOtsettleNotaxSum);
        alldata.set(ot0size, ot00);
        return alldata;
    }

    @Override
    public List<Map<String, Object>> projectFinAllClosingSumRealTime() {
        ArrayList<Map<String, Object>> alldata = new ArrayList<Map<String, Object>>();
        List<CostClosingLastEntity> allproject = this.costClosingLastMapper.revenueExpenditureSummary();
        for (int s = 0; s < allproject.size(); ++s) {
            CostClosingLastEntity materialContractEntity = allproject.get(s);
            Long trueprojectId = materialContractEntity.getProjectId();
            Integer no = s;
            Integer noo = no + 1;
            HashMap<String, Object> matmap = new HashMap<String, Object>();
            matmap.put("no", noo);
            matmap.put("projectName", materialContractEntity.getProjectName());
            String zt = materialContractEntity.getContractCode();
            String ztname = new String();
            if (zt != null) {
                if (zt.equals("0")) {
                    ztname = "\u672a\u5f00\u5de5";
                }
                if (zt.equals("1")) {
                    ztname = "\u5728\u5efa";
                }
                if (zt.equals("2")) {
                    ztname = "\u5b8c\u5de5\u672a\u9a8c\u6536";
                }
                if (zt.equals("3")) {
                    ztname = "\u5b8c\u5de5\u9a8c\u6536";
                }
                if (zt.equals("4")) {
                    ztname = "\u5df2\u9a8c\u6536\u672a\u7ed3\u7b97";
                }
                if (zt.equals("5")) {
                    ztname = "\u5df2\u7ed3\u7b97";
                }
            }
            matmap.put("engineerType", ztname);
            Date start = materialContractEntity.getCompletionTime();
            Date end = materialContractEntity.getCompletionAcceptanceTime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (start != null) {
                String startdateString = sdf.format(start);
                matmap.put("actualStart", startdateString);
            }
            if (end != null) {
                String enddateString = sdf.format(end);
                matmap.put("completionAcceptanceTime", enddateString);
            }
            matmap.put("projectCost", materialContractEntity.getSumProductionTaxMny());
            matmap.put("sumProductionMny", materialContractEntity.getSettlementTax());
            matmap.put("calculateExcludtax", materialContractEntity.getSumProductionMny());
            matmap.put("maxSettlement", materialContractEntity.getLastTaxOutputValue());
            matmap.put("conservativeSettlement", materialContractEntity.getLastOutputValue());
            BigDecimal Damount = materialContractEntity.getLastOutputValue();
            matmap.put("settleAuditAmount", materialContractEntity.getSumProductionMny());
            BigDecimal subsettle = this.costClosingForecastMapper.subsettle(trueprojectId);
            BigDecimal materialsettle = this.costClosingForecastMapper.materialsettle(trueprojectId);
            BigDecimal machinesettle = this.costClosingForecastMapper.machinesettle(trueprojectId);
            BigDecimal othersettle = this.costClosingForecastMapper.othersettle(trueprojectId);
            BigDecimal ljfk = this.costClosingForecastMapper.ljfk(trueprojectId);
            BigDecimal yjs = subsettle.add(materialsettle).add(machinesettle).add(othersettle).add(ljfk);
            matmap.put("closeCosty", yjs);
            BigDecimal subnotax = this.costClosingForecastMapper.subnotax(trueprojectId);
            BigDecimal subchangenotax = this.costClosingForecastMapper.subchangenotax(trueprojectId);
            BigDecimal othnotax = this.costClosingForecastMapper.othnotax(trueprojectId);
            BigDecimal othchangenotax = this.costClosingForecastMapper.othchangenotax(trueprojectId);
            BigDecimal yg = subnotax.add(subchangenotax).add(othnotax).add(othchangenotax);
            BigDecimal conjs = this.forecastOtherDetailChangeMapper.conjs(trueprojectId);
            BigDecimal js = this.forecastOtherDetailChangeMapper.js(trueprojectId);
            BigDecimal closecostv = yg.subtract(conjs).subtract(js);
            matmap.put("closeCostv", closecostv);
            BigDecimal wgzcb = yjs.add(closecostv);
            matmap.put("totalCost", wgzcb);
            BigDecimal lr = Damount.subtract(wgzcb);
            matmap.put("expectprofitax", lr);
            BigDecimal lrl = new BigDecimal("0.00");
            if (lr.compareTo(BigDecimal.ZERO) != 0 && Damount.compareTo(BigDecimal.ZERO) != 0) {
                lrl = lr.divide(Damount, 2, 4);
            }
            matmap.put("expectprofits", lrl);
            BigDecimal qblr = this.costClosingForecastMapper.queryqblrl(trueprojectId);
            matmap.put("targetprofitaxqb", qblr);
            BigDecimal mblr = this.costClosingForecastMapper.querylrl(trueprojectId);
            matmap.put("targetprofitax", mblr);
            BigDecimal tzlr = this.costClosingForecastMapper.querytzlrl(trueprojectId);
            matmap.put("targetprofitaxtz", tzlr);
            alldata.add(matmap);
        }
        return alldata;
    }
}

