package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 成本关门
 *
 * @author generator
 *
 */
 @TableName("ejc_cost_closing")
public class CostClosingEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="days")
    private String days; // 申请延长时间
    @TableField(value="new_cost_closing_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date newCostClosingTime; // 变更成本关门期限

    @TableField(value="old_cost_closing_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date oldCostClosingTime; // 原成本关门期限

    @TableField(value="completion_acceptance_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionAcceptanceTime; // 竣工验收时间

    @TableField(value="cost_closing_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date costClosingTime; // 成本关门期限
    @TableField(value="completion_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionTime; // 完工时间
    @TableField(value="conservative_tax_settlement")
    private BigDecimal conservativeTaxSettlement; // 保守结算值 （含税）
    @TableField(value="conservative_settlement")
    private BigDecimal conservativeSettlement; // 保守结算值 （不含税）
    @TableField(value="max_tax_settlement  ")
    private BigDecimal maxTaxSettlement; // 最大结算值 （含税）
    @TableField(value="max_settlement")
    private BigDecimal maxSettlement; // 最大结算值 （不含税）
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="project_cost")
    private BigDecimal projectCost; // 项目造价
    @TableField(value="sum_production_tax_mny")
    private BigDecimal sumProductionTaxMny; // 累计产值报量（含税）
    @TableField(value="sum_production_mny")
    private BigDecimal sumProductionMny; // 累计产值报量（不含税）
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="project_id")
    private Long projectId; // 项目主键

    @TableField(value="bill_code")
    private String billCode; // 单据编号

    @TableField(value="bill_state")
    private Integer billState; // 单据状态

    /**
     * 变更主键
     */
    @TableField("change_id")
    private Long changeId;

    @TableField(value="change_status")
    private Integer changeStatus;//变更状态

    @TableField(value="change_code")
    private String changeCode; // 变更单号

    @TableField(value="sum_production_tax")
    private Integer sumProductionTax;//项目产值税额
    @TableField(value="settlement_tax")
    private Integer settlementTax;//最大结算值税额
    @TableField(value="conservative_tax")
    private Integer conservativeTax;//保守结算值税额
    @TableField(value="memo")
    private String memo;//备注

    @TableField(value="employee_id")
    private Long employeeId; // 经办人

    @TableField(value="org_id")
    private Long orgId; // 组织

    @TableField(value="employee_name")
    private String employeeName; // 经办人名称

    @TableField(value="org_name")
    private String orgName; // 组织名称

    @TableField(value="change_status_name")
    private String changeStatusName; // 变更状态名称


    @TableField(exist = false)
    private List<CostClosingChangesEntity> costClosingChanges;



    public List<CostClosingChangesEntity> getCostClosingChanges() {
        return costClosingChanges;
    }

    public void setCostClosingChanges(List<CostClosingChangesEntity> costClosingChanges) {
        this.costClosingChanges = costClosingChanges;
    }

    public String getChangeStatusName() {
        return changeStatusName;
    }

    public void setChangeStatusName(String changeStatusName) {
        this.changeStatusName = changeStatusName;
    }

    public Date getOldCostClosingTime() {
        return oldCostClosingTime;
    }

    public void setOldCostClosingTime(Date oldCostClosingTime) {
        this.oldCostClosingTime = oldCostClosingTime;
    }

    public String getDays() {
        return days;
    }

    public void setDays(String days) {
        this.days = days;
    }
    public Date getNewCostClosingTime() {
        return newCostClosingTime;
    }

    public void setNewCostClosingTime(Date newCostClosingTime) {
        this.newCostClosingTime = newCostClosingTime;
    }
    public Date getCostClosingTime() {
        return costClosingTime;
    }

    public void setCostClosingTime(Date costClosingTime) {
        this.costClosingTime = costClosingTime;
    }
    public Date getCompletionTime() {
        return completionTime;
    }

    public void setCompletionTime(Date completionTime) {
        this.completionTime = completionTime;
    }
    public BigDecimal getConservativeTaxSettlement() {
        return conservativeTaxSettlement;
    }

    public void setConservativeTaxSettlement(BigDecimal conservativeTaxSettlement) {
        this.conservativeTaxSettlement = conservativeTaxSettlement;
    }
    public BigDecimal getConservativeSettlement() {
        return conservativeSettlement;
    }

    public void setConservativeSettlement(BigDecimal conservativeSettlement) {
        this.conservativeSettlement = conservativeSettlement;
    }
    public BigDecimal getMaxTaxSettlement() {
        return maxTaxSettlement;
    }

    public void setMaxTaxSettlement(BigDecimal maxTaxSettlement) {
        this.maxTaxSettlement = maxTaxSettlement;
    }
    public BigDecimal getMaxSettlement() {
        return maxSettlement;
    }

    public void setMaxSettlement(BigDecimal maxSettlement) {
        this.maxSettlement = maxSettlement;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public BigDecimal getProjectCost() {
        return projectCost;
    }

    public void setProjectCost(BigDecimal projectCost) {
        this.projectCost = projectCost;
    }
    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getSumProductionTax() {
        return sumProductionTax;
    }

    public void setSumProductionTax(Integer sumProductionTax) {
        this.sumProductionTax = sumProductionTax;
    }

    public Integer getSettlementTax() {
        return settlementTax;
    }

    public void setSettlementTax(Integer settlementTax) {
        this.settlementTax = settlementTax;
    }

    public Integer getConservativeTax() {
        return conservativeTax;
    }

    public void setConservativeTax(Integer conservativeTax) {
        this.conservativeTax = conservativeTax;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Date getCompletionAcceptanceTime() {
        return completionAcceptanceTime;
    }

    public void setCompletionAcceptanceTime(Date completionAcceptanceTime) {
        this.completionAcceptanceTime = completionAcceptanceTime;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public String getChangeCode() {
        return changeCode;
    }


}
