package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.ejianc.business.cost.bean.CostClosingChangesEntity;
import com.ejianc.business.cost.bean.CostClosingEntity;
import com.ejianc.business.cost.mapper.CostClosingChangesMapper;
import com.ejianc.business.cost.mapper.CostClosingForecastMapper;
import com.ejianc.business.cost.mapper.CostClosingMapper;
import com.ejianc.business.cost.vo.CostClosingVO;
import com.ejianc.business.cost.vo.ForecastContractDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.CostClosingForecastEntity;
import com.ejianc.business.cost.service.ICostClosingForecastService;
import com.ejianc.business.cost.vo.CostClosingForecastVO;

/**
 * 成本关门预估
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("costClosingForecast")
public class CostClosingForecastController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "COST_CLOSING_FORECAST";//此处需要根据实际修改

    @Autowired
    private ICostClosingForecastService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private CostClosingForecastMapper baseMapper;

    @Autowired
    private CostClosingMapper costClosingMapper;

    @Autowired
    private CostClosingChangesMapper costClosingChangesMapper;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CostClosingForecastVO> saveOrUpdate(@RequestBody CostClosingForecastVO saveOrUpdateVO) {
        Long projectId = saveOrUpdateVO.getProjectId();
//        Integer count = this.baseMapper.countClosing(projectId);
//        if(count == 0){
//            throw new BusinessException("未查询到该项目对应的过审的成本关门通知单，请先制单并过审！");
//        }
//        Integer countchange = this.baseMapper.countClosingchange(projectId);
//        if(count != 0){
//            throw new BusinessException("该项目下存在未过审的成本关门通知变更单，请先制单并过审！");
//        }
//        CostClosingEntity costClosing = costClosingMapper.queryByprojectId(projectId);
//        if(costClosing != null){
////            Date starttime = costClosing.getCompletionTime();//获取预估单完工日期
//            Date endtime = costClosing.getCostClosingTime();//获取成本关门期限
//            Date now = new Date();
//            if(now.compareTo(endtime) == 1){
//                throw new BusinessException("当前项目已不在成本关门期限内，无法制单，如需制单请变更成本关门通知单！");
//            }
//        }

        CommonResponse<CostClosingForecastVO> response = service.insertOrUpdate(saveOrUpdateVO);
    	return response;
    }

    @RequestMapping(value = "/checkmakedata", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkmakedata(@RequestParam(value = "projectId") Long projectId) {
        Integer count = this.baseMapper.countClosing(projectId);
        if(count == 0){
            throw new BusinessException("未查询到该项目对应的过审或提交的成本关门通知单！");
        }
        Integer countchange = this.baseMapper.countClosingchange(projectId);
        if(countchange != 0){
            throw new BusinessException("该项目下存在未过审或未提交的成本关门通知变更单！");
        }
        CostClosingEntity costClosing = costClosingMapper.queryByprojectId(projectId);
        if(costClosing != null){
//            Date starttime = costClosing.getCompletionTime();//获取预估单完工日期
            Date endtime = costClosing.getCostClosingTime();//获取成本关门期限
            Date now = new Date();
            if(now.compareTo(endtime) == 1){
                throw new BusinessException("当前项目已不在成本关门期限内，无法制单，如需制单请变更成本关门通知单！");
            }
        }
        String message = "校验成功，允许录入！";
        return CommonResponse.success(message);
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostClosingForecastVO> queryDetail(Long id) {
    	CostClosingForecastEntity entity = this.baseMapper.selectById(id);
    	CostClosingForecastVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetailMobile 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetailMobile", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostClosingForecastVO> queryDetailMobile(Long id) {
        CostClosingForecastVO vo = service.queryDetailMobile(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CostClosingForecastVO> vos) {
//        service.removeByIds(vos.stream().map(CostClosingForecastVO::getId).collect(Collectors.toList()),true);
        service.deleteDatas(vos);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CostClosingForecastVO>> queryList(@RequestBody QueryParam param,Long id) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("deptName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

//        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        UserContext userContextCache =sessionManager.getUserContext();
//        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//        String authOrgIds = userContextCache.getAuthOrgIds();
//        List<OrgVO> orgVOList = null;
//        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        }else {//pc端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
//        }
//        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        param.getParams().put("org_id", new Parameter("in", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<CostClosingForecastEntity> page = service.queryPage(param,false);
        IPage<CostClosingForecastVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CostClosingForecastVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<CostClosingForecastEntity> list= service.queryPage(param,false);
        List<CostClosingForecastVO> volist = new ArrayList<>();
        if(null!=list.getRecords()&&CollectionUtils.isNotEmpty(list.getRecords())){
            volist = BeanMapper.mapList(list.getRecords(), CostClosingForecastVO.class);
            volist.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", volist);
        ExcelExport.getInstance().export("CostClosingForecast-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCostClosingForecastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CostClosingForecastVO>> refCostClosingForecastData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CostClosingForecastEntity> page = service.queryPage(param,false);
        IPage<CostClosingForecastVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CostClosingForecastVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostClosingForecastVO> queryDetailRecord(Long id) {
        CostClosingForecastVO vo = service.queryDetailRecord(id);
        return CommonResponse.success("查询记录数据成功！",vo);
    }


    @RequestMapping(value = "/queryMoney", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> queryMoney(@RequestParam(value = "projectId") Long projectId) {
        Map<String,Object> map = service.queryMoney(projectId);
        return CommonResponse.success("查询记录数据成功！",map);
    }

    @RequestMapping(value = "/querypayreim",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> querypayreim(@RequestParam(value = "projectId") Long projectId){
        BigDecimal ljfk = baseMapper.ljfk(projectId);
        return CommonResponse.success("查询成功",ljfk);
    }

    @RequestMapping(value = "/addProjectCheck", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> addProjectCheck(@RequestParam(value = "projectId") Long projectId,@RequestParam(required = false,value = "id") Long id) {
        String message = service.addProjectCheck(projectId,id);
        return CommonResponse.success(message);
    }

    @RequestMapping(value = "/checkContractAndSettlement", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkContractAndSettlement(@RequestParam(value = "projectId") Long projectId) {
        String message = service.checkContractAndSettlement(projectId);
        return CommonResponse.success(message);
    }

    @RequestMapping(value = "/checkchange", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkchange(@RequestParam(value = "id") Long id) {
        String message = service.checkchange(id);
        return CommonResponse.success(message);
    }

}
