package com.ejianc.business.cost.mapper;

import com.ejianc.business.cost.bean.CostClosingLastEntity;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.cost.bean.CostClosingForecastEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 成本关门预估
 *
 * @author generator
 *
 */
@Mapper
public interface CostClosingForecastMapper extends BaseCrudMapper<CostClosingForecastEntity> {

    @Select("select ROUND(IFNULL(SUM(change_sub), 0),2) from ejc_cost_closing_forecast_change where source_forecast_id = #{id} and dr = '0'")
    BigDecimal querychangesub(@Param("id") Long id);
    @Select("select ROUND(IFNULL(SUM(change_sub_notax), 0),2) from ejc_cost_closing_forecast_change where source_forecast_id = #{id} and dr = '0'")
    BigDecimal querychangesubnotax(@Param("id") Long id);
    @Select("select ROUND(IFNULL(SUM(change_sub_tax), 0),2) from ejc_cost_closing_forecast_change where source_forecast_id = #{id} and dr = '0'")
    BigDecimal querychangesubtax(@Param("id") Long id);
    @Select("select ROUND(IFNULL(SUM(change_other), 0),2) from ejc_cost_closing_forecast_change where source_forecast_id = #{id} and dr = '0'")
    BigDecimal querychangeother(@Param("id") Long id);
    @Select("select ROUND(IFNULL(SUM(change_other_notax), 0),2) from ejc_cost_closing_forecast_change where source_forecast_id = #{id} and dr = '0'")
    BigDecimal querychangeothernotax(@Param("id") Long id);
    @Select("select ROUND(IFNULL(SUM(change_other_tax), 0),2) from ejc_cost_closing_forecast_change where source_forecast_id = #{id} and dr = '0'")
    BigDecimal querychangeothertax(@Param("id") Long id);

    List<Long> queryIds(@Param("projectId") String projectId);

    @Select("select count(id) from ejc_cost_closing where dr = '0' and bill_state IN (1, 3) and project_id = #{projectId}")
    Integer countClosing(@Param("projectId") Long projectId);

    BigDecimal subnotax(@Param("projectId") Long projectId);

    BigDecimal othnotax(@Param("projectId") Long projectId);

    BigDecimal othchangenotax(@Param("projectId") Long projectId);

    @Select("select IFNULL((select Round(IFNULL(target_rate,0),2) from ejc_cost_target_liability where dr = '0' and project_id = #{projectId}),0)")
    BigDecimal querylrl(@Param("projectId")Long projectId);

    BigDecimal subsettle(@Param("projectId") Long projectId);

    BigDecimal materialsettle(@Param("projectId") Long projectId);

    BigDecimal machinesettle(@Param("projectId") Long projectId);

    BigDecimal othersettle(@Param("projectId") Long projectId);

    BigDecimal finsubsettle(@Param("projectId") Long projectId);

    BigDecimal finmaterialsettle(@Param("projectId") Long projectId);

    BigDecimal finmachinesettle(@Param("projectId") Long projectId);

    BigDecimal finothersettle(@Param("projectId") Long projectId);

    @Select("select IFNULL((select Round(IFNULL(ectld.detail_mny,0),2) from ejc_cost_target_liability ectl " +
            "LEFT JOIN ejc_cost_target_liability_detail ectld ON ectld.target_liability_id = ectl.id where ectl.dr = '0' and ectld.dr ='0' and ectld.detail_mny = '4' " +
            "and ectl.project_id = #{projectId}),0)")
    BigDecimal queryqblrl(@Param("projectId") Long projectId);


    @Select("select IFNULL((select Round(IFNULL(ectld.detail_mny,0),2) from ejc_cost_target_liability ectl " +
            "LEFT JOIN ejc_cost_target_liability_detail ectld ON ectld.target_liability_id = ectl.id where ectl.dr = '0' and ectld.dr ='0' and ectld.detail_mny = '6' " +
            "and ectl.project_id = #{projectId}),0)")
    BigDecimal querytzlrl(@Param("projectId") Long projectId);

    @Select("select * from ejc_cost_closing_forecast where dr = '0'")
    List<CostClosingForecastEntity> revenueExpenditureSummary();

    @Select("select project_status from `ejc-market`.ejc_market_project where id = #{projectId}")
    String getprojectstatus(@Param("projectId") Long project);

    CostClosingLastEntity querysubcontract(@Param("projectId") Long project);

    BigDecimal subchangenotax(@Param("projectId") Long projectId);

    BigDecimal materialchangenotax(@Param("projectId") Long project);

    BigDecimal machinechangesettle(@Param("projectId") Long project);

    BigDecimal otherchangesettle(@Param("projectId") Long project);

    BigDecimal subchangenotaxset(@Param("projectId") Long project);

    Map<String, Object> queryMoney(@Param("projectId") Long projectId);

    List<Map<String, String>> querySub(@Param("projectId") Long projectId);

    List<Map<String, String>> queryRmat(@Param("projectId") Long projectId);

    List<Map<String, String>> queryMaterial(@Param("projectId") Long projectId);

    List<Map<String, String>> querySebeicg(@Param("projectId") Long projectId);

    List<Map<String, String>> querySebeizl(@Param("projectId") Long projectId);

    List<Map<String, String>> queryOther(@Param("projectId") Long projectId);

    List<Map<String, String>> queryReimburse(@Param("projectId") Long projectId);

    Map<String, Object> querySumSettleTaxMny(@Param("projectId") Long projectId);

    BigDecimal ljfk(@Param("projectId") Long projectId);

    BigDecimal getPayreim(@Param("projectId") Long projectId);

    List<Map<String, String>> querySubbcbg(@Param("projectId") Long projectId);

    List<Map<String, String>> querybcbgRmat(@Param("projectId") Long projectId);

    List<Map<String, String>> queryMaterialbcbg(@Param("projectId") Long projectId);

    List<Map<String, String>> querySebeicgbcbg(@Param("projectId") Long projectId);

    List<Map<String, String>> querySebeizlbcbg(@Param("projectId") Long projectId);

    List<Map<String, String>> queryOtherbcbg(@Param("projectId") Long projectId);

    List<Map<String, String>> querySubsettle(@Param("projectId") Long projectId);

    @Select("select count(id) from ejc_cost_closing_changes where dr = '0' and bill_state not IN (1, 3) and project_id = #{projectId}")
    Integer countClosingchange(@Param("projectId") Long projectId);

    @Select("select count(id) from ejc_cost_closing_forecast where dr = '0' and project_id = #{projectId}")
    Integer queryByProject(@Param("projectId") Long projectId);

    @Select("select * from ejc_cost_closing_forecast where dr = '0' and project_id = #{projectId}")
    CostClosingForecastEntity selectsourceByProject(@Param("projectId")Long projectId);

    Integer querytotal(@Param("projectId") Long projectId,@Param("id") Long id);

    @Select("select count(id) from ejc_cost_fin_cost_summary_reporting where dr = '0' and project_id = #{projectId}")
    Integer querysumtotal(@Param("projectId") Long projectId);

    @Select("select count(id) from ejc_cost_closing_forecast_change where dr = '0' and source_forecast_id = #{id} and bill_state NOT IN (1,3)")
    Integer querychange(@Param("id") Long id);


//    Integer queryold(@Param("subjectId") Long subjectId,@Param("projectId") Long projectId);
}
