package com.ejianc.business.cost.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.cost.bean.*;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 合同成本关门预估变更控制明细
 *
 * @author generator
 *
 */
@Mapper
public interface ForecastContractDetailChangeMapper extends BaseCrudMapper<ForecastContractDetailChangeEntity> {

    List<ForecastContractDetailChangeEntity> queryByForecastId(Long id);

    List<ForecastChangeMaterialcontractDetailEntity> querySubContractByProjectIdMaterial(@Param("projectId") String projectId);

    List<ForecastChangeMachinecontractDetailEntity> querySubContractByProjectIdMachine(@Param("projectId") String projectId);

    List<ForecastChangeOthercontractDetailEntity> querySubContractByProjectIdOther(@Param("projectId") String projectId);

    @Select("select efcdc.* from ejc_forecast_contract_detail_change efcdc LEFT JOIN ejc_cost_closing_forecast_change eccfc ON eccfc.id = efcdc.cost_change_forecast_id " +
            "where efcdc.dr = '0' AND eccfc.dr = '0' AND eccfc.id = #{id} AND efcdc.contract_type = '劳务分包'")
    List<ForecastContractDetailChangeEntity> querySubContractByProjectIdLW(Long id);

    @Select("select efcdc.* from ejc_forecast_contract_detail_change efcdc LEFT JOIN ejc_cost_closing_forecast_change eccfc ON eccfc.id = efcdc.cost_change_forecast_id " +
            "where efcdc.dr = '0' AND eccfc.dr = '0' AND eccfc.id = #{id} AND efcdc.contract_type = '专业分包'")
    List<ForecastContractDetailChangeEntity> querySubContractByProjectIdZY(Long sumId);

    @Select("SELECT efcdc.*  FROM ejc_forecast_change_materialcontract_detail efcdc LEFT JOIN ejc_cost_closing_forecast_change eccfc ON eccfc.id = efcdc.cost_change_forecast_id " +
            "WHERE efcdc.dr = '0'  AND eccfc.dr = '0'  AND eccfc.id = #{id}")
    List<ForecastChangeMaterialcontractDetailEntity> queryMaterialdetail(Long sumId);

    @Select("SELECT efcdc.*  FROM ejc_forecast_change_machinecontract_detail efcdc LEFT JOIN ejc_cost_closing_forecast_change eccfc ON eccfc.id = efcdc.cost_change_forecast_id " +
            "WHERE efcdc.dr = '0'  AND eccfc.dr = '0'  AND eccfc.id = #{id}")
    List<ForecastChangeMachinecontractDetailEntity> queryMachinedetail(Long sumId);

    @Select("SELECT efcdc.*  FROM ejc_forecast_change_othercontract_detail efcdc LEFT JOIN ejc_cost_closing_forecast_change eccfc ON eccfc.id = efcdc.cost_change_forecast_id " +
            "WHERE efcdc.dr = '0'  AND eccfc.dr = '0'  AND eccfc.id = #{id}")
    List<ForecastChangeOthercontractDetailEntity> queryOtherdetail(Long sumId);

    @Select("SELECT efcdc.*  FROM ejc_forecast_other_detail_change efcdc LEFT JOIN ejc_cost_closing_forecast_change eccfc ON eccfc.id = efcdc.cost_change_forecast_id " +
            "WHERE efcdc.dr = '0'  AND eccfc.dr = '0'  AND eccfc.id = #{id}")
    List<ForecastOtherDetailChangeEntity> querySubjectByProjectId(Long sumId);

    List<ForecastContractDetailChangeEntity> querySubContractByProjectIdLWALL(@Param("projectId") Long projectId);

    @Select("SELECT efcdc.*  FROM ejc_forecast_change_materialcontract_detail efcdc LEFT JOIN ejc_cost_closing_forecast_change eccfc ON eccfc.id = efcdc.cost_change_forecast_id " +
            "WHERE efcdc.dr = '0'  AND eccfc.dr = '0'  AND eccfc.project_id = #{projectId} ORDER BY eccfc.create_time DESC LIMIT 1")
    List<ForecastChangeMaterialcontractDetailEntity> queryMaterialdetailALL(@Param("projectId") Long projectId);

    @Select("SELECT efcdc.*  FROM ejc_forecast_change_machinecontract_detail efcdc LEFT JOIN ejc_cost_closing_forecast_change eccfc ON eccfc.id = efcdc.cost_change_forecast_id " +
            "WHERE efcdc.dr = '0'  AND eccfc.dr = '0'  AND eccfc.project_id = #{projectId} ORDER BY eccfc.create_time DESC LIMIT 1")
    List<ForecastChangeMachinecontractDetailEntity> queryMachinedetailALL(@Param("projectId") Long projectId);

    @Select("SELECT efcdc.*  FROM ejc_forecast_change_othercontract_detail efcdc LEFT JOIN ejc_cost_closing_forecast_change eccfc ON eccfc.id = efcdc.cost_change_forecast_id " +
            "WHERE efcdc.dr = '0'  AND eccfc.dr = '0'  AND eccfc.project_id = #{projectId} ORDER BY eccfc.create_time DESC LIMIT 1")
    List<ForecastChangeOthercontractDetailEntity> queryOtherdetailALL(@Param("projectId") Long projectId);

    List<ForecastContractDetailChangeEntity> querySubContractByProjectIdZYALL(@Param("projectId") Long projectId);

    List<ForecastOtherDetailChangeEntity> querySubjectByProjectIdALL(@Param("projectId") Long projectId);
}



