package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 已完未结成本
 * 
 * @author generator
 * 
 */
 @TableName("ejc_cost_unfinish")
public class UnfinishEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="bill_date")
    private Date billDate; // 制单日期
    @TableField(value="unfinish_mny")
    private BigDecimal unfinishMny; // 不含税金额
    @TableField(value="unfinish_tax_mny")
    private BigDecimal unfinishTaxMny; // 含税金额
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 税金
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="settlement_status")
    private String settlementStatus; // 结算状态

    @TableField(exist=false)
    @SubEntity(serviceName="unfinishDetailService",pidName = "unfinishId")
    private List<UnfinishDetailEntity> unfinishDetailList = new ArrayList<>(); // 已完未结-清单
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public BigDecimal getUnfinishMny() {
        return unfinishMny;
    }

    public void setUnfinishMny(BigDecimal unfinishMny) {
        this.unfinishMny = unfinishMny;
    }
    public BigDecimal getUnfinishTaxMny() {
        return unfinishTaxMny;
    }

    public void setUnfinishTaxMny(BigDecimal unfinishTaxMny) {
        this.unfinishTaxMny = unfinishTaxMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getSettlementStatus() {
        return settlementStatus;
    }

    public void setSettlementStatus(String settlementStatus) {
        this.settlementStatus = settlementStatus;
    }

    public List<UnfinishDetailEntity> getUnfinishDetailList() {
        return unfinishDetailList;
    }

    public void setUnfinishDetailList(List<UnfinishDetailEntity> unfinishDetailList) {
        this.unfinishDetailList = unfinishDetailList;
    }
}
