package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.ejianc.business.cost.bean.CostClosingEntity;
import com.ejianc.business.cost.mapper.CostFinCostSummaryReportingMapper;
import com.ejianc.business.cost.service.ICostClosingLastChangeService;
import com.ejianc.business.cost.service.ICostClosingLastService;
import com.ejianc.business.cost.service.ICostFinOtherDetailService;
import com.ejianc.business.cost.vo.CostClosingForecastVO;
import com.ejianc.business.cost.vo.CostClosingVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.CostFinCostSummaryReportingEntity;
import com.ejianc.business.cost.service.ICostFinCostSummaryReportingService;
import com.ejianc.business.cost.vo.CostFinCostSummaryReportingVO;

/**
 * 最终成本关门上报汇总
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("costFinCostSummaryReporting")
public class CostFinCostSummaryReportingController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ICostFinCostSummaryReportingService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private CostFinCostSummaryReportingMapper baseMapper;

    @Autowired
    private ICostFinOtherDetailService costFinOtherDetailService;

    @Autowired
    private ICostClosingLastService costClosingLastService;

    @Autowired
    private ICostClosingLastChangeService costClosingLastChangeService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CostFinCostSummaryReportingVO> saveOrUpdate(@RequestBody CostFinCostSummaryReportingVO saveOrUpdateVO) {
//        Long projectId = saveOrUpdateVO.getProjectId();
//        Integer count = this.baseMapper.countClosing(projectId);
//        if(count == 0){
//            throw new BusinessException("未查询到该项目对应的过审的最终成本关门通知单，请先制单并过审！");
//        }
        CommonResponse<CostFinCostSummaryReportingVO> response = service.insertOrUpdate(saveOrUpdateVO);
        return response;
    }

    @RequestMapping(value = "/checkmakedata", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkmakedata(@RequestParam(value = "projectId") Long projectId) {
        Integer count = this.baseMapper.countClosing(projectId);
        if(count == 0){
            throw new BusinessException("未查询到该项目对应的过审的最终成本关门通知单，请先制单并过审！");
        }
        Integer countchange = this.baseMapper.countClosingChange(projectId);
        if(count == 0){
            throw new BusinessException("未查询到该项目对应的过审的最终成本关门通知单，请先制单并过审！");
        }
        String message = "校验成功，允许录入！";
        return CommonResponse.success(message);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostFinCostSummaryReportingVO> queryDetail(Long id) {
    	CostFinCostSummaryReportingEntity entity = this.baseMapper.selectById(id);
    	CostFinCostSummaryReportingVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CostFinCostSummaryReportingVO> vos) {
        service.deleteDatas(vos);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CostFinCostSummaryReportingVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

//        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        UserContext userContextCache =sessionManager.getUserContext();
//        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//        String authOrgIds = userContextCache.getAuthOrgIds();
//        List<OrgVO> orgVOList = null;
//        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        }else {//pc端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
//        }
//        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        param.getParams().put("org_id", new Parameter("in", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<CostFinCostSummaryReportingEntity> page = service.queryPage(param,false);
        IPage<CostFinCostSummaryReportingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CostFinCostSummaryReportingVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
//        List<CostFinCostSummaryReportingEntity> list = service.queryList(param);
//        //todo:字段翻译等等
//        Map<String, Object> beans = new HashMap<>();
//        beans.put("records", list);
        IPage<CostFinCostSummaryReportingEntity> list= service.queryPage(param,false);
        List<CostFinCostSummaryReportingVO> volist = new ArrayList<>();
        if(null!=list.getRecords()&&CollectionUtils.isNotEmpty(list.getRecords())){
            volist = BeanMapper.mapList(list.getRecords(), CostFinCostSummaryReportingVO.class);
            volist.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", volist);
        ExcelExport.getInstance().export("CostFinCostSummaryReporting-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCostFinCostSummaryReportingData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CostFinCostSummaryReportingVO>> refCostFinCostSummaryReportingData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CostFinCostSummaryReportingEntity> page = service.queryPage(param,false);
        IPage<CostFinCostSummaryReportingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CostFinCostSummaryReportingVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/queryAccumulateProfitMargin", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> queryAccumulateProfitMargin(@RequestParam(value = "projectId") Long projectId) {
        Map<String,Object> map = service.queryAccumulateProfitMargin(projectId);
        return CommonResponse.success("查询记录数据成功！",map);
    }

    @RequestMapping(value = "/checkContractAndSettlement", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkContractAndSettlement(@RequestParam(value = "projectId") Long projectId) {
        String message = service.checkContractAndSettlement(projectId);
        return CommonResponse.success(message);
    }

    @RequestMapping(value = "/addProjectCheck", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> addProjectCheck(@RequestParam(value = "projectId") Long projectId,@RequestParam(value = "id") Long id) {
        String message = service.addProjectCheck(projectId,id);
        return CommonResponse.success(message);
    }

    /**
     * @Description querySubContractAmount 查询分包合同成本汇总金额
     * @param id
     */
    @RequestMapping(value = "/querySubContractAmount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostFinCostSummaryReportingVO> querySubContractAmount(@RequestParam(value = "projectId") Long projectId) {
        CostFinCostSummaryReportingEntity subcontractList = service.querySubContractByProjectId(projectId);//分包合同汇总
        CostFinCostSummaryReportingEntity matcontractList = service.querySubContractByProjectIdMaterial(projectId);//物资合同汇总
        CostFinCostSummaryReportingEntity maccontractList = service.querySubContractByProjectIdMachine(projectId);//机械合同汇总
        CostFinCostSummaryReportingEntity othcontractList = service.querySubContractByProjectIdOther(projectId);//其他合同汇总
        BigDecimal subam = BigDecimal.ZERO;
        BigDecimal subamnt = BigDecimal.ZERO;
        BigDecimal subamt = BigDecimal.ZERO;
        BigDecimal matam = BigDecimal.ZERO;
        BigDecimal matamnt = BigDecimal.ZERO;
        BigDecimal matamt = BigDecimal.ZERO;
        BigDecimal macam = BigDecimal.ZERO;
        BigDecimal macamnt = BigDecimal.ZERO;
        BigDecimal macamt = BigDecimal.ZERO;
        BigDecimal otham = BigDecimal.ZERO;
        BigDecimal othamnt = BigDecimal.ZERO;
        BigDecimal othamt = BigDecimal.ZERO;
        if(subcontractList != null){
            subam = subcontractList.getSubconsum();
            subamnt = subcontractList.getSubconsumnotax();
            subamt = subcontractList.getSubconsumtax();
        }
        if(matcontractList != null){
            matam = matcontractList.getSubconsum();
            matamnt = matcontractList.getSubconsumnotax();
            matamt = matcontractList.getSubconsumtax();
        }
        if(maccontractList != null){
            macam = maccontractList.getSubconsum();
            macamnt = maccontractList.getSubconsumnotax();
            macamt = maccontractList.getSubconsumtax();
        }
        if(othcontractList != null){
            otham = othcontractList.getSubconsum();
            othamnt = othcontractList.getSubconsumnotax();
            othamt = othcontractList.getSubconsumtax();
        }

        BigDecimal othersum = costFinOtherDetailService.subamount(String.valueOf(projectId));//其他汇总含税

        Integer countlastchange = costClosingLastChangeService.countByProject(projectId);
        BigDecimal lastnotax = BigDecimal.ZERO;
        if(countlastchange == 0){
            lastnotax = costClosingLastService.selectAmountNotaxByProjectId(projectId);//最终成本关门通知单 最终审定产值不含税
        }else{
            lastnotax = costClosingLastChangeService.selectAmountNotaxByProjectId(projectId);//最终成本关门通知单变更 最终审定产值不含税
        }


        CostFinCostSummaryReportingVO vo = new CostFinCostSummaryReportingVO();
        vo.setProjectId(projectId);
        BigDecimal subconsum = subam.add(matam.add(macam.add(otham)));
        vo.setSubconsum(subconsum);
        BigDecimal subconsumnotax = subamnt.add(matamnt.add(macamnt.add(othamnt)));
        vo.setSubconsumnotax(subconsumnotax);
        BigDecimal subconsumtax = subamt.add(matamt.add(macamt.add(othamt)));
        vo.setSubconsumtax(subconsumtax);
        BigDecimal amount = subconsumnotax.add(othersum);//实际成本
        BigDecimal lastamount = lastnotax.subtract(amount);//最终结算值不含税-实际成本（不含税合同+其他成本含税）
        BigDecimal bai = new BigDecimal("100");

        vo.setAccumulateProfitMargin(lastnotax.divide(lastamount,4, BigDecimal.ROUND_HALF_EVEN).multiply(bai));

        return CommonResponse.success("查询详情数据成功！",vo);
    }

}
