package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.ejianc.business.cost.mapper.ForecastOtherDetailMapper;
import com.ejianc.business.cost.vo.CostClosingChangesVO;
import com.ejianc.business.cost.vo.CostClosingForecastVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.ForecastOtherDetailEntity;
import com.ejianc.business.cost.service.IForecastOtherDetailService;
import com.ejianc.business.cost.vo.ForecastOtherDetailVO;

/**
 * 其他预估成本关门控制明细
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("forecastOtherDetail")
public class ForecastOtherDetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IForecastOtherDetailService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ForecastOtherDetailMapper forecastOtherDetailMapper;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ForecastOtherDetailVO> saveOrUpdate(@RequestBody ForecastOtherDetailVO saveOrUpdateVO) {
    	ForecastOtherDetailEntity entity = BeanMapper.map(saveOrUpdateVO, ForecastOtherDetailEntity.class);
    	service.saveOrUpdate(entity, false);
    	ForecastOtherDetailVO vo = BeanMapper.map(entity, ForecastOtherDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ForecastOtherDetailVO> queryDetail(Long id) {
    	ForecastOtherDetailEntity entity = service.selectById(id);
    	ForecastOtherDetailVO vo = BeanMapper.map(entity, ForecastOtherDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ForecastOtherDetailVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ForecastOtherDetailVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ForecastOtherDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ForecastOtherDetailVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ForecastOtherDetailEntity> page = service.queryPage(param,false);
        IPage<ForecastOtherDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ForecastOtherDetailVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<ForecastOtherDetailEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ForecastOtherDetail-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refForecastOtherDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ForecastOtherDetailVO>> refForecastOtherDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ForecastOtherDetailEntity> page = service.queryPage(param,false);
        IPage<ForecastOtherDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ForecastOtherDetailVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * 其他费用类保存验重方法
     */
    @RequestMapping(value = "/queryotherdatas", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryotherdatas (@RequestBody CostClosingForecastVO vo){
        if(vo != null){
            Long projectId = vo.getProjectId();
            List<ForecastOtherDetailVO> forecastOtherDetailEntity = vo.getForecastOtherDetailList();
            Integer details = vo.getForecastOtherDetailList().size();
            if(details != 0){
                for(ForecastOtherDetailVO forecastOtherDetailVO : forecastOtherDetailEntity){
                    Long subjectId = forecastOtherDetailVO.getSubjectId();
                    Integer olddatas = forecastOtherDetailMapper.queryOlddatas(projectId,subjectId);
                    if(olddatas != 0){
                        return CommonResponse.error("当前项目已有其他费用预估单！");
                    }else{
                        return CommonResponse.success("允许保存！");
                    }
                }
            }
        }
        return CommonResponse.success("允许保存！");
    }
}
