package com.ejianc.business.cost.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.cost.bean.CostClosingChangesEntity;
import com.ejianc.business.cost.bean.CostClosingEntity;
import com.ejianc.business.cost.bean.CostClosingLastEntity;
import com.ejianc.business.cost.mapper.CostClosingLastMapper;
import com.ejianc.business.cost.service.ICostClosingLastService;
import com.ejianc.business.cost.vo.CostClosingChangesVO;
import com.ejianc.business.cost.vo.CostClosingLastChangeVO;
import com.ejianc.business.cost.vo.CostClosingLastVO;
import com.ejianc.business.cost.vo.CostClosingVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.CostClosingLastChangeMapper;
import com.ejianc.business.cost.bean.CostClosingLastChangeEntity;
import com.ejianc.business.cost.service.ICostClosingLastChangeService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 最终成本关门通知变更
 *
 * @author generator
 *
 */
@Service("costClosingLastChangeService")
public class CostClosingLastChangeServiceImpl extends BaseServiceImpl<CostClosingLastChangeMapper, CostClosingLastChangeEntity> implements ICostClosingLastChangeService{

    private static final String BILL_CODE_ROLE = "COST_CLOSING_LAST_CHANGE";//此处需要根据实际修改

    @Autowired
    private CostClosingLastMapper costClosingLastMapper;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private CostClosingLastChangeMapper costClosingLastChangeMapper;

    @Autowired
    private ICostClosingLastService costClosingLastService;

    @Override
    public CostClosingLastChangeVO queryDetailChange(Long id) {
        CostClosingLastEntity costClosingLastEntity = costClosingLastMapper.selectById(id);
        if (!ObjectUtil.isEmpty(costClosingLastEntity)){
            CostClosingLastChangeVO contractVo = BeanMapper.map(costClosingLastEntity, CostClosingLastChangeVO.class);
            contractVo.setOldlastCostClosingTime(costClosingLastEntity.getLastCostClosingTime());
            contractVo.setLastCostClosingTime(costClosingLastEntity.getLastCostClosingTime());
            contractVo.setClosingLastId(costClosingLastEntity.getId());
            contractVo.setId(null);
            contractVo.setBillState(null);
            contractVo.setCreateUserCode(null);
            contractVo.setCreateTime(null);
            contractVo.setUpdateUserCode(null);
            contractVo.setUpdateTime(null);
            contractVo.setMemo(null);
            contractVo.setDays("0");
            return contractVo;
        }
        return null;
    }

    @Override
    public CommonResponse<CostClosingLastChangeVO> saveOrUpdate(CostClosingLastChangeVO saveOrUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        CostClosingLastChangeEntity entity = null;
        String operateType = null;
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) { //修改
            if (StringUtils.isEmpty(saveOrUpdateVO.getBillCode())) {
                saveOrUpdateVO.setBillCode(null);
            }
            entity = BeanMapper.map(saveOrUpdateVO, CostClosingLastChangeEntity.class);
            operateType = "edit";
        } else {
            if (null == saveOrUpdateVO.getChangeVersion() || saveOrUpdateVO.getChangeVersion() == 0) {
                saveOrUpdateVO.setChangeVersion(1);//第一次变更
            } else {
                saveOrUpdateVO.setChangeVersion(saveOrUpdateVO.getChangeVersion() + 1);//版本号+1
            }
            if (2 == saveOrUpdateVO.getChangeStatus()) {
                throw new BusinessException("成本关门通知单存在变更中单据，不允许保存!");
            }
            //新增
            if (StringUtils.isEmpty(saveOrUpdateVO.getBillCode())) {
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE_ROLE, tenantId);
                if (billCode.isSuccess()) {
                    saveOrUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }

            entity = BeanMapper.map(saveOrUpdateVO, CostClosingLastChangeEntity.class);

            operateType = "add";
        }

        super.saveOrUpdate(entity);

        //回写主表
        LambdaUpdateWrapper<CostClosingLastEntity> updateWrapper = new LambdaUpdateWrapper<>();

        Long sourceId = entity.getClosingLastId();
        CostClosingLastEntity source = costClosingLastService.selectById(sourceId);//获取原单数据
        Date oldtime = source.getOldCostClosingTime();
        if(oldtime == null){
            updateWrapper.set(CostClosingLastEntity::getOldCostClosingTime, entity.getOldlastCostClosingTime());//原变更时间
        }


        updateWrapper.set(CostClosingLastEntity::getLastCostClosingTime, saveOrUpdateVO.getLastCostClosingTime());
        updateWrapper.set(CostClosingLastEntity::getChangeId, entity.getId());//变更主键
        updateWrapper.set(CostClosingLastEntity::getDays, saveOrUpdateVO.getDays());
        updateWrapper.set(CostClosingLastEntity::getChangeStatus, 3);//状态：已变更
        updateWrapper.set(CostClosingLastEntity::getChangeCode, entity.getBillCode());//变更编码
        updateWrapper.eq(CostClosingLastEntity::getId, entity.getClosingLastId());

        costClosingLastService.update(updateWrapper);

        CostClosingLastChangeEntity costClosingLastChangeEntity = super.selectById(entity.getId());
        CostClosingLastChangeVO vo = BeanMapper.map(costClosingLastChangeEntity, CostClosingLastChangeVO.class);
        return CommonResponse.success(vo);
    }

    @Override
    public CostClosingLastVO queryDetailRecord(Long id) {
        CostClosingLastEntity costClosingLastEntity = costClosingLastMapper.selectById(id);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("closing_last_id", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("create_time", QueryParam.DESC);
        List<CostClosingLastChangeEntity> purchaseDetailss = super.queryList(queryParam, false);
        List<CostClosingLastChangeVO> costClosingChangesList = BeanMapper.mapList(purchaseDetailss, CostClosingLastChangeVO.class);
        CostClosingLastVO vo = BeanMapper.map(costClosingLastEntity, CostClosingLastVO.class);
        vo.setCostClosingChanges(costClosingChangesList);
        return vo;
    }

    @Override
    public BigDecimal selectAmountNotaxByProjectId(Long projectId) {
        BigDecimal amount = this.baseMapper.notax(projectId);
        return amount;
    }

    @Override
    public Integer countByProject(Long projectId) {
        Integer count = this.baseMapper.countByProject(projectId);
        return count;
    }
}
