package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.mapper.ForecastChangeMachinecontractDetailMapper;
import com.ejianc.business.cost.mapper.ForecastChangeMaterialcontractDetailMapper;
import com.ejianc.business.cost.mapper.ForecastChangeOthercontractDetailMapper;
import com.ejianc.business.cost.vo.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.ForecastContractDetailChangeMapper;
import com.ejianc.business.cost.service.IForecastContractDetailChangeService;

import java.util.List;

/**
 * 合同成本关门预估变更控制明细
 * 
 * @author generator
 * 
 */
@Service("forecastContractDetailChangeService")
public class ForecastContractDetailChangeServiceImpl extends BaseServiceImpl<ForecastContractDetailChangeMapper, ForecastContractDetailChangeEntity> implements IForecastContractDetailChangeService{

    @Autowired
    private ForecastChangeMaterialcontractDetailMapper forecastChangeMaterialcontractDetailMapper;

    @Autowired
    private ForecastChangeMachinecontractDetailMapper forecastChangeMachinecontractDetailMapper;

    @Autowired
    private ForecastChangeOthercontractDetailMapper forecastChangeOthercontractDetailMapper;


    @Override
    public List<ForecastChangeMaterialcontractDetailVO> querySubContractByProjectIdMaterial(String projectId) {
        List<ForecastChangeMaterialcontractDetailEntity> forecastContractDetailEntityList = this.baseMapper.querySubContractByProjectIdMaterial(projectId);
        List<ForecastChangeMaterialcontractDetailVO> forecastContractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, ForecastChangeMaterialcontractDetailVO.class);
        return forecastContractDetailVOS;
    }

    @Override
    public List<ForecastChangeMachinecontractDetailVO> querySubContractByProjectIdMachine(String projectId) {
        List<ForecastChangeMachinecontractDetailEntity> forecastContractDetailEntityList = this.baseMapper.querySubContractByProjectIdMachine(projectId);
        List<ForecastChangeMachinecontractDetailVO> forecastContractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, ForecastChangeMachinecontractDetailVO.class);
        return forecastContractDetailVOS;
    }

    @Override
    public List<ForecastChangeOthercontractDetailVO> querySubContractByProjectIdOther(String projectId) {
        List<ForecastChangeOthercontractDetailEntity> forecastContractDetailEntityList = this.baseMapper.querySubContractByProjectIdOther(projectId);
        List<ForecastChangeOthercontractDetailVO> forecastOthercontractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, ForecastChangeOthercontractDetailVO.class);
        return forecastOthercontractDetailVOS;
    }

    @Override
    public List<ForecastChangeMaterialcontractDetailVO> querySubContractByIdMaterial(Long id) {
        List<ForecastChangeMaterialcontractDetailEntity> forecastContractDetailEntityList = forecastChangeMaterialcontractDetailMapper.querySubContractByIdMaterial(id);
        List<ForecastChangeMaterialcontractDetailVO> forecastContractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, ForecastChangeMaterialcontractDetailVO.class);
        return forecastContractDetailVOS;
    }

    @Override
    public List<ForecastChangeMachinecontractDetailVO> querySubContractByIdMachine(Long id) {
        List<ForecastChangeMachinecontractDetailEntity> forecastContractDetailEntityList = forecastChangeMachinecontractDetailMapper.querySubContractByIdMachine(id);
        List<ForecastChangeMachinecontractDetailVO> forecastContractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, ForecastChangeMachinecontractDetailVO.class);
        return forecastContractDetailVOS;
    }

    @Override
    public List<ForecastChangeOthercontractDetailVO> querySubContractByIdOther(Long id) {
        List<ForecastChangeOthercontractDetailEntity> forecastContractDetailEntityList = forecastChangeOthercontractDetailMapper.querySubContractByIdOther(id);
        List<ForecastChangeOthercontractDetailVO> forecastOthercontractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, ForecastChangeOthercontractDetailVO.class);
        return forecastOthercontractDetailVOS;
    }
}
