package com.ejianc.business.cost.utils;

import java.text.SimpleDateFormat;
import java.util.Date;

public class DateCompareUtil {
    /**
     * 判断date是否在月份month内
     * @param month 年月
     * @param date
     * @return
     */
    public static Boolean isThisMonth(String month, Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String format = sdf.format(date);
        return month.equals(format);
    }

    /**
     * 判断date是否和month同年
     * @param month
     * @param date
     * @return
     */
    public static Boolean isThisYear(String month, Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String format = sdf.format(date);
        return month.indexOf(format) != -1;
    }

}
