/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.ejianc.business.cost.bean.CostCategoryEntity;
import com.ejianc.business.cost.mapper.CostCategoryMapper;
import com.ejianc.business.cost.service.ICostCategoryService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"costCategory"})
public class CostCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ICostCategoryService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private CostCategoryMapper costCategoryMapper;

    @RequestMapping(value={"/type"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> type(@RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getOrderMap().put("code", "asc");
        List<CostCategoryEntity> list = this.costCategoryMapper.queryall();
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (CostCategoryEntity entity : list) {
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("code", entity.getCode());
            map.put("name", entity.getName());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }
}

