/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.TargetLiabilityCostEntity;
import com.ejianc.business.cost.service.ITargetLiabilityCostService;
import com.ejianc.business.cost.vo.TargetLiabilityCostDetailVO;
import com.ejianc.business.cost.vo.TargetLiabilityCostExportVO;
import com.ejianc.business.cost.vo.TargetLiabilityCostVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"targetLiabilityCost"})
public class TargetLiabilityCostController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITargetLiabilityCostService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TargetLiabilityCostVO> saveOrUpdate(@RequestBody TargetLiabilityCostVO saveorUpdateVO) {
        CommonResponse commonResponse = this.checkProjectRepetition(saveorUpdateVO.getId(), saveorUpdateVO.getProjectId());
        if (commonResponse.isSuccess()) {
            return this.service.saveOrUpdate(saveorUpdateVO);
        }
        return commonResponse;
    }

    @RequestMapping(value={"/checkProjectRepetition"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse checkProjectRepetition(Long id, Long projectId) {
        List result;
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        if (id != null && id > 0L) {
            param.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if (CollectionUtils.isEmpty((Collection)(result = this.service.queryList(param)))) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u6b64\u9879\u76ee\u5df2\u5b58\u5728\u76ee\u6807\u8d23\u4efb\u6210\u672c\uff0c\u4e0d\u80fd\u91cd\u590d\u9009\u62e9\u6b64\u9879\u76ee\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TargetLiabilityCostVO> queryDetail(Long id) {
        TargetLiabilityCostVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailTemp"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<TargetLiabilityCostDetailVO>> queryDetailTemp() {
        List<TargetLiabilityCostDetailVO> voList = this.service.queryDetailTemp();
        return CommonResponse.success((String)"\u67e5\u8be2\u6a21\u677f\u6570\u636e\u6210\u529f\uff01", voList);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TargetLiabilityCostVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TargetLiabilityCostVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TargetLiabilityCostVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        ArrayList<TargetLiabilityCostExportVO> exportVOS = new ArrayList<TargetLiabilityCostExportVO>();
        for (TargetLiabilityCostEntity entity : list) {
            TargetLiabilityCostExportVO exportVO = (TargetLiabilityCostExportVO)BeanMapper.map((Object)((Object)entity), TargetLiabilityCostExportVO.class);
            exportVO.setBillState(BillStateEnum.getEnumByStateCode((Integer)entity.getBillState()).getDescription());
            exportVOS.add(exportVO);
        }
        HashMap<String, ArrayList<TargetLiabilityCostExportVO>> beans = new HashMap<String, ArrayList<TargetLiabilityCostExportVO>>();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("TargetLiabilityCost-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refTargetLiabilityCostData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TargetLiabilityCostVO>> refTargetLiabilityCostData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TargetLiabilityCostVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"targetCost-detail-import.xlsx", (String)"\u76ee\u6807\u8d23\u4efb\u6210\u672c\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImport(request, response);
    }
}

