package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.cost.vo.TargetLiabilityCostDetailVO;
import com.ejianc.business.cost.vo.TargetLiabilityCostExportVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import groovy.util.IFileNameFinder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.TargetLiabilityCostEntity;
import com.ejianc.business.cost.service.ITargetLiabilityCostService;
import com.ejianc.business.cost.vo.TargetLiabilityCostVO;

/**
 * 目标责任成本
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("targetLiabilityCost")
public class TargetLiabilityCostController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IOrgApi iOrgApi;


    
    @Autowired
    private ITargetLiabilityCostService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TargetLiabilityCostVO> saveOrUpdate(@RequestBody TargetLiabilityCostVO saveorUpdateVO) {
        CommonResponse commonResponse = this.checkProjectRepetition(saveorUpdateVO.getId(),saveorUpdateVO.getProjectId());
        if (commonResponse.isSuccess()){
            return service.saveOrUpdate(saveorUpdateVO);
        }else{
            return commonResponse;
        }
    }

    /*
    校验项目重复
     */
    @RequestMapping(value = "/checkProjectRepetition", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse checkProjectRepetition(Long id,Long projectId){
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        if (id != null && id > 0){
            param.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<TargetLiabilityCostEntity> result = service.queryList(param);
        if(CollectionUtils.isEmpty(result)){
            return CommonResponse.success();
        }else{
            return CommonResponse.error("此项目已存在目标责任成本，不能重复选择此项目！");
        }
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TargetLiabilityCostVO> queryDetail(Long id) {
        TargetLiabilityCostVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description queryDetailTemp 加载模板
     * @param id
     */
    @RequestMapping(value = "/queryDetailTemp", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<TargetLiabilityCostDetailVO>> queryDetailTemp() {
    	List<TargetLiabilityCostDetailVO> voList=service.queryDetailTemp();
        return CommonResponse.success("查询模板数据成功！",voList);
    }
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TargetLiabilityCostVO> vos) {
        service.removeByIds(vos.stream().map(TargetLiabilityCostVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TargetLiabilityCostVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<TargetLiabilityCostEntity> page = service.queryPage(param,false);
        IPage<TargetLiabilityCostVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TargetLiabilityCostVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));


        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TargetLiabilityCostEntity> list = service.queryList(param);
        List<TargetLiabilityCostExportVO> exportVOS = new ArrayList<>();
        for(TargetLiabilityCostEntity entity:list){
            TargetLiabilityCostExportVO exportVO = BeanMapper.map(entity, TargetLiabilityCostExportVO.class);
            exportVO.setBillState(BillStateEnum.getEnumByStateCode(entity.getBillState()).getDescription());
            exportVOS.add(exportVO);
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("TargetLiabilityCost-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refTargetLiabilityCostData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TargetLiabilityCostVO>> refTargetLiabilityCostData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<TargetLiabilityCostEntity> page = service.queryPage(param,false);
        IPage<TargetLiabilityCostVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TargetLiabilityCostVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "targetCost-detail-import.xlsx", "目标责任成本导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request,response);
    }


}
