/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.CostDetailEntity;
import com.ejianc.business.cost.service.ICostDetailService;
import com.ejianc.business.cost.utils.TreeUtil;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.cost.vo.ProjectSubjectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"costDetail"})
public class CostDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CostDetailVO> saveOrUpdate(@RequestBody CostDetailVO saveorUpdateVO) {
        CostDetailEntity entity = (CostDetailEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, CostDetailEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        CostDetailVO vo = (CostDetailVO)BeanMapper.map((Object)((Object)entity), CostDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CostDetailVO> queryDetail(Long id) {
        CostDetailEntity entity = (CostDetailEntity)((Object)this.service.selectById(id));
        CostDetailVO vo = (CostDetailVO)BeanMapper.map((Object)((Object)entity), CostDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CostDetailVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CostDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CostDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/projectSubjectTree"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> projectSubjectTree(@RequestParam(value="projectId") Long projectId, @RequestParam(value="happenDate") String happenDate) {
        List<Map<String, Object>> list = this.service.projectSubjectTree(projectId, happenDate);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @PostMapping(value={"projectSubjectTreeExport"})
    public void projectSubjectTreeExport(@RequestBody ProjectSubjectVO vo, HttpServletResponse response) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (vo != null && vo.getProjectId() > 0L && StringUtils.isNotBlank((CharSequence)vo.getHappenDate())) {
            list = this.service.projectSubjectTree(vo.getProjectId(), vo.getHappenDate());
        }
        HashMap<String, List<Map<String, Object>>> beans = new HashMap<String, List<Map<String, Object>>>();
        beans.put("records", TreeUtil.treeToList(list));
        ExcelExport.getInstance().export("projectSubjectTreeExport-export.xlsx", beans, response);
    }
}

