/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.bean.TargetLiabilityCostDetailEntity;
import com.ejianc.business.cost.bean.TargetLiabilityCostEntity;
import com.ejianc.business.cost.mapper.TargetLiabilityCostMapper;
import com.ejianc.business.cost.service.ITargetLiabilityCostDetailService;
import com.ejianc.business.cost.service.ITargetLiabilityCostService;
import com.ejianc.business.cost.utils.ExcelImportUtil;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.business.cost.vo.TargetLiabilityCostDetailVO;
import com.ejianc.business.cost.vo.TargetLiabilityCostVO;
import com.ejianc.business.pub.tax.TaxCalculateUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="targetLiabilityCostService")
public class TargetLiabilityCostServiceImpl
extends BaseServiceImpl<TargetLiabilityCostMapper, TargetLiabilityCostEntity>
implements ITargetLiabilityCostService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ITargetLiabilityCostDetailService detailService;
    private static final String BILL_CODE = "Target_Liability_Cost";

    @Override
    public CommonResponse<TargetLiabilityCostVO> saveOrUpdate(TargetLiabilityCostVO saveorUpdateVO) {
        this.validate(saveorUpdateVO);
        TargetLiabilityCostEntity entity = (TargetLiabilityCostEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, TargetLiabilityCostEntity.class));
        if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setDetailList(null);
        this.saveOrUpdate((Object)entity, false);
        List detailsVos = saveorUpdateVO.getDetailList();
        ArrayList<TargetLiabilityCostDetailEntity> saveOrUpldates = new ArrayList<TargetLiabilityCostDetailEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (TargetLiabilityCostDetailVO detailsVo : detailsVos) {
            TargetLiabilityCostDetailEntity detailslist;
            if ("add".equals(detailsVo.getRowState())) {
                detailslist = (TargetLiabilityCostDetailEntity)((Object)BeanMapper.map((Object)detailsVo, TargetLiabilityCostDetailEntity.class));
                detailslist.setTargetLiabilityId(entity.getId());
                detailslist.setId(null);
                saveOrUpldates.add(detailslist);
                continue;
            }
            if ("edit".equals(detailsVo.getRowState())) {
                detailslist = (TargetLiabilityCostDetailEntity)((Object)BeanMapper.map((Object)detailsVo, TargetLiabilityCostDetailEntity.class));
                saveOrUpldates.add(detailslist);
                continue;
            }
            if (!"del".equals(detailsVo.getRowState())) continue;
            deleteIds.add(detailsVo.getId());
        }
        if (saveOrUpldates.size() > 0) {
            this.detailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            BigDecimal noTaxMny = new BigDecimal(0);
            BigDecimal incomeMny = new BigDecimal(0);
            BigDecimal Lr = new BigDecimal(0);
            for (TargetLiabilityCostDetailEntity cdEntity : saveOrUpldates) {
                if ("\u4e0d\u542b\u7a0e\u76ee\u6807\u8d23\u4efb\u6210\u672c".equals(cdEntity.getName())) {
                    BigDecimal bigDecimal = noTaxMny = cdEntity.getDetailMny() != null ? cdEntity.getDetailMny() : new BigDecimal(0);
                }
                if ("\u4e0d\u542b\u7a0e\u6709\u6548\u6536\u5165".equals(cdEntity.getName())) {
                    incomeMny = cdEntity.getDetailMny() != null ? cdEntity.getDetailMny() : new BigDecimal(0);
                }
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (TargetLiabilityCostDetailEntity cdEntity : saveOrUpldates) {
                if (StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
                }
                if (("\u52b3\u52a1\u8d39".equals(cdEntity.getName()) || "\u6750\u6599\u8d39".equals(cdEntity.getName()) || "\u4e3b\u6750\u8d39".equals(cdEntity.getName()) || "\u673a\u68b0\u8d39".equals(cdEntity.getName()) || "\u4e13\u4e1a\u5206\u5305\u5de5\u7a0b\u8d39".equals(cdEntity.getName()) || "\u95f4\u63a5\u8d39".equals(cdEntity.getName())) && noTaxMny.compareTo(new BigDecimal(0)) != 0) {
                    BigDecimal mny = cdEntity.getDetailMny() != null ? cdEntity.getDetailMny() : new BigDecimal(0);
                    BigDecimal scale = mny.multiply(new BigDecimal(100)).divide(noTaxMny, 2, 4);
                    cdEntity.setScale(scale.toString());
                }
                if ("\u9879\u76ee\u76ee\u6807\u5229\u6da6\u989d".equals(cdEntity.getName()) && incomeMny.compareTo(new BigDecimal(0)) != 0) {
                    Lr = incomeMny.subtract(noTaxMny);
                    cdEntity.setDetailMny(Lr);
                }
                if (!"\u9879\u76ee\u76ee\u6807\u5229\u6da6\u7387(\u4e0d\u542b\u7a0e)".equals(cdEntity.getName()) || incomeMny.compareTo(new BigDecimal(0)) == 0) continue;
                cdEntity.setDetailMny(Lr.multiply(new BigDecimal(100)).divide(incomeMny, 2, 4));
                entity.setTargetRate(cdEntity.getDetailMny());
                this.saveOrUpdate((Object)entity, false);
            }
            this.detailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.detailService.removeByIds(deleteIds, false);
        }
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    private void validate(TargetLiabilityCostVO saveorUpdateVO) {
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(TargetLiabilityCostEntity::getBillCode, (Object)saveorUpdateVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            lambda.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            List entities = super.list((Wrapper)lambda);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)entities)) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            lambda.eq(TargetLiabilityCostEntity::getBillCode, (Object)saveorUpdateVO.getBillCode());
            List entities = super.list((Wrapper)lambda);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)entities)) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
    }

    @Override
    public TargetLiabilityCostVO queryDetail(Long id) {
        TargetLiabilityCostEntity entity = (TargetLiabilityCostEntity)((Object)super.selectById((Serializable)id));
        if (entity != null) {
            TargetLiabilityCostVO liabilityCostVO = (TargetLiabilityCostVO)BeanMapper.map((Object)((Object)entity), TargetLiabilityCostVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("targetLiabilityId", new Parameter("eq", (Object)liabilityCostVO.getId()));
            List detailEntityList = this.detailService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
                for (TargetLiabilityCostDetailEntity detailEntity : detailEntityList) {
                    detailEntity.setTid(detailEntity.getId().toString());
                    detailEntity.setTpid(detailEntity.getParentId() != null && detailEntity.getParentId() > 0L ? detailEntity.getParentId().toString() : "");
                    detailEntity.setRowState("edit");
                }
                List resultMapList = BeanMapper.mapList((Iterable)detailEntityList, TargetLiabilityCostDetailVO.class);
                liabilityCostVO.setDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            }
            return liabilityCostVO;
        }
        return null;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<TargetLiabilityCostDetailVO> detailVoList = new ArrayList<TargetLiabilityCostDetailVO>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                TargetLiabilityCostDetailVO vo = new TargetLiabilityCostDetailVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                vo.setDetailIndex(detailIndex);
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }
                } else {
                    vo.setTid(id);
                    vo.setTpid("");
                }
                if (indexMap.containsKey(detailIndex)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(detailIndex) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(detailIndex, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setCode(null);
                    warnType = warnType + "[\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setCode((String)datas.get(1));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setName(null);
                    warnType = warnType + "[\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setName((String)datas.get(2));
                }
                vo.setFeature((String)datas.get(3));
                vo.setUnit((String)datas.get(4));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    vo.setNum(null);
                    warnType = warnType + "[\u5de5\u7a0b\u91cf\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setNum(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        vo.setNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    vo.setDetailTaxRate(null);
                } else {
                    try {
                        vo.setDetailTaxRate(new BigDecimal((String)datas.get(6)));
                    }
                    catch (Exception e) {
                        vo.setDetailTaxRate(null);
                        warnType = warnType + "[\u7a0e\u7387\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(7)))) {
                    vo.setDetailPrice(null);
                } else {
                    try {
                        vo.setDetailPrice(new BigDecimal((String)datas.get(7)));
                    }
                    catch (Exception e) {
                        vo.setDetailPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(8)))) {
                    vo.setDetailTaxPrice(null);
                } else {
                    try {
                        vo.setDetailTaxPrice(new BigDecimal((String)datas.get(8)));
                    }
                    catch (Exception e) {
                        vo.setDetailTaxPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(9)))) {
                    vo.setDetailMny(null);
                } else {
                    try {
                        vo.setDetailMny(new BigDecimal((String)datas.get(9)));
                    }
                    catch (Exception e) {
                        vo.setDetailMny(null);
                        warnType = warnType + "[\u5408\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(10)))) {
                    vo.setDetailTaxMny(null);
                } else {
                    try {
                        vo.setDetailTaxMny(new BigDecimal((String)datas.get(10)));
                    }
                    catch (Exception e) {
                        vo.setDetailTaxMny(null);
                        warnType = warnType + "[\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(11)))) {
                    vo.setDetailTax(null);
                } else {
                    try {
                        vo.setDetailTax(new BigDecimal((String)datas.get(11)));
                    }
                    catch (Exception e) {
                        vo.setDetailTax(null);
                        warnType = warnType + "[\u7a0e\u989d\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setMemo((String)datas.get(12));
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setParentWarn(Boolean.valueOf(parentWarn));
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                detailVoList.add(vo);
            }
            for (TargetLiabilityCostDetailVO tVo : detailVoList) {
                tVo.setTpid((String)tidMap.get(tVo.getTpid()));
            }
            new TaxCalculateUtil().calculate(detailVoList);
            List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
            List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
            ArrayList<Map<String, Object>> falseList = new ArrayList<Map<String, Object>>();
            List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
            List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
            resp.put("successList", allList.get(0));
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public List<TargetLiabilityCostDetailVO> queryDetailTemp() {
        List<TargetLiabilityCostDetailEntity> detailEntityList = this.detailService.queryDetailTemp();
        HashMap<String, String> tidMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (TargetLiabilityCostDetailEntity detailEntity : detailEntityList) {
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                String detailIndex = detailEntity.getDetailIndex();
                String name = detailEntity.getName();
                String[] split = detailIndex.split("[-/.]");
                detailEntity.setTid(id);
                tidMap.put(detailIndex, id);
                switch (name) {
                    case "\u76f4\u63a5\u5de5\u7a0b\u8d39": {
                        detailEntity.setTpid((String)tidMap.get("2"));
                        break;
                    }
                    case "\u4e13\u4e1a\u5206\u5305\u5de5\u7a0b\u8d39": {
                        detailEntity.setTpid((String)tidMap.get("2"));
                        break;
                    }
                    case "\u5176\u4ed6\u76f4\u63a5\u8d39": {
                        detailEntity.setTpid((String)tidMap.get("2"));
                        break;
                    }
                    case "\u95f4\u63a5\u8d39": {
                        detailEntity.setTpid((String)tidMap.get("2"));
                        break;
                    }
                    case "\u9644\u52a0\u7a0e\u91d1": {
                        detailEntity.setTpid((String)tidMap.get("2"));
                        break;
                    }
                    case "\u5176\u4ed6\u8d39\u7528": {
                        detailEntity.setTpid((String)tidMap.get("2"));
                        break;
                    }
                    case "\u5408\u4f5c\u65b9\u6536\u53d6\u7684\u7ba1\u7406\u8d39": {
                        detailEntity.setTpid((String)tidMap.get("2"));
                        break;
                    }
                    case "\u52b3\u52a1\u8d39": {
                        detailEntity.setTpid((String)tidMap.get("2.1"));
                        break;
                    }
                    case "\u6750\u6599\u8d39": {
                        detailEntity.setTpid((String)tidMap.get("2.1"));
                        break;
                    }
                    case "\u673a\u68b0\u8d39": {
                        detailEntity.setTpid((String)tidMap.get("2.1"));
                        break;
                    }
                    case "\u7ba1\u7406\u8d39\u7b49": {
                        detailEntity.setTpid((String)tidMap.get("2.4"));
                        break;
                    }
                    case "\u5b89\u5168\u6587\u660e\u65bd\u5de5\u8d39": {
                        detailEntity.setTpid((String)tidMap.get("2.4"));
                        break;
                    }
                    case "\u5176\u4ed6\u95f4\u63a5\u8d39": {
                        detailEntity.setTpid((String)tidMap.get("2.4"));
                        break;
                    }
                }
                if (split.length > 2) {
                    detailEntity.setTpid((String)tidMap.get(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1)));
                }
                detailEntity.setRowState("add");
            }
        }
        List resultMapList = BeanMapper.mapList(detailEntityList, TargetLiabilityCostDetailVO.class);
        resultMapList.forEach(e -> e.setShadowId(e.getTid()));
        return TargetLiabilityCostServiceImpl.buildTree(resultMapList);
    }

    public static List<TargetLiabilityCostDetailVO> buildTree(List<TargetLiabilityCostDetailVO> values) {
        TargetLiabilityCostDetailVO parentNode;
        HashMap<String, TargetLiabilityCostDetailVO> nodeMap = new HashMap<String, TargetLiabilityCostDetailVO>();
        ArrayList<TargetLiabilityCostDetailVO> result = new ArrayList<TargetLiabilityCostDetailVO>();
        ArrayList<TargetLiabilityCostDetailVO> emptyValueList = new ArrayList<TargetLiabilityCostDetailVO>();
        for (TargetLiabilityCostDetailVO value : values) {
            if (null == value || value.getTpid() == null) {
                result.add(value);
            } else {
                parentNode = (TargetLiabilityCostDetailVO)nodeMap.get(value.getTpid());
                if (parentNode == null) {
                    emptyValueList.add(value);
                } else {
                    parentNode.getChildren().add(value);
                }
            }
            nodeMap.put(value.getTid(), value);
        }
        if (!emptyValueList.isEmpty()) {
            for (TargetLiabilityCostDetailVO value : emptyValueList) {
                parentNode = (TargetLiabilityCostDetailVO)nodeMap.get(value.getTpid());
                if (parentNode == null) {
                    result.add(value);
                    continue;
                }
                parentNode.getChildren().add(value);
            }
        }
        return result;
    }
}

