/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.TurnMaterialDetailEntity;
import com.ejianc.business.cost.bean.TurnMaterialEntity;
import com.ejianc.business.cost.controller.api.CostDetailApi;
import com.ejianc.business.cost.service.ITurnMaterialService;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="turnMaterial")
public class TurnMaterialBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private ITurnMaterialService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private CostDetailApi costDetailApi;
    private static final String MECHAN_DEPRECIATION = "MECHAN_DEPRECIATION";
    private static final String MECHAN_DEPRECIATION_DETAIL = "MECHAN_DEPRECIATION_DETAIL";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        TurnMaterialEntity entity = (TurnMaterialEntity)((Object)this.service.selectById(billId));
        this.processCost(entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.delCost(billId);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public void processCost(TurnMaterialEntity entity) {
        boolean canPush = true;
        ArrayList<CostDetailVO> list = new ArrayList<CostDetailVO>();
        if (ListUtil.isNotEmpty(entity.getDetailList())) {
            for (int i = 0; i < entity.getDetailList().size(); ++i) {
                TurnMaterialDetailEntity sub = entity.getDetailList().get(i);
                if (sub.getSubjectId() == null || sub.getSubjectId() <= 0L || sub.getAccountingId() == null || sub.getAccountingId() <= 0L) {
                    canPush = false;
                    break;
                }
                CostDetailVO c = new CostDetailVO();
                c.setSubjectId(sub.getSubjectId());
                c.setOrgSubjectId(sub.getOrgSubjectId());
                c.setAccountingId(sub.getAccountingId());
                c.setOrgAccountingId(sub.getOrgAccountingId());
                c.setSourceId(entity.getId());
                c.setSourceDetailId(sub.getId());
                c.setProjectId(entity.getProjectId());
                c.setHappenTaxMny(sub.getSumMny() == null ? new BigDecimal("0.00") : sub.getSumMny());
                c.setHappenMny(sub.getSumMny() == null ? new BigDecimal("0.00") : sub.getSumMny());
                c.setHappenDate(entity.getCountDate());
                c.setMemo(sub.getMemo());
                c.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                c.setSourceType(MECHAN_DEPRECIATION);
                c.setSourceTabType(MECHAN_DEPRECIATION_DETAIL);
                list.add(c);
            }
        }
        if (canPush) {
            CommonResponse<CostDetailVO> response = this.costDetailApi.saveSubject(list);
            this.logger.info("\u63a8\u9001\u6210\u672c \u673a\u68b0\u6298\u65e7\u8d39 \u7ed3\u679c:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
        } else {
            CommonResponse<CostDetailVO> response = this.costDetailApi.deleteCostDetail(entity.getId());
            this.logger.info("\u5220\u9664\u6210\u672c \u673a\u68b0\u6298\u65e7\u8d39 \u7ed3\u679c:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
        }
    }

    public void delCost(Long id) {
        CommonResponse<CostDetailVO> response = this.costDetailApi.deleteCostDetail(id);
        this.logger.info("\u5220\u9664\u6210\u672c \u673a\u68b0\u6298\u65e7\u8d39 \u7ed3\u679c:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + id);
    }
}

