package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 最终合同成本汇总
 *
 * @author generator
 *
 */
@TableName("ejc_cost_fin_contract_detail")
public class CostFinContractDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="name")
    private String name; // 单据名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0 自由态，1 已提交，2 审批中，3 审批通过，4 驳回，5 提交后有人审批中
    @TableField(value="contract_type")
    private String contractType; // 合同类型
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="contract_amount")
    private BigDecimal contractAmount; // 合同金额
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="sub_org")
    private String subOrg; // 分包企业
    @TableField(value="sub_org_id")
    private Long subOrgId; // 分包企业主键
    @TableField(value="amount_settled")
    private BigDecimal amountSettled; // 不含税已结算
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="forecast_id")
    private Long forecastId; // 成本关门预估主键
    @TableField(value="detail_index")
    private String detailIndex; // 序号
    @TableField(value="accounting_id")
    private String accountingId; // 变更状态	
    @TableField(value="accounting_name")
    private String accountingName; // 变更状态名称
    @TableField(value="cost_fin_id")
    private Long costFinId; // 成本关门预估id
    @TableField(value="estimated_amount")
    private BigDecimal estimatedAmount; // 含税预估成本
    @TableField(value="estimated_amount_tax")
    private BigDecimal estimatedAmountTax; // 预估成本税金
    @TableField(value="change_status")
    private Long changeStatus; // 变更状态
    @TableField(value="estimated_amount_notax")
    private BigDecimal estimatedAmountNotax; // 预估成本不含税




    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public String getSubOrg() {
        return subOrg;
    }

    public void setSubOrg(String subOrg) {
        this.subOrg = subOrg;
    }
    public Long getSubOrgId() {
        return subOrgId;
    }

    public void setSubOrgId(Long subOrgId) {
        this.subOrgId = subOrgId;
    }
    public BigDecimal getAmountSettled() {
        return amountSettled;
    }

    public void setAmountSettled(BigDecimal amountSettled) {
        this.amountSettled = amountSettled;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getForecastId() {
        return forecastId;
    }

    public void setForecastId(Long forecastId) {
        this.forecastId = forecastId;
    }
    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    public String getAccountingId() {
        return accountingId;
    }

    public void setAccountingId(String accountingId) {
        this.accountingId = accountingId;
    }
    public String getAccountingName() {
        return accountingName;
    }

    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }
    public Long getCostFinId() {
        return costFinId;
    }

    public void setCostFinId(Long costFinId) {
        this.costFinId = costFinId;
    }
    public BigDecimal getEstimatedAmount() {
        return estimatedAmount;
    }

    public void setEstimatedAmount(BigDecimal estimatedAmount) {
        this.estimatedAmount = estimatedAmount;
    }
    public BigDecimal getEstimatedAmountTax() {
        return estimatedAmountTax;
    }

    public void setEstimatedAmountTax(BigDecimal estimatedAmountTax) {
        this.estimatedAmountTax = estimatedAmountTax;
    }
    public Long getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Long changeStatus) {
        this.changeStatus = changeStatus;
    }
    public BigDecimal getEstimatedAmountNotax() {
        return estimatedAmountNotax;
    }

    public void setEstimatedAmountNotax(BigDecimal estimatedAmountNotax) {
        this.estimatedAmountNotax = estimatedAmountNotax;
    }

}
