package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.cost.bean.CostClosingForecastChangeEntity;
import com.ejianc.business.cost.bean.CostClosingForecastEntity;
import com.ejianc.business.cost.bean.CostClosingLastEntity;
import com.ejianc.business.cost.mapper.CostClosingLastMapper;
import com.ejianc.business.cost.service.ICostClosingLastService;
import com.ejianc.business.cost.vo.CostClosingChangesVO;
import com.ejianc.business.cost.vo.CostClosingLastVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.CostClosingLastChangeEntity;
import com.ejianc.business.cost.service.ICostClosingLastChangeService;
import com.ejianc.business.cost.vo.CostClosingLastChangeVO;

/**
 * 最终成本关门通知变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("costClosingLastChange")
public class CostClosingLastChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ICostClosingLastChangeService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private CostClosingLastMapper costClosingLastMapper;

    @Autowired
    private ICostClosingLastService costClosingLastService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CostClosingLastChangeVO> saveOrUpdate(@RequestBody CostClosingLastChangeVO saveOrUpdateVO) {
//    	CostClosingLastChangeEntity entity = BeanMapper.map(saveOrUpdateVO, CostClosingLastChangeEntity.class);
////        Integer total = costClosingLastMapper.auditcount(entity.getProjectId());//查询当前项目是否存在其他最终成本关门通知单
////        if(total == 0){
////            throw new BusinessException("当前项目不存在已过审的最终成本关门通知单，请制单并审核后再进行变更！");
////        }
//    	if(entity.getId() == null || entity.getId() == 0){
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
//        }
//    	service.saveOrUpdate(entity, false);
//    	CostClosingLastChangeVO vo = BeanMapper.map(entity, CostClosingLastChangeVO.class);
//        return CommonResponse.success("保存或修改单据成功！",vo);
        CommonResponse<CostClosingLastChangeVO> commonResponse = service.saveOrUpdate(saveOrUpdateVO);
        return commonResponse;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostClosingLastChangeVO> queryDetail(Long id) {
    	CostClosingLastChangeEntity entity = service.selectById(id);
    	CostClosingLastChangeVO vo = BeanMapper.map(entity, CostClosingLastChangeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CostClosingLastChangeVO> vos) {
//        if(ListUtil.isNotEmpty(vos)){
//            for (CostClosingLastChangeVO vo : vos) {
//                // 参数是单据类型编码字符串 根据需求是否打开下面代码
//                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
//                if(!resp.isSuccess()){
//                    return CommonResponse.error("删除失败！"+resp.getMsg());
//                }*/
//            }
//        }
        Long id = vos.get(0).getId();
        CostClosingLastChangeEntity vo = service.selectById(id);
        service.removeByIds(vos.stream().map(CostClosingLastChangeVO::getId).collect(Collectors.toList()),true);
        //查询删除后是否还存在变更单
        List<CostClosingLastChangeEntity> list = costClosingLastMapper.querylastchangeList(vo.getClosingLastId());
        //回写主表
        LambdaUpdateWrapper<CostClosingLastEntity> updateWrapper = new LambdaUpdateWrapper<>();
        if(list.isEmpty()){//不存在
            //设置变更状态为未变更
            updateWrapper.set(CostClosingLastEntity::getChangeStatus, '1');
            //设置最终成本关门期限为原成本关门期限
            updateWrapper.set(CostClosingLastEntity::getLastCostClosingTime, costClosingLastMapper.selectById(vo.getClosingLastId()).getOldCostClosingTime());
            //设置申请延长时间
            updateWrapper.set(CostClosingLastEntity::getDays, "0");
            updateWrapper.eq(CostClosingLastEntity::getId,vo.getClosingLastId());
            costClosingLastService.update(updateWrapper);
        }else {//存在
            //设置最终成本关门期限为最新一条变更单最终成本关门期限
            updateWrapper.set(CostClosingLastEntity::getLastCostClosingTime, list.get(0).getLastCostClosingTime());
            //设置申请延长时间
            //计算最终成本关门期限与原最终成本关门期限差值
            LocalDate lastCostClosingTimelocalDate = list.get(0).getLastCostClosingTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate oldCostClosingTimelocalDate = costClosingLastMapper.selectById(vo.getClosingLastId()).getOldCostClosingTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            long days = ChronoUnit.DAYS.between(oldCostClosingTimelocalDate, lastCostClosingTimelocalDate);
            updateWrapper.set(CostClosingLastEntity::getDays, String.valueOf(days));
            updateWrapper.eq(CostClosingLastEntity::getId,vo.getClosingLastId());
            costClosingLastService.update(updateWrapper);
        }


        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CostClosingLastChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<CostClosingLastChangeEntity> page = service.queryPage(param,false);
        IPage<CostClosingLastChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CostClosingLastChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CostClosingLastChangeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CostClosingLastChange-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCostClosingLastChangeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CostClosingLastChangeVO>> refCostClosingLastChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CostClosingLastChangeEntity> page = service.queryPage(param,false);
        IPage<CostClosingLastChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CostClosingLastChangeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 变更新增
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailChange", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostClosingLastChangeVO> queryDetailChange(@RequestParam Long id) {
        CostClosingLastChangeVO vo=service.queryDetailChange(id);
        return CommonResponse.success(vo);
    }

    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostClosingLastVO> queryDetailRecord(Long id) {
        CostClosingLastVO vo = service.queryDetailRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
}
