package com.ejianc.business.cost.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.budget.bean.BudgetProjectChangeEntity;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.vo.BudgetProjectChangeVO;
import com.ejianc.business.budget.vo.BudgetProjectVO;
import com.ejianc.business.cost.bean.CostClosingEntity;
import com.ejianc.business.cost.mapper.CostClosingMapper;
import com.ejianc.business.cost.service.ICostClosingService;
import com.ejianc.business.cost.vo.CostClosingChangesVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.CostClosingChangesMapper;
import com.ejianc.business.cost.bean.CostClosingChangesEntity;
import com.ejianc.business.cost.service.ICostClosingChangesService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 成本关门通知变更单
 *
 * @author generator
 *
 */
@Service("costClosingChangesService")
public class CostClosingChangesServiceImpl extends BaseServiceImpl<CostClosingChangesMapper, CostClosingChangesEntity> implements ICostClosingChangesService{

    private static final String BILL_CODE_ROLE = "COST_CLOSING_CODE_CHANGES";//此处需要根据实际修改
    @Autowired
    CostClosingMapper costClosingMapper;

    @Autowired
    private ICostClosingService costClosingService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    CostClosingChangesMapper costClosingChangesMapper;

    @Override
    public CommonResponse<CostClosingChangesVO> saveOrUpdate(CostClosingChangesVO changeVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        CostClosingChangesEntity entity = null;
        String operateType = null;
        if (changeVo.getId() != null && changeVo.getId() > 0) { //修改
            if (StringUtils.isEmpty(changeVo.getBillCode())) {
                changeVo.setBillCode(null);
            }
            entity = BeanMapper.map(changeVo, CostClosingChangesEntity.class);
            operateType = "edit";
        } else {
            if (null == changeVo.getChangeVersion() || changeVo.getChangeVersion() == 0) {
                changeVo.setChangeVersion(1);//第一次变更
            } else {
                changeVo.setChangeVersion(changeVo.getChangeVersion() + 1);//版本号+1
            }
            if (2 == changeVo.getChangeStatus()) {
                throw new BusinessException("成本关门通知单存在变更中单据，不允许保存!");
            }
            //新增
            if (StringUtils.isEmpty(changeVo.getBillCode())) {
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE_ROLE, tenantId);
                if (billCode.isSuccess()) {
                    changeVo.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }

            entity = BeanMapper.map(changeVo, CostClosingChangesEntity.class);

            operateType = "add";
        }

        super.saveOrUpdate(entity);


        //回写主表
        LambdaUpdateWrapper<CostClosingEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(CostClosingEntity::getNewCostClosingTime, changeVo.getCostClosingTime());//变更中
        updateWrapper.set(CostClosingEntity::getDays, changeVo.getDays());//变更中
        updateWrapper.set(CostClosingEntity::getChangeId, entity.getId());//变更主键
        updateWrapper.set(CostClosingEntity::getOldCostClosingTime, entity.getOldCostClosingTime());//原变更时间
        updateWrapper.set(CostClosingEntity::getChangeStatus, 3);//状态：变更中
        updateWrapper.set(CostClosingEntity::getChangeStatusName, "已变更");//状态：变更中
        updateWrapper.set(CostClosingEntity::getChangeCode, entity.getBillCode());//变更编码
        updateWrapper.eq(CostClosingEntity::getId, entity.getClosNoticeId());

        costClosingService.update(updateWrapper);

        CostClosingChangesEntity costClosingChangesEntity = super.selectById(entity.getId());
        CostClosingChangesVO vo = BeanMapper.map(costClosingChangesEntity, CostClosingChangesVO.class);
        return CommonResponse.success(vo);
    }


    @Override
    public CostClosingChangesVO queryDetailChange(Long id) {
        CostClosingEntity costClosingChangesEntity = costClosingMapper.selectById(id);//首次变更
//        CostClosingChangesEntity costClosingChangesEntity1 = costClosingChangesMapper.selectByMaster(id);//非首次变更
        if (!ObjectUtil.isEmpty(costClosingChangesEntity)){
            CostClosingChangesVO contractVo = BeanMapper.map(costClosingChangesEntity, CostClosingChangesVO.class);
            contractVo.setOldCostClosingTime(costClosingChangesEntity.getCostClosingTime());
            contractVo.setCostClosingTime(costClosingChangesEntity.getCostClosingTime());
            contractVo.setBillState(null);
            contractVo.setCreateUserCode(null);
            contractVo.setCreateTime(null);
            contractVo.setUpdateUserCode(null);
            contractVo.setUpdateTime(null);
            contractVo.setMemo(null);
            return contractVo;
        }
        return null;
    }

    @Override
    public void deleteChange(List<CostClosingChangesVO> vos) {
        for (CostClosingChangesVO vo : vos) {
            CostClosingChangesEntity changeEntity = super.selectById(vo.getId());
            LambdaUpdateWrapper<CostClosingEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(CostClosingEntity::getDays, null);
            updateWrapper.set(CostClosingEntity::getNewCostClosingTime, null);
            if (changeEntity.getChangeVersion() == 1) {
                updateWrapper.set(CostClosingEntity::getChangeStatus, 1);
                updateWrapper.set(CostClosingEntity::getChangeStatusName, "未变更");
            } else {
                updateWrapper.set(CostClosingEntity::getChangeStatus, 3);
                updateWrapper.set(CostClosingEntity::getChangeStatusName, "已变更");
            }
            updateWrapper.eq(CostClosingEntity::getId, changeEntity.getClosNoticeId());
            costClosingService.update(updateWrapper);
            super.removeById(vo, false);
        }
    }
}
