package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.mapper.*;
import com.ejianc.business.cost.vo.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.service.ICostFinContractDetailService;

import java.util.List;

/**
 * 最终合同成本汇总
 * 
 * @author generator
 * 
 */
@Service("costFinContractDetailService")
public class CostFinContractDetailServiceImpl extends BaseServiceImpl<CostFinContractDetailMapper, CostFinContractDetailEntity> implements ICostFinContractDetailService{

    @Autowired
    private CostFinOtherDetailMapper costFinOtherDetailMapper;

    @Autowired
    private FinMaterialContractMapper finMaterialContractMapper;

    @Autowired
    private FinMachineContractMapper finMachineContractMapper;

    @Autowired
    private FinOtherContractMapper finOtherContractMapper;

    @Override
    public List<CostFinContractDetailVO> querySubContractByProjectId(String projectId) {
        List<CostFinContractDetailEntity> forecastContractDetailEntityList = this.baseMapper.querySubContractByProjectId(projectId);
        List<CostFinContractDetailVO> forecastContractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, CostFinContractDetailVO.class);
        return forecastContractDetailVOS;
    }

    @Override
    public List<FinMaterialContractVO> querySubContractByProjectIdMaterial(String projectId) {
        List<FinMaterialContractEntity> forecastContractDetailEntityList = this.baseMapper.querySubContractByProjectIdMaterial(projectId);
        List<FinMaterialContractVO> forecastContractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, FinMaterialContractVO.class);
        return forecastContractDetailVOS;
    }

    @Override
    public List<FinMachineContractVO> querySubContractByProjectIdMachine(String projectId) {
        List<FinMachineContractEntity> forecastContractDetailEntityList = this.baseMapper.querySubContractByProjectIdMachine(projectId);
        List<FinMachineContractVO> forecastContractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, FinMachineContractVO.class);
        return forecastContractDetailVOS;
    }

    @Override
    public List<FinOtherContractVO> querySubContractByProjectIdOther(String projectId) {
        List<FinOtherContractEntity> forecastContractDetailEntityList = this.baseMapper.querySubContractByProjectIdOther(projectId);
        List<FinOtherContractVO> forecastOthercontractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, FinOtherContractVO.class);
        return forecastOthercontractDetailVOS;
    }

    @Override
    public List<CostFinOtherDetailVO> queryOtherById(Long id) {
        List<CostFinOtherDetailEntity> forecastContractDetailEntityList = costFinOtherDetailMapper.querySubContractById(id);
        List<CostFinOtherDetailVO> forecastContractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, CostFinOtherDetailVO.class);
        return forecastContractDetailVOS;
    }

    @Override
    public List<FinMaterialContractVO> querySubContractByIdMaterial(Long id) {
        List<FinMaterialContractEntity> forecastContractDetailEntityList = finMaterialContractMapper.querySubContractByIdMaterial(id);
        List<FinMaterialContractVO> forecastContractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, FinMaterialContractVO.class);
        return forecastContractDetailVOS;
    }

    @Override
    public List<FinMachineContractVO> querySubContractByIdMachine(Long id) {
        List<FinMachineContractEntity> forecastContractDetailEntityList = finMachineContractMapper.querySubContractByIdMachine(id);
        List<FinMachineContractVO> forecastContractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, FinMachineContractVO.class);
        return forecastContractDetailVOS;
    }

    @Override
    public List<FinOtherContractVO> querySubContractByIdOther(Long id) {
        List<FinOtherContractEntity> forecastContractDetailEntityList = finOtherContractMapper.querySubContractByIdOther(id);
        List<FinOtherContractVO> forecastOthercontractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, FinOtherContractVO.class);
        return forecastOthercontractDetailVOS;
    }
}
