package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.ForecastMachinecontractDetailEntity;
import com.ejianc.business.cost.bean.ForecastMaterialcontractDetailEntity;
import com.ejianc.business.cost.bean.ForecastOthercontractDetailEntity;
import com.ejianc.business.cost.mapper.ForecastMachinecontractDetailMapper;
import com.ejianc.business.cost.mapper.ForecastMaterialcontractDetailMapper;
import com.ejianc.business.cost.mapper.ForecastOthercontractDetailMapper;
import com.ejianc.business.cost.vo.ForecastContractDetailVO;
import com.ejianc.business.cost.vo.ForecastMachinecontractDetailVO;
import com.ejianc.business.cost.vo.ForecastMaterialcontractDetailVO;
import com.ejianc.business.cost.vo.ForecastOthercontractDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.ForecastContractDetailMapper;
import com.ejianc.business.cost.bean.ForecastContractDetailEntity;
import com.ejianc.business.cost.service.IForecastContractDetailService;

import java.util.List;

/**
 * 合同成本·关门预估控制明细
 *
 * @author generator
 *
 */
@Service("forecastContractDetailService")
public class ForecastContractDetailServiceImpl extends BaseServiceImpl<ForecastContractDetailMapper, ForecastContractDetailEntity> implements IForecastContractDetailService{

    @Autowired
    ForecastOthercontractDetailMapper forecastOthercontractDetailMapper;
    @Autowired
    ForecastMachinecontractDetailMapper forecastMachinecontractDetailMapper;
    @Autowired
    ForecastMaterialcontractDetailMapper forecastMaterialcontractDetailMapper;
    @Autowired
    ForecastContractDetailMapper forecastContractDetailMapper;

    @Override
    public List<ForecastContractDetailVO> querySubContractByProjectId(String projectId,String contractIds) {
        List<ForecastContractDetailEntity> forecastContractDetailEntityList = this.baseMapper.querySubContractByProjectId(projectId,contractIds);
        for(int a = 0;a<forecastContractDetailEntityList.size();a++){
            ForecastContractDetailEntity forecastContractDetailEntity = forecastContractDetailEntityList.get(a);
            Long contractId = forecastContractDetailEntity.getContractId();
            Integer finishcount = this.baseMapper.querySubFinish(contractId);
            Integer finishcostcount = this.baseMapper.queryCostFinish(projectId);
            if(finishcount != 0 || finishcostcount != 0){
                forecastContractDetailEntity.setIsend("Y");
            }else{
                forecastContractDetailEntity.setIsend("N");
            }
            forecastContractDetailEntityList.set(a,forecastContractDetailEntity);
        }
        List<ForecastContractDetailVO> forecastContractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, ForecastContractDetailVO.class);
        return forecastContractDetailVOS;
    }

    @Override
    public List<ForecastMaterialcontractDetailVO> querySubContractByProjectIdMaterial(String projectId) {
        List<ForecastMaterialcontractDetailEntity> forecastContractDetailEntityList = this.baseMapper.querySubContractByProjectIdMaterial(projectId);
        List<ForecastMaterialcontractDetailVO> forecastContractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, ForecastMaterialcontractDetailVO.class);
        return forecastContractDetailVOS;
    }

    @Override
    public List<ForecastMachinecontractDetailVO> querySubContractByProjectIdMachine(String projectId) {
        List<ForecastMachinecontractDetailEntity> forecastContractDetailEntityList = this.baseMapper.querySubContractByProjectIdMachine(projectId);
        List<ForecastMachinecontractDetailVO> forecastContractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, ForecastMachinecontractDetailVO.class);
        return forecastContractDetailVOS;
    }

    @Override
    public List<ForecastOthercontractDetailVO> querySubContractByProjectIdOther(String projectId) {
        List<ForecastOthercontractDetailEntity> forecastContractDetailEntityList = this.baseMapper.querySubContractByProjectIdOther(projectId);
        List<ForecastOthercontractDetailVO> forecastOthercontractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, ForecastOthercontractDetailVO.class);
        return forecastOthercontractDetailVOS;
    }

    @Override
    public List<ForecastOthercontractDetailVO> querySubContractByIdOther(Long id) {
        List<ForecastOthercontractDetailEntity> forecastContractDetailEntityList = forecastOthercontractDetailMapper.querySubContractByIdOther(id);
        List<ForecastOthercontractDetailVO> forecastOthercontractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, ForecastOthercontractDetailVO.class);
        return forecastOthercontractDetailVOS;
    }

    @Override
    public List<ForecastMachinecontractDetailVO> querySubContractByIdMachine(Long id) {
        List<ForecastMachinecontractDetailEntity> forecastContractDetailEntityList = forecastMachinecontractDetailMapper.querySubContractByIdMachine(id);
        List<ForecastMachinecontractDetailVO> forecastContractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, ForecastMachinecontractDetailVO.class);
        return forecastContractDetailVOS;
    }

    @Override
    public List<ForecastMaterialcontractDetailVO> querySubContractByIdMaterial(Long id) {
        List<ForecastMaterialcontractDetailEntity> forecastContractDetailEntityList = forecastMaterialcontractDetailMapper.querySubContractByIdMaterial(id);
        List<ForecastMaterialcontractDetailVO> forecastContractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, ForecastMaterialcontractDetailVO.class);
        return forecastContractDetailVOS;
    }

    @Override
    public String queryallcontractcheck(Long id,Long projectId) {
        String result = "T";
        List<String> datacontract = forecastContractDetailMapper.queryallcontract(id);
        List<String> projectcontract = forecastContractDetailMapper.queryprojectcontract(projectId);
        if(datacontract.size() != projectcontract.size()){
            result = "F";
        }
        return result;
    }
}
