package com.ejianc.business.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.mapper.*;
import com.ejianc.business.cost.service.*;
import com.ejianc.business.cost.utils.MathUtil;
import com.ejianc.business.cost.vo.*;
import com.ejianc.business.cost.vo.report.*;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Service
public class ReportServiceImpl extends BaseServiceImpl<ReportMapper, CostDetailEntity> implements IReportService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private ISubjectOrgService subjectOrgService;

    @Autowired
    private IAccountingOrgService accountingOrgService;

    @Autowired
    private IAccountingProjectService accountingProjectService;

    @Autowired
    private ITargetLiabilityCostService iTargetLiabilityCostService;

    @Autowired
    private CostFinContractDetailMapper costFinContractDetailMapper;

    @Autowired
    private CostFinCostSummaryReportingMapper costFinCostSummaryReportingMapper;

    @Autowired
    private CostFinOtherDetailMapper costFinOtherDetailMapper;

    @Autowired
    private FinMaterialContractMapper finMaterialContractMapper;

    @Autowired
    private FinMachineContractMapper finMachineContractMapper;

    @Autowired
    private FinOtherContractMapper finOtherContractMapper;

    @Autowired
    private ForecastOtherDetailMapper forecastOtherDetailMapper;

    @Autowired
    private CostClosingForecastMapper costClosingForecastMapper;

    @Autowired
    private ForecastContractDetailMapper forecastContractDetailMapper;

    @Autowired
    private ForecastMaterialcontractDetailMapper forecastMaterialcontractDetailMapper;

    @Autowired
    private ForecastMachinecontractDetailMapper forecastMachinecontractDetailMapper;

    @Autowired
    private ForecastOthercontractDetailMapper forecastOthercontractDetailMapper;

    @Autowired
    private CostClosingLastMapper costClosingLastMapper;

    @Autowired
    private ForecastOtherDetailChangeMapper forecastOtherDetailChangeMapper;

    @Autowired
    private CostClosingForecastChangeMapper costClosingForecastChangeMapper;

    @Autowired
    private ForecastContractDetailChangeMapper forecastContractDetailChangeMapper;

    @Autowired
    private ISubjectProjectService subjectProjectService;

    @Autowired
    private ICostFinCostSummaryReportingService costFinCostSummaryReportingService;

    /**
     * 产值统计报表
     * @param param
     * @return
     */
    @Override
    public JSONObject subjectCostList(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        List<SubjectCostVO> list = new ArrayList<>();
        Page<SubjectCostVO> pages = new Page<>(param.getPageIndex(), param.getPageSize());
        if(param.getParams().containsKey("subjectId") && param.getParams().containsKey("countMonth")){
            String countMonth = (String) param.getParams().get("countMonth").getValue();
            param.getParams().remove("countMonth");

            param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

            List<Long> orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
            param.getParams().put("projectDepartmentId",new Parameter(QueryParam.IN, orgIds));

            // 集团成本科目本下
            Long subjectId = Long.valueOf((String) param.getParams().get("subjectId").getValue());
            List<SubjectOrgVO> childList = subjectOrgService.getChildrenByPid(subjectId);
            param.getParams().put("subjectId",new Parameter(QueryParam.IN, childList.stream().map(SubjectOrgVO::getId).collect(Collectors.toList())));

            QueryWrapper wrapper = changeToQueryWrapper(param);
            list = baseMapper.subjectCostList(pages, wrapper, countMonth);

            // 汇总
            Map<String, SubjectCostVO> map = list.stream().collect(Collectors.toMap(x->x.getProjectId() + "-" + x.getSubjectId(), Function.identity()));
            if(CollectionUtils.isNotEmpty(list)) {
                for(SubjectCostVO vo : list){
                    String parentKey = vo.getProjectId() + "-" + subjectId;
                    SubjectCostVO parent = new SubjectCostVO();
                    if(map.containsKey(parentKey)){
                        if(!subjectId.equals(vo.getSubjectId())){
                            parent = map.get(parentKey);
                            parent.setMonthCostMny(ComputeUtil.safeAdd(parent.getMonthCostMny(), vo.getMonthCostMny()));
                            parent.setMonthCostTaxMny(ComputeUtil.safeAdd(parent.getMonthCostTaxMny(), vo.getMonthCostTaxMny()));
                            parent.setYearCostMny(ComputeUtil.safeAdd(parent.getYearCostMny(), vo.getYearCostMny()));
                            parent.setYearCostTaxMny(ComputeUtil.safeAdd(parent.getYearCostTaxMny(), vo.getYearCostTaxMny()));
                            parent.setTotalCostMny(ComputeUtil.safeAdd(parent.getTotalCostMny(), vo.getTotalCostMny()));
                            parent.setTotalCostTaxMny(ComputeUtil.safeAdd(parent.getTotalCostTaxMny(), vo.getTotalCostTaxMny()));
                        }
                    } else {
                        parent = BeanMapper.map(vo, SubjectCostVO.class);
                        parent.setSubjectId(subjectId);
                        map.put(parentKey, parent);
                    }
                }
            }
            // 过滤非选择集团成本科目数据
            list = new ArrayList<>();
            if(MapUtils.isNotEmpty(map)) {
                list = map.values().stream().filter(x->subjectId.equals(x.getSubjectId())).
                        sorted(Comparator.comparing(SubjectCostVO::getProjectId)).collect(Collectors.toList());
            }
        }
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());
        return page;

    }

    @Override
    public JSONObject getProductionVersusCostCompanyList(QueryParam param){


        int total = 0;//总条数
        int current = param.getPageIndex();//第几页
        int size = param.getPageSize();//一页几条
        int pages = 0;//有几页

        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        if(param.getParams().get("countMonth")==null){
            page.put("records", new ArrayList<ProductionVersusCostCompanyVO>());
            page.put("total", total);
            page.put("current", current);
            page.put("size", size);
            page.put("pages", pages);
            return page;
        }

        Long tenantId = InvocationInfoProxy.getTenantid();
        String countMonth = (String) param.getParams().get("countMonth").getValue();


        //获取当前年的月报产值
        //List<Map<String, Object>> thisYearProductionList = reportMapper.getThisYearProduction(tenantId,countMonth);
        //获取当前年的实际成本
        //List<Map<String, Object>> thisYearCost = reportMapper.getThisYearCost(tenantId, countMonth);

        //获取当前年的月报产值和实际成本
        List<ProductionVersusCostCompanyVO> thisYearProductionAndCost = baseMapper.getThisYearProductionAndCost(tenantId, countMonth);
        //进行为空和字符编码转换
        for (ProductionVersusCostCompanyVO productionVersusCostCompany:thisYearProductionAndCost){
            productionVersusCostCompany.setCountMonth(countMonth);
            if(productionVersusCostCompany.getMonthProduction()==null||productionVersusCostCompany.getMonthProduction().equals(new BigDecimal("0E-8"))){
                productionVersusCostCompany.setMonthProduction(BigDecimal.ZERO);
            }
            if(productionVersusCostCompany.getYearProduction()==null||productionVersusCostCompany.getYearProduction().equals(new BigDecimal("0E-8"))){
                productionVersusCostCompany.setYearProduction(BigDecimal.ZERO);
            }
            if(productionVersusCostCompany.getMonthProductionTax()==null||productionVersusCostCompany.getMonthProductionTax().equals(new BigDecimal("0E-8"))){
                productionVersusCostCompany.setMonthProductionTax(BigDecimal.ZERO);
            }
            if(productionVersusCostCompany.getYearProductionTax()==null||productionVersusCostCompany.getYearProductionTax().equals(new BigDecimal("0E-8"))){
                productionVersusCostCompany.setYearProductionTax(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getMonthCost()==null||productionVersusCostCompany.getMonthCost().equals(new BigDecimal("0E-8"))){
                productionVersusCostCompany.setMonthCost(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getYearCost()==null||productionVersusCostCompany.getYearCost().equals(new BigDecimal("0E-8"))){
                productionVersusCostCompany.setYearCost(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getMonthCostTax()==null||productionVersusCostCompany.getMonthCostTax().equals(new BigDecimal("0E-8"))){
                productionVersusCostCompany.setMonthCostTax(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getYearCostTax()==null||productionVersusCostCompany.getYearCostTax().equals(new BigDecimal("0E-8"))){
                productionVersusCostCompany.setYearCostTax(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getMonthProfit()==null||productionVersusCostCompany.getMonthProfit().equals(new BigDecimal("0E-8"))){
                productionVersusCostCompany.setMonthProfit(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getYearProfit()==null||productionVersusCostCompany.getYearProfit().equals(new BigDecimal("0E-8"))){
                productionVersusCostCompany.setYearProfit(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getMonthProfitMargin()==null||productionVersusCostCompany.getMonthProfitMargin().equals(new BigDecimal("0E-8"))){
                productionVersusCostCompany.setMonthProfitMargin(BigDecimal.ZERO);
            }
            if (productionVersusCostCompany.getYearProfitMargin()==null||productionVersusCostCompany.getYearProfitMargin().equals(new BigDecimal("0E-8"))){
                productionVersusCostCompany.setYearProfitMargin(BigDecimal.ZERO);
            }
        }
        Map<Long, ProductionVersusCostCompanyVO> thisYearProductionAndCostMap = thisYearProductionAndCost.stream().collect(Collectors.toMap(ProductionVersusCostCompanyVO::getId, Function.identity()));

        //根据租户id查询根节点组织信息
        Long topOrgId = orgApi.findOrgByTenantId(tenantId).getData().getId();
        //获取跟组织下所有组织
        List<OrgVO> allSecondAndNextOrg = orgApi.findChildrenByParentId(topOrgId).getData();
        //查询所有二级分子公司
        List<OrgVO> secondOrg = orgApi.getDirectChildrenByPid(topOrgId, null).getData().stream().filter(e -> e.getOrgType() == 2).collect(Collectors.toList());

        //进行汇总
        List<ProductionVersusCostCompanyVO> companyListMny = new ArrayList<>();
        for (OrgVO second:secondOrg){
            ProductionVersusCostCompanyVO sum = new ProductionVersusCostCompanyVO();
            sum.setCountMonth(countMonth);
            sum.setId(second.getId());
            sum.setOrgCode(second.getCode());
            sum.setName(second.getName());
            BigDecimal monthProductionMny = BigDecimal.ZERO;
            BigDecimal yearProductionMny = BigDecimal.ZERO;
            BigDecimal monthProductionMnyTax = BigDecimal.ZERO;
            BigDecimal yearProductionMnyTax = BigDecimal.ZERO;
            BigDecimal monthCost = BigDecimal.ZERO;
            BigDecimal yearCost = BigDecimal.ZERO;
            BigDecimal monthCostTax = BigDecimal.ZERO;
            BigDecimal yearCostTax = BigDecimal.ZERO;
            BigDecimal monthProfit = BigDecimal.ZERO;
            BigDecimal yearProfit = BigDecimal.ZERO;
            BigDecimal monthProfitMargin = BigDecimal.ZERO;
            BigDecimal yearProfitMargin = BigDecimal.ZERO;
            for (OrgVO allSecondAndNext:allSecondAndNextOrg){
                if (allSecondAndNext.getInnerCode().indexOf(second.getInnerCode())!=-1){
                    if (thisYearProductionAndCostMap.containsKey(allSecondAndNext.getId())){
                        ProductionVersusCostCompanyVO productionVersusCostCompany = thisYearProductionAndCostMap.get(allSecondAndNext.getId());
                        monthProductionMny = MathUtil.safeAdd(monthProductionMny,productionVersusCostCompany.getMonthProduction());
                        yearProductionMny = MathUtil.safeAdd(yearProductionMny,productionVersusCostCompany.getYearProduction());
                        monthProductionMnyTax = MathUtil.safeAdd(monthProductionMnyTax,productionVersusCostCompany.getMonthProductionTax());
                        yearProductionMnyTax = MathUtil.safeAdd(yearProductionMnyTax,productionVersusCostCompany.getYearProductionTax());
                        monthCost = MathUtil.safeAdd(monthCost,productionVersusCostCompany.getMonthCost());
                        yearCost = MathUtil.safeAdd(yearCost,productionVersusCostCompany.getYearCost());
                        monthCostTax = MathUtil.safeAdd(monthCostTax,productionVersusCostCompany.getMonthCostTax());
                        yearCostTax = MathUtil.safeAdd(yearCostTax,productionVersusCostCompany.getYearCostTax());
                        monthProfit = MathUtil.safeAdd(monthProfit,productionVersusCostCompany.getMonthProfit());
                        yearProfit = MathUtil.safeAdd(yearProfit,productionVersusCostCompany.getYearProfit());
                    }
                }
            }
            sum.setMonthProduction(monthProductionMny);
            sum.setYearProduction(yearProductionMny);
            sum.setMonthProductionTax(monthProductionMnyTax);
            sum.setYearProductionTax(yearProductionMnyTax);
            sum.setMonthCost(monthCost);
            sum.setYearCost(yearCost);
            sum.setMonthCostTax(monthCostTax);
            sum.setYearCostTax(yearCostTax);
            sum.setMonthProfit(monthProfit);
            sum.setYearProfit(yearProfit);
            monthProfitMargin = MathUtil.safeMultiply(MathUtil.safeDiv(monthProfit,monthProductionMny),new BigDecimal(100));
            yearProfitMargin = MathUtil.safeMultiply(MathUtil.safeDiv(yearProfit,yearProductionMny),new BigDecimal(100));
            sum.setMonthProfitMargin(monthProfitMargin);
            sum.setYearProfitMargin(yearProfitMargin);
            companyListMny.add(sum);
        }

        if (CollectionUtils.isEmpty(companyListMny)){
            page.put("records", new ArrayList<ProductionVersusCostCompanyVO>());
            page.put("total", total);
            page.put("current", current);
            page.put("size", size);
            page.put("pages", pages);
            return page;
        }

        total = companyListMny.size();
        if (total % size > 0) {
            pages = (total / size) + 1;
        } else if (total % size == 0) {
            pages = total / size;
        }

        page.put("records", companyListMny);
        page.put("total", total);
        page.put("current", current);
        page.put("size", size);
        page.put("pages", pages);
        return page;

    }

    @Override
    public JSONObject queryProjectProductionCostTwo(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");

        CommonResponse<List<ProjectRegisterVO>> projectResponse = projectApi.queryChildrenProjectByOrgId(InvocationInfoProxy.getOrgId());
        List<Long> projectIds = new ArrayList<>();
        if (projectResponse.isSuccess()) {
            projectIds = projectResponse.getData().stream().map(ProjectRegisterVO::getId).collect(Collectors.toList());
        }else {
            throw new BusinessException("查询项目失败！");
        }

        List<ProjectProductionCostTwoVO> resultList = new ArrayList<>();
        Page<ProjectProductionCostTwoVO> pages = new Page<>(param.getPageIndex(), param.getPageSize());
        if (param.getParams().containsKey("countMonth")) {
            String countMonth = (String) param.getParams().get("countMonth").getValue();
            param.getParams().remove("countMonth");
            param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
            QueryWrapper wrapper = changeToQueryWrapper(param);
            resultList = baseMapper.queryProjectProductionCostTwo(pages, wrapper, projectIds, InvocationInfoProxy.getTenantid(), countMonth);
        }

        for (ProjectProductionCostTwoVO vo : resultList) {
            vo.setMonthProfit(MathUtil.safeSub(vo.getMonthProduction(), vo.getMonthCost()));
            vo.setYearProfit(MathUtil.safeSub(vo.getYearProduction(), vo.getYearCost()));
            vo.setMonthProfitMargin(MathUtil.safeMultiply(MathUtil.safeDiv(vo.getMonthProfit(), vo.getMonthProduction()), new BigDecimal("100")));
            vo.setYearProfitMargin(MathUtil.safeMultiply(MathUtil.safeDiv(vo.getYearProfit(), vo.getYearProduction()), new BigDecimal("100")));
        }

        JSONObject page = new JSONObject();
        page.put("records", resultList);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());
        return page;
    }

    @Override
    public JSONObject queryProjectCostThree(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");

        CommonResponse<List<ProjectRegisterVO>> projectResponse = projectApi.queryChildrenProjectByOrgId(InvocationInfoProxy.getOrgId());
        List<Long> projectIds = new ArrayList<>();
        if (projectResponse.isSuccess()) {
            projectIds = projectResponse.getData().stream().map(ProjectRegisterVO::getId).collect(Collectors.toList());
        }else {
            throw new BusinessException("查询项目失败！");
        }

        param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
        Page<ProjectCostThreeVo> pages = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ProjectCostThreeVo> resultList = baseMapper.queryProjectCostThree(pages, wrapper, projectIds, InvocationInfoProxy.getTenantid());
        List<TargetLiabilityCostEntity> list = getTargetRate(projectIds);
        for (TargetLiabilityCostEntity entity : list) {
            for (ProjectCostThreeVo vo : resultList) {
                if (entity.getProjectId().equals(vo.getProjectId())){
                    vo.setTargetRate(entity.getTargetRate());
                }
            }
        }
        for (ProjectCostThreeVo vo : resultList) {
            // 实际利润(产值-实际成本)
            vo.setActualProfit(MathUtil.safeSub(vo.getProductionMny(), vo.getCostMny()));
            // 实际利润率(实际利润/产值)
            vo.setActualProfitMargin(MathUtil.safeMultiply(MathUtil.safeDiv(vo.getActualProfit(), vo.getProductionMny()), new BigDecimal("100")));

            // 目标利润(产值-目标成本)
            vo.setTargetProfit(MathUtil.safeSub(vo.getProductionMny(), vo.getTargetCostMny()));
            // 目标利润率(目标利润/产值)
            vo.setTargetProfitMargin(MathUtil.safeMultiply(MathUtil.safeDiv(vo.getTargetProfit(), vo.getProductionMny()), new BigDecimal("100")));

            // 目标成本-实际成本
            vo.setDifference(MathUtil.safeSub(vo.getTargetCostMny(), vo.getCostMny()));
            // 目标实际差异率(目标成本-实际成本)/目标成本
            vo.setDifferenceMargin(MathUtil.safeMultiply(MathUtil.safeDiv(vo.getDifference(), vo.getTargetCostMny()), new BigDecimal("100")));
        }

        JSONObject page = new JSONObject();
        page.put("records", resultList);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());

        return page;
    }

    private List<TargetLiabilityCostEntity> getTargetRate (List<Long> projectIds){
        QueryWrapper<TargetLiabilityCostEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("project_id,target_rate");
        queryWrapper.eq("dr",0);
        queryWrapper.in("bill_state",1,3);
        queryWrapper.in("project_id",projectIds);
        queryWrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
        queryWrapper.groupBy("project_id");
        List<TargetLiabilityCostEntity> entityList = iTargetLiabilityCostService.list(queryWrapper);
        return entityList;
    }

    @Override
    public List<Map<String,Object>> getProductionVersusCostAccountingTreeList(Long projectId, String happenDate){
        List<ProductionVersusCostAccountingVO> productionVersusCostAccountingTree = baseMapper.getProductionVersusCostAccountingTree(InvocationInfoProxy.getTenantid(), projectId, happenDate);
        for (ProductionVersusCostAccountingVO accountingVO:productionVersusCostAccountingTree){
            accountingVO.setCountMonth(happenDate);
            if(accountingVO.getMonthProduction()==null||accountingVO.getMonthProduction().equals(new BigDecimal("0E-8"))){
                accountingVO.setMonthProduction(BigDecimal.ZERO);
            }
            if(accountingVO.getYearProduction()==null||accountingVO.getYearProduction().equals(new BigDecimal("0E-8"))){
                accountingVO.setYearProduction(BigDecimal.ZERO);
            }
            if(accountingVO.getMonthProductionTax()==null||accountingVO.getMonthProductionTax().equals(new BigDecimal("0E-8"))){
                accountingVO.setMonthProductionTax(BigDecimal.ZERO);
            }
            if(accountingVO.getYearProductionTax()==null||accountingVO.getYearProductionTax().equals(new BigDecimal("0E-8"))){
                accountingVO.setYearProductionTax(BigDecimal.ZERO);
            }
            if (accountingVO.getMonthCost()==null||accountingVO.getMonthCost().equals(new BigDecimal("0E-8"))){
                accountingVO.setMonthCost(BigDecimal.ZERO);
            }
            if (accountingVO.getYearCost()==null||accountingVO.getYearCost().equals(new BigDecimal("0E-8"))){
                accountingVO.setYearCost(BigDecimal.ZERO);
            }
            if (accountingVO.getMonthCostTax()==null||accountingVO.getMonthCostTax().equals(new BigDecimal("0E-8"))){
                accountingVO.setMonthCost(BigDecimal.ZERO);
            }
            if (accountingVO.getYearCostTax()==null||accountingVO.getYearCostTax().equals(new BigDecimal("0E-8"))){
                accountingVO.setYearCost(BigDecimal.ZERO);
            }
        }
        List<Map> resultMapList = BeanMapper.mapList(productionVersusCostAccountingTree, Map.class);
        List<Map<String, Object>> subTree = ResultAsTree.createTreeData(resultMapList);
        List<Map<String, Object>> automatic = automatic(subTree);
        return automatic;
    }

    private List<Map<String, Object>> automatic(List<Map<String, Object>> list) {
        for (Map<String, Object> map : list) {
            List<Map<String, Object>> child = (List) map.get("children");
            if (child != null) {
                List<Map<String, Object>> newChildren = automatic(child);
                map.put("children", newChildren);

                BigDecimal monthProduction = (BigDecimal) map.get("monthProduction");
                BigDecimal newMonthProduction = MathUtil.safeAdd(monthProduction, childSum(newChildren, "monthProduction"));
                map.put("monthProduction", newMonthProduction.compareTo(BigDecimal.ZERO) == 0 ? null : newMonthProduction);
                BigDecimal yearProduction = (BigDecimal) map.get("yearProduction");
                BigDecimal newYearProduction = MathUtil.safeAdd(yearProduction, childSum(newChildren, "yearProduction"));
                map.put("yearProduction", newYearProduction.compareTo(BigDecimal.ZERO) == 0 ? null : newYearProduction);

                BigDecimal monthProductionTax = (BigDecimal) map.get("monthProductionTax");
                BigDecimal newMonthProductionTax = MathUtil.safeAdd(monthProductionTax, childSum(newChildren, "monthProductionTax"));
                map.put("monthProductionTax", newMonthProductionTax.compareTo(BigDecimal.ZERO) == 0 ? null : newMonthProductionTax);
                BigDecimal yearProductionTax = (BigDecimal) map.get("yearProductionTax");
                BigDecimal newYearProductionTax = MathUtil.safeAdd(yearProductionTax, childSum(newChildren, "yearProductionTax"));
                map.put("yearProductionTax", newYearProductionTax.compareTo(BigDecimal.ZERO) == 0 ? null : newYearProductionTax);

                BigDecimal monthCost = (BigDecimal) map.get("monthCost");
                BigDecimal newMonthCost = MathUtil.safeAdd(monthCost, childSum(newChildren, "monthCost"));
                map.put("monthCost", newMonthCost.compareTo(BigDecimal.ZERO) == 0 ? null : newMonthCost);
                BigDecimal yearCost = (BigDecimal) map.get("yearCost");
                BigDecimal newYearCost = MathUtil.safeAdd(yearCost, childSum(newChildren, "yearCost"));
                map.put("yearCost", newYearCost.compareTo(BigDecimal.ZERO) == 0 ? null : newYearCost);

                BigDecimal monthCostTax = (BigDecimal) map.get("monthCostTax");
                BigDecimal newMonthCostTax = MathUtil.safeAdd(monthCostTax, childSum(newChildren, "monthCostTax"));
                map.put("monthCostTax", newMonthCostTax.compareTo(BigDecimal.ZERO) == 0 ? null : newMonthCostTax);
                BigDecimal yearCostTax = (BigDecimal) map.get("yearCostTax");
                BigDecimal newYearCostTax = MathUtil.safeAdd(yearCostTax, childSum(newChildren, "yearCostTax"));
                map.put("yearCostTax", newYearCostTax.compareTo(BigDecimal.ZERO) == 0 ? null : newYearCostTax);

                BigDecimal monthProfit = (BigDecimal) map.get("monthProfit");
                BigDecimal newMonthProfit = MathUtil.safeAdd(monthProfit, childSum(newChildren, "monthProfit"));
                map.put("monthProfit", newMonthProfit.compareTo(BigDecimal.ZERO) == 0 ? null : newMonthProfit);
                BigDecimal yearProfit = (BigDecimal) map.get("yearProfit");
                BigDecimal newYearProfit = MathUtil.safeAdd(yearProfit, childSum(newChildren, "yearProfit"));
                map.put("yearProfit", newYearProfit.compareTo(BigDecimal.ZERO) == 0 ? null : newYearProfit);

                BigDecimal monthProfitMargin = MathUtil.safeMultiply(MathUtil.safeDiv(newMonthProfit, newMonthProduction), new BigDecimal("100"));
                map.put("monthProfitMargin", monthProfitMargin);
                BigDecimal yearProfitMargin = MathUtil.safeMultiply(MathUtil.safeDiv(newYearProfit, newYearProduction), new BigDecimal("100"));
                map.put("yearProfitMargin", yearProfitMargin);
            } else {
                BigDecimal monthProduction = (BigDecimal) map.get("monthProduction");
                map.put("monthProduction", monthProduction == null||monthProduction.compareTo(BigDecimal.ZERO) == 0 ? null : monthProduction);
                BigDecimal yearProduction = (BigDecimal) map.get("yearProduction");
                map.put("yearProduction", yearProduction == null||yearProduction.compareTo(BigDecimal.ZERO) == 0 ? null : yearProduction);

                BigDecimal monthProductionTax = (BigDecimal) map.get("monthProductionTax");
                map.put("monthProductionTax", monthProductionTax == null||monthProductionTax.compareTo(BigDecimal.ZERO) == 0 ? null : monthProductionTax);
                BigDecimal yearProductionTax = (BigDecimal) map.get("yearProductionTax");
                map.put("yearProductionTax", yearProductionTax == null||yearProductionTax.compareTo(BigDecimal.ZERO) == 0 ? null : yearProductionTax);

                BigDecimal monthCost = (BigDecimal) map.get("monthCost");
                map.put("monthCost", monthCost == null||monthCost.compareTo(BigDecimal.ZERO) == 0 ? null : monthCost);
                BigDecimal yearCost = (BigDecimal) map.get("yearCost");
                map.put("yearCost", yearCost == null||yearCost.compareTo(BigDecimal.ZERO) == 0 ? null : yearCost);

                BigDecimal monthCostTax = (BigDecimal) map.get("monthCostTax");
                map.put("monthCostTax", monthCostTax == null||monthCostTax.compareTo(BigDecimal.ZERO) == 0 ? null : monthCostTax);
                BigDecimal yearCostTax = (BigDecimal) map.get("yearCostTax");
                map.put("yearCostTax", yearCostTax == null||yearCostTax.compareTo(BigDecimal.ZERO) == 0 ? null : yearCostTax);

                BigDecimal monthProfit = (BigDecimal) map.get("monthProfit");
                map.put("monthProfit", monthProfit == null||monthProfit.compareTo(BigDecimal.ZERO) == 0 ? null : monthProfit);
                BigDecimal yearProfit = (BigDecimal) map.get("yearProfit");
                map.put("yearProfit", yearProfit == null||yearProfit.compareTo(BigDecimal.ZERO) == 0 ? null : yearProfit);

                BigDecimal monthProfitMargin = MathUtil.safeMultiply(MathUtil.safeDiv(monthProfit, monthProduction), new BigDecimal("100"));
                map.put("monthProfitMargin", monthProfitMargin);
                BigDecimal yearProfitMargin = MathUtil.safeMultiply(MathUtil.safeDiv(yearProfit, yearProduction), new BigDecimal("100"));
                map.put("yearProfitMargin", yearProfitMargin);
            }
        }
        return list;
    }

    private BigDecimal childSum(List<Map<String, Object>> list, String colums) {
        BigDecimal allMny = BigDecimal.ZERO;
        for (Map<String, Object> map : list) {
            BigDecimal mny = (BigDecimal) map.get(colums);
            allMny = MathUtil.safeAdd(allMny, mny);
        }
        return allMny;
    }

    /**
     * 项目实际成本统计（按核算对象展开）
     * @param param
     * @return
     */
    @Override
    public JSONObject accountingCostList(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        List<AccountingCostVO> list = new ArrayList<>();
        Page<AccountingCostVO> pages = new Page<>(param.getPageIndex(), param.getPageSize());
        if(param.getParams().containsKey("accountingId") && param.getParams().containsKey("countMonth")){
            String countMonth = (String) param.getParams().get("countMonth").getValue();
            param.getParams().remove("countMonth");

            param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

            List<Long> orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
            param.getParams().put("projectDepartmentId",new Parameter(QueryParam.IN, orgIds));

            // 集团核算对象本下
            Long accountingId = Long.valueOf((String) param.getParams().get("accountingId").getValue());
            List<AccountingOrgVO> childList = accountingOrgService.getChildrenByPid(accountingId);
            param.getParams().put("accountingId",new Parameter(QueryParam.IN, childList.stream().map(AccountingOrgVO::getId).collect(Collectors.toList())));

            QueryWrapper wrapper = changeToQueryWrapper(param);
            list = baseMapper.accountingCostList(pages, wrapper, countMonth);

            // 汇总
            Map<String, AccountingCostVO> map = list.stream().collect(Collectors.toMap(x->x.getProjectId() + "-" + x.getAccountingId(), Function.identity()));
            if(CollectionUtils.isNotEmpty(list)) {
                for(AccountingCostVO vo : list){
                    String parentKey = vo.getProjectId() + "-" + accountingId;
                    AccountingCostVO parent = new AccountingCostVO();
                    if(map.containsKey(parentKey)){
                        if(!accountingId.equals(vo.getAccountingId())){
                            parent = map.get(parentKey);
                            parent.setMonthCostMny(ComputeUtil.safeAdd(parent.getMonthCostMny(), vo.getMonthCostMny()));
                            parent.setMonthCostTaxMny(ComputeUtil.safeAdd(parent.getMonthCostTaxMny(), vo.getMonthCostTaxMny()));
                            parent.setYearCostMny(ComputeUtil.safeAdd(parent.getYearCostMny(), vo.getYearCostMny()));
                            parent.setYearCostTaxMny(ComputeUtil.safeAdd(parent.getYearCostTaxMny(), vo.getYearCostTaxMny()));
                            parent.setTotalCostMny(ComputeUtil.safeAdd(parent.getTotalCostMny(), vo.getTotalCostMny()));
                            parent.setTotalCostTaxMny(ComputeUtil.safeAdd(parent.getTotalCostTaxMny(), vo.getTotalCostTaxMny()));
                        }
                    } else {
                        parent = BeanMapper.map(vo, AccountingCostVO.class);
                        parent.setAccountingId(accountingId);
                        map.put(parentKey, parent);
                    }
                }
            }
            // 过滤非选择集团成本科目数据
            list = new ArrayList<>();
            if(MapUtils.isNotEmpty(map)) {
                list = map.values().stream().filter(x->accountingId.equals(x.getAccountingId())).
                        sorted(Comparator.comparing(AccountingCostVO::getProjectId)).collect(Collectors.toList());
            }
        }
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());
        return page;

    }

    @Override
    public List<OrgSubjectReportVO> querySubjectCostList(Integer yearFlag) {
        // 查询项目
        CommonResponse<List<ProjectRegisterVO>> response = projectApi.queryChildrenProjectByOrgId(InvocationInfoProxy.getOrgId());
        if (!response.isSuccess()) {
            throw new BusinessException("查询项目信息失败！");
        }
        List<ProjectRegisterVO> projectList = response.getData();
        List<Long> idsList = projectList.stream().map(ProjectRegisterVO::getId).collect(Collectors.toList());

        // 查询成本中间表
        List<CostDetailVO> costList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(idsList)){
            costList = baseMapper.querySubjectCostList(yearFlag, idsList);
        }
        // 金额合计
        BigDecimal totalHappenMny = costList.stream().map(CostDetailVO::getHappenMny).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 查询集团成本科目
        LambdaQueryWrapper<SubjectOrgEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SubjectOrgEntity::getTenantId, InvocationInfoProxy.getTenantid());
        List<SubjectOrgEntity> list = subjectOrgService.list(wrapper);
        Map<Long, SubjectOrgEntity> map = list.stream().collect(Collectors.toMap(SubjectOrgEntity::getId, Function.identity()));

        // 过滤出来一级节点
        List<SubjectOrgEntity> oneNodeList = list.stream().filter(i -> i.getParentId() == null).collect(Collectors.toList());

        Map<String, OrgSubjectReportVO> resultMap = new HashMap<>();

        // 封装数据
        for (CostDetailVO vo : costList) {
            if(!map.containsKey(vo.getOrgSubjectId())){
                continue;
            }
            String innerCode = map.get(vo.getOrgSubjectId()).getInnerCode();
            List<SubjectOrgEntity> entityList = oneNodeList.stream().filter(i -> innerCode.contains(i.getInnerCode())).collect(Collectors.toList());
            if (ListUtil.isNotEmpty(entityList)) {
                SubjectOrgEntity entity = entityList.get(0);
                String subjectName = entity.getSubjectName();

                BigDecimal happenMny = MathUtil.judgeZeroError(vo.getHappenMny());

                if (resultMap.containsKey(subjectName)) {
                    OrgSubjectReportVO reportVO = resultMap.get(subjectName);
                    reportVO.setHappenMny(ComputeUtil.safeAdd(happenMny, reportVO.getHappenMny()));
                    reportVO.setTaxRate(MathUtil.judgeZeroError(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(reportVO.getHappenMny(), totalHappenMny), new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP)));

                    resultMap.put(subjectName, reportVO);
                }else {
                    OrgSubjectReportVO reportVO = new OrgSubjectReportVO();
                    reportVO.setSubjectName(subjectName);
                    reportVO.setHappenMny(happenMny);
                    reportVO.setTaxRate(MathUtil.judgeZeroError(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(happenMny, totalHappenMny), new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP)));
                    reportVO.setTotalHappenTaxMny(totalHappenMny);

                    resultMap.put(subjectName, reportVO);
                }
            }
        }

        return new ArrayList<>(resultMap.values());
    }

    //表3
    @Override
    public List<Map<String,Object>> projectCompletionSum(Long projectId) {
        //根据所选项目查找该项目对应的预估单id
        Long fin = forecastContractDetailMapper.queryId(String.valueOf(projectId));

        if(fin != null){
            List<Map<String, Object>> alldata = new ArrayList<>();

            CostClosingForecastEntity costClosingForecastEntity = costClosingForecastMapper.selectById(fin);

            List<ForecastContractDetailEntity> sublist = forecastContractDetailMapper.querySubdetailLW(fin);
            List<ForecastContractDetailEntity> zysublist = forecastContractDetailMapper.querySubdetailZY(fin);
//            List<ForecastOtherDetailEntity> othlist = forecastContractDetailMapper.queryotherdetail(fin);
            List<CostFinOtherDetailEntity> othlist = costFinOtherDetailMapper.querySubjectByProjectId(String.valueOf(projectId));
            List<ForecastMaterialcontractDetailEntity> matlist = forecastContractDetailMapper.queryMaterialdetail(fin);
            List<ForecastMachinecontractDetailEntity> maclist = forecastContractDetailMapper.queryMachinedetail(fin);
            List<ForecastOthercontractDetailEntity> oclist = forecastContractDetailMapper.queryOthercontractdetail(fin);

///////////////////////////////////////////////////////1.劳务分包费（劳务分包合同）
            Map<String, Object> lw = new HashMap<>();
            lw.put("no", "1");
            lw.put("id","1");
            lw.put("costItems", "劳务分包费（劳务分包合同）");

            alldata.add(lw);

            BigDecimal lwcontractamount = new BigDecimal("0");
            BigDecimal lwsettleNotax = new BigDecimal("0");
            BigDecimal lwsettleTax = new BigDecimal("0");
            BigDecimal lwsettle = new BigDecimal("0");
            BigDecimal lwforecastamountNotax = new BigDecimal("0");
            BigDecimal lwforecastamountTax = new BigDecimal("0");
            BigDecimal lwforecastamount = new BigDecimal("0");
            BigDecimal lwallamount = new BigDecimal("0");
            List<Map<String, Object>> newChildren = new ArrayList<>();
            if(sublist != null && sublist.size()>0){
                for (int s = 0; s < sublist.size(); s++) {
                    ForecastContractDetailEntity materialContractEntity = sublist.get(s);
                    Integer no = s;
                    Integer noo = no + 1;
                    Map<String, Object> matmap = new HashMap<>();
                    matmap.put("no", "1." + noo);
                    matmap.put("id", "1." + noo);
                    matmap.put("costItems", materialContractEntity.getContractType());
                    matmap.put("contractName", materialContractEntity.getContractName());
                    matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    lwcontractamount = lwcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("taxRate", materialContractEntity.getTaxRate());
                    matmap.put("subName", materialContractEntity.getSubOrg());


                    matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    lwsettleNotax = lwsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                    lwsettleTax = lwsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                    lwsettle = lwsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));

                    BigDecimal ygnamount = costFinContractDetailMapper.queryForecastnotax(materialContractEntity.getContractId());
                    BigDecimal bgnamount = costFinContractDetailMapper.queryForecastChangenotax(materialContractEntity.getContractId());
                    BigDecimal notax = ygnamount.add(bgnamount);
                    matmap.put("forecastNotax", notax.setScale(2, RoundingMode.HALF_UP));
                    lwforecastamountNotax = lwforecastamountNotax.add(notax.setScale(2, RoundingMode.HALF_UP));

                    BigDecimal ygtaxamount = costFinContractDetailMapper.queryForecasttax(materialContractEntity.getContractId());
                    BigDecimal bgtaxamount = costFinContractDetailMapper.queryForecastChangetax(materialContractEntity.getContractId());
                    BigDecimal tax = ygtaxamount.add(bgtaxamount);
                    matmap.put("forecastTax", tax.setScale(2, RoundingMode.HALF_UP));
                    lwforecastamountTax = lwforecastamountTax.add(tax.setScale(2, RoundingMode.HALF_UP));

                    BigDecimal ygamount = costFinContractDetailMapper.queryForecastamount(materialContractEntity.getContractId());
                    BigDecimal bgamount = costFinContractDetailMapper.queryForecastChangeamount(materialContractEntity.getContractId());
                    BigDecimal amount = ygamount.add(bgamount);
                    matmap.put("forecastAmount", amount.setScale(2, RoundingMode.HALF_UP));
                    lwforecastamount = lwforecastamount.add(amount.setScale(2, RoundingMode.HALF_UP));

//                    G=A+D
                    BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP).add
                            (notax.setScale(2, RoundingMode.HALF_UP));
                    matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                    lwallamount = lwallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                    newChildren.add(matmap);
                }
            }
            lw.put("children", newChildren);
            lw.put("contractAmount", lwcontractamount);
            lw.put("settleNotax", lwsettleNotax);
            lw.put("settleTax", lwsettleTax);
            lw.put("settleAmount", lwsettle);
            lw.put("forecastNotax", lwforecastamountNotax);
            lw.put("forecastTax", lwforecastamountTax);
            lw.put("forecastAmount", lwforecastamount);
            lw.put("allCostNotax", lwallamount);
            alldata.set(0, lw);

            ///////////////////////////////////////////////////////2.材料费（材料合同、含周转材租赁）
            Map<String, Object> cl = new HashMap<>();
            cl.put("no", "2");
            cl.put("id", "2");
            cl.put("costItems", "材料费（材料合同、含周转材租赁）");

            Integer allsize = alldata.size();
            alldata.add(cl);

            BigDecimal clcontractamount = new BigDecimal("0");
            BigDecimal clsettleNotax = new BigDecimal("0");
            BigDecimal clsettleTax = new BigDecimal("0");
            BigDecimal clsettle = new BigDecimal("0");
            BigDecimal clallamount = new BigDecimal("0");
            List<Map<String, Object>> newChildren2 = new ArrayList<>();
            if(matlist != null && matlist.size()>0){
                for (int s = 0; s < matlist.size(); s++) {
                    ForecastMaterialcontractDetailEntity materialContractEntity = matlist.get(s);
                    Integer no = s;
                    Integer noo = no + 1;
                    Map<String, Object> matmap = new HashMap<>();
                    matmap.put("no", "2." + noo);
                    matmap.put("id", "2." + noo);
                    matmap.put("costItems", materialContractEntity.getContractType());
                    matmap.put("contractName", materialContractEntity.getContractName());
                    matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    clcontractamount = clcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("taxRate", materialContractEntity.getTaxRate());
                    matmap.put("subName", materialContractEntity.getSubOrg());


                    matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    clsettleNotax = clsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                    clsettleTax = clsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                    clsettle = clsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));

                    BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                    matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                    clallamount = clallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                    newChildren2.add(matmap);
                }
            }
            cl.put("children", newChildren2);
            cl.put("contractAmount", clcontractamount);
            cl.put("settleNotax", clsettleNotax);
            cl.put("settleTax", clsettleTax);
            cl.put("settleAmount", clsettle);
            cl.put("allCostNotax", clallamount);
            alldata.set(allsize, cl);

            ///////////////////////////////////////////////////////3.机械费（机械合同、含设备采购）
            Map<String, Object> jx = new HashMap<>();
            jx.put("no", "3");
            jx.put("id", "3");
            jx.put("costItems", "机械费（机械合同、含设备采购）");

            Integer jxsize = alldata.size();
            alldata.add(jx);

            BigDecimal jxcontractamount = new BigDecimal("0");
            BigDecimal jxsettleNotax = new BigDecimal("0");
            BigDecimal jxsettleTax = new BigDecimal("0");
            BigDecimal jxsettle = new BigDecimal("0");
            BigDecimal jxallamount = new BigDecimal("0");
            List<Map<String, Object>> newChildren3 = new ArrayList<>();
            if(maclist != null && maclist.size()>0){
                for (int s = 0; s < maclist.size(); s++) {
                    ForecastMachinecontractDetailEntity materialContractEntity = maclist.get(s);
                    Integer no = s;
                    Integer noo = no + 1;
                    Map<String, Object> matmap = new HashMap<>();
                    matmap.put("no", "3." + noo);
                    matmap.put("id", "3." + noo);
                    matmap.put("costItems", materialContractEntity.getContractType());
                    matmap.put("contractName", materialContractEntity.getContractName());
                    matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    jxcontractamount = jxcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("taxRate", materialContractEntity.getTaxRate());
                    matmap.put("subName", materialContractEntity.getSubOrg());


                    matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    jxsettleNotax = jxsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                    jxsettleTax = jxsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                    jxsettle = jxsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));

                    BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                    matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                    jxallamount = jxallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                    newChildren3.add(matmap);
                }
            }
            jx.put("children", newChildren3);
            jx.put("contractAmount", jxcontractamount);
            jx.put("settleNotax", jxsettleNotax);
            jx.put("settleTax", jxsettleTax);
            jx.put("settleAmount", jxsettle);
            jx.put("allCostNotax", jxallamount);
            alldata.set(jxsize, jx);

            ///////////////////////////////////////////////////////4.专业分包工程费（专业分包合同）
            Map<String, Object> zy = new HashMap<>();
            zy.put("no", "4");
            zy.put("id", "4");
            zy.put("costItems", "专业分包工程费（专业分包合同）");

            Integer zysize = alldata.size();
            alldata.add(zy);

            BigDecimal zycontractamount = new BigDecimal("0");
            BigDecimal zysettleNotax = new BigDecimal("0");
            BigDecimal zysettleTax = new BigDecimal("0");
            BigDecimal zysettle = new BigDecimal("0");
            BigDecimal zyforecastamountNotax = new BigDecimal("0");
            BigDecimal zyforecastamountTax = new BigDecimal("0");
            BigDecimal zyforecastamount = new BigDecimal("0");
            BigDecimal zyallamount = new BigDecimal("0");
            List<Map<String, Object>> newChildren4 = new ArrayList<>();
            if(zysublist != null && zysublist.size()>0){
                for (int s = 0; s < zysublist.size(); s++) {
                    ForecastContractDetailEntity materialContractEntity = zysublist.get(s);
                    Integer no = s;
                    Integer noo = no + 1;
                    Map<String, Object> matmap = new HashMap<>();
                    matmap.put("no", "4." + noo);
                    matmap.put("id", "4." + noo);
                    matmap.put("costItems", materialContractEntity.getContractType());
                    matmap.put("contractName", materialContractEntity.getContractName());
                    matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    zycontractamount = zycontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("taxRate", materialContractEntity.getTaxRate());
                    matmap.put("subName", materialContractEntity.getSubOrg());




                    matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    zysettleNotax = zysettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                    zysettleTax = zysettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                    matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                    zysettle = zysettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));

                    BigDecimal ygnamount = costFinContractDetailMapper.queryForecastnotax(materialContractEntity.getContractId());
                    BigDecimal bgnamount = costFinContractDetailMapper.queryForecastChangenotax(materialContractEntity.getContractId());
                    BigDecimal notax = ygnamount.add(bgnamount);
                    matmap.put("forecastNotax", notax.setScale(2, RoundingMode.HALF_UP));
                    zyforecastamountNotax = zyforecastamountNotax.add(notax.setScale(2, RoundingMode.HALF_UP));

                    BigDecimal ygtaxamount = costFinContractDetailMapper.queryForecasttax(materialContractEntity.getContractId());
                    BigDecimal bgtaxamount = costFinContractDetailMapper.queryForecastChangetax(materialContractEntity.getContractId());
                    BigDecimal tax = ygtaxamount.add(bgtaxamount);
                    matmap.put("forecastTax", tax.setScale(2, RoundingMode.HALF_UP));
                    zyforecastamountTax = zyforecastamountTax.add(tax.setScale(2, RoundingMode.HALF_UP));

                    BigDecimal ygamount = costFinContractDetailMapper.queryForecastamount(materialContractEntity.getContractId());
                    BigDecimal bgamount = costFinContractDetailMapper.queryForecastChangeamount(materialContractEntity.getContractId());
                    BigDecimal amount = ygamount.add(bgamount);
                    matmap.put("forecastAmount", amount.setScale(2, RoundingMode.HALF_UP));
                    zyforecastamount = zyforecastamount.add(amount.setScale(2, RoundingMode.HALF_UP));

                    BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP).add
                            (notax.setScale(2, RoundingMode.HALF_UP));
                    matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                    zyallamount = zyallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                    newChildren4.add(matmap);
                }
            }
            zy.put("children", newChildren4);
            zy.put("contractAmount", zycontractamount);
            zy.put("settleNotax", zysettleNotax);
            zy.put("settleTax", zysettleTax);
            zy.put("settleAmount", zysettle);
            zy.put("forecastNotax", zyforecastamountNotax);
            zy.put("forecastTax", zyforecastamountTax);
            zy.put("forecastAmount", zyforecastamount);
            zy.put("allCostNotax", zyallamount);
            alldata.set(zysize, zy);

            ///////////////////////////////////////////////////////5.其他费用（有合同的）
            Map<String, Object> oc = new HashMap<>();
            oc.put("no", "5");
            oc.put("id", "5");
            oc.put("costItems", "其他费用（有合同的）");

            Integer ocsize = alldata.size();
            alldata.add(oc);

            BigDecimal occontractamount = new BigDecimal("0");
            BigDecimal ocsettleNotax = new BigDecimal("0");
            BigDecimal ocsettleTax = new BigDecimal("0");
            BigDecimal ocsettle = new BigDecimal("0");
            BigDecimal ocallamount = new BigDecimal("0");
            List<Map<String, Object>> newChildren5 = new ArrayList<>();
            for (int s = 0; s < oclist.size(); s++) {
                ForecastOthercontractDetailEntity materialContractEntity = oclist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "5." + noo);
                matmap.put("id", "5." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                occontractamount = occontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());


                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                ocsettleNotax = ocsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                ocsettleTax = ocsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                ocsettle = ocsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));

                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                ocallamount = ocallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                newChildren5.add(matmap);
            }
            oc.put("children", newChildren5);
            oc.put("contractAmount", occontractamount);
            oc.put("settleNotax", ocsettleNotax);
            oc.put("settleTax", ocsettleTax);
            oc.put("settleAmount", ocsettle);
            oc.put("allCostNotax", ocallamount);
            alldata.set(ocsize, oc);

            ///////////////////////////////////////////////////////6.其他费用（无合同的间接费）
            Map<String, Object> ot = new HashMap<>();
            ot.put("no", "6");
            ot.put("id", "6");
            ot.put("costItems", "其他费用（无合同的间接费）");

            Integer otsize = alldata.size();
            alldata.add(ot);

            BigDecimal otsettleNotax = new BigDecimal("0");
            BigDecimal zOtsettleNotax = BigDecimal.ZERO;
            BigDecimal ygOtherNotax = BigDecimal.ZERO;
            BigDecimal forecastTaxSum = BigDecimal.ZERO;
            BigDecimal forecastAmountSum = BigDecimal.ZERO;
            List<Long> subjectIdList = new ArrayList<>();
            List<Map<String, Object>> newChildren6 = new ArrayList<>();
            if(othlist != null && othlist.size()>0){
                for (int t = 0; t < othlist.size(); t++) {
                    CostFinOtherDetailEntity materialContractEntity = othlist.get(t);
                    Integer no = t;
                    Integer noo = no + 1;
                    Map<String, Object> matmap = new HashMap<>();
                    matmap.put("no", "6." + noo);
                    matmap.put("id", "6." + noo);
                    String fylb = forecastOtherDetailMapper.querytypename(materialContractEntity.getCostTypeId());
                    matmap.put("contractName",fylb);

                    String objid = String.valueOf(materialContractEntity.getId());

                    String cbkm = forecastOtherDetailMapper.queryname(materialContractEntity.getSubjectId());
                    subjectIdList.add(materialContractEntity.getSubjectId());
                    matmap.put("taxRate",cbkm);

//                        matmap.put("settleNotax", BigDecimal.ZERO);
//                        zOtsettleNotax = zOtsettleNotax.add(materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
//                        matmap.put("forecastNotax",materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
//                        matmap.put("forecastTax",materialContractEntity.getTaxMny().setScale(2,RoundingMode.HALF_UP));
//                        matmap.put("forecastAmount",materialContractEntity.getEstimatedTaxAmount().setScale(2,RoundingMode.HALF_UP));
//                        matmap.put("allCostNotax", materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
//                        forecastTaxSum = forecastTaxSum.add(materialContractEntity.getTaxMny().setScale(2,RoundingMode.HALF_UP));
//                        forecastAmountSum = forecastAmountSum.add(materialContractEntity.getEstimatedTaxAmount().setScale(2,RoundingMode.HALF_UP));
//                        ygOtherNotax = ygOtherNotax.add(materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                    SimpleDateFormat smart = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String formatdate = smart.format(costClosingForecastEntity.getCreateTime());

                    BigDecimal settleAmount = forecastOtherDetailMapper.queryPaymnytime(projectId,materialContractEntity.getSubjectId(),formatdate);

                    matmap.put("settleAmount", settleAmount.setScale(2, RoundingMode.HALF_UP));
                    otsettleNotax = otsettleNotax.add(settleAmount.setScale(2, RoundingMode.HALF_UP));

                    matmap.put("allCostNotax", settleAmount.setScale(2, RoundingMode.HALF_UP));

                    zOtsettleNotax = zOtsettleNotax.add(settleAmount.setScale(2, RoundingMode.HALF_UP));

                    newChildren6.add(matmap);
                }
            }


//        缺失查询变更逻辑
//                QueryParam param = new QueryParam();
//                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
//                param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//                param.getOrderMap().put("subjectCode", "asc");
//                List<SubjectProjectEntity> list = subjectProjectService.queryList(param, false);
//                if (list == null || list.size() == 0) {
//                    return new ArrayList<>();
//                }
//                List<ProjectSubjectVO> res = BeanMapper.mapList(list, ProjectSubjectVO.class);
//                List<Long> subjectIds = new ArrayList<>();
//                for (ProjectSubjectVO projectSubjectVO : res){
//                    subjectIds.add(projectSubjectVO.getId());
//                }
//                List<Long> resultList = new ArrayList<>(Stream.concat(subjectIds.stream(), subjectIdList.stream())
//                        .distinct()
//                        .collect(Collectors.toList()));



//                QueryParam queryParam = new QueryParam();
//                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
//                queryParam.getParams().put("subjectId", new Parameter(QueryParam.IN, resultList));
//                queryParam.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
//                queryParam.getOrderMap().put("createTime", QueryParam.DESC);
//                List<Map<String,Object>> entityList = forecastOtherDetailMapper.queryPayReimList(projectId,resultList);

//                for (int i=0;i<othlist.size();i++){
//                    Map<String,Object> payReimburseEntity = othlist.get(i);
//                    Integer no = i;
//                    Integer noo = no + 1;
//                    Map<String, Object> matmap = new HashMap<>();
//                    matmap.put("no", "6." + noo);
//                    matmap.put("id", "6." + noo);
//
//                    String objid = String.valueOf(payReimburseEntity.get("id"));
//                    String typename = forecastOtherDetailMapper.querytype(projectId,Long.parseLong(objid));
//                    String changetypename = forecastOtherDetailMapper.querytypechange(projectId,Long.parseLong(objid));
//
//                    if(typename == null){
//                        matmap.put("contractName",changetypename);
//                    }else{
//                        matmap.put("contractName",typename);
//                    }
//
//                    matmap.put("taxRate",payReimburseEntity.get("subjectName"));
//
//
//                    BigDecimal settleAmount = forecastOtherDetailMapper.queryPaymny(projectId,Long.parseLong(objid));
//
//                    matmap.put("settleAmount", settleAmount.setScale(2, RoundingMode.HALF_UP));
//                    otsettleNotax = otsettleNotax.add(settleAmount.setScale(2, RoundingMode.HALF_UP));
//
//                    matmap.put("allCostNotax", settleAmount.setScale(2, RoundingMode.HALF_UP));
//
//                    zOtsettleNotax = zOtsettleNotax.add(settleAmount.setScale(2, RoundingMode.HALF_UP));
//                    newChildren6.add(matmap);
//                }
            ot.put("children", newChildren6);
//                ot.put("forecastNotax",ygOtherNotax);
            ot.put("settleAmount", otsettleNotax);
//                ot.put("forecastTax",forecastTaxSum);
//                ot.put("forecastAmount",forecastAmountSum);
            //10.9注
            ot.put("allCostNotax", zOtsettleNotax);
            alldata.set(otsize, ot);

            ///////////////////////////////////////////////////////7.其他预估成本
            BigDecimal zOtsettleNotaxSum = BigDecimal.ZERO;
            Map<String, Object> ot00 = new HashMap<>();
            ot00.put("no", "7");
            ot00.put("id", "7");
            ot00.put("costItems", "其他预估成本");

            Integer ot0size = alldata.size();
            alldata.add(ot00);
            List<Map<String, Object>> newChildren7 = new ArrayList<>();
            Map<String, Object> ot1 = new HashMap<>();
            ot1.put("no", "7.1");
            ot1.put("id", "7.1");
            ot1.put("costItems", "间接费预估");
            BigDecimal jjtotalnt = forecastOtherDetailMapper.queryjjtotal(projectId);
            ot1.put("forecastNotax", jjtotalnt);
            BigDecimal jjtotalt = forecastOtherDetailMapper.queryjjtotaltax(projectId);
            ot1.put("forecastTax", jjtotalt);
            BigDecimal jjtotal = forecastOtherDetailMapper.queryjjtotalamount(projectId);
            ot1.put("forecastAmount", jjtotal);
            ot1.put("allCostNotax", jjtotalnt);
            zOtsettleNotaxSum = zOtsettleNotaxSum.add(jjtotalnt);

//            Integer ot1size = alldata.size();
            newChildren7.add(ot1);
            Map<String, Object> ot2 = new HashMap<>();
            ot2.put("no", "7.2");
            ot2.put("id", "7.2");
            ot2.put("costItems", "收尾阶段发生的其他费预估");
            BigDecimal qttotalnt = forecastOtherDetailMapper.queryqttotal(projectId);
            ot2.put("forecastNotax", qttotalnt);
            BigDecimal qttotalt = forecastOtherDetailMapper.queryqttotaltax(projectId);
            ot2.put("forecastTax", qttotalt);
            BigDecimal qttotal = forecastOtherDetailMapper.queryqttotalamount(projectId);
            ot2.put("forecastAmount", qttotal);
            ot2.put("allCostNotax", qttotalnt);
            zOtsettleNotaxSum = zOtsettleNotaxSum.add(qttotalnt);

//            Integer ot2size = alldata.size();
            newChildren7.add(ot2);
            ot00.put("children", newChildren7);
            ot00.put("forecastNotax", jjtotalnt.add(qttotalnt));
            ot00.put("forecastTax", jjtotalt.add(qttotalt));
            ot00.put("forecastAmount", jjtotal.add(qttotal));
            ot00.put("allCostNotax", zOtsettleNotaxSum);
            alldata.set(ot0size, ot00);
//            }
//        }

            return alldata;
        }else{
            throw new BusinessException("当前项目尚未创建成本预估单，请先创建。");
        }

    }

    //表4
    @Override
    public List<Map<String,Object>> projectCompletionSumRealtime(Long projectId) {
//        Long sumId = costClosingForecastChangeMapper.queryId(projectId);
        Integer idtotal = costClosingForecastChangeMapper.queryIdtotal(projectId);
        if(idtotal != 0){
            List<Map<String,Object>> alldata = new ArrayList<>();
//        if(sumId != null){
            //分包，其他费都是查询预估单+变更单全部数据，需二次遍历
            List<ForecastContractDetailChangeEntity> sublistlw = forecastContractDetailChangeMapper.querySubContractByProjectIdLWALL(projectId);
            List<ForecastContractDetailChangeEntity> zysublistzy = forecastContractDetailChangeMapper.querySubContractByProjectIdZYALL(projectId);
//            List<ForecastOtherDetailChangeEntity> othlistot = forecastContractDetailChangeMapper.querySubjectByProjectIdALL(projectId);
            List<CostFinOtherDetailEntity> othlistot = costFinOtherDetailMapper.querySubjectByProjectId(String.valueOf(projectId));
            List<ForecastChangeMaterialcontractDetailEntity> matlist = forecastContractDetailChangeMapper.queryMaterialdetailALL(projectId);
            List<ForecastChangeMachinecontractDetailEntity> maclist = forecastContractDetailChangeMapper.queryMachinedetailALL(projectId);
            List<ForecastChangeOthercontractDetailEntity> oclist = forecastContractDetailChangeMapper.queryOtherdetailALL(projectId);

            ///////////////////////////////////////////////////////1.劳务分包费（劳务分包合同）
            Map<String,Object> lw = new HashMap<>();
            lw.put("no","1");
            lw.put("id","1");
            lw.put("costItems","劳务分包费（劳务分包合同）");

            alldata.add(lw);

            BigDecimal lwcontractamount = new BigDecimal("0");
            BigDecimal lwsettleNotax = new BigDecimal("0");
            BigDecimal lwforecastamount = new BigDecimal("0");
            BigDecimal lwallamount = new BigDecimal("0");
            List<Map<String, Object>> newChildren = new ArrayList<>();
            if(sublistlw != null && sublistlw.size()>0){
                //遍历查询到的劳务子表数据，只取最新的数据
                List<ForecastContractDetailChangeEntity> sublist = new ArrayList<>();
                //遍历全部数据
                for(ForecastContractDetailChangeEntity entity :sublistlw){
                    //遍历比较，若已存在则替换，不存在则新增
                    if(sublist != null && sublist.size()>0){
                        String iscf = "N";
                        for(int a = 0; a<sublist.size();a++){
                            ForecastContractDetailChangeEntity ent = sublist.get(a);
                            if(ent.getContractId().equals(entity.getContractId())){
                                if(entity.getCreateTime().compareTo(ent.getCreateTime()) == 1){
                                    iscf = "Y";
                                    sublist.set(a,entity);
                                }else{
                                    iscf = "Y";
                                }
                            }
                        }
                        if(iscf == "N"){
                            sublist.add(entity);
                        }
                    }else{
                        //第一次遍历，直接新增
                        sublist.add(entity);
                    }
                }
                for(int s = 0;s<sublist.size();s++){
                    ForecastContractDetailChangeEntity materialContractEntity =sublist.get(s);
                    Integer no = s;
                    Integer noo = no+1;
                    Map<String,Object> matmap = new HashMap<>();
                    matmap.put("no","1."+ noo);
                    matmap.put("id","1."+ noo);
                    matmap.put("costItems",materialContractEntity.getContractType());
                    matmap.put("contractName",materialContractEntity.getContractName());
                    matmap.put("contractAmount",materialContractEntity.getContractAmount().setScale(2,RoundingMode.HALF_UP));
                    lwcontractamount = lwcontractamount.add(materialContractEntity.getContractAmount().setScale(2,RoundingMode.HALF_UP));
                    matmap.put("taxRate",materialContractEntity.getTaxRate());
                    matmap.put("subName",materialContractEntity.getSubOrg());

                    //不含税已结算
                    matmap.put("settleNotax",materialContractEntity.getAmountSettledNotax().setScale(2,RoundingMode.HALF_UP));
                    lwsettleNotax = lwsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2,RoundingMode.HALF_UP));

                    BigDecimal ygamount = costFinContractDetailMapper.queryForecastnotax(materialContractEntity.getContractId());
                    matmap.put("forecastamount",ygamount.setScale(2,RoundingMode.HALF_UP));
                    lwforecastamount = lwforecastamount.add(ygamount.setScale(2,RoundingMode.HALF_UP));

                    matmap.put("klamountnotax",new BigDecimal("0"));

                    BigDecimal bgamount = costFinContractDetailMapper.queryForecastChangenotax(materialContractEntity.getContractId());
                    matmap.put("forecastchangeamount",bgamount.setScale(2,RoundingMode.HALF_UP));

                    BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2,RoundingMode.HALF_UP).add(ygamount).add(bgamount);
                    matmap.put("allamount",allamount.setScale(2,RoundingMode.HALF_UP));
                    lwallamount = lwallamount.add(allamount.setScale(2,RoundingMode.HALF_UP));

                    newChildren.add(matmap);
                }
            }
            lw.put("children", newChildren);
            lw.put("contractAmount",lwcontractamount);
            lw.put("settleNotax",lwsettleNotax);
            lw.put("forecastamount",lwforecastamount);
            lw.put("allamount",lwallamount);
            alldata.set(0,lw);

            ///////////////////////////////////////////////////////2.材料费（材料合同、含周转材租赁）
            Map<String,Object> cl = new HashMap<>();
            cl.put("no","2");
            cl.put("id","2");
            cl.put("costItems","材料费（材料合同、含周转材租赁）");

            Integer allsize = alldata.size();
            alldata.add(cl);

            BigDecimal clcontractamount = new BigDecimal("0");
            BigDecimal clsettleNotax = new BigDecimal("0");
            List<Map<String, Object>> newChildren2 = new ArrayList<>();
            if(matlist != null && matlist.size()>0){
                for(int m = 0;m<matlist.size();m++){
                    ForecastChangeMaterialcontractDetailEntity materialContractEntity =matlist.get(m);
                    Integer no = m;
                    Integer noo = no+1;
                    Map<String,Object> matmap = new HashMap<>();
                    matmap.put("no","2."+ noo);
                    matmap.put("id","2."+ noo);
                    matmap.put("costItems",materialContractEntity.getContractType());
                    matmap.put("contractName",materialContractEntity.getContractName());
                    matmap.put("contractAmount",materialContractEntity.getContractAmount().setScale(2,RoundingMode.HALF_UP));
                    clcontractamount = clcontractamount.add(materialContractEntity.getContractAmount().setScale(2,RoundingMode.HALF_UP));
                    matmap.put("taxRate",materialContractEntity.getTaxRate());
                    matmap.put("subName",materialContractEntity.getSubOrg());


                    matmap.put("settleNotax",materialContractEntity.getAmountSettledNotax().setScale(2,RoundingMode.HALF_UP));
                    clsettleNotax = clsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2,RoundingMode.HALF_UP));

//                matmap.put("forecastamount","——");

                    matmap.put("klamountnotax",new BigDecimal("0"));

//                matmap.put("forecastchangeamount","——");

                    matmap.put("allamount",materialContractEntity.getAmountSettledNotax().setScale(2,RoundingMode.HALF_UP));
                    newChildren2.add(matmap);
                }
            }
            cl.put("children", newChildren2);
            cl.put("contractAmount",clcontractamount);
            cl.put("settleNotax",clsettleNotax);
            cl.put("allamount",clsettleNotax);
            alldata.set(allsize,cl);

            ///////////////////////////////////////////////////////3.机械费（机械合同、含设备采购）
            Map<String,Object> jx = new HashMap<>();
            jx.put("no","3");
            jx.put("id","3");
            jx.put("costItems","机械费（机械合同、含设备采购）");

            Integer jxsize = alldata.size();
            alldata.add(jx);

            BigDecimal jxcontractamount = new BigDecimal("0");
            BigDecimal jxsettleNotax = new BigDecimal("0");
            List<Map<String, Object>> newChildren3 = new ArrayList<>();
            if(maclist != null && maclist.size()>0){
                for(int j = 0;j<maclist.size();j++){
                    ForecastChangeMachinecontractDetailEntity materialContractEntity =maclist.get(j);
                    Integer no = j;
                    Integer noo = no+1;
                    Map<String,Object> matmap = new HashMap<>();
                    matmap.put("no","3."+ noo);
                    matmap.put("id","3."+ noo);
                    matmap.put("costItems",materialContractEntity.getContractType());
                    matmap.put("contractName",materialContractEntity.getContractName());
                    matmap.put("contractAmount",materialContractEntity.getContractAmount().setScale(2,RoundingMode.HALF_UP));
                    jxcontractamount = jxcontractamount.add(materialContractEntity.getContractAmount().setScale(2,RoundingMode.HALF_UP));
                    matmap.put("taxRate",materialContractEntity.getTaxRate());
                    matmap.put("subName",materialContractEntity.getSubOrg());


                    matmap.put("settleNotax",materialContractEntity.getAmountSettledNotax().setScale(2,RoundingMode.HALF_UP));
                    jxsettleNotax = jxsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2,RoundingMode.HALF_UP));

                    matmap.put("forecastamount","——");

                    matmap.put("klamountnotax",new BigDecimal("0"));

                    matmap.put("forecastchangeamount","——");

                    matmap.put("allamount",materialContractEntity.getAmountSettledNotax().setScale(2,RoundingMode.HALF_UP));
                    newChildren3.add(matmap);
                }
            }
            jx.put("children", newChildren3);
            jx.put("contractAmount",jxcontractamount);
            jx.put("settleNotax",jxsettleNotax);
            jx.put("allamount",jxsettleNotax);
            alldata.set(jxsize,jx);

            ///////////////////////////////////////////////////////4.专业分包工程费（专业分包合同）
            Map<String,Object> zy = new HashMap<>();
            zy.put("no","4");
            zy.put("id","4");
            zy.put("costItems","专业分包工程费（专业分包合同）");

            Integer zysize = alldata.size();
            alldata.add(zy);

            BigDecimal zycontractamount = new BigDecimal("0");
            BigDecimal zysettleNotax = new BigDecimal("0");
            BigDecimal zyforecastamount = new BigDecimal("0");
            BigDecimal zyallamount = new BigDecimal("0");
            List<Map<String, Object>> newChildren4 = new ArrayList<>();
            if(zysublistzy != null && zysublistzy.size()>0){
                //遍历查询到的劳务子表数据，只取最新的数据
                List<ForecastContractDetailChangeEntity> zysublist = new ArrayList<>();
                //遍历全部数据
                for(ForecastContractDetailChangeEntity entity :zysublistzy){
                    //遍历比较，若已存在则替换，不存在则新增
                    if(zysublist != null && zysublist.size()>0){
                        String iscf = "N";
                        for(int a = 0; a<zysublist.size();a++){
                            ForecastContractDetailChangeEntity ent = zysublist.get(a);
                            if(ent.getContractId().equals(entity.getContractId())){
                                if(entity.getCreateTime().compareTo(ent.getCreateTime()) == 1){
                                    iscf = "Y";
                                    zysublist.set(a,entity);
                                }else{
                                    iscf = "Y";
                                }
                            }
                        }
                        if(iscf == "N"){
                            zysublist.add(entity);
                        }
                    }else{
                        //第一次遍历，直接新增
                        zysublist.add(entity);
                    }
                }
                for(int z = 0;z<zysublist.size();z++){
                    ForecastContractDetailChangeEntity materialContractEntity =zysublist.get(z);
                    Integer no = z;
                    Integer noo = no+1;
                    Map<String,Object> matmap = new HashMap<>();
                    matmap.put("no","4."+ noo);
                    matmap.put("id","4."+ noo);
                    matmap.put("costItems",materialContractEntity.getContractType());
                    matmap.put("contractName",materialContractEntity.getContractName());
                    matmap.put("contractAmount",materialContractEntity.getContractAmount().setScale(2,RoundingMode.HALF_UP));
                    zycontractamount = zycontractamount.add(materialContractEntity.getContractAmount().setScale(2,RoundingMode.HALF_UP));
                    matmap.put("taxRate",materialContractEntity.getTaxRate());
                    matmap.put("subName",materialContractEntity.getSubOrg());


                    matmap.put("settleNotax",materialContractEntity.getAmountSettledNotax().setScale(2,RoundingMode.HALF_UP));
                    zysettleNotax = zysettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2,RoundingMode.HALF_UP));

                    BigDecimal ygamount = costFinContractDetailMapper.queryForecastnotax(materialContractEntity.getContractId());
                    matmap.put("forecastamount",ygamount.setScale(2,RoundingMode.HALF_UP));
                    zyforecastamount = zyforecastamount.add(ygamount.setScale(2,RoundingMode.HALF_UP));

                    matmap.put("klamountnotax",new BigDecimal("0"));

                    BigDecimal bgamount = costFinContractDetailMapper.queryForecastChangenotax(materialContractEntity.getContractId());
                    matmap.put("forecastchangeamount",bgamount.setScale(2,RoundingMode.HALF_UP));

                    BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2,RoundingMode.HALF_UP).add(ygamount).add(bgamount);
                    matmap.put("allamount",allamount.setScale(2,RoundingMode.HALF_UP));
                    zyallamount = zyallamount.add(allamount.setScale(2,RoundingMode.HALF_UP));

                    newChildren4.add(matmap);
                }
            }
            zy.put("children", newChildren4);
            zy.put("contractAmount",zycontractamount);
            zy.put("settleNotax",zysettleNotax);
            zy.put("forecastamount",zyforecastamount);
            zy.put("allamount",zyallamount);
            alldata.set(zysize,zy);

            ///////////////////////////////////////////////////////5.其他费用（有合同的）
            Map<String,Object> oc = new HashMap<>();
            oc.put("no","5");
            oc.put("id","5");
            oc.put("costItems","其他费用（有合同的）");

            Integer ocsize = alldata.size();
            alldata.add(oc);

            BigDecimal occontractamount = new BigDecimal("0");
            BigDecimal ocsettleNotax = new BigDecimal("0");
            List<Map<String, Object>> newChildren5 = new ArrayList<>();
            if(oclist != null && oclist.size()>0){
                for(int c = 0;c<oclist.size();c++){
                    ForecastChangeOthercontractDetailEntity materialContractEntity =oclist.get(c);
                    Integer no = c;
                    Integer noo = no+1;
                    Map<String,Object> matmap = new HashMap<>();
                    matmap.put("no","5."+ noo);
                    matmap.put("id","5."+ noo);
                    matmap.put("costItems","间接费合同");
                    matmap.put("contractName",materialContractEntity.getContractName());
                    matmap.put("contractAmount",materialContractEntity.getContractAmount().setScale(2,RoundingMode.HALF_UP));
                    occontractamount = occontractamount.add(materialContractEntity.getContractAmount().setScale(2,RoundingMode.HALF_UP));
                    matmap.put("taxRate",materialContractEntity.getTaxRate());
                    matmap.put("subName",materialContractEntity.getSubOrg());


                    matmap.put("settleNotax",materialContractEntity.getAmountSettledNotax().setScale(2,RoundingMode.HALF_UP));
                    ocsettleNotax = ocsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2,RoundingMode.HALF_UP));

                    matmap.put("forecastamount","——");

                    matmap.put("klamountnotax",new BigDecimal("0"));

                    matmap.put("forecastchangeamount","——");

                    matmap.put("allamount",materialContractEntity.getAmountSettledNotax().setScale(2,RoundingMode.HALF_UP));
                    newChildren5.add(matmap);
                }
            }
            oc.put("children", newChildren5);
            oc.put("contractAmount",occontractamount);
            oc.put("settleNotax",ocsettleNotax);
            oc.put("allamount",ocsettleNotax);
            alldata.set(ocsize,oc);

            ///////////////////////////////////////////////////////6.其他费用（无合同的间接费）
            Map<String,Object> ot = new HashMap<>();
            ot.put("no","6");
            ot.put("id","6");
            ot.put("costItems","其他费用（无合同的间接费）");

            Integer otsize = alldata.size();
            alldata.add(ot);

            BigDecimal otsettleNotax = new BigDecimal("0");
            List<Map<String, Object>> newChildren6 = new ArrayList<>();
            if(othlistot != null && othlistot.size()>0) {
                //遍历查询到的劳务子表数据，只取最新的数据
//                List<CostFinOtherDetailEntity> othlist = new ArrayList<>();
                //遍历全部数据
//                for (CostFinOtherDetailEntity entity : othlistot) {
//                    //遍历比较，若已存在则替换，不存在则新增
//                    if (othlist != null && othlist.size() > 0) {
//                        String iscf = "N";
//                        for (int a = 0; a < othlist.size(); a++) {
//                            CostFinOtherDetailEntity ent = othlist.get(a);
//                            if (ent.getId().equals(entity.getSubjectId())) {
//                                if(entity.getCreateTime().compareTo(ent.getCreateTime()) == 1){
//                                    iscf = "Y";
//                                    othlist.set(a, entity);
//                                } else {
//                                    iscf = "Y";
//                                }
//                            }
//                        }
//                        if (iscf == "N") {
//                            othlist.add(entity);
//                        }
//                    } else {
//                        //第一次遍历，直接新增
//                        othlist.add(entity);
//                    }
//                }
                for (int t = 0; t < othlistot.size(); t++) {
                    CostFinOtherDetailEntity materialContractEntity = othlistot.get(t);
                    Integer no = t;
                    Integer noo = no + 1;
                    Map<String, Object> matmap = new HashMap<>();
                    matmap.put("no", "6." + noo);
                    matmap.put("id", "6." + noo);
//                    matmap.put("costItems",materialContractEntity.getName());
//                    String subjectname = new String();
//                    if(materialContractEntity.getSubjectId() != null){
//                        subjectname = forecastOtherDetailMapper.queryname(materialContractEntity.getSubjectId());
//                    }
//                    matmap.put("contractName",subjectname);
//                    matmap.put("settleNotax",materialContractEntity.getEstimatedTaxAmount().setScale(2,RoundingMode.HALF_UP));
//                    otsettleNotax = otsettleNotax.add(materialContractEntity.getEstimatedTaxAmount().setScale(2,RoundingMode.HALF_UP));
//
//                    matmap.put("allamount",materialContractEntity.getEstimatedTaxAmount().setScale(2,RoundingMode.HALF_UP));

                    Long objid = materialContractEntity.getSubjectId();

                    BigDecimal settleAmount = forecastOtherDetailMapper.queryPaymny(projectId, objid);

                    String typename = forecastOtherDetailMapper.querytype(projectId, objid);
                    String changetypename = forecastOtherDetailMapper.querytypechange(projectId, objid);

                    if (typename == null) {
                        matmap.put("contractName", changetypename);
                    } else {
                        matmap.put("contractName", typename);
                    }

//                    String subjectname = forecastOtherDetailMapper.queryname(Long.parseLong(materialContractEntity.getSubjectName()));

                    matmap.put("taxRate", materialContractEntity.getSubjectName());


                    matmap.put("settleNotax", settleAmount.setScale(2, RoundingMode.HALF_UP));
                    otsettleNotax = otsettleNotax.add(settleAmount.setScale(2, RoundingMode.HALF_UP));

                    matmap.put("allamount", settleAmount.setScale(2, RoundingMode.HALF_UP));

                    newChildren6.add(matmap);
                }
            }
            ot.put("children", newChildren6);
            ot.put("settleNotax",otsettleNotax);
            ot.put("allamount",otsettleNotax);
            alldata.set(otsize,ot);
//        QueryParam param = new QueryParam();
//        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getOrderMap().put("subjectCode", "asc");
//        List<SubjectProjectEntity> list = subjectProjectService.queryList(param, false);
//        if (list == null || list.size() == 0) {
//            return new ArrayList<>();
//        }
//        List<ProjectSubjectVO> res = BeanMapper.mapList(list, ProjectSubjectVO.class);
//        List<Long> subjectIds = new ArrayList<>();
//        for (ProjectSubjectVO projectSubjectVO : res){
//            subjectIds.add(projectSubjectVO.getId());
//        }
//        List<Map<String,Object>> entityList = forecastOtherDetailMapper.queryPayReimList(projectId,subjectIds);
//        for (int i=0;i<entityList.size();i++) {
//            Map<String, Object> payReimburseEntity = entityList.get(i);
//            Integer no = i;
//            Integer noo = no + 1;
//            Map<String, Object> matmap = new HashMap<>();
//            matmap.put("no", "6." + noo);
//            matmap.put("id", "6." + noo);
//
//            String objid = String.valueOf(payReimburseEntity.get("id"));
//
//            BigDecimal settleAmount = forecastOtherDetailMapper.queryPaymny(projectId,Long.parseLong(objid));
//
//            String typename = forecastOtherDetailMapper.querytype(projectId,Long.parseLong(objid));
//            String changetypename = forecastOtherDetailMapper.querytypechange(projectId,Long.parseLong(objid));
//
//            if(typename == null){
//                matmap.put("contractName",changetypename);
//            }else{
//                matmap.put("contractName",typename);
//            }
//
////            String subjectname = forecastOtherDetailMapper.queryname(Long.parseLong(objid));
//
//            matmap.put("taxRate",payReimburseEntity.get("subjectName"));
//
//
//            matmap.put("settleAmount", settleAmount.setScale(2, RoundingMode.HALF_UP));
//            otsettleNotax = otsettleNotax.add(settleAmount.setScale(2, RoundingMode.HALF_UP));
//
//            matmap.put("allCostNotax", settleAmount.setScale(2, RoundingMode.HALF_UP));
//            newChildren6.add(matmap);

            ///////////////////////////////////////////////////////7.其他预估成本
            Map<String,Object> ot00 = new HashMap<>();
            ot00.put("no","7");
            ot00.put("id","7");
            ot00.put("costItems","其他预估成本");

            Integer ot0size = alldata.size();
            alldata.add(ot00);
            List<Map<String, Object>> newChildren7 = new ArrayList<>();
            Map<String,Object> ot1 = new HashMap<>();
            ot1.put("no","7.1");
            ot1.put("id","7.1");
            ot1.put("costItems","间接费预估");
            BigDecimal jjtotal = forecastOtherDetailMapper.queryjjtotal(projectId);
            ot1.put("forecastamount",jjtotal);
            BigDecimal jjchangetotal = forecastOtherDetailMapper.queryjjchangetotal(projectId);
            ot1.put("forecastchangeamount",jjchangetotal);
            BigDecimal altotal = jjtotal.add(jjchangetotal);
            ot1.put("allamount",altotal);

//            Integer ot1size = alldata.size();
            newChildren7.add(ot1);

            Map<String,Object> ot2 = new HashMap<>();
            ot2.put("no","7.2");
            ot2.put("id","7.2");
            ot2.put("costItems","收尾阶段发生的其他费预估");
            BigDecimal qttotal = forecastOtherDetailMapper.queryqttotal(projectId);
            ot2.put("forecastamount",qttotal);
            BigDecimal qtchangetotal = forecastOtherDetailMapper.queryqtchangetotal(projectId);
            ot2.put("forecastchangeamount",qtchangetotal);
            BigDecimal qtaltotal = qttotal.add(qtchangetotal);
            ot2.put("allamount",qtaltotal);

//            Integer ot2size = alldata.size();
            newChildren7.add(ot2);

            ot00.put("children", newChildren7);
            ot00.put("forecastamount",qttotal.add(jjtotal));
            ot00.put("forecastchangeamount",jjchangetotal.add(qtchangetotal));
            ot00.put("allamount",altotal.add(qtaltotal));
            alldata.set(ot0size,ot00);


//        }

            return alldata;
        }else{
            throw new BusinessException("当前项目尚未创建成本预估变更单，请先创建。");
        }

    }

    @Override
    public JSONObject costSummaryList(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        List<SubjectCostVO> list = new ArrayList<>();
        Page<SubjectCostVO> pages = new Page<>(param.getPageIndex(), param.getPageSize());
        if(param.getParams().containsKey("subjectId") && param.getParams().containsKey("countMonth")){
            String countMonth = (String) param.getParams().get("countMonth").getValue();
            param.getParams().remove("countMonth");

            param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

            List<Long> orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
            param.getParams().put("projectDepartmentId",new Parameter(QueryParam.IN, orgIds));

            // 集团成本科目本下
            Long subjectId = Long.valueOf((String) param.getParams().get("subjectId").getValue());
            List<SubjectOrgVO> childList = subjectOrgService.getChildrenByPid(subjectId);
            param.getParams().put("subjectId",new Parameter(QueryParam.IN, childList.stream().map(SubjectOrgVO::getId).collect(Collectors.toList())));

            QueryWrapper wrapper = changeToQueryWrapper(param);
            list = baseMapper.subjectCostList(pages, wrapper, countMonth);

            // 汇总
            Map<String, SubjectCostVO> map = list.stream().collect(Collectors.toMap(x->x.getProjectId() + "-" + x.getSubjectId(), Function.identity()));
            if(CollectionUtils.isNotEmpty(list)) {
                for(SubjectCostVO vo : list){
                    String parentKey = vo.getProjectId() + "-" + subjectId;
                    SubjectCostVO parent = new SubjectCostVO();
                    if(map.containsKey(parentKey)){
                        if(!subjectId.equals(vo.getSubjectId())){
                            parent = map.get(parentKey);
                            parent.setMonthCostMny(ComputeUtil.safeAdd(parent.getMonthCostMny(), vo.getMonthCostMny()));
                            parent.setMonthCostTaxMny(ComputeUtil.safeAdd(parent.getMonthCostTaxMny(), vo.getMonthCostTaxMny()));
                            parent.setYearCostMny(ComputeUtil.safeAdd(parent.getYearCostMny(), vo.getYearCostMny()));
                            parent.setYearCostTaxMny(ComputeUtil.safeAdd(parent.getYearCostTaxMny(), vo.getYearCostTaxMny()));
                            parent.setTotalCostMny(ComputeUtil.safeAdd(parent.getTotalCostMny(), vo.getTotalCostMny()));
                            parent.setTotalCostTaxMny(ComputeUtil.safeAdd(parent.getTotalCostTaxMny(), vo.getTotalCostTaxMny()));
                        }
                    } else {
                        parent = BeanMapper.map(vo, SubjectCostVO.class);
                        parent.setSubjectId(subjectId);
                        map.put(parentKey, parent);
                    }
                }
            }
            // 过滤非选择集团成本科目数据
            list = new ArrayList<>();
            if(MapUtils.isNotEmpty(map)) {
                list = map.values().stream().filter(x->subjectId.equals(x.getSubjectId())).
                        sorted(Comparator.comparing(SubjectCostVO::getProjectId)).collect(Collectors.toList());
            }
        }
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());
        return page;

    }

    //报表1
    @Override
    public List<Map<String, Object>> revenueExpenditureSummary() {
        List<Map<String,Object>> alldata = new ArrayList<>();
        List<CostClosingForecastEntity> allproject = costClosingForecastMapper.revenueExpenditureSummary();
//        List<CostClosingLastEntity> allproject = costClosingLastMapper.revenueExpenditureSummary();

        if(allproject != null && allproject.size()>0){
            for(int s = 0;s<allproject.size();s++){
                CostClosingForecastEntity materialContractEntity =allproject.get(s);
                Long trueprojectId = materialContractEntity.getProjectId();
                Integer no = s;
                Integer noo = no+1;
                Map<String,Object> matmap = new HashMap<>();
                matmap.put("no", noo);
                matmap.put("projectName",materialContractEntity.getProjectName());

                String zt = costClosingForecastMapper.getprojectstatus(trueprojectId);
                String ztname = new String();
//            工程状态；0-未开工，1-在建，2-完工未验收，3-完工验收，4-已验收未结算，5-已结算
                if(zt != null){
                    if(zt.equals("0")){
                        ztname = "未开工";
                    }
                    if(zt.equals("1")){
                        ztname = "在建";
                    }
                    if(zt.equals("2")){
                        ztname = "完工未验收";
                    }
                    if(zt.equals("3")){
                        ztname = "完工验收";
                    }
                    if(zt.equals("4")){
                        ztname = "已验收未结算";
                    }
                    if(zt.equals("5")){
                        ztname = "已结算";
                    }
                }
                matmap.put("engineerType",ztname);

                CostClosingLastEntity entity = costClosingForecastMapper.querysubcontract(trueprojectId);

                BigDecimal sump = new BigDecimal("0");
                if(entity != null){
                    Date start = entity.getCompletionTime();
                    Date end = entity.getCompletionAcceptanceTime();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    if(start != null){

                        String startdateString = sdf.format(start);
                        matmap.put("actualStart",startdateString);
                    }
//                else{
//                    matmap.put("actualStart","--");
//                }
                    if(end != null){
                        String enddateString = sdf.format(end);
                        matmap.put("completionAcceptanceTime",enddateString);
                    }
//                else{
//                    matmap.put("completionAcceptanceTime","--");
//                }
//                matmap.put("actualStart",entity.getCompletionTime());
//                matmap.put("completionAcceptanceTime",entity.getCompletionAcceptanceTime());
                    matmap.put("projectCost",entity.getSumProductionTaxMny());
                    //开累不含税产值  A
                    matmap.put("sumProductionMny",entity.getSettlementTax());
                    //已计量不含税  B
                    matmap.put("calculateExcludtax",entity.getSumProductionMny());
                    sump = entity.getSumProductionMny();
                }

                BigDecimal maxsettlement = materialContractEntity.getMaxSettlement();
                if(maxsettlement == null){
                    maxsettlement = new BigDecimal("0");
                }

                // C
                matmap.put("maxSettlement",maxsettlement);
                // D
                BigDecimal conservativesettlement = materialContractEntity.getConservativeSettlement();
                if(conservativesettlement == null){
                    conservativesettlement = new BigDecimal("0");
                }
                matmap.put("conservativeSettlement",conservativesettlement);
                BigDecimal Damount = conservativesettlement;

                // E
                BigDecimal subsettle = costClosingForecastMapper.subsettle(trueprojectId);
                BigDecimal materialsettle = costClosingForecastMapper.materialsettle(trueprojectId);
                BigDecimal machinesettle = costClosingForecastMapper.machinesettle(trueprojectId);
                BigDecimal othersettle = costClosingForecastMapper.othersettle(trueprojectId);

                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String formatdate = format.format(materialContractEntity.getCreateTime());

//            BigDecimal ljfk = ;//此处放从预估单取到的累计付款额
                BigDecimal ljfk =  forecastOtherDetailMapper.queryPaymnybyprojectId(trueprojectId,formatdate);
                BigDecimal yjs = subsettle.add(materialsettle).add(machinesettle).add(othersettle).add(ljfk);
                matmap.put("closeCosty",yjs);
                //F
                BigDecimal subnotax = costClosingForecastMapper.subnotax(trueprojectId);
//            BigDecimal subchangenotax = costClosingForecastMapper.subchangenotax(trueprojectId);
                BigDecimal othnotax = costClosingForecastMapper.othnotax(trueprojectId);
//            BigDecimal othchangenotax = costClosingForecastMapper.othchangenotax(trueprojectId);
                BigDecimal yg = subnotax.add(othnotax);
                matmap.put("closeCostv",yg);
                //G = E+F
                BigDecimal wgzcb = yjs.add(yg);
                matmap.put("totalCost",wgzcb);
                // H = D-G
                BigDecimal lr = Damount.subtract(wgzcb);
                matmap.put("expectprofitax",lr);
                //I = H/D
                BigDecimal lrl = new BigDecimal("0.00");
                if(lr.compareTo(BigDecimal.ZERO) != 0 && Damount.compareTo(BigDecimal.ZERO) != 0){
                    BigDecimal hundred = new BigDecimal("100");
                    lrl = lr.divide(Damount,8,BigDecimal.ROUND_HALF_UP).multiply(hundred);
                    lrl = lrl.setScale(2,BigDecimal.ROUND_HALF_UP);
                }
                matmap.put("expectprofits",lrl);
                BigDecimal mblr = costClosingForecastMapper.querylrl(trueprojectId);
                matmap.put("targetprofitax",mblr);

                alldata.add(matmap);
            }
        }

        return alldata;
    }

    @Override
    public List<Map<String, Object>> ExpenditureSummaryRealTime() {
        List<Map<String,Object>> alldatareal = new ArrayList<>();
        List<CostClosingForecastChangeEntity> allrealproject = costClosingForecastChangeMapper.revenueExpenditureSummaryRealTime();
//        List<CostClosingLastEntity> allrealproject = costClosingLastMapper.revenueExpenditureSummaryRealTime();

        if(allrealproject != null && allrealproject.size()>0){
            for(int s = 0;s<allrealproject.size();s++){
                CostClosingForecastChangeEntity costClosingLastEntity =allrealproject.get(s);
                Long realprojectId = costClosingLastEntity.getProjectId();
                Integer no = s;
                Integer noo = no+1;
                Map<String,Object> matmap = new HashMap<>();
                matmap.put("no", noo);
                matmap.put("projectName",costClosingLastEntity.getProjectName());

                String zt = costClosingForecastMapper.getprojectstatus(realprojectId);
                String ztname = new String();
//            工程状态；0-未开工，1-在建，2-完工未验收，3-完工验收，4-已验收未结算，5-已结算
                if(zt != null){
                    if(zt.equals("0")){
                        ztname = "未开工";
                    }
                    if(zt.equals("1")){
                        ztname = "在建";
                    }
                    if(zt.equals("2")){
                        ztname = "完工未验收";
                    }
                    if(zt.equals("3")){
                        ztname = "完工验收";
                    }
                    if(zt.equals("4")){
                        ztname = "已验收未结算";
                    }
                    if(zt.equals("5")){
                        ztname = "已结算";
                    }
                }
                matmap.put("engineerType",ztname);

                CostClosingLastEntity entity = costClosingForecastMapper.querysubcontract(realprojectId);

                BigDecimal sump = new BigDecimal("0");
                if(entity != null){
                    Date start = entity.getCompletionTime();
                    Date end = entity.getCompletionAcceptanceTime();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    if(start != null){
                        String startdateString = sdf.format(start);
                        matmap.put("actualStart",startdateString);
                    }
                    if(end != null){
                        String enddateString = sdf.format(end);
                        matmap.put("completionAcceptanceTime",enddateString);
                    }
//                matmap.put("actualStart",entity.getCompletionTime());//开工时间
//                matmap.put("completionAcceptanceTime",entity.getCompletionAcceptanceTime());//竣工时间
                    matmap.put("projectCost",entity.getSumProductionTaxMny());
                    //开累不含税产值  A
                    matmap.put("sumProductionMny",entity.getSettlementTax());
                    //已计量不含税  D
                    matmap.put("calculateExcludtax",entity.getSumProductionMny());
                    sump = entity.getSumProductionMny();
                }

                BigDecimal maxsettlement = costClosingLastEntity.getMaxSettlement();
                if(maxsettlement == null){
                    maxsettlement = new BigDecimal("0");
                }

                // C
                matmap.put("maxSettlement",maxsettlement);
                // D
                BigDecimal conservativesettlement = costClosingLastEntity.getConservativeSettlement();
                if(conservativesettlement == null){
                    conservativesettlement = new BigDecimal("0");
                }
                matmap.put("conservativeSettlement",conservativesettlement);
                BigDecimal Damount = sump.add(conservativesettlement);

                // E
                BigDecimal subsettle = costClosingForecastMapper.subchangenotaxset(realprojectId);
                BigDecimal materialsettle = costClosingForecastMapper.materialchangenotax(realprojectId);
                BigDecimal machinesettle = costClosingForecastMapper.machinechangesettle(realprojectId);
                BigDecimal othersettle = costClosingForecastMapper.otherchangesettle(realprojectId);
                // BigDecimal ljfk = ;//此处放从预估单取到的累计付款额
                BigDecimal ljfk =  costClosingForecastMapper.ljfk(realprojectId);
                BigDecimal yjs = subsettle.add(materialsettle).add(machinesettle).add(othersettle).add(ljfk);
                matmap.put("closeCosty",yjs);
                //F
                BigDecimal realsubnotax = costClosingForecastMapper.subnotax(realprojectId);
                BigDecimal realsubchangenotax = costClosingForecastMapper.subchangenotax(realprojectId);
                BigDecimal realothnotax = costClosingForecastMapper.othnotax(realprojectId);
                BigDecimal realothchangenotax = costClosingForecastMapper.othchangenotax(realprojectId);
                BigDecimal yyg = realsubnotax.add(realothnotax);
                matmap.put("closeCostv",yyg);
                //J
                BigDecimal cyg = realsubchangenotax.add(realothchangenotax);
                matmap.put("forecastChangeAmount",cyg);
                //G = E+F+J
                BigDecimal wgzcb = yjs.add(yyg).add(cyg);
                matmap.put("totalCost",wgzcb);
                // H = D-G
                BigDecimal lr = Damount.subtract(wgzcb);
                matmap.put("expectprofitax",lr);
                //I = H/D
                BigDecimal lrl = new BigDecimal("0.00");
                if(lr.compareTo(BigDecimal.ZERO) != 0 && Damount.compareTo(BigDecimal.ZERO) != 0){
                    BigDecimal hundred = new BigDecimal("100");
                    lrl = lr.divide(Damount,8, BigDecimal.ROUND_HALF_UP).multiply(hundred);
                    lrl = lrl.setScale(2,BigDecimal.ROUND_HALF_UP);
                }
                matmap.put("expectprofits",lrl);
                BigDecimal mblr = costClosingForecastMapper.querylrl(realprojectId);
                matmap.put("targetprofitax",mblr);

                alldatareal.add(matmap);
            }
        }

        return alldatareal;
    }

    @Override
    public List<Map<String, Object>> lastRevenueExpenditureSummary() {
        List<Map<String,Object>> alldata = new ArrayList<>();
        List<CostClosingLastEntity> allproject = costClosingLastMapper.lastRevenueExpenditureSummary();

        if(allproject != null && allproject.size()>0){
            Integer no = 1;
            for(int s = 0;s<allproject.size();s++){
                CostClosingLastEntity materialContractEntity =allproject.get(s);
                Long trueprojectId = materialContractEntity.getProjectId();
                Long truecontract = materialContractEntity.getContractId();
                CostFinCostSummaryReportingEntity costFinCostSummaryReportingEntity = costFinCostSummaryReportingMapper.queryByProject(trueprojectId);

                CostClosingLastEntity costlast = costClosingLastMapper.selectByPC(truecontract);
                List<CostClosingLastChangeEntity> lastlist = costClosingLastMapper.querylastchangeList(costlast.getId());

                if(costFinCostSummaryReportingEntity != null) {
                    Map<String, Object> matmap = new HashMap<>();
                    matmap.put("no", no);
                    no++;
                    matmap.put("projectName", materialContractEntity.getProjectName());

                    Date start = materialContractEntity.getCompletionTime();
                    Date end = materialContractEntity.getCompletionAcceptanceTime();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    if(start != null){
                        String startdateString = sdf.format(start);
                        matmap.put("actualStart",startdateString);
                    }
                    if(end != null){
                        String enddateString = sdf.format(end);
                        matmap.put("completionAcceptanceTime",enddateString);
                    }
//                matmap.put("actualStart", materialContractEntity.getCompletionTime());
//                matmap.put("completionAcceptanceTime", materialContractEntity.getCompletionAcceptanceTime());
                    matmap.put("projectCost", materialContractEntity.getSumProductionTaxMny());
                    //开累不含税产值  A
                    matmap.put("sumProductionMny", materialContractEntity.getSettlementTax());
                    //工程结算审计值（不含税）  B
                    if (lastlist == null || lastlist.size() <= 0) {
                        matmap.put("settleAuditAmount", costlast.getLastOutputValue());
                    }else{
                        matmap.put("settleAuditAmount", lastlist.get(0).getLastOutputValue());
                    }

                    // E
                    BigDecimal subsettle = costClosingForecastMapper.finsubsettle(trueprojectId);
                    BigDecimal materialsettle = costClosingForecastMapper.finmaterialsettle(trueprojectId);
                    BigDecimal machinesettle = costClosingForecastMapper.finmachinesettle(trueprojectId);
                    BigDecimal othersettle = costClosingForecastMapper.finothersettle(trueprojectId);
                    BigDecimal ljfk =  costClosingForecastMapper.ljfk(trueprojectId);
                    BigDecimal yjs = subsettle.add(materialsettle).add(machinesettle).add(othersettle).add(ljfk);
                    matmap.put("closeCosty", yjs);

                    //G = E+F
//            BigDecimal wgzcb = yjs.add(yg);
                    matmap.put("totalCost", yjs);
                    // H = B-G
                    BigDecimal lr = materialContractEntity.getSumProductionMny().subtract(yjs);
                    matmap.put("expectprofitax", lr);
                    //I = H/B
                    BigDecimal lrl = new BigDecimal("0.00");
                    if (lr.compareTo(BigDecimal.ZERO) != 0 && materialContractEntity.getSumProductionMny().compareTo(BigDecimal.ZERO) != 0) {
                        lrl = lr.divide(materialContractEntity.getSumProductionMny(), 4, BigDecimal.ROUND_HALF_UP);
                    }
                    matmap.put("expectprofits", lrl.multiply(new BigDecimal("100")));//expectprofits
                    BigDecimal mblr = costClosingForecastMapper.querylrl(trueprojectId);
                    matmap.put("targetprofitax", mblr);//目标利润率（


                    alldata.add(matmap);
                }
            }
        }

        return alldata;
    }

    @Override
    public List<Map<String, Object>> projectFinCompletionSum(Long projectId) {
        //根据所选项目查找该项目对应的汇总单id
        Long fin = costFinContractDetailMapper.queryId(String.valueOf(projectId));
        List<Map<String, Object>> alldata = new ArrayList<>();

        List<CostFinContractDetailEntity> sublist = costFinContractDetailMapper.querySubdetailLW(fin);
        List<CostFinContractDetailEntity> zysublist = costFinContractDetailMapper.querySubdetailZY(fin);
        List<CostFinOtherDetailEntity> othlist = costFinContractDetailMapper.queryotherdetail(fin);
        List<FinMaterialContractEntity> matlist = costFinContractDetailMapper.queryMaterialdetail(fin);
        List<FinMachineContractEntity> maclist = costFinContractDetailMapper.queryMachinedetail(fin);
        List<FinOtherContractEntity> oclist = costFinContractDetailMapper.queryOthercontractdetail(fin);

///////////////////////////////////////////////////////1.劳务分包费（劳务分包合同）
        Map<String, Object> lw = new HashMap<>();
        lw.put("no", "1");
        lw.put("id", "1");
        lw.put("costItems", "劳务分包费（劳务分包合同）");

        alldata.add(lw);

        BigDecimal lwcontractamount = new BigDecimal("0");
        BigDecimal lwsettleNotax = new BigDecimal("0");
        BigDecimal lwsettleTax = new BigDecimal("0");
        BigDecimal lwsettle = new BigDecimal("0");
        BigDecimal lwforecastamountNotax = new BigDecimal("0");
        BigDecimal lwforecastamountTax = new BigDecimal("0");
        BigDecimal lwforecastamount = new BigDecimal("0");
        BigDecimal lwallamount = new BigDecimal("0");
        List<Map<String, Object>> newChildren = new ArrayList<>();
        if(sublist != null && sublist.size()>0){
            for (int s = 0; s < sublist.size(); s++) {
                CostFinContractDetailEntity materialContractEntity = sublist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "1." + noo);
                matmap.put("id", "1." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                lwcontractamount = lwcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());


                matmap.put("settleNotax", materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                lwsettleNotax = lwsettleNotax.add(materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                lwsettleTax = lwsettleTax.add(materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                lwsettle = lwsettle.add(materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));

//                    G=A+D
                BigDecimal allamount = materialContractEntity.getEstimatedAmountNotax();
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                lwallamount = lwallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                newChildren.add(matmap);
            }
        }
        lw.put("children", newChildren);
        lw.put("contractAmount", lwcontractamount);
        lw.put("settleNotax", lwsettleNotax);
        lw.put("settleTax", lwsettleTax);
        lw.put("settleAmount", lwsettle);
        lw.put("allCostNotax", lwallamount);
        alldata.set(0, lw);

        ///////////////////////////////////////////////////////2.材料费（材料合同、含周转材租赁）
        Map<String, Object> cl = new HashMap<>();
        cl.put("no", "2");
        cl.put("id","2");
        cl.put("costItems", "材料费（材料合同、含周转材租赁）");

        Integer allsize = alldata.size();
        alldata.add(cl);

        BigDecimal clcontractamount = new BigDecimal("0");
        BigDecimal clsettleNotax = new BigDecimal("0");
        BigDecimal clsettleTax = new BigDecimal("0");
        BigDecimal clsettle = new BigDecimal("0");
        BigDecimal clallamount = new BigDecimal("0");
        List<Map<String, Object>> newChildren2 = new ArrayList<>();
        if(matlist != null && matlist.size()>0){
            for (int s = 0; s < matlist.size(); s++) {
                FinMaterialContractEntity materialContractEntity = matlist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "2." + noo);
                matmap.put("id","2."+ noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                clcontractamount = clcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());


                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                clsettleNotax = clsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                clsettleTax = clsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                clsettle = clsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));

                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                clallamount = clallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                newChildren2.add(matmap);
            }
        }
        cl.put("children", newChildren2);
        cl.put("contractAmount", clcontractamount);
        cl.put("settleNotax", clsettleNotax);
        cl.put("settleTax", clsettleTax);
        cl.put("settleAmount", clsettle);
        cl.put("allCostNotax", clallamount);
        alldata.set(allsize, cl);

        ///////////////////////////////////////////////////////3.机械费（机械合同、含设备采购）
        Map<String, Object> jx = new HashMap<>();
        jx.put("no", "3");
        jx.put("id","3");
        jx.put("costItems", "机械费（机械合同、含设备采购）");

        Integer jxsize = alldata.size();
        alldata.add(jx);

        BigDecimal jxcontractamount = new BigDecimal("0");
        BigDecimal jxsettleNotax = new BigDecimal("0");
        BigDecimal jxsettleTax = new BigDecimal("0");
        BigDecimal jxsettle = new BigDecimal("0");
        BigDecimal jxallamount = new BigDecimal("0");
        List<Map<String, Object>> newChildren3 = new ArrayList<>();
        if(maclist != null && maclist.size()>0){
            for (int s = 0; s < maclist.size(); s++) {
                FinMachineContractEntity materialContractEntity = maclist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "3." + noo);
                matmap.put("id","3."+ noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                jxcontractamount = jxcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());


                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                jxsettleNotax = jxsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                jxsettleTax = jxsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                jxsettle = jxsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));

                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                jxallamount = jxallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                newChildren3.add(matmap);
            }
        }
        jx.put("children", newChildren3);
        jx.put("contractAmount", jxcontractamount);
        jx.put("settleNotax", jxsettleNotax);
        jx.put("settleTax", jxsettleTax);
        jx.put("settleAmount", jxsettle);
        jx.put("allCostNotax", jxallamount);
        alldata.set(jxsize, jx);

        ///////////////////////////////////////////////////////4.专业分包工程费（专业分包合同）
        Map<String, Object> zy = new HashMap<>();
        zy.put("no", "4");
        zy.put("id","4");
        zy.put("costItems", "专业分包工程费（专业分包合同）");

        Integer zysize = alldata.size();
        alldata.add(zy);

        BigDecimal zycontractamount = new BigDecimal("0");
        BigDecimal zysettleNotax = new BigDecimal("0");
        BigDecimal zysettleTax = new BigDecimal("0");
        BigDecimal zysettle = new BigDecimal("0");
        BigDecimal zyforecastamountNotax = new BigDecimal("0");
        BigDecimal zyforecastamountTax = new BigDecimal("0");
        BigDecimal zyforecastamount = new BigDecimal("0");
        BigDecimal zyallamount = new BigDecimal("0");
        List<Map<String, Object>> newChildren4 = new ArrayList<>();
        if(zysublist != null && zysublist.size()>0){
            for (int s = 0; s < zysublist.size(); s++) {
                CostFinContractDetailEntity materialContractEntity = zysublist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "4." + noo);
                matmap.put("id","4."+ noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                zycontractamount = zycontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());




                matmap.put("settleNotax", materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                zysettleNotax = zysettleNotax.add(materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                zysettleTax = zysettleTax.add(materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                zysettle = zysettle.add(materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));

                BigDecimal allamount = materialContractEntity.getEstimatedAmountNotax();
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                zyallamount = zyallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                newChildren4.add(matmap);
            }
        }
        zy.put("children", newChildren4);
        zy.put("contractAmount", zycontractamount);
        zy.put("settleNotax", zysettleNotax);
        zy.put("settleTax", zysettleTax);
        zy.put("settleAmount", zysettle);
        zy.put("allCostNotax", zyallamount);
        alldata.set(zysize, zy);

        ///////////////////////////////////////////////////////5.其他费用（有合同的）
        Map<String, Object> oc = new HashMap<>();
        oc.put("no", "5");
        oc.put("id","5");
        oc.put("costItems", "其他费用（有合同的）");

        Integer ocsize = alldata.size();
        alldata.add(oc);

        BigDecimal occontractamount = new BigDecimal("0");
        BigDecimal ocsettleNotax = new BigDecimal("0");
        BigDecimal ocsettleTax = new BigDecimal("0");
        BigDecimal ocsettle = new BigDecimal("0");
        BigDecimal ocallamount = new BigDecimal("0");
        List<Map<String, Object>> newChildren5 = new ArrayList<>();
        if(oclist != null && oclist.size()>0){
            for (int s = 0; s < oclist.size(); s++) {
                FinOtherContractEntity materialContractEntity = oclist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "5." + noo);
                matmap.put("id","5."+ noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                occontractamount = occontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());


                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                ocsettleNotax = ocsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                ocsettleTax = ocsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                ocsettle = ocsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));

                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                ocallamount = ocallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                newChildren5.add(matmap);
            }
        }
        oc.put("children", newChildren5);
        oc.put("contractAmount", occontractamount);
        oc.put("settleNotax", ocsettleNotax);
        oc.put("settleTax", ocsettleTax);
        oc.put("settleAmount", ocsettle);
        oc.put("allCostNotax", ocallamount);
        alldata.set(ocsize, oc);

        ///////////////////////////////////////////////////////6.其他费用（无合同的间接费）
        Map<String, Object> ot = new HashMap<>();
        ot.put("no", "6");
        ot.put("id","6");
        ot.put("costItems", "其他费用（无合同的间接费）");

        Integer otsize = alldata.size();
        alldata.add(ot);

        BigDecimal otsettleNotax = new BigDecimal("0");
        List<Map<String, Object>> newChildren6 = new ArrayList<>();
        if(othlist != null && othlist.size()>0){
            for (int t = 0; t < othlist.size(); t++) {
                CostFinOtherDetailEntity materialContractEntity = othlist.get(t);
                Integer no = t;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "6." + noo);
                matmap.put("id","6."+ noo);

//                matmap.put("settleNotax", materialContractEntity.getEstimatedTaxAmount().setScale(2, RoundingMode.HALF_UP));
//                otsettleNotax = otsettleNotax.add(materialContractEntity.getEstimatedTaxAmount().setScale(2, RoundingMode.HALF_UP));
//
//                matmap.put("allCostNotax", materialContractEntity.getEstimatedTaxAmount().setScale(2, RoundingMode.HALF_UP));
                if(materialContractEntity.getCostTypeId() != null){
                    String typename = forecastOtherDetailMapper.querytypename(materialContractEntity.getCostTypeId());

                    matmap.put("contractName",typename);
                }

                matmap.put("taxRate", materialContractEntity.getSubjectName());

                BigDecimal settleAmount = forecastOtherDetailMapper.queryPaymny(projectId,materialContractEntity.getSubjectId());

                matmap.put("settleAmount", settleAmount.setScale(2, RoundingMode.HALF_UP));
                otsettleNotax = otsettleNotax.add(settleAmount.setScale(2, RoundingMode.HALF_UP));

                matmap.put("allCostNotax", settleAmount.setScale(2, RoundingMode.HALF_UP));

                newChildren6.add(matmap);
            }
        }


//        QueryParam param = new QueryParam();
//        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));allCostNotax
//        param.getOrderMap().put("subjectCode", "asc");
//        List<SubjectProjectEntity> list = subjectProjectService.queryList(param, false);
//        if (list == null || list.size() == 0) {
//            return new ArrayList<>();
//        }
//        List<ProjectSubjectVO> res = BeanMapper.mapList(list, ProjectSubjectVO.class);
//        List<Long> subjectIds = new ArrayList<>();
//        for (ProjectSubjectVO projectSubjectVO : res){
//            subjectIds.add(projectSubjectVO.getId());
//        }
//        List<Map<String,Object>> entityList = forecastOtherDetailMapper.queryPayReimList(projectId,subjectIds);
//        for (int i=0;i<entityList.size();i++) {
//            Map<String, Object> payReimburseEntity = entityList.get(i);
//            Integer no = i;
//            Integer noo = no + 1;
//            Map<String, Object> matmap = new HashMap<>();
//            matmap.put("no", "6." + noo);
//            matmap.put("id", "6." + noo);
//
//
//            matmap.put("subName", payReimburseEntity.get("subjectName"));
//            String objid = String.valueOf(payReimburseEntity.get("id"));
//
//            String typename = forecastOtherDetailMapper.querytype(projectId,Long.parseLong(objid));
//            String changetypename = forecastOtherDetailMapper.querytypechange(projectId,Long.parseLong(objid));
//
//            if(typename == null){
//                matmap.put("contractName",changetypename);
//            }else{
//                matmap.put("contractName",typename);
//            }
//
//            BigDecimal settleAmount = forecastOtherDetailMapper.queryPaymny(projectId,Long.parseLong(objid));
//
//            matmap.put("settleAmount", settleAmount.setScale(2, RoundingMode.HALF_UP));
//            otsettleNotax = otsettleNotax.add(settleAmount.setScale(2, RoundingMode.HALF_UP));
////            BigDecimal payMny = new BigDecimal(payReimburseEntity.get("payMny").toString());
////            matmap.put("settleAmount", payMny.setScale(2, RoundingMode.HALF_UP));
////            otsettleNotax = otsettleNotax.add(payMny.setScale(2, RoundingMode.HALF_UP));
////            matmap.put("allCostNotax", settleAmount.setScale(2, RoundingMode.HALF_UP));
//            newChildren6.add(matmap);
//        }
        ot.put("children", newChildren6);
        ot.put("settleAmount", otsettleNotax);
        ot.put("allCostNotax", otsettleNotax);
        alldata.set(otsize, ot);

        ///////////////////////////////////////////////////////7.其他预估成本
        Map<String, Object> ot00 = new HashMap<>();
        ot00.put("no", "7");
        ot00.put("id","7");
        ot00.put("costItems", "其他预估成本");

        Integer ot0size = alldata.size();
        alldata.add(ot00);
        List<Map<String, Object>> newChildren7 = new ArrayList<>();
        Map<String, Object> ot1 = new HashMap<>();
        ot1.put("no", "7.1");
        ot1.put("id","7.1");
        ot1.put("costItems", "间接费预估");
        BigDecimal jjtotalnt = forecastOtherDetailMapper.queryjjtotal(projectId);
        ot1.put("forecastNotax", jjtotalnt);
        BigDecimal jjtotalt = forecastOtherDetailMapper.queryjjtotaltax(projectId);
        ot1.put("forecastTax", jjtotalt);
        BigDecimal jjtotal = forecastOtherDetailMapper.queryjjtotalamount(projectId);
        ot1.put("forecastAmount", jjtotal);

//            Integer ot1size = alldata.size();
        newChildren7.add(ot1);

        Map<String, Object> ot2 = new HashMap<>();
        ot2.put("no", "7.2");
        ot2.put("id","7.2");
        ot2.put("costItems", "收尾阶段发生的其他费预估");
        BigDecimal qttotalnt = forecastOtherDetailMapper.queryqttotal(projectId);
        ot2.put("forecastNotax", qttotalnt);
        BigDecimal qttotalt = forecastOtherDetailMapper.queryqttotaltax(projectId);
        ot2.put("forecastTax", qttotalt);
        BigDecimal qttotal = forecastOtherDetailMapper.queryqttotalamount(projectId);
        ot2.put("forecastAmount", qttotal);

//            Integer ot2size = alldata.size();
        newChildren7.add(ot2);
        ot00.put("children", newChildren7);
        ot00.put("forecastNotax", jjtotalnt.add(qttotalnt));
        ot00.put("forecastTax", jjtotalt.add(qttotalt));
        ot00.put("forecastAmount", jjtotal.add(qttotal));
        alldata.set(ot0size, ot00);
//            }
//        }else{
//            throw new BusinessException("未找到当前项目");
//        }

        return alldata;
    }

    @Override
    public List<Map<String, Object>> projectFinExhaustedSum(Long projectId) {
//根据所选项目查找该项目对应的预估单id
//        Long fin = costFinContractDetailMapper.queryId(String.valueOf(projectId));
        List<Map<String, Object>> alldata = new ArrayList<>();

        List<CostFinContractDetailEntity> sublist = costFinContractDetailMapper.querySubContractByProjectIdLW(String.valueOf(projectId));
        List<CostFinContractDetailEntity> zysublist = costFinContractDetailMapper.querySubContractByProjectIdZY(String.valueOf(projectId));
        List<CostFinOtherDetailEntity> othlist = costFinOtherDetailMapper.querySubjectByProjectId(String.valueOf(projectId));
        List<FinMaterialContractEntity> matlist = costFinContractDetailMapper.querySubContractByProjectIdMaterial(String.valueOf(projectId));
        List<FinMachineContractEntity> maclist = costFinContractDetailMapper.querySubContractByProjectIdMachine(String.valueOf(projectId));
        List<FinOtherContractEntity> oclist = costFinContractDetailMapper.querySubContractByProjectIdOther(String.valueOf(projectId));

///////////////////////////////////////////////////////1.劳务分包费（劳务分包合同）
        Map<String, Object> lw = new HashMap<>();
        lw.put("no", "1");
        lw.put("id","1");
        lw.put("costItems", "劳务分包费（劳务分包合同）");

        alldata.add(lw);

        BigDecimal lwcontractamount = new BigDecimal("0");
        BigDecimal lwsettleNotax = new BigDecimal("0");
        BigDecimal lwsettleTax = new BigDecimal("0");
        BigDecimal lwsettle = new BigDecimal("0");
        BigDecimal lwallamount = new BigDecimal("0");
        List<Map<String, Object>> newChildren = new ArrayList<>();
        if(sublist != null && sublist.size()>0){
            for (int s = 0; s < sublist.size(); s++) {
                CostFinContractDetailEntity materialContractEntity = sublist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "1." + noo);
                matmap.put("id","1."+ noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                lwcontractamount = lwcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());


                matmap.put("settleNotax", materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                lwsettleNotax = lwsettleNotax.add(materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                lwsettleTax = lwsettleTax.add(materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                lwsettle = lwsettle.add(materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));

//                    G=A+D
                BigDecimal allamount = materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                lwallamount = lwallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                newChildren.add(matmap);
            }
        }
        lw.put("children", newChildren);
        lw.put("contractAmount", lwcontractamount);
        lw.put("settleNotax", lwsettleNotax);
        lw.put("settleTax", lwsettleTax);
        lw.put("settleAmount", lwsettle);
        lw.put("allCostNotax", lwallamount);
        alldata.set(0, lw);

        ///////////////////////////////////////////////////////2.材料费（材料合同、含周转材租赁）
        Map<String, Object> cl = new HashMap<>();
        cl.put("no", "2");
        cl.put("id","2");
        cl.put("costItems", "材料费（材料合同、含周转材租赁）");

        Integer allsize = alldata.size();
        alldata.add(cl);

        BigDecimal clcontractamount = new BigDecimal("0");
        BigDecimal clsettleNotax = new BigDecimal("0");
        BigDecimal clsettleTax = new BigDecimal("0");
        BigDecimal clsettle = new BigDecimal("0");
        BigDecimal clallamount = new BigDecimal("0");
        List<Map<String, Object>> newChildren2 = new ArrayList<>();
        if(matlist != null && matlist.size()>0){
            for (int s = 0; s < matlist.size(); s++) {
                FinMaterialContractEntity materialContractEntity = matlist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "2." + noo);
                matmap.put("id","2."+ noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                clcontractamount = clcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());


                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                clsettleNotax = clsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                clsettleTax = clsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                clsettle = clsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));

                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                clallamount = clallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                newChildren2.add(matmap);
            }
        }
        cl.put("children", newChildren2);
        cl.put("contractAmount", clcontractamount);
        cl.put("settleNotax", clsettleNotax);
        cl.put("settleTax", clsettleTax);
        cl.put("settleAmount", clsettle);
        cl.put("allCostNotax", clallamount);
        alldata.set(allsize, cl);

        ///////////////////////////////////////////////////////3.机械费（机械合同、含设备采购）
        Map<String, Object> jx = new HashMap<>();
        jx.put("no", "3");
        jx.put("id","3");
        jx.put("costItems", "机械费（机械合同、含设备采购）");

        Integer jxsize = alldata.size();
        alldata.add(jx);

        BigDecimal jxcontractamount = new BigDecimal("0");
        BigDecimal jxsettleNotax = new BigDecimal("0");
        BigDecimal jxsettleTax = new BigDecimal("0");
        BigDecimal jxsettle = new BigDecimal("0");
        BigDecimal jxallamount = new BigDecimal("0");
        List<Map<String, Object>> newChildren3 = new ArrayList<>();
        if(maclist != null && maclist.size()>0){
            for (int s = 0; s < maclist.size(); s++) {
                FinMachineContractEntity materialContractEntity = maclist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "3." + noo);
                matmap.put("id","3."+ noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                jxcontractamount = jxcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());


                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                jxsettleNotax = jxsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                jxsettleTax = jxsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                jxsettle = jxsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));

                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                jxallamount = jxallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                newChildren3.add(matmap);
            }
        }
        jx.put("children", newChildren3);
        jx.put("contractAmount", jxcontractamount);
        jx.put("settleNotax", jxsettleNotax);
        jx.put("settleTax", jxsettleTax);
        jx.put("settleAmount", jxsettle);
        jx.put("allCostNotax", jxallamount);
        alldata.set(jxsize, jx);

        ///////////////////////////////////////////////////////4.专业分包工程费（专业分包合同）
        Map<String, Object> zy = new HashMap<>();
        zy.put("no", "4");
        zy.put("id","4");
        zy.put("costItems", "专业分包工程费（专业分包合同）");

        Integer zysize = alldata.size();
        alldata.add(zy);

        BigDecimal zycontractamount = new BigDecimal("0");
        BigDecimal zysettleNotax = new BigDecimal("0");
        BigDecimal zysettleTax = new BigDecimal("0");
        BigDecimal zysettle = new BigDecimal("0");
        BigDecimal zyallamount = new BigDecimal("0");
        List<Map<String, Object>> newChildren4 = new ArrayList<>();
        if(zysublist != null && zysublist.size()>0){
            for (int s = 0; s < zysublist.size(); s++) {
                CostFinContractDetailEntity materialContractEntity = zysublist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "4." + noo);
                matmap.put("id","4."+ noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                zycontractamount = zycontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());




                matmap.put("settleNotax", materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                zysettleNotax = zysettleNotax.add(materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                zysettleTax = zysettleTax.add(materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                zysettle = zysettle.add(materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));


                BigDecimal allamount = materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                zyallamount = zyallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                newChildren4.add(matmap);
            }
        }
        zy.put("children", newChildren4);
        zy.put("contractAmount", zycontractamount);
        zy.put("settleNotax", zysettleNotax);
        zy.put("settleTax", zysettleTax);
        zy.put("settleAmount", zysettle);
        zy.put("allCostNotax", zyallamount);
        alldata.set(zysize, zy);

        ///////////////////////////////////////////////////////5.其他费用（有合同的）
        Map<String, Object> oc = new HashMap<>();
        oc.put("no", "5");
        oc.put("id","5");
        oc.put("costItems", "其他费用（有合同的）");

        Integer ocsize = alldata.size();
        alldata.add(oc);

        BigDecimal occontractamount = new BigDecimal("0");
        BigDecimal ocsettleNotax = new BigDecimal("0");
        BigDecimal ocsettleTax = new BigDecimal("0");
        BigDecimal ocsettle = new BigDecimal("0");
        BigDecimal ocallamount = new BigDecimal("0");
        List<Map<String, Object>> newChildren5 = new ArrayList<>();
        if(oclist != null && oclist.size()>0){
            for (int s = 0; s < oclist.size(); s++) {
                FinOtherContractEntity materialContractEntity = oclist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "5." + noo);
                matmap.put("id", "5." + noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount",materialContractEntity.getContractAmount()==null ? new BigDecimal("0") : materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                occontractamount = occontractamount.add(materialContractEntity.getContractAmount()==null ? new BigDecimal("0") : materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());


                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                ocsettleNotax = ocsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                ocsettleTax = ocsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                ocsettle = ocsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));

                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                ocallamount = ocallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                newChildren5.add(matmap);
            }
        }
        oc.put("children", newChildren5);
        oc.put("contractAmount", occontractamount);
        oc.put("settleNotax", ocsettleNotax);
        oc.put("settleTax", ocsettleTax);
        oc.put("settleAmount", ocsettle);
        oc.put("allCostNotax", ocallamount);
        alldata.set(ocsize, oc);

        ///////////////////////////////////////////////////////6.其他费用（无合同的间接费）
        Map<String, Object> ot = new HashMap<>();
        ot.put("no", "6");
        ot.put("id","6");
        ot.put("costItems", "其他费用（无合同的间接费）");

        Integer otsize = alldata.size();
        alldata.add(ot);

        BigDecimal otsettleNotax = new BigDecimal("0");
        List<Map<String, Object>> newChildren6 = new ArrayList<>();
        if(othlist != null && othlist.size()>0){
            for (int t = 0; t < othlist.size(); t++) {
                CostFinOtherDetailEntity materialContractEntity = othlist.get(t);
                Integer no = t;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "6." + noo);
                matmap.put("id", "6." + noo);

                Long objid = materialContractEntity.getSubjectId();

                String typename = forecastOtherDetailMapper.querytype(projectId, objid);
                String changetypename = forecastOtherDetailMapper.querytypechange(projectId, objid);

                if (typename == null) {
                    matmap.put("contractName", changetypename);
                } else {
                    matmap.put("contractName", typename);
                }

                matmap.put("taxRate", materialContractEntity.getSubjectName());

                BigDecimal settleAmount = forecastOtherDetailMapper.queryPaymny(projectId,materialContractEntity.getSubjectId());

                matmap.put("settleAmount", settleAmount.setScale(2, RoundingMode.HALF_UP));
                otsettleNotax = otsettleNotax.add(settleAmount.setScale(2, RoundingMode.HALF_UP));

                matmap.put("allCostNotax", settleAmount.setScale(2, RoundingMode.HALF_UP));

                newChildren6.add(matmap);
            }
        }

        ot.put("settleAmount", otsettleNotax);
        ot.put("allCostNotax", otsettleNotax);
        ot.put("children", newChildren6);
        alldata.set(otsize, ot);

        return alldata;
    }

    @Override
    public List<Map<String, Object>> projectFinClosingSumRealTime(Long projectId) {
        //根据所选项目查找该项目对应的预估单id
        Long fin = costFinContractDetailMapper.queryId(String.valueOf(projectId));
        List<Map<String, Object>> alldata = new ArrayList<>();

        List<CostFinContractDetailEntity> sublist = costFinContractDetailMapper.querySubContractByProjectIdLW(String.valueOf(projectId));
        List<CostFinContractDetailEntity> zysublist = costFinContractDetailMapper.querySubContractByProjectIdZY(String.valueOf(projectId));
        List<CostFinOtherDetailEntity> othlist = costFinOtherDetailMapper.querySubjectByProjectId(String.valueOf(projectId));
        List<FinMaterialContractEntity> matlist = costFinContractDetailMapper.querySubContractByProjectIdMaterial(String.valueOf(projectId));
        List<FinMachineContractEntity> maclist = costFinContractDetailMapper.querySubContractByProjectIdMachine(String.valueOf(projectId));
        List<FinOtherContractEntity> oclist = costFinContractDetailMapper.querySubContractByProjectIdOther(String.valueOf(projectId));

///////////////////////////////////////////////////////1.劳务分包费（劳务分包合同）
        Map<String, Object> lw = new HashMap<>();
        lw.put("no", "1");
        lw.put("id","1");
        lw.put("costItems", "劳务分包费（劳务分包合同）");

        alldata.add(lw);

        BigDecimal lwcontractamount = new BigDecimal("0");
        BigDecimal lwsettleNotax = new BigDecimal("0");
        BigDecimal lwsettleTax = new BigDecimal("0");
        BigDecimal lwsettle = new BigDecimal("0");
        BigDecimal lwforecastamountNotax = new BigDecimal("0");
        BigDecimal lwforecastamountTax = new BigDecimal("0");
        BigDecimal lwforecastamount = new BigDecimal("0");
        BigDecimal lwallamount = new BigDecimal("0");
        List<Map<String, Object>> newChildren = new ArrayList<>();
        if(sublist != null && sublist.size()>0){
            for (int s = 0; s < sublist.size(); s++) {
                CostFinContractDetailEntity materialContractEntity = sublist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "1." + noo);
                matmap.put("id","1."+ noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                lwcontractamount = lwcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());


                matmap.put("settleNotax", materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                lwsettleNotax = lwsettleNotax.add(materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                lwsettleTax = lwsettleTax.add(materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                lwsettle = lwsettle.add(materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));

                BigDecimal ygnamount = costFinContractDetailMapper.queryForecastnotax(materialContractEntity.getContractId());
                BigDecimal bgnamount = costFinContractDetailMapper.queryForecastChangenotax(materialContractEntity.getContractId());
                BigDecimal notax = ygnamount.add(bgnamount);
                matmap.put("forecastNotax", notax.setScale(2, RoundingMode.HALF_UP));
                lwforecastamountNotax = lwforecastamountNotax.add(notax.setScale(2, RoundingMode.HALF_UP));

                BigDecimal ygtaxamount = costFinContractDetailMapper.queryForecasttax(materialContractEntity.getContractId());
                BigDecimal bgtaxamount = costFinContractDetailMapper.queryForecastChangetax(materialContractEntity.getContractId());
                BigDecimal tax = ygtaxamount.add(bgtaxamount);
                matmap.put("forecastTax", tax.setScale(2, RoundingMode.HALF_UP));
                lwforecastamountTax = lwforecastamountTax.add(tax.setScale(2, RoundingMode.HALF_UP));

                BigDecimal ygamount = costFinContractDetailMapper.queryForecastamount(materialContractEntity.getContractId());
                BigDecimal bgamount = costFinContractDetailMapper.queryForecastChangeamount(materialContractEntity.getContractId());
                BigDecimal amount = ygamount.add(bgamount);
                matmap.put("forecastAmount", amount.setScale(2, RoundingMode.HALF_UP));
                lwforecastamount = lwforecastamount.add(amount.setScale(2, RoundingMode.HALF_UP));

//                    G=A+D
                BigDecimal allamount = materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP).add
                        (notax.setScale(2, RoundingMode.HALF_UP));
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                lwallamount = lwallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                newChildren.add(matmap);
            }
        }
        lw.put("children", newChildren);
        lw.put("contractAmount", lwcontractamount);
        lw.put("settleNotax", lwsettleNotax);
        lw.put("settleTax", lwsettleTax);
        lw.put("settleAmount", lwsettle);
        lw.put("forecastNotax", lwforecastamountNotax);
        lw.put("forecastTax", lwforecastamountTax);
        lw.put("forecastAmount", lwforecastamount);
        lw.put("allCostNotax", lwallamount);
        alldata.set(0, lw);

        ///////////////////////////////////////////////////////2.材料费（材料合同、含周转材租赁）
        Map<String, Object> cl = new HashMap<>();
        cl.put("no", "2");
        cl.put("id","2");
        cl.put("costItems", "材料费（材料合同、含周转材租赁）");

        Integer allsize = alldata.size();
        alldata.add(cl);

        BigDecimal clcontractamount = new BigDecimal("0");
        BigDecimal clsettleNotax = new BigDecimal("0");
        BigDecimal clsettleTax = new BigDecimal("0");
        BigDecimal clsettle = new BigDecimal("0");
        BigDecimal clallamount = new BigDecimal("0");
        List<Map<String, Object>> newChildren2 = new ArrayList<>();
        if(matlist != null && matlist.size()>0){
            for (int s = 0; s < matlist.size(); s++) {
                FinMaterialContractEntity materialContractEntity = matlist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "2." + noo);
                matmap.put("id","2."+ noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                clcontractamount = clcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());


                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                clsettleNotax = clsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                clsettleTax = clsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                clsettle = clsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));

                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                clallamount = clallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                newChildren2.add(matmap);
            }
        }
        cl.put("children", newChildren2);
        cl.put("contractAmount", clcontractamount);
        cl.put("settleNotax", clsettleNotax);
        cl.put("settleTax", clsettleTax);
        cl.put("settleAmount", clsettle);
        cl.put("allCostNotax", clallamount);
        alldata.set(allsize, cl);

        ///////////////////////////////////////////////////////3.机械费（机械合同、含设备采购）
        Map<String, Object> jx = new HashMap<>();
        jx.put("no", "3");
        jx.put("id","3");
        jx.put("costItems", "机械费（机械合同、含设备采购）");

        Integer jxsize = alldata.size();
        alldata.add(jx);

        BigDecimal jxcontractamount = new BigDecimal("0");
        BigDecimal jxsettleNotax = new BigDecimal("0");
        BigDecimal jxsettleTax = new BigDecimal("0");
        BigDecimal jxsettle = new BigDecimal("0");
        BigDecimal jxallamount = new BigDecimal("0");
        List<Map<String, Object>> newChildren3 = new ArrayList<>();
        if(maclist != null && maclist.size()>0){
            for (int s = 0; s < maclist.size(); s++) {
                FinMachineContractEntity materialContractEntity = maclist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "3." + noo);
                matmap.put("id","3."+ noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                jxcontractamount = jxcontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());


                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                jxsettleNotax = jxsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                jxsettleTax = jxsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                jxsettle = jxsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));

                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                jxallamount = jxallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                newChildren3.add(matmap);
            }
        }
        jx.put("children", newChildren3);
        jx.put("contractAmount", jxcontractamount);
        jx.put("settleNotax", jxsettleNotax);
        jx.put("settleTax", jxsettleTax);
        jx.put("settleAmount", jxsettle);
        jx.put("allCostNotax", jxallamount);
        alldata.set(jxsize, jx);

        ///////////////////////////////////////////////////////4.专业分包工程费（专业分包合同）
        Map<String, Object> zy = new HashMap<>();
        zy.put("no", "4");
        zy.put("id","4");
        zy.put("costItems", "专业分包工程费（专业分包合同）");

        Integer zysize = alldata.size();
        alldata.add(zy);

        BigDecimal zycontractamount = new BigDecimal("0");
        BigDecimal zysettleNotax = new BigDecimal("0");
        BigDecimal zysettleTax = new BigDecimal("0");
        BigDecimal zysettle = new BigDecimal("0");
        BigDecimal zyforecastamountNotax = new BigDecimal("0");
        BigDecimal zyforecastamountTax = new BigDecimal("0");
        BigDecimal zyforecastamount = new BigDecimal("0");
        BigDecimal zyallamount = new BigDecimal("0");
        List<Map<String, Object>> newChildren4 = new ArrayList<>();
        if(zysublist != null && zysublist.size()>0){
            for (int s = 0; s < zysublist.size(); s++) {
                CostFinContractDetailEntity materialContractEntity = zysublist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "4." + noo);
                matmap.put("id","4."+ noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                zycontractamount = zycontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());




                matmap.put("settleNotax", materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                zysettleNotax = zysettleNotax.add(materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                zysettleTax = zysettleTax.add(materialContractEntity.getEstimatedAmountTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));
                zysettle = zysettle.add(materialContractEntity.getEstimatedAmount().setScale(2, RoundingMode.HALF_UP));

                BigDecimal ygnamount = costFinContractDetailMapper.queryForecastnotax(materialContractEntity.getContractId());
                BigDecimal bgnamount = costFinContractDetailMapper.queryForecastChangenotax(materialContractEntity.getContractId());
                BigDecimal notax = ygnamount.add(bgnamount);
                matmap.put("forecastNotax", notax.setScale(2, RoundingMode.HALF_UP));
                zyforecastamountNotax = zyforecastamountNotax.add(notax.setScale(2, RoundingMode.HALF_UP));

                BigDecimal ygtaxamount = costFinContractDetailMapper.queryForecasttax(materialContractEntity.getContractId());
                BigDecimal bgtaxamount = costFinContractDetailMapper.queryForecastChangetax(materialContractEntity.getContractId());
                BigDecimal tax = ygtaxamount.add(bgtaxamount);
                matmap.put("forecastTax", tax.setScale(2, RoundingMode.HALF_UP));
                zyforecastamountTax = zyforecastamountTax.add(tax.setScale(2, RoundingMode.HALF_UP));

                BigDecimal ygamount = costFinContractDetailMapper.queryForecastamount(materialContractEntity.getContractId());
                BigDecimal bgamount = costFinContractDetailMapper.queryForecastChangeamount(materialContractEntity.getContractId());
                BigDecimal amount = ygamount.add(bgamount);
                matmap.put("forecastAmount", amount.setScale(2, RoundingMode.HALF_UP));
                zyforecastamount = zyforecastamount.add(amount.setScale(2, RoundingMode.HALF_UP));

                BigDecimal allamount = materialContractEntity.getEstimatedAmountNotax().setScale(2, RoundingMode.HALF_UP).add
                        (notax.setScale(2, RoundingMode.HALF_UP));
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                zyallamount = zyallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                newChildren4.add(matmap);
            }
        }
        zy.put("children", newChildren4);
        zy.put("contractAmount", zycontractamount);
        zy.put("settleNotax", zysettleNotax);
        zy.put("settleTax", zysettleTax);
        zy.put("settleAmount", zysettle);
        zy.put("forecastNotax", zyforecastamountNotax);
        zy.put("forecastTax", zyforecastamountTax);
        zy.put("forecastAmount", zyforecastamount);
        zy.put("allCostNotax", zyallamount);
        alldata.set(zysize, zy);

        ///////////////////////////////////////////////////////5.其他费用（有合同的）
        Map<String, Object> oc = new HashMap<>();
        oc.put("no", "5");
        oc.put("id","5");
        oc.put("costItems", "其他费用（有合同的）");

        Integer ocsize = alldata.size();
        alldata.add(oc);

        BigDecimal occontractamount = new BigDecimal("0");
        BigDecimal ocsettleNotax = new BigDecimal("0");
        BigDecimal ocsettleTax = new BigDecimal("0");
        BigDecimal ocsettle = new BigDecimal("0");
        BigDecimal ocallamount = new BigDecimal("0");
        List<Map<String, Object>> newChildren5 = new ArrayList<>();
        if(oclist != null && oclist.size()>0){
            for (int s = 0; s < oclist.size(); s++) {
                FinOtherContractEntity materialContractEntity = oclist.get(s);
                Integer no = s;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "5." + noo);
                matmap.put("id","5."+ noo);
                matmap.put("costItems", materialContractEntity.getContractType());
                matmap.put("contractName", materialContractEntity.getContractName());
                matmap.put("contractAmount", materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                occontractamount = occontractamount.add(materialContractEntity.getContractAmount().setScale(2, RoundingMode.HALF_UP));
                matmap.put("taxRate", materialContractEntity.getTaxRate());
                matmap.put("subName", materialContractEntity.getSubOrg());


                matmap.put("settleNotax", materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                ocsettleNotax = ocsettleNotax.add(materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleTax", materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                ocsettleTax = ocsettleTax.add(materialContractEntity.getAmountSettledTax().setScale(2, RoundingMode.HALF_UP));
                matmap.put("settleAmount", materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));
                ocsettle = ocsettle.add(materialContractEntity.getAmountSettled().setScale(2, RoundingMode.HALF_UP));

                BigDecimal allamount = materialContractEntity.getAmountSettledNotax().setScale(2, RoundingMode.HALF_UP);
                matmap.put("allCostNotax", allamount.setScale(2, RoundingMode.HALF_UP));
                ocallamount = ocallamount.add(allamount.setScale(2, RoundingMode.HALF_UP));

                newChildren5.add(matmap);
            }
        }
        oc.put("children", newChildren5);
        oc.put("contractAmount", occontractamount);
        oc.put("settleNotax", ocsettleNotax);
        oc.put("settleTax", ocsettleTax);
        oc.put("settleAmount", ocsettle);
        oc.put("allCostNotax", ocallamount);
        alldata.set(ocsize, oc);

        ///////////////////////////////////////////////////////6.其他费用（无合同的间接费）
        Map<String, Object> ot = new HashMap<>();
        ot.put("no", "6");
        ot.put("id","6");
        ot.put("costItems", "其他费用（无合同的间接费）");

        Integer otsize = alldata.size();
        alldata.add(ot);

        BigDecimal otsettleNotax = new BigDecimal("0");
//        BigDecimal otforecastamountNotax = new BigDecimal("0");
//        BigDecimal otsettleNotax = new BigDecimal("0");
//        BigDecimal zOtsettleNotax = BigDecimal.ZERO;
//        BigDecimal otforecastamountTax = new BigDecimal("0");
//        BigDecimal otforecastamount = new BigDecimal("0");
        List<Map<String, Object>> newChildren6 = new ArrayList<>();
        if(othlist != null && othlist.size()>0){
            for (int t = 0; t < othlist.size(); t++) {
                CostFinOtherDetailEntity materialContractEntity = othlist.get(t);
                Integer no = t;
                Integer noo = no + 1;
                Map<String, Object> matmap = new HashMap<>();
                matmap.put("no", "6." + noo);
                matmap.put("id","6."+ noo);

                Long objid = materialContractEntity.getSubjectId();

                String typename = forecastOtherDetailMapper.querytype(projectId, objid);
                String changetypename = forecastOtherDetailMapper.querytypechange(projectId, objid);

                if (typename == null) {
                    matmap.put("contractName", changetypename);
                } else {
                    matmap.put("contractName", typename);
                }

                matmap.put("taxRate",materialContractEntity.getSubjectName());


                BigDecimal settleAmount = forecastOtherDetailMapper.queryPaymny(projectId,materialContractEntity.getSubjectId());

                matmap.put("settleAmount", settleAmount.setScale(2, RoundingMode.HALF_UP));
                otsettleNotax = otsettleNotax.add(settleAmount.setScale(2, RoundingMode.HALF_UP));
                matmap.put("allCostNotax", settleAmount.setScale(2, RoundingMode.HALF_UP));

                newChildren6.add(matmap);
            }
        }

//        QueryParam param = new QueryParam();
//        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getOrderMap().put("subjectCode", "asc");
//        List<SubjectProjectEntity> list = subjectProjectService.queryList(param, false);
//        if (list == null || list.size() == 0) {
//            return new ArrayList<>();
//        }
//        List<ProjectSubjectVO> res = BeanMapper.mapList(list, ProjectSubjectVO.class);
//        List<Long> subjectIds = new ArrayList<>();
//        for (ProjectSubjectVO projectSubjectVO : res){
//            subjectIds.add(projectSubjectVO.getId());
//        }
//
//        List<Map<String,Object>> entityList = forecastOtherDetailMapper.queryPayReimList(projectId,subjectIds);
//        for (int i=0;i<entityList.size();i++){
//            Map<String,Object> payReimburseEntity = entityList.get(i);
//            Integer no = i;
//            Integer noo = no + 1;
//            Map<String, Object> matmap = new HashMap<>();
//            matmap.put("no", "6." + noo);
//            matmap.put("id", "6." + noo);
//            matmap.put("contractName","");
//            matmap.put("subName",payReimburseEntity.get("subjectName"));
//            BigDecimal payMny = new BigDecimal(payReimburseEntity.get("payMny").toString());
//            matmap.put("settleNotax", payMny.setScale(2, RoundingMode.HALF_UP));
//            otsettleNotax = otsettleNotax.add(payMny.setScale(2, RoundingMode.HALF_UP));
//            zOtsettleNotax = zOtsettleNotax.add(payMny.setScale(2, RoundingMode.HALF_UP));
//            matmap.put("allCostNotax", payMny.setScale(2, RoundingMode.HALF_UP));
//            newChildren6.add(matmap);
//        }
        ot.put("children", newChildren6);
        ot.put("settleAmount", otsettleNotax);
        ot.put("allCostNotax", otsettleNotax);
        alldata.set(otsize, ot);

        ///////////////////////////////////////////////////////7.其他预估成本
        BigDecimal zOtsettleNotaxSum = BigDecimal.ZERO;
        Map<String, Object> ot00 = new HashMap<>();
        ot00.put("no", "7");
        ot00.put("id", "7");
        ot00.put("costItems", "其他预估成本");

        Integer ot0size = alldata.size();
        alldata.add(ot00);
        List<Map<String, Object>> newChildren7 = new ArrayList<>();
        Map<String, Object> ot1 = new HashMap<>();
        ot1.put("no", "7.1");
        ot1.put("id", "7.1");
        ot1.put("costItems", "间接费预估");
        BigDecimal jjtotalnt = forecastOtherDetailMapper.queryjjtotal(projectId);
        ot1.put("forecastNotax", jjtotalnt);
        BigDecimal jjtotalt = forecastOtherDetailMapper.queryjjtotaltax(projectId);
        ot1.put("forecastTax", jjtotalt);
        BigDecimal jjtotal = forecastOtherDetailMapper.queryjjtotalamount(projectId);
        ot1.put("forecastAmount", jjtotal);
        ot1.put("allCostNotax", jjtotalnt);
        zOtsettleNotaxSum = zOtsettleNotaxSum.add(jjtotalnt);

//            Integer ot1size = alldata.size();
        newChildren7.add(ot1);
        Map<String, Object> ot2 = new HashMap<>();
        ot2.put("no", "7.2");
        ot2.put("id", "7.2");
        ot2.put("costItems", "收尾阶段发生的其他费预估");
        BigDecimal qttotalnt = forecastOtherDetailMapper.queryqttotal(projectId);
        ot2.put("forecastNotax", qttotalnt);
        BigDecimal qttotalt = forecastOtherDetailMapper.queryqttotaltax(projectId);
        ot2.put("forecastTax", qttotalt);
        BigDecimal qttotal = forecastOtherDetailMapper.queryqttotalamount(projectId);
        ot2.put("forecastAmount", qttotal);
        ot2.put("allCostNotax", qttotalnt);
        zOtsettleNotaxSum = zOtsettleNotaxSum.add(qttotalnt);

//            Integer ot2size = alldata.size();
        newChildren7.add(ot2);
        ot00.put("children", newChildren7);
        ot00.put("forecastNotax", jjtotalnt.add(qttotalnt));
        ot00.put("forecastTax", jjtotalt.add(qttotalt));
        ot00.put("forecastAmount", jjtotal.add(qttotal));
        ot00.put("allCostNotax", zOtsettleNotaxSum);
        alldata.set(ot0size, ot00);


        return alldata;
    }

    @Override
    public List<Map<String, Object>> projectFinAllClosingSumRealTime() {
        List<Map<String,Object>> alldata = new ArrayList<>();
        List<CostClosingLastEntity> allproject = costClosingLastMapper.revenueExpenditureSummary();

        for(int s = 0;s<allproject.size();s++){
            CostClosingLastEntity materialContractEntity =allproject.get(s);
            Long trueprojectId = materialContractEntity.getProjectId();
            Integer no = s;
            Integer noo = no+1;
            Map<String,Object> matmap = new HashMap<>();
            matmap.put("no", noo);
            matmap.put("projectName",materialContractEntity.getProjectName());

            String zt = materialContractEntity.getContractCode();
            String ztname = new String();
//            工程状态；0-未开工，1-在建，2-完工未验收，3-完工验收，4-已验收未结算，5-已结算
            if(zt != null){
                if(zt.equals("0")){
                    ztname = "未开工";
                }
                if(zt.equals("1")){
                    ztname = "在建";
                }
                if(zt.equals("2")){
                    ztname = "完工未验收";
                }
                if(zt.equals("3")){
                    ztname = "完工验收";
                }
                if(zt.equals("4")){
                    ztname = "已验收未结算";
                }
                if(zt.equals("5")){
                    ztname = "已结算";
                }
            }

            matmap.put("engineerType",ztname);
            Date start = materialContractEntity.getCompletionTime();
            Date end = materialContractEntity.getCompletionAcceptanceTime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if(start != null){
                String startdateString = sdf.format(start);
                matmap.put("actualStart",startdateString);
            }
            if(end != null){
                String enddateString = sdf.format(end);
                matmap.put("completionAcceptanceTime",enddateString);
            }
//            matmap.put("actualStart",materialContractEntity.getCompletionTime());
//            matmap.put("completionAcceptanceTime",materialContractEntity.getCompletionAcceptanceTime());
            matmap.put("projectCost",materialContractEntity.getSumProductionTaxMny());
            //开累不含税产值  A
            matmap.put("sumProductionMny",materialContractEntity.getSettlementTax());
            //已计量不含税  D
            matmap.put("calculateExcludtax",materialContractEntity.getSumProductionMny());
            // C
            matmap.put("maxSettlement",materialContractEntity.getLastTaxOutputValue());
            // D
            matmap.put("conservativeSettlement",materialContractEntity.getLastOutputValue());

            BigDecimal Damount = materialContractEntity.getLastOutputValue();

            //工程结算审计值（不含税）
            matmap.put("settleAuditAmount",materialContractEntity.getSumProductionMny());

            // E
            BigDecimal subsettle = costClosingForecastMapper.subsettle(trueprojectId);
            BigDecimal materialsettle = costClosingForecastMapper.materialsettle(trueprojectId);
            BigDecimal machinesettle = costClosingForecastMapper.machinesettle(trueprojectId);
            BigDecimal othersettle = costClosingForecastMapper.othersettle(trueprojectId);
            BigDecimal ljfk =  costClosingForecastMapper.ljfk(trueprojectId);
            BigDecimal yjs = subsettle.add(materialsettle).add(machinesettle).add(othersettle).add(ljfk);
            matmap.put("closeCosty",yjs);
            //F(F应为预估-预估发生后的结算)
            BigDecimal subnotax = costClosingForecastMapper.subnotax(trueprojectId);
            BigDecimal subchangenotax = costClosingForecastMapper.subchangenotax(trueprojectId);
            BigDecimal othnotax = costClosingForecastMapper.othnotax(trueprojectId);
            BigDecimal othchangenotax = costClosingForecastMapper.othchangenotax(trueprojectId);
            BigDecimal yg = subnotax.add(subchangenotax).add(othnotax).add(othchangenotax);

            //
            BigDecimal conjs = forecastOtherDetailChangeMapper.conjs(trueprojectId);
            BigDecimal js = forecastOtherDetailChangeMapper.js(trueprojectId);
            BigDecimal closecostv = yg.subtract(conjs).subtract(js);
            matmap.put("closeCostv",closecostv);
            //G = E+F
            BigDecimal wgzcb = yjs.add(closecostv);
            matmap.put("totalCost",wgzcb);
            // H = D-G
            BigDecimal lr = Damount.subtract(wgzcb);
            matmap.put("expectprofitax",lr);
            //I = H/D
            BigDecimal lrl = new BigDecimal("0.00");
            if(lr.compareTo(BigDecimal.ZERO) != 0 && Damount.compareTo(BigDecimal.ZERO) != 0){
                lrl = lr.divide(Damount,2, BigDecimal.ROUND_HALF_UP);
            }
            matmap.put("expectprofits",lrl);

            BigDecimal qblr = costClosingForecastMapper.queryqblrl(trueprojectId);
            matmap.put("targetprofitaxqb",qblr);
            BigDecimal mblr = costClosingForecastMapper.querylrl(trueprojectId);
            matmap.put("targetprofitax",mblr);
            BigDecimal tzlr = costClosingForecastMapper.querytzlrl(trueprojectId);
            matmap.put("targetprofitaxtz",tzlr);


            alldata.add(matmap);
        }
        return alldata;
    }


}
