package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.service.ISubjectProjectService;
import com.ejianc.business.cost.vo.SubjectOrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.SubjectOrgMapper;
import com.ejianc.business.cost.bean.SubjectOrgEntity;
import com.ejianc.business.cost.service.ISubjectOrgService;

import java.util.ArrayList;
import java.util.List;

/**
 * 集团成本科目实体
 *
 * @author generator
 */
@Service("subjectOrgService")
public class SubjectOrgServiceImpl extends BaseServiceImpl<SubjectOrgMapper, SubjectOrgEntity> implements ISubjectOrgService {

    @Autowired
    private ISubjectProjectService subjectProjectService;

    @Override
    public CommonResponse<SubjectOrgVO> saveOrUpdate(SubjectOrgVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        SubjectOrgEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            List<Long> ids = new ArrayList<>();
            ids.add(saveorUpdateVO.getId());
            Boolean flag = subjectProjectService.delRefCheck(ids);
            if (flag) {
                throw new BusinessException("存在被引用的核算对象，暂不允许编辑");
            }
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<SubjectOrgEntity> lambda = Wrappers.<SubjectOrgEntity>lambdaQuery();
            lambda.eq(SubjectOrgEntity::getSubjectCode, saveorUpdateVO.getSubjectCode());
            lambda.eq(SubjectOrgEntity::getTenantId, tenantId);
            lambda.ne(SubjectOrgEntity::getId, saveorUpdateVO.getId());
            List<SubjectOrgEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }

            entity = BeanMapper.map(saveorUpdateVO, SubjectOrgEntity.class);
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("修改成功！");
        } else {//新增
            //校验合同编号是否重复
            LambdaQueryWrapper<SubjectOrgEntity> lambda = Wrappers.<SubjectOrgEntity>lambdaQuery();
            lambda.eq(SubjectOrgEntity::getTenantId, tenantId);
            lambda.eq(SubjectOrgEntity::getSubjectCode, saveorUpdateVO.getSubjectCode());
            List<SubjectOrgEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
            entity = BeanMapper.map(saveorUpdateVO, SubjectOrgEntity.class);
            entity.setId(IdWorker.getId());
            if (entity.getParentId() != null && entity.getParentId() > 0) {
                SubjectOrgEntity uniqueBean = baseMapper.selectById(entity.getParentId());
                entity.setInnerCode(uniqueBean.getInnerCode() + "," + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("保存成功！");
        }
    }

    @Override
    public List<SubjectOrgVO> getChildrenByPid(Long id) {
        SubjectOrgEntity parent = this.selectById(id);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("innerCode", new Parameter(QueryParam.LIKE_RIGHT, parent.getInnerCode()));
        List<SubjectOrgEntity> list = super.queryList(queryParam, false);
        return BeanMapper.mapList(list, SubjectOrgVO.class);
    }
}
