package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.vo.TurnMaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.TurnMaterialMapper;
import com.ejianc.business.cost.bean.TurnMaterialEntity;
import com.ejianc.business.cost.service.ITurnMaterialService;

/**
 * 周转材摊销费用单
 * 
 * @author generator
 * 
 */
@Service("turnMaterialService")
public class TurnMaterialServiceImpl extends BaseServiceImpl<TurnMaterialMapper, TurnMaterialEntity> implements ITurnMaterialService{
    private static final String BILL_CODE = "TURN_CODE";;//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Override
    public TurnMaterialVO saveOrUpdate(TurnMaterialVO saveOrUpdateVO) {
        TurnMaterialEntity entity = BeanMapper.map(saveOrUpdateVO, TurnMaterialEntity.class);
        if(StringUtils.isBlank(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        return queryDetail(entity.getId());
    }

    @Override
    public TurnMaterialVO queryDetail(Long id) {
        TurnMaterialEntity entity = super.selectById(id);
        TurnMaterialVO vo = BeanMapper.map(entity, TurnMaterialVO.class);
        return vo;
    }
}
