package com.ejianc.certify.enums;

public enum BillStatusEnum {
    /**
     * 单据状态
     */
    STORAGE(-1, "暂存"),
    FREE(0, "自由态"),
    COMMIT(1, "提交态"),
    APPROVING(2, "审批进行中"),
    APPROVED(3, "审批通过"),
    UNAPPROVED(4, "审批不通过 "),//没用
    APPROVECOMMIT(5, "已提交未审批");

    private Integer id;
    private String name;

    BillStatusEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public static String getDesc(Integer id){
        switch (id){
            case -1:
                return BillStatusEnum.STORAGE.getName();
            case 0:
                return BillStatusEnum.FREE.getName();
            case 1:
                return BillStatusEnum.COMMIT.getName();
            case 2:
                return BillStatusEnum.APPROVING.getName();
            case 3:
                return BillStatusEnum.APPROVED.getName();
            case 4:
                return BillStatusEnum.UNAPPROVED.getName();
            case 5:
                return BillStatusEnum.APPROVECOMMIT.getName();
            default:
                return BillStatusEnum.STORAGE.getName();
        }
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
