package com.ejianc.certify.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum BillStatusEnum {
    /**
     * 单据状态
     */
    STORAGE(-1, "暂存"),
    FREE(0, "自由态"),
    COMMIT(1, "已提交"),
    APPROVING(2, "审核中（有人审核）"),
    APPROVED(3, "审批通过"),
    UNAPPROVED(4, "审批驳回"),
    APPROVECOMMIT(5, "审核中(有审批流的提交态)");

    private Integer id;
    private String name;
    private static Map<Integer, BillStatusEnum> enumMap = new HashMap<>();

    BillStatusEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    static {
        enumMap = EnumSet.allOf(BillStatusEnum.class).stream().collect(Collectors.toMap(BillStatusEnum::getId, Function.identity(), (k1, k2) -> k2));
    }

    public static BillStatusEnum getEnumByStateCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }

    public static String getDesc(Integer id){
        switch (id){
            case -1:
                return BillStatusEnum.STORAGE.getName();
            case 0:
                return BillStatusEnum.FREE.getName();
            case 1:
                return BillStatusEnum.COMMIT.getName();
            case 2:
                return BillStatusEnum.APPROVING.getName();
            case 3:
                return BillStatusEnum.APPROVED.getName();
            case 4:
                return BillStatusEnum.UNAPPROVED.getName();
            case 5:
                return BillStatusEnum.APPROVECOMMIT.getName();
            default:
                return BillStatusEnum.STORAGE.getName();
        }
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
