package com.ejianc.certify.enums;

/**
 * @description  证照类别状态枚举类
 * @author ligansi
 */
public enum CertifTypeStatusEnum {
    NOT_ACTIVATED(0, "未启用"),
    ACTIVATED(1, "已启用"),
    TERMINATED(2, "已停用");

    private Integer code;
    private String desc;

    CertifTypeStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDesc(Integer code){
        switch (code){
            case 1:
                return CertifTypeStatusEnum.ACTIVATED.getDesc();
            case 2:
                return CertifTypeStatusEnum.TERMINATED.getDesc();
            default:
                return CertifTypeStatusEnum.NOT_ACTIVATED.getDesc();
        }
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
