/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.certify.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum BillStatusEnum {
    STORAGE(-1, "\u6682\u5b58"),
    FREE(0, "\u81ea\u7531\u6001"),
    COMMIT(1, "\u5df2\u63d0\u4ea4"),
    APPROVING(2, "\u5ba1\u6838\u4e2d\uff08\u6709\u4eba\u5ba1\u6838\uff09"),
    APPROVED(3, "\u5ba1\u6279\u901a\u8fc7"),
    UNAPPROVED(4, "\u5ba1\u6279\u9a73\u56de"),
    APPROVECOMMIT(5, "\u5ba1\u6838\u4e2d(\u6709\u5ba1\u6279\u6d41\u7684\u63d0\u4ea4\u6001)");

    private Integer id;
    private String name;
    private static Map<Integer, BillStatusEnum> enumMap;

    private BillStatusEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public static BillStatusEnum getEnumByStateCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }

    public static String getDesc(Integer id) {
        switch (id) {
            case -1: {
                return STORAGE.getName();
            }
            case 0: {
                return FREE.getName();
            }
            case 1: {
                return COMMIT.getName();
            }
            case 2: {
                return APPROVING.getName();
            }
            case 3: {
                return APPROVED.getName();
            }
            case 4: {
                return UNAPPROVED.getName();
            }
            case 5: {
                return APPROVECOMMIT.getName();
            }
        }
        return STORAGE.getName();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    static {
        enumMap = new HashMap<Integer, BillStatusEnum>();
        enumMap = EnumSet.allOf(BillStatusEnum.class).stream().collect(Collectors.toMap(BillStatusEnum::getId, Function.identity(), (k1, k2) -> k2));
    }
}

