package com.ejianc.certify.utils;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Objects;

/**
 * @author yxm
 * @date 2022/6/8
 * @description
 */
public class RpcUtil {

    /**
     * @description  校验rpc服务是否调用成功
     * @author yxm
     * @date 2022/6/8
     * @param resp          返回值
     * @param isMustSuc     是否必须查到数据
     * @param title         失败标题
     * @param errMsg        失败原因
     */
    public static void checkRespData(CommonResponse<?> resp, boolean isMustSuc, String title, String errMsg) {
        if (!resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? title + errMsg : "调用Rpc服务失败");
        }
        if (isMustSuc) {
            if (Objects.isNull(resp.getData())) {
                throw new BusinessException(title + "查询不到数据!");
            }
            if (resp.getData() instanceof List && ListUtil.isEmpty((List) resp.getData())) {
                throw new BusinessException(title + "查询不到数据!");
            }
            if (resp.getData() instanceof IPage && ListUtil.isEmpty(((IPage) resp.getData()).getRecords())) {
                throw new BusinessException(title + "查询不到数据!");
            }
        }
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须查到数据
     * title  失败标题
     * errMsg 失败原因
     */
    public static Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String title, String errMsg) {
        if (!resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? title + errMsg : "调用Rpc服务失败");
        }
        if (isMustSuc) {
            if (Objects.isNull(resp.getData())) {
                throw new BusinessException(title + "查询不到数据!");
            }
            if (resp.getData() instanceof List && ListUtil.isEmpty((List) resp.getData())) {
                throw new BusinessException(title + "查询不到数据!");
            }
            if (resp.getData() instanceof IPage && ListUtil.isEmpty(((IPage) resp.getData()).getRecords())) {
                throw new BusinessException(title + "查询不到数据!");
            }
        }
        return resp.getData();
    }


}
