/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.certify.utils;

import com.ejianc.certify.utils.RpcUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthUtil {
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IEmployeeApi iEmplApi;
    @Autowired
    private SessionManager sessionManager;
    private static AuthUtil authUtil;

    @PostConstruct
    public void init() {
        authUtil = this;
        AuthUtil.authUtil.iEmplApi = this.iEmplApi;
        AuthUtil.authUtil.iOrgApi = this.iOrgApi;
        AuthUtil.authUtil.sessionManager = this.sessionManager;
    }

    public static Map<String, List<Long>> getOrgAndDeptAuths() {
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>();
        UserContext userContextCache = AuthUtil.authUtil.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            List ids = Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
            CommonResponse childsResp = AuthUtil.authUtil.iOrgApi.findChildrenByParentIds(ids);
            orgVOList = (List)RpcUtil.getRespData(childsResp, false, "\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25:", childsResp.getMsg());
        } else {
            CommonResponse childsResp = AuthUtil.authUtil.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
            orgVOList = (List)RpcUtil.getRespData(childsResp, false, "\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25:", childsResp.getMsg());
        }
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            result.put("pkOrg", commonOrgIds);
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            result.put("pkDept", departmentIds);
        }
        return result;
    }

    public static List<Long> getOrgAuths() {
        UserContext userContextCache = AuthUtil.authUtil.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            List ids = Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
            CommonResponse childsResp = AuthUtil.authUtil.iOrgApi.findChildrenByParentIds(ids);
            orgVOList = (List)RpcUtil.getRespData(childsResp, false, "\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25:", childsResp.getMsg());
        } else {
            CommonResponse childsResp = AuthUtil.authUtil.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
            orgVOList = (List)RpcUtil.getRespData(childsResp, false, "\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25:", childsResp.getMsg());
        }
        List<Long> commonOrgIds = orgVOList.stream().filter(org -> org.getOrgType() != 5).map(BaseVO::getId).collect(Collectors.toList());
        return commonOrgIds;
    }
}

