/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.certify.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BarCodeUtils {
    private static final int WIDTH = 200;
    private static final int HEIGHT = 50;
    private static final int WORD_HEIGHT = 110;
    private static Map<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(EncodeHintType.CHARACTER_SET, "utf-8");
            this.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            this.put(EncodeHintType.MARGIN, 1);
        }
    };

    public static BufferedImage getBarCode(String vaNumber) {
        Code128Writer writer = new Code128Writer();
        BitMatrix bitMatrix = writer.encode(vaNumber, BarcodeFormat.CODE_128, 200, 50, hints);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
    }

    public static BufferedImage insertWords(BufferedImage image, String words) {
        if (StringUtils.isNotEmpty((CharSequence)words)) {
            BufferedImage outImage = new BufferedImage(200, 110, 1);
            Graphics2D g2d = outImage.createGraphics();
            BarCodeUtils.setGraphics2D(g2d);
            BarCodeUtils.setColorWhite(g2d);
            g2d.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
            Color color = new Color(0, 0, 0);
            g2d.setColor(color);
            g2d.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 16));
            int strWidth = g2d.getFontMetrics().stringWidth(words);
            int wordStartX = (200 - strWidth) / 2;
            int wordStartY = 70;
            boolean timeWidth = true;
            g2d.drawString(words, wordStartX, wordStartY);
            g2d.dispose();
            outImage.flush();
            return outImage;
        }
        return null;
    }

    private static void setGraphics2D(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        BasicStroke s = new BasicStroke(1.0f, 1, 0);
        g2d.setStroke(s);
    }

    private static void setColorWhite(Graphics2D g2d) {
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, 302, 113);
        g2d.setColor(Color.BLACK);
    }
}

