package com.ejianc.certify.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * @author yxm
 * @date 2022/6/14
 * @description 主数据类型枚举类
 */
public enum MdgTypeEnum {
    ZC("ZC","成本中心"),
    ZB("ZB","利润中心"),
    ZBNU("ZBNU","主数据联行号");

    private String code;
    private String desc;

    private static Map<String,MdgTypeEnum> enumMap = new HashMap<>();

    static {
        for (MdgTypeEnum value : MdgTypeEnum.values()) {
            enumMap.put(value.getCode(),value);
            enumMap.put(value.getDesc(),value);
        }
    }


    private MdgTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code查找
     * @param code 枚举code
     * @return 枚举对象
     */
    public static String findDesc(String code) {
        String desc = enumMap.get(code).getDesc();
        if (StringUtils.isNotBlank(desc)) {
            return desc;
        }else{
            throw new IllegalArgumentException("没有找到对应的是否状态,请检查数据是否正确");
        }
    }

    /**
     * 根据desc查找
     * @param desc 枚举desc
     * @return 枚举对象
     */
    public static String findCode(String desc) {
        String code = enumMap.get(desc).getCode();
        if (Optional.ofNullable(code).isPresent()) {
            return code;
        }else{
            throw new IllegalArgumentException("没有找到对应的是否状态,请检查数据是否正确");
        }
    }
}
