/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.certify.utils;

import com.ejianc.certify.utils.Base64Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientTool {
    private static final Logger log = LoggerFactory.getLogger(HttpClientTool.class);

    public static String sendHttpGet(String url) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        return HttpClientTool.doGet(url, httpClient);
    }

    public static String sendHttpsGet(String url) throws Exception {
        CloseableHttpClient httpClient = HttpClientTool.createIgnoreVerifyHttpClient();
        return HttpClientTool.doGet(url, httpClient);
    }

    public static String sendHttpPost(String url, String params) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        return HttpClientTool.doPost(httpClient, url, params);
    }

    public static String sendHttpsPost(String url, String params) throws Exception {
        CloseableHttpClient httpClient = HttpClientTool.createIgnoreVerifyHttpClient();
        return HttpClientTool.doPost(httpClient, url, params);
    }

    private static String doGet(String url, CloseableHttpClient httpClient) throws Exception {
        log.info("HGet\u8bf7\u6c42url={}", (Object)url);
        HttpGet httpGet = new HttpGet(url);
        return HttpClientTool.execute(httpClient, (HttpRequestBase)httpGet);
    }

    private static String doPost(CloseableHttpClient httpClient, String url, String params) throws Exception {
        log.info("Post\u8bf7\u6c42url\uff1a{}", (Object)url);
        log.info("Post\u8bf7\u6c42params\uff1a{}", (Object)params);
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json; charset=utf-8");
        httpPost.setEntity((HttpEntity)new StringEntity(params, Charset.forName("UTF-8")));
        return HttpClientTool.execute(httpClient, (HttpRequestBase)httpPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String execute(CloseableHttpClient httpClient, HttpRequestBase requestBase) throws Exception {
        String result = null;
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)requestBase);
            int statusCode = response.getStatusLine().getStatusCode();
            log.info("HttpClient\u54cd\u5e94\u7801={}", (Object)statusCode);
            if (statusCode == 200) {
                result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            } else {
                result = String.valueOf(statusCode);
                log.error("HttpClient\u8bf7\u6c42\u5931\u8d25\uff0c\u9519\u8bef\u7801={}", (Object)statusCode);
            }
        }
        catch (Exception e) {
            log.error("HttpClient\u8bf7\u6c42\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            if (null != httpClient) {
                httpClient.close();
            }
            if (null != response) {
                response.close();
            }
        }
        log.info("HttpClient\u8bf7\u6c42\u7ed3\u679c\uff1a{}", result);
        return result;
    }

    public static CloseableHttpClient createIgnoreVerifyHttpClient() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sslContext.init(null, new TrustManager[]{trustManager}, null);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
        return httpClient;
    }

    public static CloseableHttpClient createIgnoreVerifyHttpClient(String user, String password) throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sslContext.init(null, new TrustManager[]{trustManager}, null);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(user, password);
        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)provider).setConnectionManager((HttpClientConnectionManager)connManager).build();
        return httpClient;
    }

    public static String sendHttpsPost(String url, String params, String user, String password) throws Exception {
        CloseableHttpClient httpClient = HttpClientTool.createIgnoreVerifyHttpClient(user, password);
        return HttpClientTool.doPost(httpClient, url, params);
    }

    public static String sendJsonPost(String url, String paramJson, String username, String password) throws Exception {
        OutputStreamWriter out = null;
        BufferedReader in = null;
        StringBuffer result = new StringBuffer();
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            HttpClientTool.addHeaderBasic(username, password, conn);
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(60000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            out.write(paramJson);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (result != null && result.length() > 0) {
            return result.toString();
        }
        return null;
    }

    public static String sendJsonPostApikey(String url, String paramJson, String apikey) throws Exception {
        OutputStreamWriter out = null;
        BufferedReader in = null;
        StringBuffer result = new StringBuffer();
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            HttpClientTool.addHeaderApiKey(apikey, conn);
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(60000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            out.write(paramJson);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (result != null && result.length() > 0) {
            return result.toString();
        }
        return null;
    }

    public static void addHeaderBasic(String username, String password, URLConnection urlConn) {
        String basic = username + ":" + password;
        urlConn.addRequestProperty("Authorization", "Basic " + Base64Util.getBase64Encoder().encode(basic.getBytes()));
    }

    public static void addHeaderApiKey(String appkey, URLConnection urlConn) {
        urlConn.addRequestProperty("APPKEY", appkey);
    }
}

