package com.ejianc.business.doc.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.doc.vo.KbmCategoryAccessVO;
import com.ejianc.business.doc.vo.KbmCategoryUploadVO;

/**
 * 知识分类
 * 
 * @author generator
 * 
 */
public class KbmCategoryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String categoryName; // 分类名称
    private String access; // 访问权限，0-默认，1-自定义
    private String upload; // 上传权限，0-不允许，1-默认，2-自定义
    private String enabled; // 启停用，1启用0停用
    private Long orgId; // 组织主键
    private String orgName; // 组织名称
    private Long parentId; // 父id
    private String parentName; // 父名称
    private String innerCode; // 内置编码
    
    private List<KbmCategoryAccessVO> kbmCategoryAccessVos = new ArrayList<>(); // 知识分类访问权限
    private List<KbmCategoryUploadVO> kbmCategoryUploadVos = new ArrayList<>(); // 知识分类上传权限

    private String userAccess;// 用户访问权限，0-没有(补充过来的)，1-有
    private String userUpload;// 用户上传权限，0-没有(补充过来的)，1-有
    private Integer fileNum;// 分类下文件夹的数量

    public Integer getFileNum() {
        return fileNum;
    }

    public void setFileNum(Integer fileNum) {
        this.fileNum = fileNum;
    }

    public String getUserUpload() {
        return userUpload;
    }

    public void setUserUpload(String userUpload) {
        this.userUpload = userUpload;
    }

    public String getUserAccess() {
        return userAccess;
    }

    public void setUserAccess(String userAccess) {
        this.userAccess = userAccess;
    }

    /**
     * 分类名称
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * 分类名称
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    /**
     * 访问权限，0-默认，1-自定义
     */
    public String getAccess() {
        return access;
    }

    /**
     * 访问权限，0-默认，1-自定义
     */
    public void setAccess(String access) {
        this.access = access;
    }
    /**
     * 上传权限，0-不允许，1-默认，2-自定义
     */
    public String getUpload() {
        return upload;
    }

    /**
     * 上传权限，0-不允许，1-默认，2-自定义
     */
    public void setUpload(String upload) {
        this.upload = upload;
    }
    /**
     * 是否启用，0-否，1-是
     */
    public String getEnabled() {
        return enabled;
    }

    public void setEnabled(String enabled) {
        this.enabled = enabled;
    }

    /**
     * 组织主键
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织主键
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父id
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * 父id
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 父名称
     */
    public String getParentName() {
        return parentName;
    }

    /**
     * 父名称
     */
    public void setParentName(String parentName) {
        this.parentName = parentName;
    }
    /**
     * 内置编码
     */
    public String getInnerCode() {
        return innerCode;
    }

    /**
     * 内置编码
     */
    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    
     /**
      * 知识分类访问权限
      */
     public List<KbmCategoryAccessVO> getKbmCategoryAccessVos() {
        return kbmCategoryAccessVos;
     }

     /**
      * 知识分类访问权限
      */
     public void setKbmCategoryAccessVos(List<KbmCategoryAccessVO> kbmCategoryAccessVos) {
        this.kbmCategoryAccessVos = kbmCategoryAccessVos;
     }
     /**
      * 知识分类上传权限
      */
     public List<KbmCategoryUploadVO> getKbmCategoryUploadVos() {
        return kbmCategoryUploadVos;
     }

     /**
      * 知识分类上传权限
      */
     public void setKbmCategoryUploadVos(List<KbmCategoryUploadVO> kbmCategoryUploadVos) {
        this.kbmCategoryUploadVos = kbmCategoryUploadVos;
     }
}
