/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.doc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.doc.bean.DocCategoryEntity;
import com.ejianc.business.doc.service.IDocCategoryService;
import com.ejianc.business.doc.vo.DocCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"docCategory"})
public class DocCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDocCategoryService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DocCategoryVO> saveOrUpdate(@RequestBody DocCategoryVO saveorUpdateVO) {
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            DocCategoryEntity uniqueBean = (DocCategoryEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
            uniqueBean.setCategoryName(saveorUpdateVO.getCategoryName());
            uniqueBean.setNum(saveorUpdateVO.getNum());
            uniqueBean.setRequired(saveorUpdateVO.getRequired());
            this.service.saveOrUpdate((Object)uniqueBean, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        DocCategoryEntity entity = (DocCategoryEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), DocCategoryEntity.class));
        entity.setId(IdWorker.getId());
        if (entity.getPid() != null && entity.getPid() > 0L) {
            DocCategoryEntity uniqueBean = (DocCategoryEntity)((Object)this.service.selectById(entity.getPid()));
            entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DocCategoryVO> queryDetail(Long id) {
        DocCategoryEntity entity = (DocCategoryEntity)((Object)this.service.selectById(id));
        DocCategoryVO vo = (DocCategoryVO)((Object)BeanMapper.map((Object)((Object)entity), DocCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DocCategoryVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        List resultMapList = BeanMapper.mapList((Iterable)page.getRecords(), Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @RequestMapping(value={"/enabled"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> enabled(@RequestParam Long id, @RequestParam boolean enable) {
        DocCategoryEntity entity = (DocCategoryEntity)((Object)this.service.selectById(id));
        if (enable) {
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("innerCode", new Parameter("like", (Object)entity.getInnerCode()));
            List editList = this.service.queryList(param, false);
            List<DocCategoryVO> parents = this.service.findParentsByOrgId(id);
            for (DocCategoryVO vo : parents) {
                if (vo.getId().equals(id)) continue;
                if (!"0".equals(vo.getEnabled())) break;
                editList.add(BeanMapper.map((Object)((Object)vo), DocCategoryEntity.class));
            }
            for (DocCategoryEntity en : editList) {
                en.setEnabled("1");
            }
            this.service.saveOrUpdateBatch(editList, editList.size(), false);
        } else {
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("innerCode", new Parameter("like", (Object)entity.getInnerCode()));
            List editList = this.service.queryList(param, false);
            for (DocCategoryEntity en : editList) {
                en.setEnabled("0");
            }
            this.service.saveOrUpdateBatch(editList, editList.size(), false);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01");
    }
}

