package com.ejianc.business.doc.controller;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.doc.bean.DocCategoryEntity;
import com.ejianc.business.doc.bean.DocCategoryRoleRelationEntity;
import com.ejianc.business.doc.service.IDocCategoryRoleRelationService;
import com.ejianc.business.doc.service.IDocCategoryService;
import com.ejianc.business.doc.vo.DocCategoryRoleRelationVO;
import com.ejianc.business.doc.vo.DocCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;

/**
 * 文档分类
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("docCategory")
public class DocCategoryController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IDocCategoryService service; 
    @Autowired
    private IDocCategoryRoleRelationService relationService; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DocCategoryVO> saveOrUpdate(@RequestBody DocCategoryVO saveorUpdateVO) {
		if(saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) {
			DocCategoryEntity uniqueBean = service.selectById(saveorUpdateVO.getId());
			uniqueBean.setCategoryName(saveorUpdateVO.getCategoryName());
			uniqueBean.setNum(saveorUpdateVO.getNum());
			uniqueBean.setRequired(saveorUpdateVO.getRequired());
			service.saveOrUpdate(uniqueBean, false);
			return CommonResponse.success("修改成功！");
		}else{
	    	DocCategoryEntity entity = BeanMapper.map(saveorUpdateVO, DocCategoryEntity.class);
	    	entity.setId(IdWorker.getId());
	    	entity.setEnabled("1");
			if(entity.getParentId() != null && entity.getParentId() > 0) {
				DocCategoryEntity uniqueBean = service.selectById(entity.getParentId());
				entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
			} else {
				entity.setInnerCode(entity.getId().toString());
			}
			service.saveOrUpdate(entity, false);
	    	return CommonResponse.success("保存成功！");
		}
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DocCategoryVO> queryDetail(Long id) {
    	DocCategoryEntity entity = service.selectById(id);
    	DocCategoryVO vo = BeanMapper.map(entity, DocCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DocCategoryVO> vos) {
        service.removeByIds(vos.stream().map(DocCategoryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询分类树
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @SuppressWarnings("rawtypes")
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 租户隔离 */
    	param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
    	List<DocCategoryEntity> list = service.queryList(param,false);

		List<Map> resultMapList = BeanMapper.mapList(list, Map.class);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success("查询列表数据成功！",jsonObject);
    }

    /**
     * @Description 启停用
     * @param id：分类id；enable：将要启停用的状态，启用true停用false
     */
    @RequestMapping(value = "/enabled", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> enabled(@RequestParam Long id, @RequestParam boolean enable) {
    	DocCategoryEntity entity = service.selectById(id);
    	//父级停用所有子级停用；父级开启所有子级开启；子级开启一个,父级开启；子级全部停用，父级停用
    	if(enable){
    		//启用
    		//1、查询所有下级
    		QueryParam param = new QueryParam();
        	param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        	param.getParams().put("innerCode", new Parameter(QueryParam.LIKE, entity.getInnerCode()));
            List<DocCategoryEntity> editList = service.queryList(param,false);
            //2、子级开启一个,父级开启
            List<DocCategoryVO> parents = service.findParentsById(id);
            for(DocCategoryVO vo : parents){
            	if(!vo.getId().equals(id)){//去除本级
            		//寻找到上级启用的节点为止
            		if("0".equals(vo.getEnabled())){
            			editList.add(BeanMapper.map(vo, DocCategoryEntity.class));
            		}else{
            			break;
            		}
            	}
            }
            for (DocCategoryEntity en : editList) {
            	en.setEnabled("1");
			}
            service.saveOrUpdateBatch(editList, editList.size(), false);
            return CommonResponse.success("启用成功！");
    	}else{
    		//停用
    		//1、父级停用所有子级停用
    		QueryParam param = new QueryParam();
        	param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        	param.getParams().put("innerCode", new Parameter(QueryParam.LIKE, entity.getInnerCode()));
            List<DocCategoryEntity> editList = service.queryList(param,false);
            for (DocCategoryEntity en : editList) {
            	en.setEnabled("0");
			}
            service.saveOrUpdateBatch(editList, editList.size(), false);
            //2、子级全部停用，父级停用---需求不合理，注掉
            /*if(entity.getPid()!=null){
                //获取父级的详细信息，
            	DocCategoryEntity pentity = service.selectById(entity.getPid());
            	param.getParams().put("innerCode", new Parameter(QueryParam.LIKE, pentity.getInnerCode()));
                List<DocCategoryEntity> pEditList = service.queryList(param,false);
                boolean flag = true;
                for (DocCategoryEntity en : editList) {
                	if(!en.getId().equals(entity.getPid())){//非父节点本身
                		//若其子节点中存在启用的节点，则不需要停用父节点
                		if("1".equals(en.getEnabled())){
                			flag = false;
                		}
                	}
    			}
                if(flag){
                	//子级全部停用，停用父级
                	pentity.setEnabled("0");
                	service.saveOrUpdate(pentity, false);
                }
            }*/
            return CommonResponse.success("停用成功！");
    	}
    }

    /*********************角色start*********************/
    /**
     * @Description queryList 查询角色列表信息
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
	@RequestMapping(value = "/queryRoleList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DocCategoryRoleRelationVO>> queryRoleList(@RequestBody QueryParam param) {
		
    	param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
    	IPage<DocCategoryRoleRelationEntity> page = relationService.queryPage(param,false);
    	
    	IPage<DocCategoryRoleRelationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DocCategoryRoleRelationVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

	/**
	 * 保存套餐角色关系
	 * 
	 * 
	 * 
	 * @return
	 */
	@RequestMapping(value = "/saveDocCategoryRole", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveDocCategoryRole(@RequestBody List<DocCategoryRoleRelationVO> relationList) {
		return relationService.saveDocCategoryRole(relationList);
	}

	/**
	 * 删除授权角色
	 * 
	 * 
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/deleteDocCategoryRole", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> deleteDocCategoryRole(@RequestBody List<DocCategoryRoleRelationVO> relationList) {
		return relationService.deleteDocCategoryRole(relationList);
	}
    /*********************角色end*********************/
    
}
