package com.ejianc.business.doc.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.doc.bean.DocCategoryEntity;
import com.ejianc.business.doc.bean.DocCategoryRoleRelationEntity;
import com.ejianc.business.doc.mapper.DocCategoryRoleRelationMapper;
import com.ejianc.business.doc.service.IDocCategoryRoleRelationService;
import com.ejianc.business.doc.service.IDocCategoryService;
import com.ejianc.business.doc.vo.DocCategoryRoleRelationVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 文档分类角色关系
 * 
 * @author generator
 * 
 */
@Service("docCategoryRoleRelationService")
public class DocCategoryRoleRelationServiceImpl extends BaseServiceImpl<DocCategoryRoleRelationMapper, DocCategoryRoleRelationEntity> implements IDocCategoryRoleRelationService{

	@Autowired
	private DocCategoryRoleRelationMapper docCategoryMapper;
	@Autowired
	private IDocCategoryService docCategoryService;
	
	

	@Override
	public CommonResponse<String> saveDocCategoryRole(List<DocCategoryRoleRelationVO> relationList) {
		List<DocCategoryRoleRelationEntity> addList = new ArrayList<>();
		String roleName = "";
		//1、判重
		QueryWrapper<DocCategoryRoleRelationEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("category_id", relationList.get(0).getCategoryId());
		queryWrapper.eq("dr", 0);
		List<DocCategoryRoleRelationEntity> list = this.list(queryWrapper);
		Map<Long,DocCategoryRoleRelationEntity> map = new HashMap<>();
		if(list!=null&&list.size()>0){
			for(DocCategoryRoleRelationEntity relation : list){
				map.put(relation.getRoleId(), relation);
				if(roleName.length()>0){
					roleName += ("、"+relation.getRoleName());
				}else{
					roleName += relation.getRoleName();
				}
			}
		}
		String message = "";
		for(DocCategoryRoleRelationVO vo : relationList){
			if(map.get(vo.getRoleId())==null){
				addList.add(BeanMapper.map(vo, DocCategoryRoleRelationEntity.class));
			}else{
				if(message.length()>0){
					message += ("、"+vo.getRoleName());
				}else{
					message += vo.getRoleName();
				}
			}
		}
		//2、保存
		if(addList.size()>0){
			this.saveOrUpdateBatch(addList, addList.size(), false);
			for(DocCategoryRoleRelationEntity relation : addList){
				map.put(relation.getRoleId(), relation);
				if(roleName.length()>0){
					roleName += ("、"+relation.getRoleName());
				}else{
					roleName += relation.getRoleName();
				}
			}
			DocCategoryEntity categoryEntity = docCategoryService.getById(relationList.get(0).getCategoryId());
			categoryEntity.setRoleName(roleName);
			docCategoryService.saveOrUpdate(categoryEntity, false);
			if(addList.size()!=relationList.size()){
				//有重复数据
				return CommonResponse.success("添加成功,其中以下角色："+message+"已存在");
			}
		}else{
			return CommonResponse.success("选择的角色都已在该分类下，请重新选择");
		}
		
		//
		return CommonResponse.success("添加成功");
	}

	@Override
	public CommonResponse<String> deleteDocCategoryRole(List<DocCategoryRoleRelationVO> relationList) {
		List<Long> ids = new ArrayList<>();
		for(DocCategoryRoleRelationVO vo : relationList){
			ids.add(vo.getId());
		}
		this.removeByIds(ids, false);

		String roleName = "";
		QueryWrapper<DocCategoryRoleRelationEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("category_id", relationList.get(0).getCategoryId());
		queryWrapper.eq("dr", 0);
		List<DocCategoryRoleRelationEntity> list = this.list(queryWrapper);
		if(list!=null&&list.size()>0){
			for(DocCategoryRoleRelationEntity relation : list){
				if(roleName.length()>0){
					roleName += ("、"+relation.getRoleName());
				}else{
					roleName += relation.getRoleName();
				}
			}
		}

		DocCategoryEntity categoryEntity = docCategoryService.getById(relationList.get(0).getCategoryId());
		categoryEntity.setRoleName(roleName);
		docCategoryService.saveOrUpdate(categoryEntity, false);
		return CommonResponse.success("删除成功");
	}
	
}
