package com.ejianc.business.doc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.doc.bean.ProjectDocEntity;
import com.ejianc.business.doc.service.IProjectDocService;
import com.ejianc.business.doc.vo.ProjectDocVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.metadata.api.IMdProjectApi;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import net.bytebuddy.asm.Advice;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2020/11/28 14:00
 */
@RestController
@RequestMapping(value = "/docManage/")
public class DocManageController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProjectDocService projectDocService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IMdProjectApi mdProjectApi;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectApi projectApi;

    private final String COMMON_REQ_URL = "/commonstate/queryBillDetail";

    @PostMapping(value = "pageList")
    public CommonResponse<IPage<ProjectDocVO>> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getFuzzyFields().add("fileName");
        queryParam.getFuzzyFields().add("superviseUserName");
        IPage<ProjectDocEntity> pageData = projectDocService.queryPage(queryParam, false);


        IPage<ProjectDocVO> respPage = new Page<>();
        respPage.setRecords(BeanMapper.mapList(pageData.getRecords(), ProjectDocVO.class));
        respPage.setCurrent(pageData.getCurrent());
        respPage.setSize(pageData.getSize());
        respPage.setTotal(pageData.getTotal());
        respPage.setPages(pageData.getPages());

        return CommonResponse.success(respPage);
    }

    @PostMapping(value = "saveProjectDoc")
    public CommonResponse<String> saveOrUpdate(@RequestBody List<ProjectDocVO> projectDocVOs) {
        List<ProjectDocEntity> saveEntitys = BeanMapper.mapList(projectDocVOs, ProjectDocEntity.class);
        projectDocService.saveOrUpdateBatch(saveEntitys, saveEntitys.size());

        return CommonResponse.success("操作成功！");
    }

    @PostMapping(value = "delete")
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        projectDocService.removeByIds(ids);

        return CommonResponse.success("删除成功！");
    }

    @GetMapping(value = "queryDetail")
    public CommonResponse<ProjectDocVO> queryDetail(@RequestParam(value = "id") Long id) {
        ProjectDocEntity projectDocEntity = projectDocService.selectById(id);

        return CommonResponse.success(BeanMapper.map(projectDocEntity, ProjectDocVO.class));
    }

    /**
     * 附件归档
     * 1、根据billType找到单据对应工程应用服务
     * 2、根据sourceId找到单据详情信息
     * 3、获取到组织、项目信息并设置到归档信息中
     * 4、保存归档信息并将对应附件信息设置为已归档
     *
     * @param projectDocVOs
     * @return
     */
    @PostMapping(value = "archiveFiles")
    public CommonResponse<String> archiveFiles(@RequestBody List<ProjectDocVO> projectDocVOs) {
        ProjectDocVO tmpVo = projectDocVOs.get(0);
        String billType = tmpVo.getBillType();
        String orgIdField = tmpVo.getOrgIdField();
        String projectField = tmpVo.getProjectIdField();
        Long sourceId = tmpVo.getSourceId();
        Long orgId = null, projectId = null;
        String orgName = null, projectName = null;

        //1、根据billType找到单据对应工程应用服务
        CommonResponse<MdReferVO> mdReferResp = billTypeApi.queryMetadataByBillType(billType);
        if(!mdReferResp.isSuccess()) {
            return CommonResponse.error("归档失败，查询元数据信息失败！");
        }
        MdReferVO mdReferVO = mdReferResp.getData();
        // 2、 获取单据详情
        JSONObject detail = reqResult(mdReferVO.getProjectName(), mdReferVO.getTableName(), sourceId, mdReferVO.getMetadataId());
        //3、获取到组织、项目信息并设置到归档信息中
        orgId = null != detail.get(orgIdField) ? Long.valueOf(detail.get(orgIdField).toString()) : null;
        projectId = null != detail.get(projectField) ? Long.valueOf(detail.get(projectField).toString()) : null;
        if(null == orgId && null == projectId) {
            return CommonResponse.error("归档失败，从业务单据中获取组织、项目信息失败！");
        }
        if(null != projectId) {
            List<Long> proIds = new ArrayList<>();
            proIds.add(projectId);
            CommonResponse<List<ProjectRegisterVO>> projectResp = projectApi.queryProjectByIds(proIds);
            if(!projectResp.isSuccess()) {
                logger.error("【附件归档】根据项目Id{}获取项目信息失败：{}", projectId, projectResp.getMsg());
                return CommonResponse.error("归档失败，获取项目信息失败！");
            }
            List<ProjectRegisterVO> projects = projectResp.getData();
            if(CollectionUtils.isEmpty(projects)) {
                logger.error("【附件归档】：根据项目Id{}查询不到匹配的项目信息", projectId);
                return CommonResponse.error("归档失败，系统中没有匹配的项目信息！");
            }
            ProjectRegisterVO project = projects.get(0);
            orgId = project.getProjectDepartmentId();
            orgName = project.getName();
            projectId = project.getId();
            projectName = project.getName();
        } else {
            CommonResponse<OrgVO> orgResp = orgApi.getOneById(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("【附件归档】根据组织Id{}获取组织信息失败：{}", orgId, orgResp.getMsg());
                return CommonResponse.error("归档失败，获取组织信息失败！");
            }
            OrgVO orgvo = orgResp.getData();
            orgId = orgvo.getId();
            orgName = orgvo.getName();
        }
        List<Long> attachIds = new ArrayList<>();
        for(ProjectDocVO doc : projectDocVOs) {
            doc.setOrgId(orgId);
            doc.setOrgName(orgName);
            doc.setProjectId(projectId);
            doc.setProjectName(projectName);
            attachIds.add(doc.getFileId());
        }

        projectDocService.archiveFiles(projectDocVOs, attachIds);

        return CommonResponse.success("归档成功！");
    }

    private JSONObject reqResult(String projectName, String tableName, Long dataId, Long metaDataId) {
        Gson gson = new Gson();
        Map<String, Object> paramterMap = new HashMap<>();
        paramterMap.put("billId", dataId);
        paramterMap.put("tableName", tableName);
        paramterMap.put("metadataId", metaDataId);

        String paramterStr = gson.toJson(paramterMap);
        String url = BASE_HOST + projectName + COMMON_REQ_URL;
        logger.info("【附件归档】查询单据详情数据：【url-{}】, 【param-{}】", url, paramterStr);

        try {
            String result = ReferHttpClientUtils.postByJson(url, paramterStr);
            logger.info("【附件归档】查询单据详情数据返回的结果：---------------"+result);
            if(null == JSONObject.parseObject(result, Map.class).get("code")) {
                //返回结果非CommonResponse时
                throw new BusinessException("查询单据详情数据异常：" + result);
            }

            CommonResponse resp  = JSONObject.parseObject(result, CommonResponse.class);
            if(!resp.isSuccess()) {
                throw new BusinessException("查询单据详情数据异常：" + resp.getMsg());
            }
            return (JSONObject) resp.getData();
        } catch (Exception e) {
            logger.error("【附件归档】查询单据详情数据异常：", e);
            throw new BusinessException("查询单据详情数据异常：", e);
        }
    }
}
