package com.ejianc.business.doc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.doc.bean.ProjectDocEntity;
import com.ejianc.business.doc.mapper.ProjectDocMapper;
import com.ejianc.business.doc.service.IProjectDocService;
import com.ejianc.business.doc.vo.ProjectDocVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2020/11/28 14:43
 */
@Service("projectService")
public class ProjectDocServiceImpl extends BaseServiceImpl<ProjectDocMapper, ProjectDocEntity> implements IProjectDocService {

    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public void archiveFiles(List<ProjectDocVO> projectDocVOs, List<Long> attachIds) {
        List<ProjectDocEntity> saveEntities = BeanMapper.mapList(projectDocVOs, ProjectDocEntity.class);
        super.saveBatch(saveEntities);

        //更新对应附件的归档状态
        JSONObject param = new JSONObject();
        param.put("status", 1);
        param.put("attachIds", attachIds);
        CommonResponse<String> updateResp = attachmentApi.updateAttachArchiveStatus(param.toJSONString());
        if(!updateResp.isSuccess()) {
            throw new BusinessException("归档失败，更新附件归档状态失败！");
        }
    }

}
