package com.ejianc.business.doc.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;

/**
 * @author CJ
 * @Description:
 * @date 2020/11/28 14:26
 */
@TableName(value = "ejc_doc_project_doc")
public class ProjectDocEntity extends BaseEntity {
    private static final long serialVersionUID = -8779855242821545581L;

    /**
     * 文件Id
     */
    @TableField(value = "file_id")
    private Long fileId;

    /**
     * 文件名称
     */
    @TableField(value = "file_name")
    private String fileName;

    /**
     * 文件大小
     */
    @TableField(value = "file_size")
    private Long fileSize;

    /**
     * 文件类型
     */
    @TableField(value = "file_type")
    private String fileType;

    /**
     * 文件预览路径
     */
    @TableField(value = "online_path")
    private String onlinePath;

    /**
     * 文件路径
     */
    @TableField(value = "file_path")
    private String filePath;

    /**
     * 文件来源：0-附件归档，1-文件上传
     */
    @TableField(value = "doc_source")
    private String docSource;

    /**
     * 项目Id
     */
    @TableField(value = "project_id")
    private Long projectId;

    /**
     * 组织Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 项目名称
     */
    @TableField(value = "project_name")
    private String projectName;

    /**
     * 归档人Id
     */
    @TableField(value = "supervise_user_id")
    private Long superviseUserId;

    /**
     * 归档人名称
     */
    @TableField(value = "supervise_user_name")
    private String superviseUserName;

    /**
     * 归档时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "supervise_time")
    private Date superviseTime;

    /**
     * 文档分类Id
     */
    @TableField(value = "doc_category_id")
    private Long docCategoryId;

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOnlinePath() {
        return onlinePath;
    }

    public void setOnlinePath(String onlinePath) {
        this.onlinePath = onlinePath;
    }

    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getFileSize() {
        return fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileType() {
        return fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getDocSource() {
        return docSource;
    }

    public void setDocSource(String docSource) {
        this.docSource = docSource;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getSuperviseUserId() {
        return superviseUserId;
    }

    public void setSuperviseUserId(Long superviseUserId) {
        this.superviseUserId = superviseUserId;
    }

    public String getSuperviseUserName() {
        return superviseUserName;
    }

    public void setSuperviseUserName(String superviseUserName) {
        this.superviseUserName = superviseUserName;
    }

    public Date getSuperviseTime() {
        return superviseTime;
    }

    public void setSuperviseTime(Date superviseTime) {
        this.superviseTime = superviseTime;
    }

    public Long getDocCategoryId() {
        return docCategoryId;
    }

    public void setDocCategoryId(Long docCategoryId) {
        this.docCategoryId = docCategoryId;
    }
}
