/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.doc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.doc.bean.DocCategoryEntity;
import com.ejianc.business.doc.bean.ProjectDocEntity;
import com.ejianc.business.doc.service.IDocCategoryService;
import com.ejianc.business.doc.service.IProjectDocService;
import com.ejianc.business.doc.vo.ProjectDocVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.metadata.api.IMdProjectApi;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/docManage/"})
public class DocManageController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectDocService projectDocService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IMdProjectApi mdProjectApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    private final String COMMON_REQ_URL = "/commonstate/queryBillDetail";
    @Autowired
    private IDocCategoryService docCategoryService;

    @PostMapping(value={"pageList"})
    public CommonResponse<IPage<ProjectDocVO>> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getFuzzyFields().add("fileName");
        queryParam.getFuzzyFields().add("superviseUserName");
        IPage pageData = this.projectDocService.queryPage(queryParam, false);
        Page respPage = new Page();
        respPage.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), ProjectDocVO.class));
        respPage.setCurrent(pageData.getCurrent());
        respPage.setSize(pageData.getSize());
        respPage.setTotal(pageData.getTotal());
        respPage.setPages(pageData.getPages());
        return CommonResponse.success((Object)respPage);
    }

    @PostMapping(value={"saveProjectDoc"})
    public CommonResponse<String> saveOrUpdate(@RequestBody List<ProjectDocVO> projectDocVOs) {
        List saveEntitys = BeanMapper.mapList(projectDocVOs, ProjectDocEntity.class);
        this.projectDocService.saveOrUpdateBatch(saveEntitys, saveEntitys.size());
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.projectDocService.delArchiveDocs(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<ProjectDocVO> queryDetail(@RequestParam(value="id") Long id) {
        ProjectDocEntity projectDocEntity = (ProjectDocEntity)((Object)this.projectDocService.selectById(id));
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)projectDocEntity), ProjectDocVO.class));
    }

    @PostMapping(value={"archiveFiles"})
    public CommonResponse<String> archiveFiles(@RequestBody List<ProjectDocVO> projectDocVOs) {
        CommonResponse mdReferResp;
        ProjectDocVO tmpVo = projectDocVOs.get(0);
        String billType = tmpVo.getBillType();
        String orgIdField = tmpVo.getOrgIdField();
        String projectField = tmpVo.getProjectIdField();
        Long sourceId = tmpVo.getSourceId();
        Long orgId = null;
        Long projectId = null;
        String orgName = null;
        String projectName = null;
        Long docCategoryId = tmpVo.getDocCategoryId();
        DocCategoryEntity docCategory = (DocCategoryEntity)((Object)this.docCategoryService.selectById(docCategoryId));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.eq((Object)"doc_category_id", (Object)docCategory.getId());
        int count = this.projectDocService.count((Wrapper)queryWrapper);
        String respMsg = "\u5f52\u6863\u6210\u529f\uff01";
        if (count >= docCategory.getNum().intValue()) {
            return CommonResponse.error((String)("\u5f52\u6863\u5931\u8d25\uff0c\u5df2\u5f52\u6863\u6587\u6863\u6570\u91cf\u4ee5\u8fbe\u5230\u6587\u6863\u5206\u7c7b\u6570\u91cf\u9650\u5236\uff1a" + docCategory.getNum().intValue()));
        }
        if (count + projectDocVOs.size() > docCategory.getNum().intValue()) {
            projectDocVOs = projectDocVOs.subList(0, docCategory.getNum().intValue() - count);
            respMsg = "\u90e8\u5206\u5f52\u6863\u6210\u529f\uff0c\u9644\u4ef6\u5f52\u6863\u8fbe\u5230\u6587\u6863\u5206\u7c7b\u6570\u91cf\u9650\u5236\uff01";
        }
        if (!(mdReferResp = this.billTypeApi.queryMetadataByBillType(billType)).isSuccess()) {
            return CommonResponse.error((String)"\u5f52\u6863\u5931\u8d25\uff0c\u67e5\u8be2\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25\uff01");
        }
        MdReferVO mdReferVO = (MdReferVO)mdReferResp.getData();
        JSONObject detail = this.reqResult(mdReferVO.getProjectName(), mdReferVO.getTableName(), sourceId, mdReferVO.getMetadataId());
        orgId = null != detail.get((Object)orgIdField) ? Long.valueOf(detail.get((Object)orgIdField).toString()) : null;
        Long l = projectId = null != detail.get((Object)projectField) ? Long.valueOf(detail.get((Object)projectField).toString()) : null;
        if (null == orgId && null == projectId) {
            return CommonResponse.error((String)"\u5f52\u6863\u5931\u8d25\uff0c\u4ece\u4e1a\u52a1\u5355\u636e\u4e2d\u83b7\u53d6\u7ec4\u7ec7\u3001\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != projectId) {
            ArrayList<Long> proIds = new ArrayList<Long>();
            proIds.add(projectId);
            CommonResponse projectResp = this.projectApi.queryProjectByIds(proIds);
            if (!projectResp.isSuccess()) {
                this.logger.error("\u3010\u9644\u4ef6\u5f52\u6863\u3011\u6839\u636e\u9879\u76eeId{}\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)projectId, (Object)projectResp.getMsg());
                return CommonResponse.error((String)"\u5f52\u6863\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List projects = (List)projectResp.getData();
            if (CollectionUtils.isEmpty((Collection)projects)) {
                this.logger.error("\u3010\u9644\u4ef6\u5f52\u6863\u3011\uff1a\u6839\u636e\u9879\u76eeId{}\u67e5\u8be2\u4e0d\u5230\u5339\u914d\u7684\u9879\u76ee\u4fe1\u606f", (Object)projectId);
                return CommonResponse.error((String)"\u5f52\u6863\u5931\u8d25\uff0c\u7cfb\u7edf\u4e2d\u6ca1\u6709\u5339\u914d\u7684\u9879\u76ee\u4fe1\u606f\uff01");
            }
            ProjectRegisterVO project = (ProjectRegisterVO)projects.get(0);
            orgId = project.getProjectDepartmentId();
            orgName = project.getName();
            projectId = project.getId();
            projectName = project.getName();
        } else {
            CommonResponse orgResp = this.orgApi.getOneById(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u3010\u9644\u4ef6\u5f52\u6863\u3011\u6839\u636e\u7ec4\u7ec7Id{}\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)orgId, (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u5f52\u6863\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            OrgVO orgvo = (OrgVO)orgResp.getData();
            orgId = orgvo.getId();
            orgName = orgvo.getName();
        }
        ArrayList<Long> attachIds = new ArrayList<Long>();
        for (ProjectDocVO doc : projectDocVOs) {
            doc.setOrgId(orgId);
            doc.setOrgName(orgName);
            doc.setProjectId(projectId);
            doc.setProjectName(projectName);
            attachIds.add(doc.getFileId());
        }
        this.projectDocService.archiveFiles(projectDocVOs, attachIds);
        return CommonResponse.success((String)respMsg);
    }

    private JSONObject reqResult(String projectName, String tableName, Long dataId, Long metaDataId) {
        Gson gson = new Gson();
        HashMap<String, Object> paramterMap = new HashMap<String, Object>();
        paramterMap.put("billId", dataId);
        paramterMap.put("tableName", tableName);
        paramterMap.put("metadataId", metaDataId);
        String paramterStr = gson.toJson(paramterMap);
        String url = this.BASE_HOST + projectName + "/commonstate/queryBillDetail";
        this.logger.info("\u3010\u9644\u4ef6\u5f52\u6863\u3011\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u6570\u636e\uff1a\u3010url-{}\u3011, \u3010param-{}\u3011", (Object)url, (Object)paramterStr);
        try {
            String result = ReferHttpClientUtils.postByJson((String)url, (String)paramterStr);
            this.logger.info("\u3010\u9644\u4ef6\u5f52\u6863\u3011\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u6570\u636e\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + result);
            if (null == ((Map)JSONObject.parseObject((String)result, Map.class)).get("code")) {
                throw new BusinessException("\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u6570\u636e\u5f02\u5e38\uff1a" + result);
            }
            CommonResponse resp = (CommonResponse)JSONObject.parseObject((String)result, CommonResponse.class);
            if (!resp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u6570\u636e\u5f02\u5e38\uff1a" + resp.getMsg());
            }
            return (JSONObject)resp.getData();
        }
        catch (Exception e) {
            this.logger.error("\u3010\u9644\u4ef6\u5f52\u6863\u3011\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

