package com.ejianc.business.doc.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.business.doc.bean.DocCategoryEntity;
import com.ejianc.business.doc.mapper.DocCategoryMapper;
import com.ejianc.business.doc.service.IDocCategoryService;
import com.ejianc.business.doc.vo.DocCategoryVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 文档分类
 * 
 * @author generator
 * 
 */
@Service("docCategoryService")
public class DocCategoryServiceImpl extends BaseServiceImpl<DocCategoryMapper, DocCategoryEntity> implements IDocCategoryService{

	@Autowired
	private DocCategoryMapper docCategoryMapper;
	
	@Override
	public List<DocCategoryVO> findParentsById(Long cateId) {
		DocCategoryEntity entity = docCategoryMapper.selectById(cateId);
		if(entity != null) {
			List<DocCategoryVO> result = docCategoryMapper.queryParentsById(entity.getInnerCode());
			return result;
		}
		return null;
	}
}
