package com.ejianc.business.doc.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.doc.bean.ProjectDocEntity;
import com.ejianc.business.doc.vo.ProjectDocVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2020/11/28 14:42
 */
public interface IProjectDocService extends IBaseService<ProjectDocEntity> {
    /**
     * 附件归档
     * @param projectDocVOs
     * @param attachIds
     */
    void archiveFiles(List<ProjectDocVO> projectDocVOs, List<Long> attachIds);

    /**
     * 批量删除归档的文档
     *
     * @param ids
     */
    void delArchiveDocs(List<Long> ids);

    /**
     * 分页查询文档分类下的文档列表
     *
     * @param pageSize
     * @param pageIndex
     * @param tenantid
     * @param categoryIds
     * @param searchText
     * @return
     */
    IPage<ProjectDocEntity> queryPageList(Integer pageSize, Integer pageIndex, Long tenantid, List<Long> categoryIds, String searchText);
}
